/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.component;

import com.intellij.jpa.jpb.model.backend.util.JpbXmlUtil;
import com.intellij.jpa.jpb.model.core.model.dbprop.Db2DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbprop.DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbprop.H2DbProperties;
import com.intellij.jpa.jpb.model.core.model.dbprop.HsqlFileDbProperties;
import com.intellij.jpa.jpb.model.core.model.dbprop.MssqlDbProperties;
import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MssqlJtdsType;
import com.intellij.jpa.jpb.model.core.model.dbtype.MssqlType;
import com.intellij.jpa.jpb.model.core.model.dbtype.OracleType;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.dbdrivers.DatabaseArtifactsManager;
import com.intellij.jpa.jpb.model.dbdrivers.DbDriversManager;
import com.intellij.jpa.jpb.model.ui.SSwingUtilKt;
import com.intellij.jpa.jpb.model.ui.StudioMigPanel;
import com.intellij.jpa.jpb.model.ui.component.DbDriverProblemPanel;
import com.intellij.jpa.jpb.model.ui.component.DbParamsField;
import com.intellij.jpa.jpb.model.util.DbUtils;
import com.intellij.jpa.jpb.model.util.JpaUiUtil;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.SimpleListCellRenderer;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPasswordField;
import com.intellij.ui.components.JBTextField;
import com.intellij.util.SmartList;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.ListCellRenderer;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbPropertiesEditor {
    public static final Pattern HSQL_DB_HOST = Pattern.compile("^localhost(:(\\d+))?$");
    public static final Pattern ORACLE_USER = Pattern.compile("[a-zA-Z_0-9#]+");
    public static final String trustServerCertificateParamName = "trustServerCertificate";
    private JPanel mainPanel;
    private ComboBox<DbType> typeCombo;
    private JBLabel urlPrefixLab;
    private JBTextField hostField;
    private JBTextField nameField;
    private JBLabel connectionParamsLabel;
    private DbParamsField connectionParamsField;
    private JBTextField userField;
    private JBPasswordField passwField;
    private JBCheckBox showPasswordField;
    private JBCheckBox integratedSecurityField;
    private final Project project;
    private boolean showDbmsWarning;
    private JLabel dbUserLab;
    private JPanel userLayout;
    private final List<Consumer<DbType>> dbTypeListeners;
    private boolean dbNameChangedByUser = false;
    private boolean dbNameSystemChangeInProgress = false;
    public DbDriverProblemPanel dbDriverProblemPanel;
    private JBLabel hostSeparatorLab;
    private StudioMigPanel dbHostDbNameLayout;
    private StudioMigPanel dbConnectionParamsLayout;

    public DbPropertiesEditor(@Nullable Project project) {
        this.project = project;
        this.dbTypeListeners = new SmartList();
        this.create();
    }

    public void create() {
        this.mainPanel = new StudioMigPanel(new LC().insets("0px").hideMode(2));
        JBLabel dbTypeLab = new JBLabel(JpaModelBundle.message("ProjectPropertiesPage.dbType", new Object[0]));
        this.typeCombo = new ComboBox();
        this.typeCombo.setRenderer((ListCellRenderer)SimpleListCellRenderer.create((label, value, index) -> {
            if (value == null) {
                return;
            }
            if (value instanceof MssqlType) {
                label.setText(value instanceof MssqlJtdsType ? JpaModelBundle.message("microsoft.sql.server.jtds", new Object[0]) : JpaModelBundle.message("microsoft.sql.server", new Object[0]));
            } else {
                label.setText(value.toString());
            }
            label.setIcon(JpaUiUtil.getDbTypeIcon(value));
        }));
        JButton connectionBtn = new JButton(JpaModelBundle.message("ProjectPropertiesPage.connection", new Object[0]));
        connectionBtn.addActionListener(new TestConnectionListener());
        StudioMigPanel dbTypeLayout = new StudioMigPanel();
        ((Container)((Object)dbTypeLayout)).add((Component)this.typeCombo);
        this.mainPanel.add((Component)dbTypeLab);
        this.mainPanel.add((Component)((Object)dbTypeLayout), new CC().wrap());
        StudioMigPanel dbUrlLabPanel = new StudioMigPanel(new LC().insets("4px", "0px", "0px", "0px"));
        this.mainPanel.add((Component)((Object)dbUrlLabPanel), new CC().alignY("top"));
        ((Container)((Object)dbUrlLabPanel)).add((Component)new JBLabel(JpaModelBundle.message("ProjectPropertiesPage.dbUrl", new Object[0])));
        StudioMigPanel dbUrlLayout = new StudioMigPanel(new LC().wrapAfter(1).insets("0px", "0px", "4px", "0px").hideMode(2));
        this.mainPanel.add((Component)((Object)dbUrlLayout), new CC().wrap().growX().width("100%").alignY("top"));
        JPanel dbLayout = new JPanel(new BorderLayout());
        dbLayout.add((Component)this.createPrefixDbUrlLayout(), "Center");
        ((Container)((Object)dbUrlLayout)).add(dbLayout, new CC().growX().width("100%"));
        this.integratedSecurityField = new JBCheckBox(JpaModelBundle.message("ProjectPropertiesPage.integratedSecurity", new Object[0]));
        this.integratedSecurityField.addItemListener(e -> this.updateUserLayout());
        this.integratedSecurityField.addItemListener(e -> this.showIntegratedSecurityInstructionsIfNeeded());
        ((Container)((Object)dbUrlLayout)).add((Component)this.integratedSecurityField);
        this.dbUserLab = new JBLabel(JpaModelBundle.message("ProjectPropertiesPage.dbUser", new Object[0]));
        this.mainPanel.add(this.dbUserLab);
        this.userLayout = new StudioMigPanel(new LC().insets("0px"));
        this.mainPanel.add((Component)this.userLayout, new CC().wrap().growX().width("100%"));
        this.mainPanel.add((Component)new JBLabel());
        this.mainPanel.add((Component)connectionBtn, new CC().wrap());
        this.userField = new JBTextField();
        this.userLayout.add((Component)this.userField, new CC().growX().width("100%"));
        JBLabel dbPasswField = new JBLabel(JpaModelBundle.message("ProjectPropertiesPage.dbPassword", new Object[0]));
        this.userLayout.add((Component)dbPasswField);
        this.passwField = new JBPasswordField();
        this.userLayout.add((Component)this.passwField, new CC().growX().width("100%"));
        this.showPasswordField = new JBCheckBox(JpaModelBundle.message("ProjectPropertiesPage.dbPassword.showCheckBox", new Object[0]));
        this.userLayout.add((Component)this.showPasswordField, new CC().growX().width("20%"));
        char passwFieldEchoChar = this.passwField.getEchoChar();
        JpaUiUtil.addShowPasswordActionListener((JPasswordField)this.passwField, (JCheckBox)this.showPasswordField, passwFieldEchoChar);
        this.dbDriverProblemPanel = new DbDriverProblemPanel(this.project);
        this.mainPanel.add((Component)((Object)this.dbDriverProblemPanel), new CC().wrap().spanX().width("100%"));
        this.typeCombo.addItemListener((ItemListener)new DbTypeChangeListener());
        StreamEx.of(DbType.allTypes(true)).forEachOrdered(arg_0 -> this.typeCombo.addItem(arg_0));
    }

    private void showIntegratedSecurityInstructionsIfNeeded() {
        if (!this.showDbmsWarning || !this.integratedSecurityField.isSelected() || DbPropertiesEditor.isNativeDllLibraryDownloaded()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> Messages.showInfoMessage((String)JpaModelBundle.message("ProjectPropertiesPage.integratedSecurityInstruction", DbDriversManager.getMssqlAuthLibUrl(), DbUtils.NATIVE_LIBS_ROOT), (String)JpaModelBundle.message("ProjectPropertiesPage.integratedSecurity", new Object[0])));
    }

    private static boolean isNativeDllLibraryDownloaded() {
        if (!SystemInfo.isWindows) {
            return false;
        }
        if (!DbUtils.NATIVE_LIBS_ROOT.exists()) {
            return false;
        }
        try {
            return Files.find(DbUtils.NATIVE_LIBS_ROOT.toPath(), 6, (path, basicFileAttributes) -> {
                String fileName = path.getFileName().toString();
                return StringUtil.containsIgnoreCase((String)fileName, (String)"mssql") && StringUtil.containsIgnoreCase((String)fileName, (String)"auth") && fileName.endsWith(".dll");
            }, new FileVisitOption[0]).findFirst().isPresent();
        }
        catch (IOException e) {
            return false;
        }
    }

    private void updateUserLayout() {
        DbType selectedItemTyped = SSwingUtilKt.getSelectedItemTyped(this.typeCombo);
        boolean integratedSecurity = this.integratedSecurityField.isSelected() && selectedItemTyped == DbType.MSSQL;
        this.userLayout.setVisible(!integratedSecurity);
        this.dbUserLab.setVisible(!integratedSecurity);
        if (!integratedSecurity && StringUtils.isBlank((CharSequence)this.userField.getText())) {
            this.userField.setText("sa");
        }
    }

    @NotNull
    private JPanel createPrefixDbUrlLayout() {
        StudioMigPanel prefixUrlLayout = new StudioMigPanel(new LC().wrapAfter(1).insets("0px"));
        this.dbHostDbNameLayout = new StudioMigPanel(new LC().insets("0px"));
        ((Container)((Object)prefixUrlLayout)).add((Component)((Object)this.dbHostDbNameLayout), new CC().growX().width("100%"));
        this.urlPrefixLab = new JBLabel("jdbc:hsqldb:hsql://");
        this.dbHostDbNameLayout.add((Component)this.urlPrefixLab);
        this.hostField = new JBTextField();
        this.dbHostDbNameLayout.add((Component)this.hostField, new CC().growX().width("100%"));
        this.hostSeparatorLab = new JBLabel("/");
        this.dbHostDbNameLayout.add((Component)this.hostSeparatorLab);
        this.nameField = new JBTextField();
        this.nameField.getDocument().addDocumentListener(e -> {
            if (!this.dbNameSystemChangeInProgress) {
                this.dbNameChangedByUser = true;
            }
        });
        this.dbHostDbNameLayout.add((Component)this.nameField, new CC().growX().width("100%"));
        this.dbConnectionParamsLayout = new StudioMigPanel(new LC().insets("0px"));
        ((Container)((Object)prefixUrlLayout)).add((Component)((Object)this.dbConnectionParamsLayout), new CC().growX().width("100%"));
        this.connectionParamsLabel = new JBLabel(JpaModelBundle.message("ProjectPropertiesPage.dbConnectionParams", new Object[0]));
        this.dbConnectionParamsLayout.add((Component)this.connectionParamsLabel);
        this.connectionParamsField = new DbParamsField(this.project);
        this.dbConnectionParamsLayout.add((Component)((Object)this.connectionParamsField), new CC().growX().width("100%"));
        StudioMigPanel studioMigPanel = prefixUrlLayout;
        if (studioMigPanel == null) {
            DbPropertiesEditor.$$$reportNull$$$0(0);
        }
        return studioMigPanel;
    }

    public void doSystemDbNameChange(@NotNull Runnable runnable) {
        if (runnable == null) {
            DbPropertiesEditor.$$$reportNull$$$0(1);
        }
        this.dbNameSystemChangeInProgress = true;
        try {
            runnable.run();
        }
        finally {
            this.dbNameSystemChangeInProgress = false;
        }
    }

    public boolean isDbNameChangedByUser() {
        return this.dbNameChangedByUser;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setValues(@NotNull DbProperties dbProperties) {
        if (dbProperties == null) {
            DbPropertiesEditor.$$$reportNull$$$0(2);
        }
        this.showDbmsWarning = false;
        try {
            DbType dbType = dbProperties.getType();
            if (this.typeCombo.getSelectedItem() == dbType) {
                this.typeCombo.setSelectedItem(null);
            }
            SSwingUtilKt.setSelectedItemTyped(this.typeCombo, dbType);
            this.hostField.setText(dbProperties.getHost());
            dbProperties.setUrl(JpbXmlUtil.unescape(dbProperties.getUrl()));
            String dbName = dbProperties instanceof HsqlFileDbProperties || dbProperties instanceof H2DbProperties || dbProperties instanceof Db2DbProperties ? dbProperties.getUrl().replace(Objects.requireNonNull(dbProperties.getUrlPrefix()), "") : dbProperties.getDatabaseName();
            this.setDbName(dbName);
            this.connectionParamsField.setText(dbProperties.getConnectionParams());
            this.userField.setText(JpbXmlUtil.unescape(dbProperties.getUser()));
            this.passwField.setText(JpbXmlUtil.unescape(dbProperties.getPassword()));
            if (dbProperties instanceof MssqlDbProperties) {
                this.integratedSecurityField.setSelected(((MssqlDbProperties)dbProperties).isIntegratedSecurity());
            }
        }
        finally {
            this.showDbmsWarning = true;
        }
    }

    private String generateDefaultDbName(DbType dbType) {
        String projectName = this.project.getName();
        if (dbType == DbType.HSQL_FILE) {
            return "~/" + projectName;
        }
        if (dbType == DbType.H2) {
            return "file:~/h2/" + projectName;
        }
        if (dbType == DbType.DB2) {
            return "localhost:50000/" + projectName;
        }
        return projectName;
    }

    public DbProperties createDbProperties() {
        DbType dbType = Objects.requireNonNull(SSwingUtilKt.getSelectedItemTyped(this.typeCombo));
        DbProperties dbProperties = DbProperties.create(dbType, this.generateDefaultDbName(dbType));
        dbProperties.setUser(this.userField.getText().trim()).setPassword(String.valueOf(this.passwField.getPassword()));
        String dbName = this.nameField.getText().trim();
        if (dbType == DbType.HSQL_INMEMORY || dbType == DbType.HSQL_FILE || dbType == DbType.H2 || dbType == DbType.DB2) {
            dbProperties.setUrl(dbProperties.getUrlPrefix() + dbName);
        } else {
            dbProperties.setUrl(this.hostField.getText().trim(), dbName, this.connectionParamsField.getText().trim());
        }
        if (dbProperties instanceof MssqlDbProperties) {
            boolean integratedSecurity = this.integratedSecurityField.isSelected();
            ((MssqlDbProperties)dbProperties).setIntegratedSecurity(integratedSecurity);
            if (integratedSecurity) {
                dbProperties.setUser(null);
                dbProperties.setPassword(null);
            }
        }
        return dbProperties;
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    @Nullable
    public ValidationInfo validate() {
        DbType dbType = SSwingUtilKt.getSelectedItemTyped(this.typeCombo);
        if (dbType != DbType.HSQL_FILE && dbType != DbType.HSQL_INMEMORY && dbType != DbType.H2 && dbType != DbType.DB2) {
            String host = this.hostField.getText().trim();
            if (StringUtils.isBlank((CharSequence)host)) {
                return new ValidationInfo(JpaModelBundle.message("ProjectPropertiesPage.validation.empty", new Object[0]), (JComponent)this.hostField);
            }
            if (dbType == DbType.HSQL && !HSQL_DB_HOST.matcher(host.trim()).matches()) {
                return new ValidationInfo(JpaModelBundle.message("ProjectPropertiesPage.incorrectDbHost", host), (JComponent)this.hostField);
            }
        }
        if (StringUtils.isBlank((CharSequence)this.nameField.getText())) {
            return new ValidationInfo(JpaModelBundle.message("ProjectPropertiesPage.validation.empty", new Object[0]), (JComponent)this.nameField);
        }
        String userName = this.userField.getText();
        if (this.userLayout.isVisible() && StringUtils.isBlank((CharSequence)userName) && (!this.integratedSecurityField.isVisible() || !this.integratedSecurityField.isSelected())) {
            return new ValidationInfo(JpaModelBundle.message("ProjectPropertiesPage.validation.empty", new Object[0]), (JComponent)this.userField);
        }
        return null;
    }

    public static boolean needToAddTrustServerCertificateParam(DbProperties dbProperties, Project project) {
        Driver driver;
        DbDriversManager driversManager = DbDriversManager.getInstance(project);
        DbType dbType = dbProperties.getType();
        if (dbProperties.getConnectionParam(trustServerCertificateParamName) == null && driversManager.hasDriver(dbType) && (driver = driversManager.findDriver(dbType)) != null) {
            int majorVersion = driver.getMajorVersion();
            int minorVersion = driver.getMinorVersion();
            return majorVersion == 10 && minorVersion >= 2 || majorVersion > 10;
        }
        return false;
    }

    public void addDbTypeListener(@NotNull Consumer<DbType> listener) {
        if (listener == null) {
            DbPropertiesEditor.$$$reportNull$$$0(3);
        }
        this.dbTypeListeners.add(listener);
    }

    public String getDbName() {
        return this.nameField.getText().trim();
    }

    public void setDbName(String dbName) {
        this.doSystemDbNameChange(() -> this.nameField.setText(dbName));
    }

    public DbDriverProblemPanel getDbDriverProblemPanel() {
        return this.dbDriverProblemPanel;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/jpb/model/ui/component/DbPropertiesEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dbProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createPrefixDbUrlLayout";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/jpb/model/ui/component/DbPropertiesEditor";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "doSystemDbNameChange";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "setValues";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addDbTypeListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }

    private class TestConnectionListener
    implements ActionListener {
        private TestConnectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DbProperties dbProperties = DbPropertiesEditor.this.createDbProperties();
            ProgressManager.getInstance().run((Task)new TestConnectionTask(DbPropertiesEditor.this.project, dbProperties, DbPropertiesEditor.this.dbDriverProblemPanel));
        }
    }

    private class DbTypeChangeListener
    implements ItemListener {
        private DbTypeChangeListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent e) {
            if (e.getStateChange() == 2) {
                return;
            }
            DbType dbType = (DbType)e.getItem();
            DbProperties dbProperties = DbProperties.create(dbType, DbPropertiesEditor.this.generateDefaultDbName(dbType));
            DbPropertiesEditor.this.urlPrefixLab.setText(dbProperties.getUrlPrefix());
            DbPropertiesEditor.this.hostSeparatorLab.setText(dbProperties.getHostSeparator());
            DbPropertiesEditor.this.hostField.setText(StringUtil.defaultIfEmpty((String)dbProperties.getHost(), (String)"localhost"));
            DbPropertiesEditor.this.userField.setText(dbType instanceof OracleType && StringUtil.isEmptyOrSpaces((String)dbProperties.getUser()) ? StringUtil.notNullize((String)DbPropertiesEditor.this.project.getName()).replace('-', '_') : dbProperties.getUser());
            DbPropertiesEditor.this.userField.setEditable(true);
            DbPropertiesEditor.this.passwField.setEditable(true);
            DbPropertiesEditor.this.passwField.setText(dbProperties.getPassword());
            boolean isMssql = dbProperties instanceof MssqlDbProperties;
            if (isMssql && DbPropertiesEditor.needToAddTrustServerCertificateParam(dbProperties, DbPropertiesEditor.this.project)) {
                dbProperties.addConnectionParam(DbPropertiesEditor.trustServerCertificateParamName, Boolean.TRUE.toString());
            }
            DbPropertiesEditor.this.connectionParamsField.setText(dbProperties.getConnectionParams());
            DbPropertiesEditor.this.connectionParamsField.setDbType(dbType);
            DbPropertiesEditor.this.connectionParamsField.setEditable(dbType.getStartSeparator() != null);
            DbPropertiesEditor.this.connectionParamsField.setEnabled(dbType.getStartSeparator() != null);
            DbPropertiesEditor.this.showPasswordField.setEnabled(true);
            this.updateHsqlFields(dbType);
            this.updateOnlyJdbcFieldDbTypeFields(dbType);
            DbPropertiesEditor.this.setDbName(DbPropertiesEditor.this.generateDefaultDbName(dbType));
            DbPropertiesEditor.this.integratedSecurityField.setVisible(isMssql);
            DbPropertiesEditor.this.integratedSecurityField.setSelected(isMssql && ((MssqlDbProperties)dbProperties).isIntegratedSecurity());
            DbPropertiesEditor.this.updateUserLayout();
            for (Consumer<DbType> listener : DbPropertiesEditor.this.dbTypeListeners) {
                listener.accept(dbType);
            }
        }

        private void updateOnlyJdbcFieldDbTypeFields(DbType dbType) {
            boolean isOnlyJdbcType;
            boolean bl = isOnlyJdbcType = dbType == DbType.H2 || dbType == DbType.DB2;
            if (isOnlyJdbcType) {
                DbPropertiesEditor.this.dbHostDbNameLayout.remove((Component)DbPropertiesEditor.this.hostField);
                DbPropertiesEditor.this.dbHostDbNameLayout.remove((Component)DbPropertiesEditor.this.hostSeparatorLab);
                DbPropertiesEditor.this.dbConnectionParamsLayout.remove((Component)DbPropertiesEditor.this.connectionParamsLabel);
                DbPropertiesEditor.this.dbConnectionParamsLayout.remove((Component)((Object)DbPropertiesEditor.this.connectionParamsField));
            } else {
                if (DbPropertiesEditor.this.hostField.getParent() == null) {
                    DbPropertiesEditor.this.dbHostDbNameLayout.add((Component)DbPropertiesEditor.this.hostField, new CC().growX().width("100%"), 1);
                    DbPropertiesEditor.this.dbHostDbNameLayout.add((Component)DbPropertiesEditor.this.hostSeparatorLab, 2);
                }
                if (DbPropertiesEditor.this.connectionParamsField.getParent() == null) {
                    DbPropertiesEditor.this.dbConnectionParamsLayout.add((Component)DbPropertiesEditor.this.connectionParamsLabel);
                    DbPropertiesEditor.this.dbConnectionParamsLayout.add((Component)((Object)DbPropertiesEditor.this.connectionParamsField), new CC().growX().width("100%"));
                }
            }
        }

        private void updateHsqlFields(DbType dbType) {
            boolean isHsqlEmbedded = dbType == DbType.HSQL_INMEMORY || dbType == DbType.HSQL_FILE;
            boolean isHsqlType = dbType == DbType.HSQL || isHsqlEmbedded;
            DbPropertiesEditor.this.userField.setEditable(!isHsqlType);
            DbPropertiesEditor.this.passwField.setEditable(!isHsqlType);
            DbPropertiesEditor.this.showPasswordField.setEnabled(!isHsqlType);
            if (isHsqlEmbedded) {
                DbPropertiesEditor.this.dbHostDbNameLayout.remove((Component)DbPropertiesEditor.this.hostField);
                DbPropertiesEditor.this.dbHostDbNameLayout.remove((Component)DbPropertiesEditor.this.hostSeparatorLab);
            } else {
                DbPropertiesEditor.this.dbHostDbNameLayout.add((Component)DbPropertiesEditor.this.hostField, new CC().growX().width("100%"), 1);
                DbPropertiesEditor.this.dbHostDbNameLayout.add((Component)DbPropertiesEditor.this.hostSeparatorLab, 2);
            }
        }
    }

    public static class TestConnectionTask
    extends Task.Backgroundable {
        private final Application application;
        private final Project project;
        private final DbProperties dbProperties;
        private final boolean loadDriver;
        private DbDriverProblemPanel dbDriverProblemPanel;

        public TestConnectionTask(Project project, DbProperties dbProperties, DbDriverProblemPanel dbDriverProblemPanel) {
            this(project, dbProperties, true);
            this.dbDriverProblemPanel = dbDriverProblemPanel;
        }

        public TestConnectionTask(@Nullable Project project, @NotNull DbProperties dbProperties) {
            if (dbProperties == null) {
                TestConnectionTask.$$$reportNull$$$0(0);
            }
            this(project, dbProperties, true);
        }

        public TestConnectionTask(@Nullable Project project, @NotNull DbProperties dbProperties, boolean loadDriver) {
            if (dbProperties == null) {
                TestConnectionTask.$$$reportNull$$$0(1);
            }
            super(project, JpaModelBundle.message("ProjectPropertiesPage.testConnection.title", new Object[0]), false, PerformInBackgroundOption.DEAF);
            this.application = ApplicationManager.getApplication();
            this.loadDriver = loadDriver;
            this.project = project;
            this.dbProperties = dbProperties;
            this.dbDriverProblemPanel = null;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            String url;
            if (indicator == null) {
                TestConnectionTask.$$$reportNull$$$0(2);
            }
            if (StringUtil.isEmptyOrSpaces((String)(url = this.dbProperties.getUrl()))) {
                this.application.invokeLater(() -> Messages.showErrorDialog((Project)this.project, (String)JpaModelBundle.message("ProjectPropertiesPage.emptyUrl", new Object[0]), (String)JpaModelBundle.message("ProjectPropertiesPage.connectionTestCaption", new Object[0])));
                return;
            }
            indicator.setText(url);
            this.tryConnectToDb(this.loadDriver);
        }

        private void tryConnectToDb(boolean isLoadDriver) {
            try (Connection ignored = DbUtils.openConnection(this.project, this.dbProperties);){
                this.doOnSuccess();
            }
            catch (ClassNotFoundException | SQLException e) {
                if (isLoadDriver && this.isDriverNotFoundException(e)) {
                    ApplicationManager.getApplication().invokeLater(() -> DatabaseArtifactsManager.getInstance().downloadDriversAndSaveState(this.project, Collections.singletonList(this.dbProperties.getType()), () -> this.tryConnectToDb(false)));
                }
                this.doOnError(e);
            }
            if (this.dbDriverProblemPanel != null) {
                this.dbDriverProblemPanel.updatePanelState(this.dbProperties.getType());
            }
        }

        private boolean isDriverNotFoundException(Exception e) {
            String message = e.getMessage();
            return e instanceof SQLException && StringUtil.startsWithIgnoreCase((String)message, (String)"No suitable driver found") || e instanceof ClassNotFoundException && DbDriversManager.getInstance(this.project).isDriverNeedToWrap(message);
        }

        private void doOnSuccess() {
            this.application.invokeLater(() -> Messages.showInfoMessage((Project)this.project, (String)JpaModelBundle.message("ProjectPropertiesPage.connectionSuccessful", Objects.requireNonNull(this.dbProperties.getUrl())), (String)JpaModelBundle.message("ProjectPropertiesPage.connectionTestCaption", new Object[0])));
        }

        private void doOnError(@NotNull Exception e) {
            if (e == null) {
                TestConnectionTask.$$$reportNull$$$0(3);
            }
            this.application.invokeLater(() -> Messages.showErrorDialog((Project)this.project, (String)e.getMessage(), (String)JpaModelBundle.message("ProjectPropertiesPage.connectionTestCaption", new Object[0])));
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "dbProperties";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/jpa/jpb/model/ui/component/DbPropertiesEditor$TestConnectionTask";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "run";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "doOnError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

