/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.jpb.model.ui.structure;

import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.jpa.jpb.model.core.ProjectStateManger;
import com.intellij.jpa.jpb.model.core.msg.JpaModelBundle;
import com.intellij.jpa.jpb.model.core.util.SlowOpertionUtilsKt;
import com.intellij.jpa.jpb.model.ui.structure.HSection$isAllChildrenEmpty$;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.RuntimeExceptionWithAttachments;
import com.intellij.openapi.fileTypes.FileTypeRegistry;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.impl.VirtualDirectoryImpl;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b&\u0018\u0000 -*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001-B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u0017\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010J\u0006\u0010\u0018\u001a\u00020\u0019J\b\u0010\u001a\u001a\u00020\u0019H\u0002J\u001a\u0010\u001b\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u00102\b\b\u0002\u0010\u001c\u001a\u00020\u0019J\b\u0010\u001d\u001a\u00020\u0019H\u0014J\b\u0010\u001e\u001a\u00020\u0019H\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0016J\u0010\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u0019H\u0016J\b\u0010#\u001a\u00020\u0019H\u0016J\n\u0010$\u001a\u0004\u0018\u00010%H\u0014J\u0012\u0010&\u001a\u00020\u00192\b\u0010'\u001a\u0004\u0018\u00010(H\u0016J\u0014\u0010)\u001a\u0004\u0018\u00010\u00162\b\u0010'\u001a\u0004\u0018\u00010(H\u0002J\u0011\u0010*\u001a\u00020\u00192\u0006\u0010+\u001a\u00020\u0016H\u0096\u0002J\n\u0010)\u001a\u0004\u0018\u00010\u0016H\u0016J\u0012\u0010,\u001a\u00020\u00192\b\u0010+\u001a\u0004\u0018\u00010\u0016H\u0016R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u0018\u0010\u0014\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00110\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/intellij/jpa/jpb/model/ui/structure/HSection;", "Value", "Lcom/intellij/ide/projectView/ProjectViewNode;", "project", "Lcom/intellij/openapi/project/Project;", "value", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/lang/Object;Lcom/intellij/ide/projectView/ViewSettings;)V", "maxDuration", "", "millisInSec", "dumbService", "Lcom/intellij/openapi/project/DumbService;", "childrenImpl", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getChildrenImpl", "()Ljava/util/Collection;", "cachedChildren", "myVirtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getChildren", "isAllChildrenEmpty", "", "isCacheNoInitialized", "getCachedChildren", "completeRawChildren", "isProcessChildrenInDumb", "isValid", "canNavigate", "navigate", "", "requestFocus", "canNavigateToSource", "getNavigatable", "Lcom/intellij/pom/Navigatable;", "canRepresent", "element", "", "getVirtualFile", "contains", "file", "someChildContainsFile", "Companion", "intellij.javaee.jpa.jpb.model.ui"})
@SourceDebugExtension(value={"SMAP\nHSection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HSection.kt\ncom/intellij/jpa/jpb/model/ui/structure/HSection\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,176:1\n477#2:177\n1232#2,2:178\n808#3,11:180\n1761#3,3:191\n1761#3,3:194\n14#4:197\n*S KotlinDebug\n*F\n+ 1 HSection.kt\ncom/intellij/jpa/jpb/model/ui/structure/HSection\n*L\n81#1:177\n81#1:178,2\n124#1:180,11\n124#1:191,3\n166#1:194,3\n24#1:197\n*E\n"})
public abstract class HSection<Value>
extends ProjectViewNode<Value> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxDuration;
    private final int millisInSec;
    @NotNull
    private final DumbService dumbService;
    private Collection<? extends AbstractTreeNode<?>> cachedChildren;
    @Nullable
    private final VirtualFile myVirtualFile;
    @NotNull
    private static final Logger logger;

    public HSection(@NotNull Project project, Value value, @NotNull ViewSettings settings) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        Value Value2 = value;
        Intrinsics.checkNotNull(Value2);
        super(project, Value2, settings);
        this.maxDuration = 5000;
        this.millisInSec = 1000;
        this.dumbService = DumbService.Companion.getInstance(project);
        Value Value3 = value;
        if (Value3 instanceof PsiElement) {
            PsiFile psiFile = ((PsiElement)value).getContainingFile();
            object = psiFile != null ? psiFile.getVirtualFile() : null;
        } else {
            object = Value3 instanceof VirtualFile ? (VirtualFile)value : null;
        }
        this.myVirtualFile = object;
    }

    public /* synthetic */ HSection(Project project, Object object, ViewSettings viewSettings, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            ViewSettings viewSettings2 = ViewSettings.DEFAULT;
            Intrinsics.checkNotNullExpressionValue((Object)viewSettings2, (String)"DEFAULT");
            viewSettings = viewSettings2;
        }
        this(project, object, viewSettings);
    }

    @NotNull
    protected abstract Collection<AbstractTreeNode<?>> getChildrenImpl();

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Collection<AbstractTreeNode<?>> getChildren() {
        Collection<AbstractTreeNode<?>> collection;
        Collection<AbstractTreeNode<?>> collection2;
        HSection hSection;
        long startTimer = System.currentTimeMillis();
        if (!this.isProcessChildrenInDumb() && this.dumbService.isDumb() && this.isValid() || this.myProject == null || this.myProject.isDisposed()) {
            Collection<AbstractTreeNode<?>> collection3;
            if (this.isCacheNoInitialized()) {
                this.cachedChildren = new ArrayList();
            }
            if ((collection3 = this.cachedChildren) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"cachedChildren");
                collection3 = null;
            }
            return collection3;
        }
        HSection hSection2 = this;
        try {
            hSection = hSection2;
            collection2 = this.getChildrenImpl();
        }
        catch (Exception exception) {
            Collection<AbstractTreeNode<?>> collection4;
            void ex;
            hSection = hSection2;
            if (ex instanceof ProcessCanceledException) {
                throw ex;
            }
            if (ex instanceof RuntimeExceptionWithAttachments || ex instanceof IllegalStateException || ex instanceof IllegalArgumentException) {
                logger.info("Exception while calculating children! Instance class - " + ((Object)((Object)this)).getClass().getName());
            }
            if (this.isCacheNoInitialized()) {
                collection4 = CollectionsKt.emptyList();
            } else {
                collection4 = this.cachedChildren;
                if (collection4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"cachedChildren");
                    collection4 = null;
                }
            }
            collection2 = collection4;
        }
        hSection.cachedChildren = collection2;
        long stopTimer = System.currentTimeMillis();
        long durationMillis = stopTimer - startTimer;
        if (durationMillis > (long)this.maxDuration) {
            double durationSec = (double)durationMillis / (double)this.millisInSec;
            Object[] objectArray = new Object[]{((Object)((Object)this)).getClass().getSimpleName(), durationSec};
            logger.warn(JpaModelBundle.message("calculation.of.structure.section", objectArray));
        }
        if ((collection = this.cachedChildren) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedChildren");
            collection = null;
        }
        return collection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isAllChildrenEmpty() {
        Collection<AbstractTreeNode<?>> collection;
        if (this.isCacheNoInitialized()) return true;
        Collection<AbstractTreeNode<?>> collection2 = this.cachedChildren;
        if (collection2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedChildren");
            collection2 = null;
        }
        if (collection2.isEmpty()) return true;
        Collection<AbstractTreeNode<?>> collection3 = this.cachedChildren;
        if (collection3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedChildren");
            collection3 = null;
        }
        Sequence $this$filterIsInstance$iv = CollectionsKt.asSequence((Iterable)collection3);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)isAllChildrenEmpty$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        Sequence $this$all$iv = sequence;
        boolean $i$f$all = false;
        Iterator iterator = $this$all$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            HSection it = (HSection)((Object)element$iv);
            boolean bl = false;
            collection = it.cachedChildren;
            if (collection != null) continue;
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedChildren");
            collection = null;
        } while (collection.isEmpty());
        return false;
    }

    private final boolean isCacheNoInitialized() {
        return this.cachedChildren == null;
    }

    @NotNull
    public final Collection<AbstractTreeNode<?>> getCachedChildren(boolean completeRawChildren) {
        if (this.isCacheNoInitialized()) {
            return completeRawChildren ? this.getChildren() : (Collection)new ArrayList();
        }
        Collection<AbstractTreeNode<?>> collection = this.cachedChildren;
        if (collection == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"cachedChildren");
            collection = null;
        }
        return collection;
    }

    public static /* synthetic */ Collection getCachedChildren$default(HSection hSection, boolean bl, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: getCachedChildren");
        }
        if ((n & 1) != 0) {
            bl = false;
        }
        return hSection.getCachedChildren(bl);
    }

    protected boolean isProcessChildrenInDumb() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    public boolean canNavigate() {
        Navigatable navigatable = this.getNavigatable();
        return navigatable != null ? navigatable.canNavigate() : false;
    }

    public void navigate(boolean requestFocus) {
        block0: {
            Navigatable navigatable = this.getNavigatable();
            if (navigatable == null) break block0;
            navigatable.navigate(requestFocus);
        }
    }

    public boolean canNavigateToSource() {
        Navigatable navigatable = this.getNavigatable();
        return navigatable != null ? navigatable.canNavigateToSource() : false;
    }

    @Nullable
    protected Navigatable getNavigatable() {
        Object object = this.getValue();
        return object instanceof Navigatable ? (Navigatable)object : null;
    }

    /*
     * WARNING - void declaration
     */
    public boolean canRepresent(@Nullable Object element) {
        VirtualFile file = this.getVirtualFile(element);
        if (file != null && Intrinsics.areEqual((Object)this.getVirtualFile(), (Object)file)) {
            return true;
        }
        if (this.myVirtualFile == null && file instanceof VirtualDirectoryImpl) {
            boolean bl;
            block7: {
                void $this$filterIsInstanceTo$iv$iv;
                Iterable $this$filterIsInstance$iv = HSection.getCachedChildren$default(this, false, 1, null);
                boolean $i$f$filterIsInstance = false;
                Iterable iterable = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterIsInstanceTo = false;
                for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof ProjectViewNode)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable $this$any$iv = (List)destination$iv$iv;
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        ProjectViewNode it = (ProjectViewNode)element$iv;
                        boolean bl2 = false;
                        VirtualFile currVf = it.getVirtualFile();
                        if (!(currVf != null && !(currVf instanceof VirtualDirectoryImpl) && Intrinsics.areEqual((Object)currVf.getParent(), (Object)file))) continue;
                        bl = true;
                        break block7;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
        }
        return super.canRepresent(element);
    }

    private final VirtualFile getVirtualFile(Object element) {
        if (element instanceof PsiDirectory) {
            return ((PsiDirectory)element).getVirtualFile();
        }
        return element instanceof VirtualFile ? (VirtualFile)element : null;
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Project project = this.myProject;
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"myProject");
        ProjectStateManger projectStateManger = ProjectStateManger.Companion.getInstance(project);
        if (this.dumbService.isDumb() || this.myProject == null || this.myProject.isDisposed() || !file.isValid() || FileTypeRegistry.getInstance().isFileIgnored(file) || !projectStateManger.isProjectOpen()) {
            return false;
        }
        if (Intrinsics.areEqual((Object)file, (Object)this.myVirtualFile)) {
            return true;
        }
        if (file instanceof VirtualDirectoryImpl && this.myVirtualFile != null && !(this.myVirtualFile instanceof VirtualDirectoryImpl) && Intrinsics.areEqual((Object)file, (Object)this.myVirtualFile.getParent())) {
            return true;
        }
        Object object = SlowOpertionUtilsKt.nonBlocking(() -> HSection.contains$lambda$3(this, projectStateManger, file)).executeSynchronously();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"executeSynchronously(...)");
        return (Boolean)object;
    }

    @Nullable
    public VirtualFile getVirtualFile() {
        return this.myVirtualFile;
    }

    public boolean someChildContainsFile(@Nullable VirtualFile file) {
        return this.someChildContainsFile(file, true);
    }

    private static final boolean contains$lambda$3(HSection this$0, ProjectStateManger $projectStateManger, VirtualFile $file) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = this$0.getCachedChildren($projectStateManger.isSelectFileInTree());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    AbstractTreeNode it = (AbstractTreeNode)element$iv;
                    boolean bl2 = false;
                    if (!(it instanceof ProjectViewNode && ((ProjectViewNode)it).contains($file))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(HSection.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        HSection.logger = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/jpa/jpb/model/ui/structure/HSection$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.javaee.jpa.jpb.model.ui"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

