/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class DebuggerSettingsUtils {
    private static final Logger LOG = Logger.getInstance(DebuggerSettingsUtils.class);

    private DebuggerSettingsUtils() {
    }

    public static ClassFilter[] readFilters(List<? extends Element> children) {
        if (ContainerUtil.isEmpty(children)) {
            return ClassFilter.EMPTY_ARRAY;
        }
        ArrayList<ClassFilter> filters = new ArrayList<ClassFilter>(children.size());
        for (Element element : children) {
            try {
                filters.add(DebuggerSettingsUtils.create(element));
            }
            catch (InvalidDataException e) {
                LOG.error((Throwable)e);
            }
        }
        return filters.toArray(ClassFilter.EMPTY_ARRAY);
    }

    public static void writeFilters(@NotNull Element parentNode, @NonNls String tagName, ClassFilter[] filters) throws WriteExternalException {
        if (parentNode == null) {
            DebuggerSettingsUtils.$$$reportNull$$$0(0);
        }
        for (ClassFilter filter : filters) {
            Element element = new Element(tagName);
            parentNode.addContent(element);
            DefaultJDOMExternalizer.writeExternal((Object)filter, (Element)element);
        }
    }

    public static ClassFilter create(Element element) throws InvalidDataException {
        ClassFilter filter = new ClassFilter();
        DefaultJDOMExternalizer.readExternal((Object)filter, (Element)element);
        filter.matches("");
        return filter;
    }

    public static boolean filterEquals(ClassFilter[] filters1, ClassFilter[] filters2) {
        if (filters1.length != filters2.length) {
            return false;
        }
        HashSet f1 = new HashSet(Math.max((int)((float)filters1.length / 0.75f) + 1, 16));
        HashSet f2 = new HashSet(Math.max((int)((float)filters2.length / 0.75f) + 1, 16));
        Collections.addAll(f1, filters1);
        Collections.addAll(f2, filters2);
        return f2.equals(f1);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "com/intellij/debugger/settings/DebuggerSettingsUtils", "writeFilters"));
    }
}

