/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cron;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.cron.CronExpressionProvider;
import com.intellij.cron.CronUtilsKt;
import com.intellij.cron.InvalidCronExpression;
import com.intellij.cron.psi.CronExpFile;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J-\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0007\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0003\u00a8\u0006\u0013"}, d2={"Lcom/intellij/cron/CronExpressionValidationInspection;", "Lcom/intellij/codeInspection/LocalInspectionTool;", "<init>", "()V", "checkFile", "", "Lcom/intellij/codeInspection/ProblemDescriptor;", "file", "Lcom/intellij/psi/PsiFile;", "manager", "Lcom/intellij/codeInspection/InspectionManager;", "isOnTheFly", "", "(Lcom/intellij/psi/PsiFile;Lcom/intellij/codeInspection/InspectionManager;Z)[Lcom/intellij/codeInspection/ProblemDescriptor;", "validateCronExpression", "", "Lcom/intellij/cron/psi/CronExpFile;", "cronExpressionProvider", "Lcom/intellij/cron/CronExpressionProvider;", "intellij.cron"})
public final class CronExpressionValidationInspection
extends LocalInspectionTool {
    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        String problem;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        if (!(file instanceof CronExpFile)) {
            return null;
        }
        CronExpressionProvider cronExpressionProvider = CronUtilsKt.getCronExpressionProvider((PsiElement)file);
        if (cronExpressionProvider != null && (problem = this.validateCronExpression((CronExpFile)file, cronExpressionProvider)) != null) {
            InjectedLanguageManager hostManager = InjectedLanguageManager.getInstance((Project)((CronExpFile)file).getProject());
            PsiLanguageInjectionHost psiLanguageInjectionHost = hostManager.getInjectionHost((PsiElement)file);
            if (psiLanguageInjectionHost == null) {
                return null;
            }
            PsiLanguageInjectionHost host = psiLanguageInjectionHost;
            ProblemDescriptor problemDescriptor = manager.createProblemDescriptor((PsiElement)host, problem, LocalQuickFix.EMPTY_ARRAY, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly, false);
            Intrinsics.checkNotNullExpressionValue((Object)problemDescriptor, (String)"createProblemDescriptor(...)");
            ProblemDescriptor problemDescriptor2 = problemDescriptor;
            ProblemDescriptor[] problemDescriptorArray = new ProblemDescriptor[]{problemDescriptor2};
            return problemDescriptorArray;
        }
        return null;
    }

    @InspectionMessage
    private final String validateCronExpression(CronExpFile file, CronExpressionProvider cronExpressionProvider) {
        String cronExpr = file.getText();
        if (Intrinsics.areEqual((Object)cronExpr, (Object)"")) {
            return null;
        }
        try {
            Intrinsics.checkNotNull((Object)cronExpr);
            cronExpressionProvider.getCronExplanation(cronExpr, (PsiElement)file);
            return null;
        }
        catch (InvalidCronExpression iae) {
            return iae.getMessage();
        }
    }
}

