/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.beans;

import com.intellij.microservices.jvm.beans.BeanPresentation;
import com.intellij.microservices.jvm.beans.BeanStereotype;
import com.intellij.microservices.jvm.beans.BeansCursor;
import com.intellij.microservices.jvm.beans.BeansProvider;
import com.intellij.microservices.jvm.beans.FlatBeanItem;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u00020\u0002BA\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u0012\u0006\u0010\n\u001a\u00028\u0000\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0018\u0010\u001b\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u001d0\u001cJ\t\u0010\u001e\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\u0015\u0010 \u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\tH\u00c6\u0003J\u000e\u0010!\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0017J\u000f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0003J^\u0010#\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u0014\b\u0002\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t2\b\b\u0002\u0010\n\u001a\u00028\u00002\u000e\b\u0002\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u00c6\u0001\u00a2\u0006\u0002\u0010$J\u0013\u0010%\u001a\u00020&2\b\u0010'\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010(\u001a\u00020)H\u00d6\u0001J\t\u0010*\u001a\u00020+H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0013\u0010\n\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u0018\u001a\u0004\b\u0016\u0010\u0017R\u0017\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006,"}, d2={"Lcom/intellij/microservices/jvm/beans/FlatBeanGroup;", "G", "", "E", "project", "Lcom/intellij/openapi/project/Project;", "module", "Lcom/intellij/openapi/module/Module;", "provider", "Lcom/intellij/microservices/jvm/beans/BeansProvider;", "group", "stereotypes", "", "Lcom/intellij/microservices/jvm/beans/BeanStereotype;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/intellij/microservices/jvm/beans/BeansProvider;Ljava/lang/Object;Ljava/util/List;)V", "getProject", "()Lcom/intellij/openapi/project/Project;", "getModule", "()Lcom/intellij/openapi/module/Module;", "getProvider", "()Lcom/intellij/microservices/jvm/beans/BeansProvider;", "getGroup", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getStereotypes", "()Ljava/util/List;", "getBeans", "Lkotlin/sequences/Sequence;", "Lcom/intellij/microservices/jvm/beans/FlatBeanItem;", "component1", "component2", "component3", "component4", "component5", "copy", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/module/Module;Lcom/intellij/microservices/jvm/beans/BeansProvider;Ljava/lang/Object;Ljava/util/List;)Lcom/intellij/microservices/jvm/beans/FlatBeanGroup;", "equals", "", "other", "hashCode", "", "toString", "", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nBeansCursor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BeansCursor.kt\ncom/intellij/microservices/jvm/beans/FlatBeanGroup\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,233:1\n14#2:234\n*S KotlinDebug\n*F\n+ 1 BeansCursor.kt\ncom/intellij/microservices/jvm/beans/FlatBeanGroup\n*L\n176#1:234\n*E\n"})
final class FlatBeanGroup<G, E> {
    @NotNull
    private final Project project;
    @NotNull
    private final Module module;
    @NotNull
    private final BeansProvider<G, E> provider;
    @NotNull
    private final G group;
    @NotNull
    private final List<BeanStereotype> stereotypes;

    public FlatBeanGroup(@NotNull Project project, @NotNull Module module, @NotNull BeansProvider<G, E> provider, @NotNull G group, @NotNull List<? extends BeanStereotype> stereotypes) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(stereotypes, (String)"stereotypes");
        this.project = project;
        this.module = module;
        this.provider = provider;
        this.group = group;
        this.stereotypes = stereotypes;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final Module getModule() {
        return this.module;
    }

    @NotNull
    public final BeansProvider<G, E> getProvider() {
        return this.provider;
    }

    @NotNull
    public final G getGroup() {
        return this.group;
    }

    @NotNull
    public final List<BeanStereotype> getStereotypes() {
        return this.stereotypes;
    }

    @NotNull
    public final Sequence<FlatBeanItem<G, E>> getBeans() {
        Iterable iterable;
        try {
            iterable = this.provider.getBeans(this.group, this.stereotypes);
        }
        catch (Exception ex) {
            if (ex instanceof ControlFlowException) {
                throw ex;
            }
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(BeansCursor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error((Throwable)ex);
            iterable = CollectionsKt.emptyList();
        }
        Iterable beans = iterable;
        return SequencesKt.map((Sequence)CollectionsKt.asSequence(beans), arg_0 -> FlatBeanGroup.getBeans$lambda$0(this, arg_0));
    }

    @NotNull
    public final Project component1() {
        return this.project;
    }

    @NotNull
    public final Module component2() {
        return this.module;
    }

    @NotNull
    public final BeansProvider<G, E> component3() {
        return this.provider;
    }

    @NotNull
    public final G component4() {
        return this.group;
    }

    @NotNull
    public final List<BeanStereotype> component5() {
        return this.stereotypes;
    }

    @NotNull
    public final FlatBeanGroup<G, E> copy(@NotNull Project project, @NotNull Module module, @NotNull BeansProvider<G, E> provider, @NotNull G group, @NotNull List<? extends BeanStereotype> stereotypes) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter(provider, (String)"provider");
        Intrinsics.checkNotNullParameter(group, (String)"group");
        Intrinsics.checkNotNullParameter(stereotypes, (String)"stereotypes");
        return new FlatBeanGroup<G, E>(project, module, provider, group, stereotypes);
    }

    public static /* synthetic */ FlatBeanGroup copy$default(FlatBeanGroup flatBeanGroup, Project project, Module module, BeansProvider beansProvider, Object object, List list2, int n, Object object2) {
        if ((n & 1) != 0) {
            project = flatBeanGroup.project;
        }
        if ((n & 2) != 0) {
            module = flatBeanGroup.module;
        }
        if ((n & 4) != 0) {
            beansProvider = flatBeanGroup.provider;
        }
        if ((n & 8) != 0) {
            object = flatBeanGroup.group;
        }
        if ((n & 0x10) != 0) {
            list2 = flatBeanGroup.stereotypes;
        }
        return flatBeanGroup.copy(project, module, beansProvider, object, list2);
    }

    @NotNull
    public String toString() {
        return "FlatBeanGroup(project=" + this.project + ", module=" + this.module + ", provider=" + this.provider + ", group=" + this.group + ", stereotypes=" + this.stereotypes + ")";
    }

    public int hashCode() {
        int result = this.project.hashCode();
        result = result * 31 + this.module.hashCode();
        result = result * 31 + this.provider.hashCode();
        result = result * 31 + this.group.hashCode();
        result = result * 31 + ((Object)this.stereotypes).hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof FlatBeanGroup)) {
            return false;
        }
        FlatBeanGroup flatBeanGroup = (FlatBeanGroup)other;
        if (!Intrinsics.areEqual((Object)this.project, (Object)flatBeanGroup.project)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.module, (Object)flatBeanGroup.module)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.provider, flatBeanGroup.provider)) {
            return false;
        }
        if (!Intrinsics.areEqual(this.group, flatBeanGroup.group)) {
            return false;
        }
        return Intrinsics.areEqual(this.stereotypes, flatBeanGroup.stereotypes);
    }

    private static final FlatBeanItem getBeans$lambda$0(FlatBeanGroup this$0, Object it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        BeanPresentation presentation2 = this$0.provider.getBeanPresentation(this$0.group, it);
        return new FlatBeanItem(this$0.project, this$0.module, this$0.provider, this$0.group, it, presentation2);
    }
}

