/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config;

import com.intellij.codeInsight.completion.PrioritizedLookupElement;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.icons.AllIcons;
import com.intellij.microservices.jvm.config.AbstractMetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKey;
import com.intellij.microservices.jvm.config.MetaConfigKeyLookupElementBuilder;
import com.intellij.microservices.jvm.config.MetaConfigKeyType;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.ui.IconManager;
import com.intellij.ui.PlatformIcons;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b&\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0003H\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\n\u0010\u0017\u001a\u0004\u0018\u00010\u0007H\u0016J\n\u0010\u0018\u001a\u0004\u0018\u00010\u0007H\u0016J%\u0010\u0019\u001a\u00020\u001a2\u0016\u0010\u001b\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\t0\u001c\"\u0004\u0018\u00010\tH\u0016\u00a2\u0006\u0002\u0010\u001dJ\n\u0010\u001e\u001a\u0004\u0018\u00010\u001fH\u0016J\b\u0010 \u001a\u00020!H\u0016J\n\u0010\"\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010#\u001a\u00020$H\u0016J\b\u0010%\u001a\u00020$H\u0016J\b\u0010&\u001a\u00020\u0014H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/intellij/microservices/jvm/config/AbstractMetaConfigKey;", "Lcom/intellij/microservices/jvm/config/MetaConfigKey;", "name", "", "declaration", "Lcom/intellij/psi/PsiElement;", "type", "Lcom/intellij/psi/PsiType;", "accessType", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$AccessType;", "<init>", "(Ljava/lang/String;Lcom/intellij/psi/PsiElement;Lcom/intellij/psi/PsiType;Lcom/intellij/microservices/jvm/config/MetaConfigKey$AccessType;)V", "declarationAnchor", "Lcom/intellij/psi/PsiAnchor;", "Lorg/jetbrains/annotations/NotNull;", "keyType", "Lcom/intellij/microservices/jvm/config/MetaConfigKeyType;", "getKeyType", "()Lcom/intellij/microservices/jvm/config/MetaConfigKeyType;", "presentation", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$MetaConfigKeyPresentation;", "getName", "getDeclaration", "getType", "getEffectiveValueType", "isAccessType", "", "types", "", "([Lcom/intellij/microservices/jvm/config/MetaConfigKey$AccessType;)Z", "getMapKeyType", "Lcom/intellij/psi/PsiClass;", "getDeprecation", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$Deprecation;", "getDefaultValue", "getItemHint", "Lcom/intellij/microservices/jvm/config/MetaConfigKey$ItemHint;", "getKeyItemHint", "getPresentation", "intellij.microservices.config"})
@SourceDebugExtension(value={"SMAP\nAbstractMetaConfigKey.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AbstractMetaConfigKey.kt\ncom/intellij/microservices/jvm/config/AbstractMetaConfigKey\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,77:1\n12637#2,2:78\n*S KotlinDebug\n*F\n+ 1 AbstractMetaConfigKey.kt\ncom/intellij/microservices/jvm/config/AbstractMetaConfigKey\n*L\n63#1:78,2\n*E\n"})
public abstract class AbstractMetaConfigKey
implements MetaConfigKey {
    @NotNull
    private final String name;
    @NotNull
    private final PsiAnchor declarationAnchor;
    @NotNull
    private final MetaConfigKeyType keyType;
    @NotNull
    private final MetaConfigKey.MetaConfigKeyPresentation presentation;

    public AbstractMetaConfigKey(@NotNull String name, @NotNull PsiElement declaration, @Nullable PsiType type, @NotNull MetaConfigKey.AccessType accessType) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)((Object)accessType), (String)"accessType");
        this.name = name;
        PsiAnchor psiAnchor = PsiAnchor.create((PsiElement)declaration);
        Intrinsics.checkNotNullExpressionValue((Object)psiAnchor, (String)"create(...)");
        this.declarationAnchor = psiAnchor;
        Project project = declaration.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        this.keyType = new MetaConfigKeyType(type, accessType, project, this.name);
        this.presentation = new MetaConfigKey.MetaConfigKeyPresentation(this){
            final /* synthetic */ AbstractMetaConfigKey this$0;
            {
                this.this$0 = $receiver;
            }

            public Icon getIcon() {
                Icon icon;
                switch (presentation.WhenMappings.$EnumSwitchMapping$0[this.this$0.getKeyType().getAccessType().ordinal()]) {
                    case 1: {
                        Icon icon2 = AllIcons.Nodes.PropertyRead;
                        icon = icon2;
                        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"PropertyRead");
                        break;
                    }
                    case 2: {
                        Icon icon3 = AllIcons.Nodes.PropertyWrite;
                        icon = icon3;
                        Intrinsics.checkNotNullExpressionValue((Object)icon3, (String)"PropertyWrite");
                        break;
                    }
                    case 3: {
                        Icon icon4 = AllIcons.Nodes.PropertyWriteStatic;
                        icon = icon4;
                        Intrinsics.checkNotNullExpressionValue((Object)icon4, (String)"PropertyWriteStatic");
                        break;
                    }
                    case 4: {
                        icon = IconManager.Companion.getInstance().getPlatformIcon(PlatformIcons.Property);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
                return icon;
            }

            public LookupElementBuilder getLookupElement() {
                return this.getLookupElement(this.this$0.getName());
            }

            public LookupElementBuilder getLookupElement(String lookupString) {
                Intrinsics.checkNotNullParameter((Object)lookupString, (String)"lookupString");
                LookupElementBuilder lookupElementBuilder = MetaConfigKeyLookupElementBuilder.create(this.this$0, lookupString);
                Intrinsics.checkNotNullExpressionValue((Object)lookupElementBuilder, (String)"create(...)");
                return lookupElementBuilder;
            }

            public LookupElement tuneLookupElement(LookupElement lookupElement) {
                double d;
                Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
                if (!Intrinsics.areEqual((Object)this.this$0.getDeprecation(), (Object)MetaConfigKey.Deprecation.NOT_DEPRECATED)) {
                    d = -100.0;
                } else if (this.this$0.getDeclarationResolveResult() == MetaConfigKey.DeclarationResolveResult.JSON_UNRESOLVED_SOURCE_TYPE) {
                    d = -50.0;
                } else if (this.this$0.getDeclarationResolveResult() == MetaConfigKey.DeclarationResolveResult.ADDITIONAL_JSON) {
                    d = 50.0;
                } else {
                    return lookupElement;
                }
                double priority = d;
                LookupElement lookupElement2 = PrioritizedLookupElement.withPriority((LookupElement)lookupElement, (double)priority);
                Intrinsics.checkNotNullExpressionValue((Object)lookupElement2, (String)"withPriority(...)");
                return lookupElement2;
            }
        };
    }

    @NotNull
    protected final MetaConfigKeyType getKeyType() {
        return this.keyType;
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }

    @Override
    @NotNull
    public PsiElement getDeclaration() {
        PsiElement psiElement = this.declarationAnchor.retrieve();
        if (psiElement == null) {
            throw new IllegalStateException(("Failed to get declaration for config key '" + this.name + "'").toString());
        }
        return psiElement;
    }

    @Override
    @Nullable
    public PsiType getType() {
        return this.keyType.getType();
    }

    @Override
    @Nullable
    public PsiType getEffectiveValueType() {
        return this.keyType.getEffectiveValueType();
    }

    @Override
    public boolean isAccessType(MetaConfigKey.AccessType ... types) {
        boolean bl;
        block1: {
            Intrinsics.checkNotNullParameter((Object)types, (String)"types");
            MetaConfigKey.AccessType accessType = this.keyType.getAccessType();
            MetaConfigKey.AccessType[] $this$any$iv = types;
            boolean $i$f$any = false;
            int n = $this$any$iv.length;
            for (int i = 0; i < n; ++i) {
                MetaConfigKey.AccessType element$iv;
                MetaConfigKey.AccessType it = element$iv = $this$any$iv[i];
                boolean bl2 = false;
                if (!(it == accessType)) continue;
                bl = true;
                break block1;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @Nullable
    public PsiClass getMapKeyType() {
        return this.keyType.getMapKeyClass();
    }

    @Override
    @NotNull
    public MetaConfigKey.Deprecation getDeprecation() {
        MetaConfigKey.Deprecation deprecation = MetaConfigKey.Deprecation.NOT_DEPRECATED;
        Intrinsics.checkNotNullExpressionValue((Object)deprecation, (String)"NOT_DEPRECATED");
        return deprecation;
    }

    @Override
    @Nullable
    public String getDefaultValue() {
        return null;
    }

    @Override
    @NotNull
    public MetaConfigKey.ItemHint getItemHint() {
        MetaConfigKey.ItemHint itemHint = MetaConfigKey.ItemHint.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)itemHint, (String)"NONE");
        return itemHint;
    }

    @Override
    @NotNull
    public MetaConfigKey.ItemHint getKeyItemHint() {
        MetaConfigKey.ItemHint itemHint = MetaConfigKey.ItemHint.NONE;
        Intrinsics.checkNotNullExpressionValue((Object)itemHint, (String)"NONE");
        return itemHint;
    }

    @Override
    @NotNull
    public MetaConfigKey.MetaConfigKeyPresentation getPresentation() {
        return this.presentation;
    }
}

