/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.config.hints;

import com.intellij.microservices.jvm.config.MicroservicesConfigBundle;
import com.intellij.microservices.jvm.config.hints.HintReferenceBase;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.ProcessingContext;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class NumberHintReferenceBase
extends HintReferenceBase {
    public static final Key<Function<String, String>> NUMBER_VALUE_SANITIZER_KEY = Key.create((String)"NUMBER_VALUE_SANITIZER");
    private final Class<? extends Number> myType;
    private final Function<String, String> myValueSanitizer;

    protected NumberHintReferenceBase(@NotNull PsiElement element, @NotNull TextRange range, Class<? extends Number> numberType, ProcessingContext context) {
        if (element == null) {
            NumberHintReferenceBase.$$$reportNull$$$0(0);
        }
        if (range == null) {
            NumberHintReferenceBase.$$$reportNull$$$0(1);
        }
        super(element, range);
        this.myType = numberType;
        this.myValueSanitizer = (Function)context.get(NUMBER_VALUE_SANITIZER_KEY);
    }

    @Override
    public TextAttributesKey getTextAttributesKey() {
        return DefaultLanguageHighlighterColors.NUMBER;
    }

    protected abstract void doDecode(String var1) throws NumberFormatException;

    @Override
    @Nullable
    protected final PsiElement doResolve() {
        String value = this.getValue().trim();
        if (this.myValueSanitizer != null) {
            value = this.myValueSanitizer.apply(value);
        }
        if (StringUtil.isEmpty((String)value)) {
            return null;
        }
        try {
            this.doDecode(value);
            return this.getElement();
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = MicroservicesConfigBundle.partialMessage("config.unresolved.number.value", 1, this.myType.getName());
        if (string == null) {
            NumberHintReferenceBase.$$$reportNull$$$0(2);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "range";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/microservices/jvm/config/hints/NumberHintReferenceBase";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/microservices/jvm/config/hints/NumberHintReferenceBase";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

