/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.debugger.scheduled;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.microservices.jvm.MicroservicesJvmBundle;
import com.intellij.microservices.jvm.debugger.scheduled.CallingService;
import com.intellij.microservices.jvm.debugger.scheduled.ScheduledDebuggerRunConfiguration;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.ui.JBUI;
import javax.swing.JComponent;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000&\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0000\u001a\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\f"}, d2={"callScheduledMethod", "", "element", "Lcom/intellij/psi/PsiElement;", "eventPoint", "Lcom/intellij/ui/awt/RelativePoint;", "calculateJniSignature", "", "uClass", "Lorg/jetbrains/uast/UClass;", "uMethod", "Lorg/jetbrains/uast/UMethod;", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nCallScheduledMethod.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CallScheduledMethod.kt\ncom/intellij/microservices/jvm/debugger/scheduled/CallScheduledMethodKt\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,112:1\n30#2,2:113\n*S KotlinDebug\n*F\n+ 1 CallScheduledMethod.kt\ncom/intellij/microservices/jvm/debugger/scheduled/CallScheduledMethodKt\n*L\n50#1:113,2\n*E\n"})
public final class CallScheduledMethodKt {
    public static final void callScheduledMethod(@NotNull PsiElement element, @Nullable RelativePoint eventPoint) {
        boolean isRunning;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Module module = ModuleUtilCore.findModuleForFile((PsiFile)element.getContainingFile());
        Project project = element.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        ExecutionManager executionManager = ExecutionManager.Companion.getInstance(project2);
        boolean bl = isRunning = module != null && SequencesKt.any((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)RunManager.Companion.getInstance(project2).getAllConfigurationsList()), arg_0 -> CallScheduledMethodKt.callScheduledMethod$lambda$0(module, arg_0)), arg_0 -> CallScheduledMethodKt.callScheduledMethod$lambda$3(executionManager, arg_0)));
        if (!isRunning) {
            JComponent jComponent = HintUtil.createWarningLabel((String)MicroservicesJvmBundle.message("scheduled.target.process.not.started", new Object[0]));
            Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"createWarningLabel(...)");
            JComponent label = jComponent;
            label.setBorder((Border)JBUI.Borders.empty((int)2, (int)7));
            JBPopupFactory.getInstance().createBalloonBuilder(label).setFadeoutTime(3000L).setFillColor(HintUtil.getWarningColor()).createBalloon().show(eventPoint, Balloon.Position.above);
            return;
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)element);
        if (uElement == null) {
            return;
        }
        UElement uElement2 = uElement;
        UMethod uMethod = UastUtils.getContainingUMethod((UElement)uElement2);
        if (uMethod == null) {
            return;
        }
        UMethod uMethod2 = uMethod;
        UElement uElement3 = uMethod2.getUastParent();
        UClass uClass = uElement3 instanceof UClass ? (UClass)uElement3 : null;
        if (uClass == null) {
            return;
        }
        UClass uClass2 = uClass;
        String msg = CallScheduledMethodKt.calculateJniSignature(uClass2, uMethod2);
        ComponentManager $this$service$iv = (ComponentManager)project2;
        boolean $i$f$service = false;
        Class<CallingService> serviceClass$iv = CallingService.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((CallingService)object).callMethod(msg);
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final String calculateJniSignature(UClass uClass, UMethod uMethod) {
        String string;
        StringBuilder stringBuilder;
        PsiType psiType;
        String typeName;
        String string2;
        StringBuilder stringBuilder2;
        String string3;
        String string4 = uClass.getQualifiedName();
        boolean bl = string4 != null ? StringsKt.endsWith$default((String)string4, (String)"Companion", (boolean)false, (int)2, null) : false;
        if (bl) {
            UElement uElement = uClass.getUastParent();
            UClass uClass2 = uElement instanceof UClass ? (UClass)uElement : null;
            string3 = uClass2 != null ? uClass2.getQualifiedName() : null;
        } else {
            string3 = uClass.getQualifiedName();
        }
        String className = string3;
        StringBuilder $this$calculateJniSignature_u24lambda_u244 = stringBuilder2 = new StringBuilder();
        boolean bl2 = false;
        $this$calculateJniSignature_u24lambda_u244.append(className);
        $this$calculateJniSignature_u24lambda_u244.append(':');
        $this$calculateJniSignature_u24lambda_u244.append(uMethod.getName());
        $this$calculateJniSignature_u24lambda_u244.append(':');
        $this$calculateJniSignature_u24lambda_u244.append("()");
        PsiType returnType = uMethod.getReturnType();
        if (returnType instanceof PsiArrayType) {
            int n = ((PsiArrayType)returnType).getArrayDimensions();
            for (int i = 0; i < n; ++i) {
                $this$calculateJniSignature_u24lambda_u244.append('[');
            }
        }
        if ((string2 = (typeName = (psiType = returnType) != null && (psiType = psiType.getDeepComponentType()) != null ? psiType.getCanonicalText() : null)) != null) {
            int n = -1;
            switch (string2.hashCode()) {
                case 3625364: {
                    if (!string2.equals("void")) break;
                    n = 1;
                    break;
                }
                case 64711720: {
                    if (!string2.equals("boolean")) break;
                    n = 2;
                    break;
                }
                case 3039496: {
                    if (!string2.equals("byte")) break;
                    n = 3;
                    break;
                }
                case -1325958191: {
                    if (!string2.equals("double")) break;
                    n = 4;
                    break;
                }
                case 3052374: {
                    if (!string2.equals("char")) break;
                    n = 5;
                    break;
                }
                case 109413500: {
                    if (!string2.equals("short")) break;
                    n = 6;
                    break;
                }
                case 97526364: {
                    if (!string2.equals("float")) break;
                    n = 7;
                    break;
                }
                case 104431: {
                    if (!string2.equals("int")) break;
                    n = 8;
                    break;
                }
                case 3327612: {
                    if (!string2.equals("long")) break;
                    n = 9;
                    break;
                }
            }
            switch (n) {
                case 1: {
                    stringBuilder = $this$calculateJniSignature_u24lambda_u244.append("V");
                    return stringBuilder2.toString();
                }
                case 2: {
                    stringBuilder = $this$calculateJniSignature_u24lambda_u244.append("Z");
                    return stringBuilder2.toString();
                }
                case 3: {
                    stringBuilder = $this$calculateJniSignature_u24lambda_u244.append("B");
                    return stringBuilder2.toString();
                }
                case 6: {
                    stringBuilder = $this$calculateJniSignature_u24lambda_u244.append("S");
                    return stringBuilder2.toString();
                }
                case 5: {
                    stringBuilder = $this$calculateJniSignature_u24lambda_u244.append("C");
                    return stringBuilder2.toString();
                }
                case 8: {
                    stringBuilder = $this$calculateJniSignature_u24lambda_u244.append("I");
                    return stringBuilder2.toString();
                }
                case 9: {
                    stringBuilder = $this$calculateJniSignature_u24lambda_u244.append("J");
                    return stringBuilder2.toString();
                }
                case 7: {
                    stringBuilder = $this$calculateJniSignature_u24lambda_u244.append("F");
                    return stringBuilder2.toString();
                }
                case 4: {
                    stringBuilder = $this$calculateJniSignature_u24lambda_u244.append("D");
                    return stringBuilder2.toString();
                }
            }
        }
        String string5 = typeName;
        if (string5 == null) return "V";
        int genericIndex = StringsKt.indexOf$default((CharSequence)string5, (char)'<', (int)0, (boolean)false, (int)6, null);
        if (genericIndex == -1) {
            string = typeName;
        } else {
            String string6 = typeName.substring(0, genericIndex);
            string = string6;
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"substring(...)");
        }
        String rawTypeName = string;
        stringBuilder = $this$calculateJniSignature_u24lambda_u244.append("L").append(StringsKt.replace$default((String)rawTypeName, (String)".", (String)"/", (boolean)false, (int)4, null)).append(';');
        return stringBuilder2.toString();
    }

    private static final boolean callScheduledMethod$lambda$0(Module $module, RunConfiguration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it instanceof ScheduledDebuggerRunConfiguration && ((ScheduledDebuggerRunConfiguration)it).containsModule($module);
    }

    private static final boolean callScheduledMethod$lambda$3$lambda$1(RunConfiguration $settings, RunnerAndConfigurationSettings it) {
        return Intrinsics.areEqual((Object)it.getName(), (Object)$settings.getName());
    }

    private static final boolean callScheduledMethod$lambda$3$lambda$2(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final Iterable callScheduledMethod$lambda$3(ExecutionManager $executionManager, RunConfiguration settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        return $executionManager.getRunningDescriptors(arg_0 -> CallScheduledMethodKt.callScheduledMethod$lambda$3$lambda$2(arg_0 -> CallScheduledMethodKt.callScheduledMethod$lambda$3$lambda$1(settings, arg_0), arg_0));
    }
}

