/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.microservices.jvm.pathvars;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInsight.intention.preview.IntentionPreviewUtils;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.lang.jvm.JvmMethod;
import com.intellij.lang.jvm.actions.AnnotationAttributeRequest;
import com.intellij.lang.jvm.actions.AnnotationAttributeValueRequestKt;
import com.intellij.lang.jvm.actions.AnnotationRequestsKt;
import com.intellij.lang.jvm.actions.ChangeParametersRequest;
import com.intellij.lang.jvm.actions.ExpectedParameter;
import com.intellij.lang.jvm.actions.JvmElementActionFactories;
import com.intellij.lang.jvm.actions.MethodRequestsKt;
import com.intellij.lang.jvm.actions.ParametersKt;
import com.intellij.lang.jvm.types.JvmType;
import com.intellij.microservices.MicroservicesBundle;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u0007\u001a\u00020\u0003H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/intellij/microservices/jvm/pathvars/PathVariableQuickFix;", "Lcom/intellij/codeInspection/LocalQuickFix;", "pathVariableName", "", "pathVariableAnnotationFQN", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "getName", "getFamilyName", "applyFix", "", "project", "Lcom/intellij/openapi/project/Project;", "descriptor", "Lcom/intellij/codeInspection/ProblemDescriptor;", "makeExpectedPathVariableParameter", "", "Lcom/intellij/lang/jvm/actions/ExpectedParameter;", "name", "context", "Lcom/intellij/psi/PsiElement;", "intellij.microservices.jvm"})
@SourceDebugExtension(value={"SMAP\nPathVariableMethodInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PathVariableMethodInspection.kt\ncom/intellij/microservices/jvm/pathvars/PathVariableQuickFix\n+ 2 UastContext.kt\norg/jetbrains/uast/UastContextKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,185:1\n171#2:186\n19#3:187\n*S KotlinDebug\n*F\n+ 1 PathVariableMethodInspection.kt\ncom/intellij/microservices/jvm/pathvars/PathVariableQuickFix\n*L\n132#1:186\n132#1:187\n*E\n"})
final class PathVariableQuickFix
implements LocalQuickFix {
    @NotNull
    private final String pathVariableName;
    @NotNull
    private final String pathVariableAnnotationFQN;

    public PathVariableQuickFix(@NotNull String pathVariableName, @NotNull String pathVariableAnnotationFQN) {
        Intrinsics.checkNotNullParameter((Object)pathVariableName, (String)"pathVariableName");
        Intrinsics.checkNotNullParameter((Object)pathVariableAnnotationFQN, (String)"pathVariableAnnotationFQN");
        this.pathVariableName = pathVariableName;
        this.pathVariableAnnotationFQN = pathVariableAnnotationFQN;
    }

    @NotNull
    public String getName() {
        Object[] objectArray = new Object[]{this.pathVariableName};
        return MicroservicesBundle.message((String)"PathVariableInspection.quick.fix.create.param.name", (Object[])objectArray);
    }

    @NotNull
    public String getFamilyName() {
        return MicroservicesBundle.message((String)"PathVariableInspection.quick.fix.create.param", (Object[])new Object[0]);
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        UIdentifier uIdentifier;
        List<ExpectedParameter> paramsToAdd;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                PsiElement psiElement = descriptor.getPsiElement();
                if (psiElement == null) {
                    return;
                }
                PsiElement element = psiElement;
                paramsToAdd = this.makeExpectedPathVariableParameter(this.pathVariableName, element);
                PsiElement $this$toUElementOfType$iv = element;
                boolean $i$f$toUElementOfType = false;
                uIdentifier = (UIdentifier)UastContextKt.toUElement((PsiElement)$this$toUElementOfType$iv, UIdentifier.class);
                if (uIdentifier == null || (uIdentifier = uIdentifier.getUastParent()) == null) break block6;
                UIdentifier $this$asSafely$iv = uIdentifier;
                boolean $i$f$asSafely = false;
                UIdentifier uIdentifier2 = $this$asSafely$iv;
                if (!(uIdentifier2 instanceof UMethod)) {
                    uIdentifier2 = null;
                }
                if ((uIdentifier = (UMethod)uIdentifier2) != null && (uIdentifier = uIdentifier.getJavaPsi()) != null) break block7;
            }
            return;
        }
        UIdentifier method = uIdentifier;
        IntentionAction intentionAction = (IntentionAction)CollectionsKt.firstOrNull((List)JvmElementActionFactories.createChangeParametersActions((JvmMethod)((JvmMethod)method), (ChangeParametersRequest)MethodRequestsKt.updateMethodParametersRequest(() -> PathVariableQuickFix.applyFix$lambda$0((PsiMethod)method), arg_0 -> PathVariableQuickFix.applyFix$lambda$1(paramsToAdd, arg_0))));
        if (intentionAction == null) {
            return;
        }
        IntentionAction methodsFix = intentionAction;
        IntentionPreviewUtils.write(() -> PathVariableQuickFix.applyFix$lambda$2(methodsFix, project, descriptor));
    }

    private final List<ExpectedParameter> makeExpectedPathVariableParameter(String name, PsiElement context) {
        AnnotationAttributeRequest[] annotationAttributeRequestArray;
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        boolean isValidIdentifier = PsiNameHelper.getInstance((Project)project2).isIdentifier(name, PsiUtil.getLanguageLevel((PsiElement)context));
        PsiClassType psiClassType = PsiType.getJavaLangString((PsiManager)PsiManager.getInstance((Project)project2), (GlobalSearchScope)context.getResolveScope());
        Intrinsics.checkNotNullExpressionValue((Object)psiClassType, (String)"getJavaLangString(...)");
        JvmType jvmType = (JvmType)psiClassType;
        String string = isValidIdentifier ? name : "parameter";
        if (isValidIdentifier) {
            annotationAttributeRequestArray = new AnnotationAttributeRequest[]{};
        } else {
            AnnotationAttributeRequest[] annotationAttributeRequestArray2 = new AnnotationAttributeRequest[]{AnnotationAttributeValueRequestKt.stringAttribute((String)"value", (String)name)};
            annotationAttributeRequestArray = annotationAttributeRequestArray2;
        }
        AnnotationAttributeRequest[] annotationAttributeRequestArray3 = annotationAttributeRequestArray;
        return CollectionsKt.listOf((Object)ParametersKt.expectedParameter((JvmType)jvmType, (String)string, (Collection)CollectionsKt.listOf((Object)AnnotationRequestsKt.annotationRequest((String)this.pathVariableAnnotationFQN, (AnnotationAttributeRequest[])Arrays.copyOf(annotationAttributeRequestArray3, annotationAttributeRequestArray3.length)))));
    }

    private static final JvmMethod applyFix$lambda$0(PsiMethod $method) {
        return (JvmMethod)$method;
    }

    private static final List applyFix$lambda$1(List $paramsToAdd, List existing) {
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        return ContainerUtil.concat((List)existing, (List)$paramsToAdd);
    }

    private static final void applyFix$lambda$2(IntentionAction $methodsFix, Project $project, ProblemDescriptor $descriptor) {
        $methodsFix.invoke($project, null, $descriptor.getPsiElement().getContainingFile());
    }
}

