/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.modulith.model;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.ide.impl.StructureViewWrapperImpl;
import com.intellij.ide.projectView.ProjectView;
import com.intellij.ide.structureView.StructureViewFactory;
import com.intellij.ide.structureView.StructureViewFactoryEx;
import com.intellij.ide.structureView.StructureViewWrapper;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.ModuleListener;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.ModificationTracker;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiTreeChangeAdapter;
import com.intellij.psi.PsiTreeChangeEvent;
import com.intellij.psi.PsiTreeChangeListener;
import com.intellij.psi.impl.PsiTreeChangeEventImpl;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.modulith.SpringModulithLibraryUtilsKt;
import com.intellij.spring.modulith.model.ApplicationModule;
import com.intellij.spring.modulith.model.SpringModulithDesignTimeModelProvider;
import com.intellij.spring.modulith.model.SpringModulithModelCollector;
import com.intellij.spring.modulith.model.SpringModulithModelModificationTracker;
import com.intellij.spring.modulith.model.SpringModulithModelProvider;
import com.intellij.spring.modulith.model.SpringModulithModelServiceKt;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.util.Function;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import kotlinx.coroutines.channels.BufferOverflow;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableSharedFlow;
import kotlinx.coroutines.flow.SharedFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\n\b\u0001\u0018\u0000 +2\u00020\u0001:\u0003)*+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u001b\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u001f\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020\fH\u0002J\b\u0010#\u001a\u00020\u001dH\u0002J\b\u0010$\u001a\u00020\u001dH\u0002J\u001a\u0010%\u001a\u00020\u001d2\u0010\b\u0002\u0010&\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\rH\u0002J\b\u0010'\u001a\u00020\u0010H\u0002J\u0010\u0010(\u001a\u00020\u001d2\u0006\u0010\u001f\u001a\u00020\fH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\n\u001a\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R'\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00130\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\f0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u001a\u001a\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\f\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\u001b0\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/spring/modulith/model/SpringModulithModelService;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "cs", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "modelProvider", "Lcom/intellij/spring/modulith/model/SpringModulithModelProvider;", "model", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/intellij/openapi/module/Module;", "", "Lcom/intellij/spring/modulith/model/ApplicationModule;", "moduleModificationsCount", "", "moduleTrackers", "", "Lcom/intellij/openapi/util/ModificationTracker;", "getModuleTrackers", "()Ljava/util/Map;", "moduleTrackers$delegate", "Lkotlin/Lazy;", "updateRequestsFlow", "Lkotlinx/coroutines/flow/MutableSharedFlow;", "modelUpdatesFlow", "Lkotlin/Pair;", "dispose", "", "getModel", "module", "getModel$intellij_spring_modulith", "hasModulith", "", "initListeners", "initFlowSubscriptions", "resetModel", "modules", "getModificationCount", "collectModelSynchronously", "MyPsiTreeChangeListener", "MyVirtualFileListener", "Companion", "intellij.spring.modulith"})
@SourceDebugExtension(value={"SMAP\nSpringModulithModelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringModulithModelService.kt\ncom/intellij/spring/modulith/model/SpringModulithModelService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,284:1\n1869#2,2:285\n1285#2,2:290\n1299#2,4:292\n3829#3:287\n4344#3,2:288\n*S KotlinDebug\n*F\n+ 1 SpringModulithModelService.kt\ncom/intellij/spring/modulith/model/SpringModulithModelService\n*L\n202#1:285,2\n70#1:290,2\n70#1:292,4\n67#1:287\n67#1:288,2\n*E\n"})
public final class SpringModulithModelService
implements Disposable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final CoroutineScope cs;
    @NotNull
    private final SpringModulithModelProvider modelProvider;
    @NotNull
    private final ConcurrentHashMap<Module, List<ApplicationModule>> model;
    private volatile long moduleModificationsCount;
    @NotNull
    private final Lazy moduleTrackers$delegate;
    @NotNull
    private final MutableSharedFlow<Module> updateRequestsFlow;
    @NotNull
    private final MutableSharedFlow<Pair<Module, List<ApplicationModule>>> modelUpdatesFlow;

    public SpringModulithModelService(@NotNull Project project, @NotNull CoroutineScope cs) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)cs, (String)"cs");
        this.project = project;
        this.cs = cs;
        this.modelProvider = new SpringModulithDesignTimeModelProvider();
        this.model = new ConcurrentHashMap();
        this.moduleTrackers$delegate = LazyKt.lazy(() -> SpringModulithModelService.moduleTrackers_delegate$lambda$2(this));
        this.updateRequestsFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        this.modelUpdatesFlow = SharedFlowKt.MutableSharedFlow$default((int)1, (int)0, (BufferOverflow)BufferOverflow.DROP_OLDEST, (int)2, null);
        PluginVerifier.verifyUltimatePlugin();
        this.initListeners();
        this.initFlowSubscriptions();
    }

    private final Map<Module, ModificationTracker> getModuleTrackers() {
        Lazy lazy = this.moduleTrackers$delegate;
        return (Map)lazy.getValue();
    }

    public void dispose() {
    }

    @NotNull
    public final List<ApplicationModule> getModel$intellij_spring_modulith(@NotNull Module module) {
        List list;
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!this.hasModulith(module)) {
            SpringModulithModelServiceKt.access$getLOG$p().debug("Modulith Model is requested for module '" + module + "' without corresponding dependency. Skipping");
            return CollectionsKt.emptyList();
        }
        if (this.model.get(module) == null) {
            SpringModulithModelServiceKt.access$getLOG$p().debug("Spring Modulith model cache is empty. Requesting model update for module: " + module);
            this.updateRequestsFlow.tryEmit((Object)module);
        } else {
            long newModificationCount = this.getModificationCount();
            if (this.moduleModificationsCount != newModificationCount) {
                SpringModulithModelServiceKt.access$getLOG$p().debug("PSI changed. Requesting Spring Modulith model update for module: " + module);
                this.updateRequestsFlow.tryEmit((Object)module);
            }
        }
        if ((list = this.model.get(module)) == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final boolean hasModulith(Module module) {
        Object object = ReadAction.compute(() -> SpringModulithModelService.hasModulith$lambda$3(module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"compute(...)");
        return (Boolean)object;
    }

    private final void initListeners() {
        SimpleMessageBusConnection messageBus = this.project.getMessageBus().connect(this.cs);
        PsiManager.getInstance((Project)this.project).addPsiTreeChangeListener((PsiTreeChangeListener)new MyPsiTreeChangeListener((Function1<? super Module, Unit>)((Function1)arg_0 -> SpringModulithModelService.initListeners$lambda$4(this, arg_0))), (Disposable)this);
        Topic topic = VirtualFileManager.VFS_CHANGES;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"VFS_CHANGES");
        messageBus.subscribe(topic, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new MyVirtualFileListener(this.project, (Function1<? super Module, Unit>)((Function1)arg_0 -> SpringModulithModelService.initListeners$lambda$5(this, arg_0)))));
        messageBus.subscribe(DumbService.DUMB_MODE, (Object)new DumbService.DumbModeListener(this){
            final /* synthetic */ SpringModulithModelService this$0;
            {
                this.this$0 = $receiver;
            }

            public void exitDumbMode() {
                SpringModulithModelService.resetModel$default(this.this$0, null, 1, null);
            }
        });
        Topic topic2 = ModuleRootListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic2, (String)"TOPIC");
        messageBus.subscribe(topic2, (Object)new ModuleRootListener(this){
            final /* synthetic */ SpringModulithModelService this$0;
            {
                this.this$0 = $receiver;
            }

            public void rootsChanged(ModuleRootEvent event) {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                SpringModulithModelService.resetModel$default(this.this$0, null, 1, null);
            }
        });
        Topic topic3 = ModuleListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic3, (String)"TOPIC");
        messageBus.subscribe(topic3, (Object)new ModuleListener(this){
            final /* synthetic */ SpringModulithModelService this$0;
            {
                this.this$0 = $receiver;
            }

            public void modulesRenamed(Project project, List<? extends Module> modules, Function<? super Module, String> oldNameProvider) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter(modules, (String)"modules");
                Intrinsics.checkNotNullParameter(oldNameProvider, (String)"oldNameProvider");
                SpringModulithModelService.access$resetModel(this.this$0, modules);
            }

            public void moduleRemoved(Project project, Module module) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                Intrinsics.checkNotNullParameter((Object)module, (String)"module");
                SpringModulithModelService.access$resetModel(this.this$0, CollectionsKt.listOf((Object)module));
            }
        });
    }

    private final void initFlowSubscriptions() {
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpringModulithModelService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)((Flow)SpringModulithModelService.access$getModelUpdatesFlow$p(this.this$0)), (Function2)((Function2)new Function2<Pair<? extends Module, ? extends List<? extends ApplicationModule>>, Continuation<? super Unit>, Object>(this.this$0, null){
                            Object L$1;
                            Object L$2;
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SpringModulithModelService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * WARNING - void declaration
                             * Enabled force condition propagation
                             * Lifted jumps to return sites
                             */
                            public final Object invokeSuspend(Object $result) {
                                Pair pair = (Pair)this.L$0;
                                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        void <destruct>;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Module module = (Module)<destruct>.component1();
                                        List appModules = (List)<destruct>.component2();
                                        ((Map)SpringModulithModelService.access$getModel$p(this.this$0)).put(module, appModules);
                                        SpringModulithModelService.access$setModuleModificationsCount$p(this.this$0, SpringModulithModelService.access$getModificationCount(this.this$0));
                                        SpringModulithModelModificationTracker.Companion.getInstance$intellij_spring_modulith(SpringModulithModelService.access$getProject$p(this.this$0)).incModificationCount();
                                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)<destruct>);
                                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)module);
                                        this.L$2 = SpillingKt.nullOutSpilledVariable((Object)appModules);
                                        this.label = 1;
                                        Object object2 = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.this$0, null){
                                            int label;
                                            final /* synthetic */ SpringModulithModelService this$0;
                                            {
                                                this.this$0 = $receiver;
                                                super(2, $completion);
                                            }

                                            /*
                                             * WARNING - void declaration
                                             */
                                            public final Object invokeSuspend(Object $result) {
                                                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                                switch (this.label) {
                                                    case 0: {
                                                        StructureViewWrapper structureViewWrapper;
                                                        StructureViewFactoryEx structureViewFactoryEx;
                                                        ResultKt.throwOnFailure((Object)$result);
                                                        DaemonCodeAnalyzer.getInstance((Project)SpringModulithModelService.access$getProject$p(this.this$0)).restart();
                                                        ProjectView.getInstance((Project)SpringModulithModelService.access$getProject$p(this.this$0)).refresh();
                                                        StructureViewFactory $this$asSafely$iv = StructureViewFactory.getInstance((Project)SpringModulithModelService.access$getProject$p(this.this$0));
                                                        boolean $i$f$asSafely = false;
                                                        StructureViewFactory structureViewFactory = $this$asSafely$iv;
                                                        if (!(structureViewFactory instanceof StructureViewFactoryEx)) {
                                                            structureViewFactory = null;
                                                        }
                                                        if ((structureViewFactoryEx = (StructureViewFactoryEx)structureViewFactory) != null && (structureViewWrapper = structureViewFactoryEx.getStructureViewWrapper()) != null) {
                                                            StructureViewWrapperImpl structureViewWrapperImpl;
                                                            void $this$asSafely$iv2;
                                                            StructureViewWrapper structureViewWrapper2 = structureViewWrapper;
                                                            boolean $i$f$asSafely2 = false;
                                                            Object v1 = $this$asSafely$iv2;
                                                            if (!(v1 instanceof StructureViewWrapperImpl)) {
                                                                v1 = null;
                                                            }
                                                            if ((structureViewWrapperImpl = (StructureViewWrapperImpl)v1) != null) {
                                                                structureViewWrapperImpl.queueUpdate();
                                                            }
                                                        }
                                                        return Unit.INSTANCE;
                                                    }
                                                }
                                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                            }

                                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                                return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                            }

                                            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                            }
                                        }), (Continuation)((Continuation)this));
                                        if (object2 != object) return Unit.INSTANCE;
                                        return object;
                                    }
                                    case 1: {
                                        List appModules = (List)this.L$2;
                                        Module module = (Module)this.L$1;
                                        ResultKt.throwOnFailure((Object)$result);
                                        Object object2 = $result;
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Pair<? extends Module, ? extends List<ApplicationModule>> p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        BuildersKt.launch$default((CoroutineScope)this.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ SpringModulithModelService this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = FlowKt.collectLatest((Flow)FlowKt.debounce((Flow)((Flow)SpringModulithModelService.access$getUpdateRequestsFlow$p(this.this$0)), (long)500L), (Function2)((Function2)new Function2<Module, Continuation<? super Unit>, Object>(this.this$0, null){
                            int label;
                            /* synthetic */ Object L$0;
                            final /* synthetic */ SpringModulithModelService this$0;
                            {
                                this.this$0 = $receiver;
                                super(2, $completion);
                            }

                            /*
                             * Unable to fully structure code
                             */
                            public final Object invokeSuspend(Object $result) {
                                var2_2 = (Module)this.L$0;
                                var4_3 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                switch (this.label) {
                                    case 0: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        this.L$0 = module;
                                        this.label = 1;
                                        v0 = SpringModulithModelService.access$getModelProvider$p(this.this$0).getModel((Module)module, (Continuation<? super List<ApplicationModule>>)((Continuation)this));
                                        if (v0 == var4_3) {
                                            return var4_3;
                                        }
                                        ** GOTO lbl15
                                    }
                                    case 1: {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl15:
                                        // 2 sources

                                        applicationModules = (List)v0;
                                        SpringModulithModelService.access$getModelUpdatesFlow$p(this.this$0).tryEmit((Object)new Pair((Object)module, (Object)applicationModules));
                                        return Unit.INSTANCE;
                                    }
                                }
                                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                            }

                            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                                var3_3.L$0 = value;
                                return (Continuation)var3_3;
                            }

                            public final Object invoke(Module p1, Continuation<? super Unit> p2) {
                                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                            }
                        }), (Continuation)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void resetModel(List<? extends Module> modules) {
        if (modules == null) {
            this.model.clear();
            return;
        }
        Iterable $this$forEach$iv = modules;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Module module = (Module)element$iv;
            boolean bl = false;
            this.model.remove(module);
        }
    }

    static /* synthetic */ void resetModel$default(SpringModulithModelService springModulithModelService, List list, int n, Object object) {
        if ((n & 1) != 0) {
            list = null;
        }
        springModulithModelService.resetModel(list);
    }

    private final long getModificationCount() {
        return SequencesKt.sumOfLong((Sequence)SequencesKt.map((Sequence)SequencesKt.mapNotNull((Sequence)CollectionsKt.asSequence((Iterable)CollectionsKt.toList((Iterable)this.getModuleTrackers().keySet())), arg_0 -> SpringModulithModelService.getModificationCount$lambda$7(this, arg_0)), SpringModulithModelService::getModificationCount$lambda$8));
    }

    @TestOnly
    public final void collectModelSynchronously(@NotNull Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        if (!ApplicationManager.getApplication().isUnitTestMode()) {
            throw new IllegalStateException("SpringModulithModelService#collectModelSynchronously is allowed to invoke only in tests".toString());
        }
        ReadAction.run(() -> SpringModulithModelService.collectModelSynchronously$lambda$9(module, this));
    }

    /*
     * WARNING - void declaration
     */
    private static final Map moduleTrackers_delegate$lambda$2(SpringModulithModelService this$0) {
        void $this$filterTo$iv$iv;
        Module[] $this$filter$iv = ModuleManager.Companion.getInstance(this$0.project).getModules();
        boolean $i$f$filter = false;
        Module[] moduleArray = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Module element$iv$iv2 : $this$filterTo$iv$iv) {
            void module = element$iv$iv2;
            boolean bl = false;
            VirtualFile[] virtualFileArray = ModuleRootManager.getInstance((Module)module).getSourceRoots(false);
            Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getSourceRoots(...)");
            boolean bl2 = !(((Object[])virtualFileArray).length == 0);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv2);
        }
        Iterable $this$associateWith$iv = (List)destination$iv$iv;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            Module element$iv$iv2;
            element$iv$iv2 = (Module)element$iv$iv;
            Object t = element$iv$iv;
            Map map = result$iv;
            boolean bl = false;
            ModificationTracker modificationTracker = SpringModificationTrackersManager.getInstance((Project)this$0.project).getOuterModelsModificationTracker();
            map.put(t, modificationTracker);
        }
        return result$iv;
    }

    private static final Boolean hasModulith$lambda$3(Module $module) {
        return SpringModulithLibraryUtilsKt.hasModulithLibrary($module);
    }

    private static final Unit initListeners$lambda$4(SpringModulithModelService this$0, Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        BuildersKt.launch$default((CoroutineScope)this$0.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, module, null){
            int label;
            final /* synthetic */ SpringModulithModelService this$0;
            final /* synthetic */ Module $module;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SpringModulithModelService.access$resetModel(this.this$0, CollectionsKt.listOf((Object)this.$module));
                        SpringModulithModelService.access$getUpdateRequestsFlow$p(this.this$0).tryEmit((Object)this.$module);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final Unit initListeners$lambda$5(SpringModulithModelService this$0, Module module) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        BuildersKt.launch$default((CoroutineScope)this$0.cs, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, module, null){
            int label;
            final /* synthetic */ SpringModulithModelService this$0;
            final /* synthetic */ Module $module;
            {
                this.this$0 = $receiver;
                this.$module = $module;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        SpringModulithModelService.access$resetModel(this.this$0, CollectionsKt.listOf((Object)this.$module));
                        SpringModulithModelService.access$getUpdateRequestsFlow$p(this.this$0).tryEmit((Object)this.$module);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
        return Unit.INSTANCE;
    }

    private static final ModificationTracker getModificationCount$lambda$7(SpringModulithModelService this$0, Module it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return this$0.getModuleTrackers().get(it);
    }

    private static final long getModificationCount$lambda$8(ModificationTracker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getModificationCount();
    }

    private static final void collectModelSynchronously$lambda$9(Module $module, SpringModulithModelService this$0) {
        List<ApplicationModule> applicationModules = new SpringModulithModelCollector($module).collect$intellij_spring_modulith();
        ((Map)this$0.model).put($module, applicationModules);
    }

    public static final /* synthetic */ void access$resetModel(SpringModulithModelService $this, List modules) {
        $this.resetModel(modules);
    }

    public static final /* synthetic */ MutableSharedFlow access$getModelUpdatesFlow$p(SpringModulithModelService $this) {
        return $this.modelUpdatesFlow;
    }

    public static final /* synthetic */ ConcurrentHashMap access$getModel$p(SpringModulithModelService $this) {
        return $this.model;
    }

    public static final /* synthetic */ void access$setModuleModificationsCount$p(SpringModulithModelService $this, long l) {
        $this.moduleModificationsCount = l;
    }

    public static final /* synthetic */ long access$getModificationCount(SpringModulithModelService $this) {
        return $this.getModificationCount();
    }

    public static final /* synthetic */ Project access$getProject$p(SpringModulithModelService $this) {
        return $this.project;
    }

    public static final /* synthetic */ MutableSharedFlow access$getUpdateRequestsFlow$p(SpringModulithModelService $this) {
        return $this.updateRequestsFlow;
    }

    public static final /* synthetic */ SpringModulithModelProvider access$getModelProvider$p(SpringModulithModelService $this) {
        return $this.modelProvider;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0015\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\b\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/modulith/model/SpringModulithModelService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/spring/modulith/model/SpringModulithModelService;", "project", "Lcom/intellij/openapi/project/Project;", "getInstance$intellij_spring_modulith", "intellij.spring.modulith"})
    @SourceDebugExtension(value={"SMAP\nSpringModulithModelService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringModulithModelService.kt\ncom/intellij/spring/modulith/model/SpringModulithModelService$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,284:1\n30#2,2:285\n*S KotlinDebug\n*F\n+ 1 SpringModulithModelService.kt\ncom/intellij/spring/modulith/model/SpringModulithModelService$Companion\n*L\n282#1:285,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SpringModulithModelService getInstance$intellij_spring_modulith(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<SpringModulithModelService> serviceClass$iv = SpringModulithModelService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (SpringModulithModelService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000e\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/spring/modulith/model/SpringModulithModelService$MyPsiTreeChangeListener;", "Lcom/intellij/psi/PsiTreeChangeAdapter;", "onConfigFileUpdate", "Lkotlin/Function1;", "Lcom/intellij/openapi/module/Module;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "beforeChildAddition", "event", "Lcom/intellij/psi/PsiTreeChangeEvent;", "childrenChanged", "beforeChildRemoval", "childAdded", "childRemoved", "childReplaced", "processChange", "intellij.spring.modulith"})
    private static final class MyPsiTreeChangeListener
    extends PsiTreeChangeAdapter {
        @NotNull
        private final Function1<Module, Unit> onConfigFileUpdate;

        public MyPsiTreeChangeListener(@NotNull Function1<? super Module, Unit> onConfigFileUpdate) {
            Intrinsics.checkNotNullParameter(onConfigFileUpdate, (String)"onConfigFileUpdate");
            this.onConfigFileUpdate = onConfigFileUpdate;
        }

        public void beforeChildAddition(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processChange(event);
        }

        public void childrenChanged(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            if (!(event instanceof PsiTreeChangeEventImpl) || !((PsiTreeChangeEventImpl)event).isGenericChange()) {
                this.processChange(event);
            }
        }

        public void beforeChildRemoval(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processChange(event);
        }

        public void childAdded(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processChange(event);
        }

        public void childRemoved(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processChange(event);
        }

        public void childReplaced(@NotNull PsiTreeChangeEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.processChange(event);
        }

        private final void processChange(PsiTreeChangeEvent event) {
            String languageId;
            PsiFile psiFile = event.getFile();
            PsiFile psiFile2 = psiFile;
            String string = psiFile2 != null && (psiFile2 = psiFile2.getLanguage()) != null ? psiFile2.getID() : (languageId = null);
            if (Intrinsics.areEqual((Object)"Properties", (Object)languageId) || Intrinsics.areEqual((Object)"yaml", (Object)languageId)) {
                Module module = ModuleUtil.findModuleForFile((PsiFile)psiFile);
                if (module == null) {
                    return;
                }
                Module module2 = module;
                this.onConfigFileUpdate.invoke((Object)module2);
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u000eR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0004\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/intellij/spring/modulith/model/SpringModulithModelService$MyVirtualFileListener;", "Lcom/intellij/openapi/vfs/VirtualFileListener;", "project", "Lcom/intellij/openapi/project/Project;", "onConfigFileUpdate", "Lkotlin/Function1;", "Lcom/intellij/openapi/module/Module;", "", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlin/jvm/functions/Function1;)V", "myFileIndex", "Lcom/intellij/openapi/roots/ProjectFileIndex;", "beforeFileDeletion", "event", "Lcom/intellij/openapi/vfs/VirtualFileEvent;", "incModificationCountIfMine", "intellij.spring.modulith"})
    private static final class MyVirtualFileListener
    implements VirtualFileListener {
        @NotNull
        private final Project project;
        @NotNull
        private final Function1<Module, Unit> onConfigFileUpdate;
        @NotNull
        private final ProjectFileIndex myFileIndex;

        public MyVirtualFileListener(@NotNull Project project, @NotNull Function1<? super Module, Unit> onConfigFileUpdate) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(onConfigFileUpdate, (String)"onConfigFileUpdate");
            this.project = project;
            this.onConfigFileUpdate = onConfigFileUpdate;
            ProjectFileIndex projectFileIndex = ProjectFileIndex.getInstance((Project)this.project);
            Intrinsics.checkNotNullExpressionValue((Object)projectFileIndex, (String)"getInstance(...)");
            this.myFileIndex = projectFileIndex;
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            this.incModificationCountIfMine(event);
        }

        public final void incModificationCountIfMine(@NotNull VirtualFileEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            VirtualFile virtualFile = event.getFile();
            Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"getFile(...)");
            VirtualFile file = virtualFile;
            if (!this.myFileIndex.isInContent(file)) {
                return;
            }
            if (!file.isDirectory() && Intrinsics.areEqual((Object)file.getName(), (Object)"package-info.java")) {
                return;
            }
            Module module = ModuleUtil.findModuleForFile((VirtualFile)file, (Project)this.project);
            if (module == null) {
                return;
            }
            Module module2 = module;
            this.onConfigFileUpdate.invoke((Object)module2);
        }
    }
}

