/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.actions;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationGroupManager;
import com.intellij.notification.NotificationType;
import com.intellij.openRewrite.OpenRewriteBundle;
import com.intellij.openRewrite.OpenRewriteIcons;
import com.intellij.openRewrite.OpenRewriteRecipeLibraryContributor;
import com.intellij.openRewrite.actions.OpenRewriteMigrationGroupAction;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeDescriptor;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeService;
import com.intellij.openRewrite.recipe.OpenRewriteType;
import com.intellij.openRewrite.run.OpenRewriteRunConfiguration;
import com.intellij.openRewrite.run.OpenRewriteRunConfigurationTypeKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.text.NaturalComparator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J \u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openRewrite/actions/OpenRewriteMigrationAction;", "Lcom/intellij/openRewrite/actions/OpenRewriteMigrationGroupAction;", "<init>", "()V", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPopupStep", "Lcom/intellij/openapi/ui/popup/ListPopupStep;", "Lcom/intellij/openRewrite/recipe/OpenRewriteRecipeDescriptor;", "descriptors", "", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "project", "Lcom/intellij/openapi/project/Project;", "runRecipe", "descriptor", "intellij.openRewrite"})
@SourceDebugExtension(value={"SMAP\nOpenRewriteMigrationAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OpenRewriteMigrationAction.kt\ncom/intellij/openRewrite/actions/OpenRewriteMigrationAction\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n774#2:129\n865#2:130\n1761#2,3:131\n866#2:134\n*S KotlinDebug\n*F\n+ 1 OpenRewriteMigrationAction.kt\ncom/intellij/openRewrite/actions/OpenRewriteMigrationAction\n*L\n47#1:129\n47#1:130\n48#1:131,3\n47#1:134\n*E\n"})
public final class OpenRewriteMigrationAction
extends OpenRewriteMigrationGroupAction {
    @Override
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        VirtualFile virtualFile = (VirtualFile)e.getData(PlatformDataKeys.VIRTUAL_FILE);
        if (virtualFile == null) {
            return;
        }
        VirtualFile virtualFile2 = virtualFile;
        Runnable runnable = () -> OpenRewriteMigrationAction.actionPerformed$lambda$5(this, project2, virtualFile2);
        Job reloadJob = OpenRewriteRecipeService.reload$default(OpenRewriteRecipeService.Companion.getInstance(project2), null, 1, null);
        if (reloadJob == null) {
            runnable.run();
        } else {
            reloadJob.invokeOnCompletion(arg_0 -> OpenRewriteMigrationAction.actionPerformed$lambda$6(runnable, arg_0));
        }
    }

    private final ListPopupStep<OpenRewriteRecipeDescriptor> createPopupStep(List<OpenRewriteRecipeDescriptor> descriptors, VirtualFile virtualFile, Project project) {
        ArrayList<OpenRewriteRecipeDescriptor> values = new ArrayList<OpenRewriteRecipeDescriptor>((Collection)descriptors);
        List list = values;
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> OpenRewriteMigrationAction.createPopupStep$lambda$8(OpenRewriteMigrationAction::createPopupStep$lambda$7, arg_0), NaturalComparator.INSTANCE);
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        CollectionsKt.sortWith((List)list, comparator);
        String string = OpenRewriteBundle.message("open.rewrite.migration.popup.title", new Object[0]);
        return (ListPopupStep)new BaseListPopupStep<OpenRewriteRecipeDescriptor>(values, this, virtualFile, project, string){
            final /* synthetic */ OpenRewriteMigrationAction this$0;
            final /* synthetic */ VirtualFile $virtualFile;
            final /* synthetic */ Project $project;
            {
                this.this$0 = $receiver;
                this.$virtualFile = $virtualFile;
                this.$project = $project;
                super($super_call_param$1, (List)$values);
            }

            public String getTextFor(OpenRewriteRecipeDescriptor value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                String string = value.getDisplayName();
                if (string == null) {
                    string = value.getName();
                }
                String text = string;
                return text;
            }

            public Icon getIconFor(OpenRewriteRecipeDescriptor value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                Icon icon = OpenRewriteIcons.OpenRewrite;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"OpenRewrite");
                return icon;
            }

            public PopupStep<?> onChosen(OpenRewriteRecipeDescriptor selectedValue, boolean finalChoice) {
                Intrinsics.checkNotNullParameter((Object)selectedValue, (String)"selectedValue");
                OpenRewriteMigrationAction.access$runRecipe(this.this$0, selectedValue, this.$virtualFile, this.$project);
                return BaseListPopupStep.FINAL_CHOICE;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }
        };
    }

    private final void runRecipe(OpenRewriteRecipeDescriptor descriptor, VirtualFile virtualFile, Project project) {
        Object v2;
        RunManager runManager;
        block3: {
            String string = virtualFile.getParent().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
            String path = string;
            runManager = RunManager.Companion.getInstance(project);
            List allSettings = runManager.getConfigurationSettingsList((ConfigurationType)OpenRewriteRunConfigurationTypeKt.openRewriteRunConfigurationType());
            Iterable iterable = allSettings;
            for (Object t : iterable) {
                OpenRewriteRunConfiguration configuration;
                RunnerAndConfigurationSettings it = (RunnerAndConfigurationSettings)t;
                boolean bl = false;
                RunConfiguration runConfiguration = it.getConfiguration();
                OpenRewriteRunConfiguration openRewriteRunConfiguration = runConfiguration instanceof OpenRewriteRunConfiguration ? (OpenRewriteRunConfiguration)runConfiguration : null;
                if (!(openRewriteRunConfiguration == null ? false : Intrinsics.areEqual((Object)(configuration = openRewriteRunConfiguration).getActiveRecipes(), (Object)descriptor.getName()) && Intrinsics.areEqual((Object)configuration.getExpandedWorkingDirectory(), (Object)path))) continue;
                v2 = t;
                break block3;
            }
            v2 = null;
        }
        RunnerAndConfigurationSettings settings = v2;
        if (settings == null) {
            settings = runManager.createConfiguration("", OpenRewriteRunConfigurationTypeKt.openRewriteRunConfigurationType().getConfigurationFactories()[0]);
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNull((Object)runConfiguration, (String)"null cannot be cast to non-null type com.intellij.openRewrite.run.OpenRewriteRunConfiguration");
            OpenRewriteRunConfiguration configuration = (OpenRewriteRunConfiguration)runConfiguration;
            configuration.setActiveRecipes(descriptor.getName());
            configuration.setGeneratedName();
            configuration.setWorkingDirectory(virtualFile.getParent().getPath());
            runManager.setUniqueNameIfNeeded(settings);
            runManager.setTemporaryConfiguration(settings);
        }
        com.intellij.execution.Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getRunExecutorInstance(...)");
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.Companion.createOrNull(executor, settings);
        if (builder != null) {
            ExecutionManager.Companion.getInstance(project).restartRunProfile(ExecutionEnvironmentBuilder.build$default((ExecutionEnvironmentBuilder)builder, null, (int)1, null));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List actionPerformed$lambda$5$lambda$2(Project $project) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = OpenRewriteRecipeService.Companion.getInstance($project).getDescriptors(null, OpenRewriteType.RECIPE);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            boolean bl;
            block4: {
                OpenRewriteRecipeDescriptor descriptor = (OpenRewriteRecipeDescriptor)element$iv$iv;
                boolean bl2 = false;
                Iterable $this$any$iv = OpenRewriteRecipeLibraryContributor.Companion.getEP_NAME$intellij_openRewrite().getExtensionList();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        OpenRewriteRecipeLibraryContributor it = (OpenRewriteRecipeLibraryContributor)element$iv;
                        boolean bl3 = false;
                        if (!it.updateMatches(descriptor.getName())) continue;
                        bl = true;
                        break block4;
                    }
                    bl = false;
                }
            }
            if (!bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final Unit actionPerformed$lambda$5$lambda$3(Project $project, OpenRewriteMigrationAction this$0, VirtualFile $virtualFile, List descriptors) {
        if (descriptors.isEmpty()) {
            NotificationGroup notificationGroup = NotificationGroupManager.getInstance().getNotificationGroup("OpenRewrite");
            String string = OpenRewriteBundle.message("open.rewrite.no.matching.migration", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            notificationGroup.createNotification(string, NotificationType.WARNING).setDisplayId("openRewrite.migration.recipe").setIcon(OpenRewriteIcons.OpenRewrite).notify($project);
            return Unit.INSTANCE;
        }
        JBPopupFactory jBPopupFactory = JBPopupFactory.getInstance();
        Intrinsics.checkNotNull((Object)descriptors);
        ListPopup listPopup = jBPopupFactory.createListPopup(this$0.createPopupStep(descriptors, $virtualFile, $project));
        Intrinsics.checkNotNullExpressionValue((Object)listPopup, (String)"createListPopup(...)");
        ListPopup popup = listPopup;
        popup.showCenteredInCurrentWindow($project);
        return Unit.INSTANCE;
    }

    private static final void actionPerformed$lambda$5$lambda$4(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final void actionPerformed$lambda$5(OpenRewriteMigrationAction this$0, Project $project, VirtualFile $virtualFile) {
        Object[] objectArray = new Object[]{this$0, $project};
        ReadAction.nonBlocking(() -> OpenRewriteMigrationAction.actionPerformed$lambda$5$lambda$2($project)).coalesceBy(objectArray).expireWith((Disposable)OpenRewriteRecipeService.Companion.getInstance($project)).inSmartMode($project).finishOnUiThread(ModalityState.nonModal(), arg_0 -> OpenRewriteMigrationAction.actionPerformed$lambda$5$lambda$4(arg_0 -> OpenRewriteMigrationAction.actionPerformed$lambda$5$lambda$3($project, this$0, $virtualFile, arg_0), arg_0)).submit((Executor)AppExecutorUtil.getAppExecutorService());
    }

    private static final Unit actionPerformed$lambda$6(Runnable $runnable, Throwable it) {
        $runnable.run();
        return Unit.INSTANCE;
    }

    private static final String createPopupStep$lambda$7(OpenRewriteRecipeDescriptor it) {
        String string = it.getDisplayName();
        if (string == null) {
            string = it.getName();
        }
        return string;
    }

    private static final String createPopupStep$lambda$8(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ void access$runRecipe(OpenRewriteMigrationAction $this, OpenRewriteRecipeDescriptor descriptor, VirtualFile virtualFile, Project project) {
        $this.runRecipe(descriptor, virtualFile, project);
    }
}

