/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.run;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.LocatableConfigurationBase;
import com.intellij.execution.configurations.LocatableRunConfigurationOptions;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunConfigurationOptions;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.util.ProgramParametersUtil;
import com.intellij.openRewrite.OpenRewriteBundle;
import com.intellij.openRewrite.run.OpenRewriteExternalSystemBridge;
import com.intellij.openRewrite.run.OpenRewriteRunConfigurationOptions;
import com.intellij.openRewrite.run.editor.OpenRewriteFragmentSettingsEditor;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u001a\n\u0002\u0010%\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\fH\u0016J\u001a\u00108\u001a\u0004\u0018\u0001092\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020=H\u0016J\u0010\u0010>\u001a\n\u0012\u0006\b\u0001\u0012\u00020@0?H\u0014J\b\u0010A\u001a\u00020BH\u0014J\n\u0010C\u001a\u0004\u0018\u00010\u0004H\u0016J\b\u0010D\u001a\u00020EH\u0016J\b\u0010F\u001a\u0004\u0018\u00010\u0004J\b\u0010G\u001a\u0004\u0018\u00010\u0004R(\u0010\u000f\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R$\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R(\u0010\u001a\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001b\u0010\u0011\"\u0004\b\u001c\u0010\u0013R(\u0010\u001d\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u001e\u0010\u0011\"\u0004\b\u001f\u0010\u0013R(\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b!\u0010\u0011\"\u0004\b\"\u0010\u0013R(\u0010#\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b$\u0010\u0011\"\u0004\b%\u0010\u0013R(\u0010&\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b'\u0010\u0011\"\u0004\b(\u0010\u0013R(\u0010)\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b*\u0010\u0011\"\u0004\b+\u0010\u0013R(\u0010,\u001a\u0004\u0018\u00010\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u00048F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b-\u0010\u0011\"\u0004\b.\u0010\u0013R<\u00100\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040/2\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040/8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00105\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u00148F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b6\u0010\u0017\"\u0004\b7\u0010\u0019\u00a8\u0006H"}, d2={"Lcom/intellij/openRewrite/run/OpenRewriteRunConfiguration;", "Lcom/intellij/execution/configurations/LocatableConfigurationBase;", "Lorg/jdom/Element;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "factory", "Lcom/intellij/execution/configurations/ConfigurationFactory;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/configurations/ConfigurationFactory;)V", "getConfigurationEditor", "Lcom/intellij/openapi/options/SettingsEditor;", "Lcom/intellij/execution/configurations/RunConfiguration;", "value", "workingDirectory", "getWorkingDirectory", "()Ljava/lang/String;", "setWorkingDirectory", "(Ljava/lang/String;)V", "", "dryRun", "getDryRun", "()Z", "setDryRun", "(Z)V", "activeRecipes", "getActiveRecipes", "setActiveRecipes", "activeStyles", "getActiveStyles", "setActiveStyles", "configLocation", "getConfigLocation", "setConfigLocation", "exclusions", "getExclusions", "setExclusions", "plainTextMasks", "getPlainTextMasks", "setPlainTextMasks", "libraryVersion", "getLibraryVersion", "setLibraryVersion", "vmOptions", "getVmOptions", "setVmOptions", "", "envs", "getEnvs", "()Ljava/util/Map;", "setEnvs", "(Ljava/util/Map;)V", "passParentEnv", "getPassParentEnv", "setPassParentEnv", "getState", "Lcom/intellij/execution/configurations/RunProfileState;", "executor", "Lcom/intellij/execution/Executor;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "getOptionsClass", "Ljava/lang/Class;", "Lcom/intellij/execution/configurations/RunConfigurationOptions;", "getOptions", "Lcom/intellij/openRewrite/run/OpenRewriteRunConfigurationOptions;", "suggestedName", "checkConfiguration", "", "getExpandedWorkingDirectory", "getExpandedConfigLocation", "intellij.openRewrite"})
public final class OpenRewriteRunConfiguration
extends LocatableConfigurationBase<Element> {
    public OpenRewriteRunConfiguration(@NotNull String name, @NotNull Project project, @NotNull ConfigurationFactory factory2) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)factory2, (String)"factory");
        super(project, factory2, name);
    }

    @NotNull
    public SettingsEditor<? extends RunConfiguration> getConfigurationEditor() {
        return (SettingsEditor)new OpenRewriteFragmentSettingsEditor(this);
    }

    @Nullable
    public final String getWorkingDirectory() {
        return this.getOptions().getWorkingDirectory();
    }

    public final void setWorkingDirectory(@Nullable String value) {
        this.getOptions().setWorkingDirectory(value);
    }

    public final boolean getDryRun() {
        return this.getOptions().getDryRun();
    }

    public final void setDryRun(boolean value) {
        this.getOptions().setDryRun(value);
    }

    @Nullable
    public final String getActiveRecipes() {
        return this.getOptions().getActiveRecipes();
    }

    public final void setActiveRecipes(@Nullable String value) {
        this.getOptions().setActiveRecipes(value);
    }

    @Nullable
    public final String getActiveStyles() {
        return this.getOptions().getActiveStyles();
    }

    public final void setActiveStyles(@Nullable String value) {
        this.getOptions().setActiveStyles(value);
    }

    @Nullable
    public final String getConfigLocation() {
        return this.getOptions().getConfigLocation();
    }

    public final void setConfigLocation(@Nullable String value) {
        this.getOptions().setConfigLocation(value);
    }

    @Nullable
    public final String getExclusions() {
        return this.getOptions().getExclusions();
    }

    public final void setExclusions(@Nullable String value) {
        this.getOptions().setExclusions(value);
    }

    @Nullable
    public final String getPlainTextMasks() {
        return this.getOptions().getPlainTextMasks();
    }

    public final void setPlainTextMasks(@Nullable String value) {
        this.getOptions().setPlainTextMasks(value);
    }

    @Nullable
    public final String getLibraryVersion() {
        return this.getOptions().getLibraryVersion();
    }

    public final void setLibraryVersion(@Nullable String value) {
        this.getOptions().setLibraryVersion(value);
    }

    @Nullable
    public final String getVmOptions() {
        return this.getOptions().getVmOptions();
    }

    public final void setVmOptions(@Nullable String value) {
        this.getOptions().setVmOptions(value);
    }

    @NotNull
    public final Map<String, String> getEnvs() {
        return this.getOptions().getEnvs();
    }

    public final void setEnvs(@NotNull Map<String, String> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.getOptions().setEnvs(value);
    }

    public final boolean getPassParentEnv() {
        return this.getOptions().getPassParentEnv();
    }

    public final void setPassParentEnv(boolean value) {
        this.getOptions().setPassParentEnv(value);
    }

    @Nullable
    public RunProfileState getState(@NotNull Executor executor, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)environment, (String)"environment");
        RunConfiguration runConfiguration = OpenRewriteExternalSystemBridge.Companion.findDelegate(this);
        if (runConfiguration == null) {
            throw new ExecutionException(OpenRewriteBundle.message("open.rewrite.run.configuration.no.delegate", new Object[0]));
        }
        RunConfiguration delegate = runConfiguration;
        return delegate.getState(executor, environment);
    }

    @NotNull
    protected Class<? extends RunConfigurationOptions> getOptionsClass() {
        return OpenRewriteRunConfigurationOptions.class;
    }

    @NotNull
    protected OpenRewriteRunConfigurationOptions getOptions() {
        LocatableRunConfigurationOptions locatableRunConfigurationOptions = super.getOptions();
        Intrinsics.checkNotNull((Object)locatableRunConfigurationOptions, (String)"null cannot be cast to non-null type com.intellij.openRewrite.run.OpenRewriteRunConfigurationOptions");
        return (OpenRewriteRunConfigurationOptions)locatableRunConfigurationOptions;
    }

    @Nullable
    public String suggestedName() {
        String string = this.getActiveRecipes();
        if (string == null || (string = StringsKt.substringBefore$default((String)string, (char)',', null, (int)2, null)) == null) {
            return null;
        }
        String recipe = string;
        return StringsKt.substringAfterLast$default((String)recipe, (char)'.', null, (int)2, null);
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        CharSequence charSequence = this.getOptions().getWorkingDirectory();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new RuntimeConfigurationException(ExecutionBundle.message((String)"run.configuration.working.directory.empty.error", (Object[])new Object[0]));
        }
        charSequence = this.getOptions().getActiveRecipes();
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            throw new RuntimeConfigurationException(OpenRewriteBundle.message("open.rewrite.run.configuration.no.active.recipe", new Object[0]));
        }
        if (OpenRewriteExternalSystemBridge.Companion.findDelegate(this) == null) {
            throw new RuntimeConfigurationException(OpenRewriteBundle.message("open.rewrite.run.configuration.no.delegate", new Object[0]));
        }
    }

    @Nullable
    public final String getExpandedWorkingDirectory() {
        return ProgramParametersUtil.expandPathAndMacros((String)this.getWorkingDirectory(), null, (Project)this.getProject());
    }

    @Nullable
    public final String getExpandedConfigLocation() {
        return ProgramParametersUtil.expandPathAndMacros((String)this.getConfigLocation(), null, (Project)this.getProject());
    }
}

