/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.run;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.history.ActivityId;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openRewrite.OpenRewriteBundle;
import com.intellij.openRewrite.run.ChangesHyperlinkConsoleWriter;
import com.intellij.openRewrite.run.OpenRewriteRunUtilsKt;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000:\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a4\u0010\u0000\u001a\u0004\u0018\u00010\u00012\b\b\u0001\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\u000e\u0010\u0007\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\b\u001a\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\u00032\b\u0010\f\u001a\u0004\u0018\u00010\u0003H\u0001\u001a\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00030\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0003\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u001a\u0010\u0010\u0014\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0000\u00a8\u0006\u0015"}, d2={"executeInLocalHistoryAction", "Lcom/intellij/execution/ExecutionResult;", "name", "", "project", "Lcom/intellij/openapi/project/Project;", "workingDirectory", "resultSupplier", "Ljava/util/function/Supplier;", "getBaseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "findConfigFile", "configLocation", "splitConfigurationValue", "", "value", "isRecipe", "", "psiClass", "Lcom/intellij/psi/PsiClass;", "isStyle", "intellij.openRewrite"})
@SourceDebugExtension(value={"SMAP\nopenRewriteRunUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 openRewriteRunUtils.kt\ncom/intellij/openRewrite/run/OpenRewriteRunUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,140:1\n17123#2,14:141\n1563#3:155\n1634#3,3:156\n774#3:159\n865#3,2:160\n*S KotlinDebug\n*F\n+ 1 openRewriteRunUtils.kt\ncom/intellij/openRewrite/run/OpenRewriteRunUtilsKt\n*L\n88#1:141,14\n105#1:155\n105#1:156,3\n105#1:159\n105#1:160,2\n*E\n"})
public final class OpenRewriteRunUtilsKt {
    @Nullable
    public static final ExecutionResult executeInLocalHistoryAction(@NlsSafe @NotNull String name, @NotNull Project project, @Nullable String workingDirectory, @NotNull Supplier<ExecutionResult> resultSupplier) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(resultSupplier, (String)"resultSupplier");
        ActivityId activityId = new ActivityId("OpenRewrite", "Recipe");
        Object[] objectArray = new Object[]{name};
        LocalHistoryAction action = LocalHistory.Companion.getInstance().startAction(OpenRewriteBundle.message("open.rewrite.recipe.local.history.label", objectArray), activityId);
        try {
            ExecutionResult result = resultSupplier.get();
            if (result == null) {
                action.finish();
                return null;
            }
            ProcessHandler processHandler = result.getProcessHandler();
            processHandler.addProcessListener((ProcessListener)new ProcessAdapter(processHandler, workingDirectory, project, action, result){
                final /* synthetic */ ProcessHandler $processHandler;
                final /* synthetic */ String $workingDirectory;
                final /* synthetic */ Project $project;
                final /* synthetic */ LocalHistoryAction $action;
                final /* synthetic */ ExecutionResult $result;
                {
                    this.$processHandler = $processHandler;
                    this.$workingDirectory = $workingDirectory;
                    this.$project = $project;
                    this.$action = $action;
                    this.$result = $result;
                }

                public void processTerminated(ProcessEvent event) {
                    ChangesHyperlinkConsoleWriter writer;
                    String file;
                    String string;
                    block10: {
                        block9: {
                            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                            this.$processHandler.removeProcessListener((ProcessListener)this);
                            string = this.$workingDirectory;
                            if (string == null) break block9;
                            String it = string;
                            boolean bl = false;
                            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)new File(it), (boolean)false);
                            string = virtualFile;
                            if (virtualFile != null) break block10;
                        }
                        string = OpenRewriteRunUtilsKt.access$getBaseDir(this.$project);
                    }
                    if ((file = string) == null) {
                        this.$action.finish();
                        return;
                    }
                    Integer n = this.$processHandler.getExitCode();
                    if (n != null && n == 0) {
                        ExecutionConsole executionConsole = this.$result.getExecutionConsole();
                        ConsoleView consoleView = executionConsole instanceof ConsoleView ? (ConsoleView)executionConsole : null;
                        if (consoleView != null) {
                            executionConsole = consoleView;
                            Project project = this.$project;
                            ExecutionConsole it = executionConsole;
                            boolean bl = false;
                            v4 = new ChangesHyperlinkConsoleWriter((ConsoleView)it, project, (VirtualFile)file);
                        } else {
                            v4 = null;
                        }
                    } else {
                        v4 = writer = null;
                    }
                    if (writer != null) {
                        Disposer.register((Disposable)((Disposable)this.$result.getExecutionConsole()), (Disposable)writer);
                    }
                    file.refresh(true, true, () -> executeInLocalHistoryAction.1.processTerminated$lambda$2(this.$action, writer));
                }

                private static final void processTerminated$lambda$2(LocalHistoryAction $action, ChangesHyperlinkConsoleWriter $writer) {
                    block0: {
                        $action.finish();
                        ChangesHyperlinkConsoleWriter changesHyperlinkConsoleWriter = $writer;
                        if (changesHyperlinkConsoleWriter == null) break block0;
                        changesHyperlinkConsoleWriter.printHyperlink();
                    }
                }
            });
            return result;
        }
        catch (ExecutionException e) {
            action.finish();
            throw e;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final VirtualFile getBaseDir(Project project) {
        Object object;
        VirtualFile[] virtualFileArray = ProjectRootManager.getInstance((Project)project).getContentRoots();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getContentRoots(...)");
        Object[] $this$minByOrNull$iv = virtualFileArray;
        boolean $i$f$minByOrNull = false;
        if ($this$minByOrNull$iv.length == 0) {
            object = null;
        } else {
            Object minElem$iv = $this$minByOrNull$iv[0];
            int lastIndex$iv = ArraysKt.getLastIndex((Object[])$this$minByOrNull$iv);
            if (lastIndex$iv == 0) {
                object = minElem$iv;
            } else {
                void var3_3;
                VirtualFile it = (VirtualFile)minElem$iv;
                boolean bl = false;
                int minValue$iv = it.getPath().length();
                int i$iv = 1;
                if (i$iv <= lastIndex$iv) {
                    while (true) {
                        Object e$iv = $this$minByOrNull$iv[i$iv];
                        VirtualFile it2 = (VirtualFile)e$iv;
                        $i$a$-minByOrNull-OpenRewriteRunUtilsKt$getBaseDir$1 = false;
                        int v$iv = it2.getPath().length();
                        if (minValue$iv > v$iv) {
                            minElem$iv = e$iv;
                            minValue$iv = v$iv;
                        }
                        if (i$iv == lastIndex$iv) break;
                        ++i$iv;
                    }
                }
                object = var3_3;
            }
        }
        return (VirtualFile)object;
    }

    @RequiresReadLock
    @Nullable
    public static final VirtualFile findConfigFile(@Nullable String workingDirectory, @Nullable String configLocation) {
        CharSequence charSequence = configLocation;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            Path path = Paths.get(configLocation, new String[0]);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
            return VfsUtil.findFile((Path)path, (boolean)false);
        }
        charSequence = workingDirectory;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        Path path = Paths.get(workingDirectory, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
        VirtualFile virtualFile = VfsUtil.findFile((Path)path, (boolean)false);
        if (virtualFile == null) {
            return null;
        }
        VirtualFile workingDirectoryFile = virtualFile;
        return VirtualFileUtil.findFile((VirtualFile)workingDirectoryFile, (String)"rewrite.yml");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final List<String> splitConfigurationValue(@Nullable String value) {
        void $this$filterTo$iv$iv;
        String it;
        Iterable $this$mapTo$iv$iv;
        String[] stringArray;
        Object object = value;
        if (object == null || (object = StringsKt.split$default((CharSequence)((CharSequence)object), (String[])(stringArray = new String[]{","}), (boolean)false, (int)0, (int)6, null)) == null) {
            object = CollectionsKt.emptyList();
        }
        Object values = object;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(((Object)StringsKt.trim((CharSequence)it)).toString());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final boolean isRecipe(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (!psiClass.hasModifierProperty("public") || psiClass.hasModifierProperty("abstract")) {
            return false;
        }
        PsiClass psiClass2 = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("org.openrewrite.Recipe", psiClass.getResolveScope());
        if (psiClass2 == null) {
            return false;
        }
        PsiClass recipeClass = psiClass2;
        return psiClass.isInheritor(recipeClass, true);
    }

    public static final boolean isStyle(@NotNull PsiClass psiClass) {
        Intrinsics.checkNotNullParameter((Object)psiClass, (String)"psiClass");
        if (!psiClass.hasModifierProperty("public") || psiClass.hasModifierProperty("abstract")) {
            return false;
        }
        PsiClass psiClass2 = JavaPsiFacade.getInstance((Project)psiClass.getProject()).findClass("org.openrewrite.style.Style", psiClass.getResolveScope());
        if (psiClass2 == null) {
            return false;
        }
        PsiClass recipeClass = psiClass2;
        return psiClass.isInheritor(recipeClass, true);
    }

    public static final /* synthetic */ VirtualFile access$getBaseDir(Project project) {
        return OpenRewriteRunUtilsKt.getBaseDir(project);
    }
}

