/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.run.before;

import com.intellij.compiler.options.CompileStepBeforeRun;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeService;
import com.intellij.openRewrite.run.OpenRewriteRunConfiguration;
import com.intellij.openRewrite.run.before.OpenRewriteInstallBeforeRunTask;
import com.intellij.openRewrite.run.before.OpenRewriteInstallBeforeRunTaskProviderKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.compiler.ClassObject;
import com.intellij.openapi.compiler.CompilationException;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileTask;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.roots.SyntheticLibrary;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JpsJavaSdkType;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u0016\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0002J \u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0002\u00a8\u0006\u0015"}, d2={"Lcom/intellij/openRewrite/run/before/OpenRewriteScratchClassCompilationSupport;", "Lcom/intellij/openapi/compiler/CompileTask;", "<init>", "()V", "execute", "", "context", "Lcom/intellij/openapi/compiler/CompileContext;", "getClasspath", "", "Ljava/io/File;", "project", "Lcom/intellij/openapi/project/Project;", "getPlatformClasspath", "getCompilerOptions", "", "", "sdk", "Lcom/intellij/openapi/projectRoots/Sdk;", "charset", "Ljava/nio/charset/Charset;", "intellij.openRewrite"})
public final class OpenRewriteScratchClassCompilationSupport
implements CompileTask {
    public boolean execute(@NotNull CompileContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        RunConfiguration configuration = CompileStepBeforeRun.getRunConfiguration((CompileContext)context);
        if (!(configuration instanceof OpenRewriteRunConfiguration)) {
            return true;
        }
        OpenRewriteInstallBeforeRunTask openRewriteInstallBeforeRunTask = (OpenRewriteInstallBeforeRunTask)((Object)((OpenRewriteRunConfiguration)configuration).getUserData(OpenRewriteInstallBeforeRunTaskProviderKt.getINSTALL_BEFORE_RUN_TASK_KEY()));
        if (openRewriteInstallBeforeRunTask == null) {
            return true;
        }
        OpenRewriteInstallBeforeRunTask beforeRunTask = openRewriteInstallBeforeRunTask;
        String scratchUrl = beforeRunTask.getScratchFileUrl();
        if (scratchUrl == null) {
            context.addMessage(CompilerMessageCategory.ERROR, ExecutionBundle.message((String)"run.java.scratch.associated.file.not.specified", (Object[])new Object[0]), null, -1, -1);
            return false;
        }
        Project project = context.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        Sdk targetSdk = ProjectRootManager.getInstance((Project)project2).getProjectSdk();
        if (targetSdk == null) {
            context.addMessage(CompilerMessageCategory.ERROR, ExecutionBundle.message((String)"run.java.scratch.missing.jdk", (Object[])new Object[0]), scratchUrl, -1, -1);
            return false;
        }
        if (!(targetSdk.getSdkType() instanceof JavaSdkType)) {
            Object[] objectArray = new Object[]{project2.getName()};
            context.addMessage(CompilerMessageCategory.ERROR, ExecutionBundle.message((String)"run.java.scratch.java.sdk.required.project", (Object[])objectArray), scratchUrl, -1, -1);
            return false;
        }
        File file = OpenRewriteInstallBeforeRunTaskProviderKt.getScratchOutputDirectory(project2);
        if (file == null) {
            return true;
        }
        File outputDir = file;
        FileUtil.delete((File)outputDir);
        try {
            File scratchFile = new File(VirtualFileManager.extractPath((String)scratchUrl));
            Charset charset = (Charset)ReadAction.compute(() -> OpenRewriteScratchClassCompilationSupport.execute$lambda$0(scratchUrl));
            Collection<File> cp = this.getClasspath(project2);
            Collection<File> platformCp = this.getPlatformClasspath(project2);
            List<String> options = this.getCompilerOptions(targetSdk, charset);
            Collection result = CompilerManager.getInstance((Project)project2).compileJavaCode(options, platformCp, cp, (Collection)CollectionsKt.emptyList(), (Collection)CollectionsKt.emptyList(), (Collection)CollectionsKt.emptyList(), (Collection)SetsKt.setOf((Object)scratchFile), outputDir);
            for (ClassObject classObject : result) {
                byte[] bytes = classObject.getContent();
                if (bytes == null) continue;
                FileUtil.writeToFile((File)new File(classObject.getPath()), (byte[])bytes);
            }
        }
        catch (CompilationException e) {
            for (CompilationException.Message m : e.getMessages()) {
                context.addMessage(m.getCategory(), m.getText(), scratchUrl, m.getLine(), m.getColumn());
            }
            return false;
        }
        catch (IOException e) {
            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), scratchUrl, -1, -1);
            return false;
        }
        return true;
    }

    private final Collection<File> getClasspath(Project project) {
        LinkedHashSet cp = new LinkedHashSet();
        ApplicationManager.getApplication().runReadAction(() -> OpenRewriteScratchClassCompilationSupport.getClasspath$lambda$1(project, cp));
        return cp;
    }

    private final Collection<File> getPlatformClasspath(Project project) {
        LinkedHashSet platformCp = new LinkedHashSet();
        ApplicationManager.getApplication().runReadAction(() -> OpenRewriteScratchClassCompilationSupport.getPlatformClasspath$lambda$2(project, platformCp));
        return platformCp;
    }

    private final List<String> getCompilerOptions(Sdk sdk, Charset charset) {
        ArrayList<String> options = new ArrayList<String>();
        options.add("-g");
        JavaSdkVersion sdkVersion = JavaSdk.getInstance().getVersion(sdk);
        if (sdkVersion != null) {
            LanguageLevel level = sdkVersion.getMaxLanguageLevel();
            String string = JpsJavaSdkType.complianceOption((JavaVersion)level.toJavaVersion());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"complianceOption(...)");
            String langLevel = string;
            options.add("-source");
            options.add(langLevel);
            options.add("-target");
            options.add(langLevel);
            if (level.isPreview()) {
                options.add("--enable-preview");
            }
        }
        options.add("-proc:none");
        if (charset != null) {
            options.add("-encoding");
            options.add(charset.name());
        }
        return options;
    }

    private static final Charset execute$lambda$0(String $scratchUrl) {
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl($scratchUrl);
        return virtualFile != null ? virtualFile.getCharset() : null;
    }

    private static final void getClasspath$lambda$1(Project $project, LinkedHashSet $cp) {
        for (SyntheticLibrary library : OpenRewriteRecipeService.Companion.getInstance($project).getLibraries()) {
            for (VirtualFile root : library.getBinaryRoots()) {
                VirtualFile localVirtualFile = JarFileSystem.getInstance().getVirtualFileForJar(root);
                if (localVirtualFile == null) continue;
                $cp.add(new File(localVirtualFile.getPath()));
            }
        }
    }

    private static final void getPlatformClasspath$lambda$2(Project $project, LinkedHashSet $platformCp) {
        OrderEnumerator orderEnumerator = ProjectRootManager.getInstance((Project)$project).orderEntries();
        Intrinsics.checkNotNullExpressionValue((Object)orderEnumerator, (String)"orderEntries(...)");
        OrderEnumerator orderEnumerator2 = orderEnumerator;
        for (String path : orderEnumerator2.compileOnly().sdkOnly().getPathsList().getPathList()) {
            $platformCp.add(new File(path));
        }
    }
}

