/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openRewrite.run.editor;

import com.intellij.execution.ui.FragmentWrapper;
import com.intellij.openRewrite.recipe.OpenRewriteRecipeDescriptor;
import com.intellij.openRewrite.recipe.OpenRewriteType;
import com.intellij.openRewrite.run.editor.OpenRewriteRecipeCompletionProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.Expandable;
import com.intellij.ui.ExpandableEditorSupport;
import com.intellij.ui.TextFieldWithAutoCompletion;
import com.intellij.ui.TextFieldWithAutoCompletionListProvider;
import com.intellij.util.Function;
import com.intellij.util.execution.ParametersListUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B5\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0001\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020 H\u0016R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0013\u001a\n\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006!"}, d2={"Lcom/intellij/openRewrite/run/editor/OpenRewriteActiveRecipesEditor;", "Ljavax/swing/JPanel;", "Lcom/intellij/execution/ui/FragmentWrapper;", "Lcom/intellij/ui/Expandable;", "project", "Lcom/intellij/openapi/project/Project;", "configSupplier", "Ljava/util/function/Supplier;", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "type", "Lcom/intellij/openRewrite/recipe/OpenRewriteType;", "accessibleName", "", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/function/Supplier;Lcom/intellij/openRewrite/recipe/OpenRewriteType;Ljava/lang/String;)V", "editor", "Lcom/intellij/ui/TextFieldWithAutoCompletion;", "Lcom/intellij/openRewrite/recipe/OpenRewriteRecipeDescriptor;", "popupEditor", "support", "Lcom/intellij/ui/ExpandableEditorSupport;", "textField", "Lcom/intellij/ui/EditorTextField;", "getTextField", "()Lcom/intellij/ui/EditorTextField;", "getComponentToRegister", "Ljavax/swing/JComponent;", "expand", "", "collapse", "isExpanded", "", "intellij.openRewrite"})
public final class OpenRewriteActiveRecipesEditor
extends JPanel
implements FragmentWrapper,
Expandable {
    @NotNull
    private final TextFieldWithAutoCompletion<OpenRewriteRecipeDescriptor> editor;
    @Nullable
    private TextFieldWithAutoCompletion<OpenRewriteRecipeDescriptor> popupEditor;
    @NotNull
    private final ExpandableEditorSupport support;

    public OpenRewriteActiveRecipesEditor(final @NotNull Project project, @NotNull Supplier<Collection<VirtualFile>> configSupplier, @NotNull OpenRewriteType type, @Nls @NotNull String accessibleName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(configSupplier, (String)"configSupplier");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)accessibleName, (String)"accessibleName");
        super(new BorderLayout());
        final OpenRewriteRecipeCompletionProvider profileCompletionProvider = new OpenRewriteRecipeCompletionProvider(project, configSupplier, type);
        this.editor = new TextFieldWithAutoCompletion(project, (TextFieldWithAutoCompletionListProvider)profileCompletionProvider, true, "");
        this.editor.getAccessibleContext().setAccessibleName(accessibleName);
        this.add((Component)this.editor, "Center");
        TextFieldWithAutoCompletion<OpenRewriteRecipeDescriptor> textFieldWithAutoCompletion = this.editor;
        Function function = ParametersListUtil.DEFAULT_LINE_PARSER;
        Function function2 = ParametersListUtil.DEFAULT_LINE_JOINER;
        this.support = new ExpandableEditorSupport(textFieldWithAutoCompletion, (Function<String, List<String>>)function, (Function<List<String>, String>)function2){

            protected EditorTextField createPopupEditor(EditorTextField field, String text) {
                Intrinsics.checkNotNullParameter((Object)field, (String)"field");
                Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                TextFieldWithAutoCompletion popupEditor = new TextFieldWithAutoCompletion(project, (TextFieldWithAutoCompletionListProvider)profileCompletionProvider, true, text);
                popupEditor.setOneLineMode(false);
                popupEditor = popupEditor;
                return (EditorTextField)popupEditor;
            }
        };
    }

    @NotNull
    public final EditorTextField getTextField() {
        EditorTextField editorTextField;
        if (this.support.isExpanded()) {
            TextFieldWithAutoCompletion<OpenRewriteRecipeDescriptor> textFieldWithAutoCompletion = this.popupEditor;
            Intrinsics.checkNotNull(textFieldWithAutoCompletion);
            editorTextField = (EditorTextField)textFieldWithAutoCompletion;
        } else {
            editorTextField = (EditorTextField)this.editor;
        }
        return editorTextField;
    }

    @NotNull
    public JComponent getComponentToRegister() {
        return (JComponent)this.editor;
    }

    public void expand() {
        this.support.expand();
    }

    public void collapse() {
        this.support.collapse();
    }

    public boolean isExpanded() {
        return this.support.isExpanded();
    }
}

