/*
 * Decompiled with CFR 0.152.
 */
package zmq;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectableChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.LockSupport;
import zmq.Config;
import zmq.Ctx;
import zmq.Msg;
import zmq.Proxy;
import zmq.SocketBase;
import zmq.ZError;
import zmq.io.Metadata;
import zmq.io.mechanism.Mechanisms;
import zmq.io.net.SelectorProviderChooser;
import zmq.msg.MsgAllocator;
import zmq.msg.MsgAllocatorThreshold;
import zmq.poll.PollItem;
import zmq.util.Clock;
import zmq.util.Utils;

public class ZMQ {
    public static final int ZMQ_VERSION_MAJOR = 4;
    public static final int ZMQ_VERSION_MINOR = 1;
    public static final int ZMQ_VERSION_PATCH = 7;
    public static final int ZMQ_IO_THREADS = 1;
    public static final int ZMQ_MAX_SOCKETS = 2;
    public static final int ZMQ_IO_THREADS_DFLT = 1;
    public static final int ZMQ_MAX_SOCKETS_DFLT = 1024;
    public static final int ZMQ_PAIR = 0;
    public static final int ZMQ_PUB = 1;
    public static final int ZMQ_SUB = 2;
    public static final int ZMQ_REQ = 3;
    public static final int ZMQ_REP = 4;
    public static final int ZMQ_DEALER = 5;
    public static final int ZMQ_ROUTER = 6;
    public static final int ZMQ_PULL = 7;
    public static final int ZMQ_PUSH = 8;
    public static final int ZMQ_XPUB = 9;
    public static final int ZMQ_XSUB = 10;
    public static final int ZMQ_STREAM = 11;
    public static final int ZMQ_SERVER = 12;
    public static final int ZMQ_CLIENT = 13;
    public static final int ZMQ_RADIO = 14;
    public static final int ZMQ_DISH = 15;
    public static final int ZMQ_CHANNEL = 16;
    public static final int ZMQ_PEER = 17;
    public static final int ZMQ_RAW = 18;
    public static final int ZMQ_SCATTER = 19;
    public static final int ZMQ_GATHER = 20;
    @Deprecated
    public static final int ZMQ_XREQ = 5;
    @Deprecated
    public static final int ZMQ_XREP = 6;
    private static final int ZMQ_CUSTOM_OPTION = 1000;
    public static final int ZMQ_AFFINITY = 4;
    public static final int ZMQ_IDENTITY = 5;
    public static final int ZMQ_SUBSCRIBE = 6;
    public static final int ZMQ_UNSUBSCRIBE = 7;
    public static final int ZMQ_RATE = 8;
    public static final int ZMQ_RECOVERY_IVL = 9;
    public static final int ZMQ_SNDBUF = 11;
    public static final int ZMQ_RCVBUF = 12;
    public static final int ZMQ_RCVMORE = 13;
    public static final int ZMQ_FD = 14;
    public static final int ZMQ_EVENTS = 15;
    public static final int ZMQ_TYPE = 16;
    public static final int ZMQ_LINGER = 17;
    public static final int ZMQ_RECONNECT_IVL = 18;
    public static final int ZMQ_BACKLOG = 19;
    public static final int ZMQ_RECONNECT_IVL_MAX = 21;
    public static final int ZMQ_MAXMSGSIZE = 22;
    public static final int ZMQ_SNDHWM = 23;
    public static final int ZMQ_RCVHWM = 24;
    public static final int ZMQ_MULTICAST_HOPS = 25;
    public static final int ZMQ_RCVTIMEO = 27;
    public static final int ZMQ_SNDTIMEO = 28;
    public static final int ZMQ_LAST_ENDPOINT = 32;
    public static final int ZMQ_ROUTER_MANDATORY = 33;
    public static final int ZMQ_TCP_KEEPALIVE = 34;
    public static final int ZMQ_TCP_KEEPALIVE_CNT = 35;
    public static final int ZMQ_TCP_KEEPALIVE_IDLE = 36;
    public static final int ZMQ_TCP_KEEPALIVE_INTVL = 37;
    public static final int ZMQ_IMMEDIATE = 1039;
    public static final int ZMQ_XPUB_VERBOSE = 40;
    public static final int ZMQ_ROUTER_RAW = 41;
    public static final int ZMQ_IPV6 = 42;
    public static final int ZMQ_MECHANISM = 43;
    public static final int ZMQ_PLAIN_SERVER = 44;
    public static final int ZMQ_PLAIN_USERNAME = 45;
    public static final int ZMQ_PLAIN_PASSWORD = 46;
    public static final int ZMQ_CURVE_SERVER = 47;
    public static final int ZMQ_CURVE_PUBLICKEY = 48;
    public static final int ZMQ_CURVE_SECRETKEY = 49;
    public static final int ZMQ_CURVE_SERVERKEY = 50;
    public static final int ZMQ_PROBE_ROUTER = 51;
    public static final int ZMQ_REQ_CORRELATE = 52;
    public static final int ZMQ_REQ_RELAXED = 53;
    public static final int ZMQ_CONFLATE = 54;
    public static final int ZMQ_ZAP_DOMAIN = 55;
    public static final int ZMQ_ROUTER_HANDOVER = 56;
    public static final int ZMQ_TOS = 57;
    public static final int ZMQ_CONNECT_RID = 61;
    public static final int ZMQ_GSSAPI_SERVER = 62;
    public static final int ZMQ_GSSAPI_PRINCIPAL = 63;
    public static final int ZMQ_GSSAPI_SERVICE_PRINCIPAL = 64;
    public static final int ZMQ_GSSAPI_PLAINTEXT = 65;
    public static final int ZMQ_HANDSHAKE_IVL = 66;
    public static final int ZMQ_SOCKS_PROXY = 67;
    public static final int ZMQ_XPUB_NODROP = 69;
    public static final int ZMQ_BLOCKY = 70;
    public static final int ZMQ_XPUB_MANUAL = 71;
    public static final int ZMQ_HEARTBEAT_IVL = 75;
    public static final int ZMQ_HEARTBEAT_TTL = 76;
    public static final int ZMQ_HEARTBEAT_TIMEOUT = 77;
    public static final int ZMQ_XPUB_VERBOSER = 78;
    @Deprecated
    public static final int ZMQ_XPUB_VERBOSE_UNSUBSCRIBE = 78;
    public static final int ZMQ_HELLO_MSG = 79;
    public static final int ZMQ_AS_TYPE = 80;
    public static final int ZMQ_DISCONNECT_MSG = 81;
    public static final int ZMQ_HICCUP_MSG = 82;
    public static final int ZMQ_SELFADDR_PROPERTY_NAME = 83;
    @Deprecated
    public static final int ZMQ_ENCODER = 1001;
    @Deprecated
    public static final int ZMQ_DECODER = 1002;
    public static final int ZMQ_MSG_ALLOCATOR = 1003;
    public static final int ZMQ_MSG_ALLOCATION_HEAP_THRESHOLD = 1004;
    public static final int ZMQ_HEARTBEAT_CONTEXT = 1005;
    public static final int ZMQ_SELECTOR_PROVIDERCHOOSER = 1006;
    public static final int ZMQ_MORE = 1;
    public static final int ZMQ_DONTWAIT = 1;
    public static final int ZMQ_SNDMORE = 2;
    @Deprecated
    public static final int ZMQ_TCP_ACCEPT_FILTER = 38;
    @Deprecated
    public static final int ZMQ_IPV4ONLY = 31;
    @Deprecated
    public static final int ZMQ_DELAY_ATTACH_ON_CONNECT = 39;
    @Deprecated
    public static final int ZMQ_NOBLOCK = 1;
    @Deprecated
    public static final int ZMQ_FAIL_UNROUTABLE = 33;
    @Deprecated
    public static final int ZMQ_ROUTER_BEHAVIOR = 33;
    public static final int ZMQ_EVENT_CONNECTED = 1;
    public static final int ZMQ_EVENT_CONNECT_DELAYED = 2;
    public static final int ZMQ_EVENT_CONNECT_RETRIED = 4;
    public static final int ZMQ_EVENT_LISTENING = 8;
    public static final int ZMQ_EVENT_BIND_FAILED = 16;
    public static final int ZMQ_EVENT_ACCEPTED = 32;
    public static final int ZMQ_EVENT_ACCEPT_FAILED = 64;
    public static final int ZMQ_EVENT_CLOSED = 128;
    public static final int ZMQ_EVENT_CLOSE_FAILED = 256;
    public static final int ZMQ_EVENT_DISCONNECTED = 512;
    public static final int ZMQ_EVENT_MONITOR_STOPPED = 1024;
    public static final int ZMQ_EVENT_HANDSHAKE_PROTOCOL = 32768;
    public static final int ZMQ_EVENT_ALL = 65535;
    public static final int ZMQ_EVENT_HANDSHAKE_FAILED_NO_DETAIL = 2048;
    public static final int ZMQ_EVENT_HANDSHAKE_SUCCEEDED = 4096;
    public static final int ZMQ_EVENT_HANDSHAKE_FAILED_PROTOCOL = 8192;
    public static final int ZMQ_EVENT_HANDSHAKE_FAILED_AUTH = 16384;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_UNSPECIFIED = 0x10000000;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_UNEXPECTED_COMMAND = 0x10000001;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_INVALID_SEQUENCE = 0x10000002;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_KEY_EXCHANGE = 0x10000003;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_MALFORMED_COMMAND_UNSPECIFIED = 0x10000011;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_MALFORMED_COMMAND_MESSAGE = 0x10000012;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_MALFORMED_COMMAND_HELLO = 0x10000013;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_MALFORMED_COMMAND_INITIATE = 0x10000014;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_MALFORMED_COMMAND_ERROR = 0x10000015;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_MALFORMED_COMMAND_READY = 0x10000016;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_MALFORMED_COMMAND_WELCOME = 0x10000017;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_INVALID_METADATA = 0x10000018;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_CRYPTOGRAPHIC = 0x11000001;
    public static final int ZMQ_PROTOCOL_ERROR_ZMTP_MECHANISM_MISMATCH = 0x11000002;
    public static final int ZMQ_PROTOCOL_ERROR_ZAP_UNSPECIFIED = 0x20000000;
    public static final int ZMQ_PROTOCOL_ERROR_ZAP_MALFORMED_REPLY = 0x20000001;
    public static final int ZMQ_PROTOCOL_ERROR_ZAP_BAD_REQUEST_ID = 0x20000002;
    public static final int ZMQ_PROTOCOL_ERROR_ZAP_BAD_VERSION = 0x20000003;
    public static final int ZMQ_PROTOCOL_ERROR_ZAP_INVALID_STATUS_CODE = 0x20000004;
    public static final int ZMQ_PROTOCOL_ERROR_ZAP_INVALID_METADATA = 0x20000005;
    public static final int ZMQ_PROTOCOL_ERROR_WS_UNSPECIFIED = 0x30000000;
    public static final int ZMQ_POLLIN = 1;
    public static final int ZMQ_POLLOUT = 2;
    public static final int ZMQ_POLLERR = 4;
    @Deprecated
    public static final int ZMQ_STREAMER = 1;
    @Deprecated
    public static final int ZMQ_FORWARDER = 2;
    @Deprecated
    public static final int ZMQ_QUEUE = 3;
    public static final byte[] MESSAGE_SEPARATOR = new byte[0];
    public static final byte[] SUBSCRIPTION_ALL = new byte[0];
    public static final Charset CHARSET = StandardCharsets.UTF_8;
    public static final byte[] PROXY_PAUSE = "PAUSE".getBytes(CHARSET);
    public static final byte[] PROXY_RESUME = "RESUME".getBytes(CHARSET);
    public static final byte[] PROXY_TERMINATE = "TERMINATE".getBytes(CHARSET);
    public static final int DEFAULT_AFFINITY = 0;
    public static final boolean DEFAULT_AS_SERVER = false;
    public static final int DEFAULT_AS_TYPE = -1;
    public static final int DEFAULT_BACKLOG = 100;
    public static final boolean DEFAULT_CONFLATE = false;
    public static final Msg DEFAULT_DISCONNECT_MSG = null;
    public static final boolean DEFAULT_GSS_PLAINTEXT = false;
    public static final int DEFAULT_HANDSHAKE_IVL = 30000;
    public static final byte[] DEFAULT_HEARTBEAT_CONTEXT = new byte[0];
    public static final int DEFAULT_HEARTBEAT_INTERVAL = 0;
    public static final int DEFAULT_HEARTBEAT_TIMEOUT = -1;
    public static final int DEFAULT_HEARTBEAT_TTL = 0;
    public static final Msg DEFAULT_HELLO_MSG = null;
    public static final Msg DEFAULT_HICCUP_MSG = null;
    public static final byte[] DEFAULT_IDENTITY = new byte[0];
    public static final boolean DEFAULT_IMMEDIATE = true;
    public static final boolean DEFAULT_IPV6 = PREFER_IPV6;
    public static final int DEFAULT_LINGER = -1;
    public static final long DEFAULT_MAX_MSG_SIZE = -1L;
    public static final Mechanisms DEFAULT_MECHANISM = Mechanisms.NULL;
    public static final int DEFAULT_ALLOCATION_HEAP_THRESHOLD = Config.MSG_ALLOCATION_HEAP_THRESHOLD.getValue();
    public static final MsgAllocator DEFAULT_MSG_ALLOCATOR = new MsgAllocatorThreshold(DEFAULT_ALLOCATION_HEAP_THRESHOLD);
    public static final int DEFAULT_RECONNECT_IVL = 100;
    public static final int DEFAULT_RECONNECT_IVL_MAX = 0;
    public static final int DEFAULT_RECV_HWM = 1000;
    public static final int DEFAULT_RECV_TIMEOUT = -1;
    public static final int DEFAULT_RCVBUF = 0;
    public static final int DEFAULT_RATE = 100;
    public static final int DEFAULT_RECOVERY_IVL = 10000;
    public static final String DEFAULT_SELF_ADDRESS_PROPERTY_NAME = null;
    public static final int DEFAULT_SEND_HWM = 1000;
    public static final int DEFAULT_SEND_TIMEOUT = -1;
    public static final SelectorProviderChooser DEFAULT_SELECTOR_CHOOSER = null;
    public static final int DEFAULT_SNDBUF = 0;
    public static final String DEFAULT_SOCKS_PROXY_ADDRESS = null;
    public static final int DEFAULT_TCP_KEEP_ALIVE = -1;
    public static final int DEFAULT_TCP_KEEP_ALIVE_CNT = -1;
    public static final int DEFAULT_TCP_KEEP_ALIVE_IDLE = -1;
    public static final int DEFAULT_TCP_KEEP_ALIVE_INTVL = -1;
    public static final int DEFAULT_TOS = 0;
    public static final int DEFAULT_TYPE = -1;
    public static final int DEFAULT_MULTICAST_HOPS = 1;
    public static final String DEFAULT_ZAP_DOMAIN = "";
    public static final boolean PREFER_IPV6;

    public static Ctx createContext() {
        return new Ctx();
    }

    private static void checkContext(Ctx ctx) {
        if (ctx == null || !ctx.isActive()) {
            throw new IllegalStateException();
        }
    }

    private static void destroyContext(Ctx ctx) {
        ZMQ.checkContext(ctx);
        ctx.terminate();
    }

    public static void setContextOption(Ctx ctx, int option2, int optval) {
        ZMQ.checkContext(ctx);
        ctx.set(option2, optval);
    }

    public static int getContextOption(Ctx ctx, int option2) {
        ZMQ.checkContext(ctx);
        return ctx.get(option2);
    }

    public static Ctx init(int ioThreads) {
        Utils.checkArgument(ioThreads >= 0, "I/O threads must not be negative");
        Ctx ctx = ZMQ.createContext();
        ZMQ.setContextOption(ctx, 1, ioThreads);
        return ctx;
    }

    public static void term(Ctx ctx) {
        ZMQ.destroyContext(ctx);
    }

    public static SocketBase socket(Ctx ctx, int type2) {
        ZMQ.checkContext(ctx);
        return ctx.createSocket(type2);
    }

    private static void checkSocket(SocketBase s) {
        if (s == null || !s.isActive()) {
            throw new IllegalStateException();
        }
    }

    public static void closeZeroLinger(SocketBase s) {
        ZMQ.checkSocket(s);
        s.setSocketOpt(17, 0);
        s.close();
    }

    public static void close(SocketBase s) {
        ZMQ.checkSocket(s);
        s.close();
    }

    public static boolean setSocketOption(SocketBase s, int option2, Object optval) {
        ZMQ.checkSocket(s);
        return s.setSocketOpt(option2, optval);
    }

    public static Object getSocketOptionExt(SocketBase s, int option2) {
        ZMQ.checkSocket(s);
        return s.getSocketOptx(option2);
    }

    public static int getSocketOption(SocketBase s, int opt) {
        return s.getSocketOpt(opt);
    }

    public static boolean monitorSocket(SocketBase s, String addr, int events) {
        ZMQ.checkSocket(s);
        return s.monitor(addr, events);
    }

    public static boolean bind(SocketBase s, String addr) {
        ZMQ.checkSocket(s);
        return s.bind(addr);
    }

    public static boolean connect(SocketBase s, String addr) {
        ZMQ.checkSocket(s);
        return s.connect(addr);
    }

    public static int connectPeer(SocketBase s, String addr) {
        ZMQ.checkSocket(s);
        return s.connectPeer(addr);
    }

    public static boolean disconnectPeer(SocketBase s, int routingId) {
        ZMQ.checkSocket(s);
        return s.disconnectPeer(routingId);
    }

    public static boolean unbind(SocketBase s, String addr) {
        ZMQ.checkSocket(s);
        return s.termEndpoint(addr);
    }

    public static boolean disconnect(SocketBase s, String addr) {
        ZMQ.checkSocket(s);
        return s.termEndpoint(addr);
    }

    public static int send(SocketBase s, String str, int flags) {
        byte[] data = str.getBytes(CHARSET);
        return ZMQ.send(s, data, data.length, flags);
    }

    public static int send(SocketBase s, Msg msg, int flags) {
        int rc = ZMQ.sendMsg(s, msg, flags);
        if (rc < 0) {
            return -1;
        }
        return rc;
    }

    public static int send(SocketBase s, byte[] buf, int flags) {
        return ZMQ.send(s, buf, buf.length, flags);
    }

    public static int send(SocketBase s, byte[] buf, int len, int flags) {
        ZMQ.checkSocket(s);
        Msg msg = new Msg(len);
        msg.put(buf, 0, len);
        int rc = ZMQ.sendMsg(s, msg, flags);
        if (rc < 0) {
            return -1;
        }
        return rc;
    }

    public int sendiov(SocketBase s, byte[][] a, int count, int flags) {
        ZMQ.checkSocket(s);
        int rc = 0;
        for (int i = 0; i < count; ++i) {
            Msg msg = new Msg(a[i]);
            if (i == count - 1) {
                flags &= 0xFFFFFFFD;
            }
            if ((rc = ZMQ.sendMsg(s, msg, flags)) >= 0) continue;
            rc = -1;
            break;
        }
        return rc;
    }

    public static boolean sendMsg(SocketBase socket, byte[] ... data) {
        int rc;
        if (data.length == 0) {
            return false;
        }
        for (int idx = 0; idx < data.length - 1; ++idx) {
            rc = ZMQ.send(socket, new Msg(data[idx]), 1);
            if (rc >= 0) continue;
            return false;
        }
        rc = ZMQ.send(socket, new Msg(data[data.length - 1]), 0);
        return rc >= 0;
    }

    public static int sendMsg(SocketBase s, Msg msg, int flags) {
        int sz = ZMQ.msgSize(msg);
        boolean rc = s.send(msg, flags);
        if (!rc) {
            return -1;
        }
        return sz;
    }

    public static Msg recv(SocketBase s, int flags) {
        ZMQ.checkSocket(s);
        return ZMQ.recvMsg(s, flags);
    }

    public int recviov(SocketBase s, byte[][] a, int count, int flags) {
        ZMQ.checkSocket(s);
        int nread = 0;
        boolean recvmore = true;
        for (int i = 0; recvmore && i < count; ++i) {
            Msg msg = ZMQ.recvMsg(s, flags);
            if (msg == null) {
                nread = -1;
                break;
            }
            a[i] = msg.data();
            recvmore = msg.hasMore();
        }
        return nread;
    }

    public static Msg recvMsg(SocketBase s, int flags) {
        return s.recv(flags);
    }

    public static boolean join(SocketBase s, String group) {
        ZMQ.checkSocket(s);
        return s.join(group);
    }

    public static boolean leave(SocketBase s, String group) {
        ZMQ.checkSocket(s);
        return s.leave(group);
    }

    public static Msg msgInit() {
        return new Msg();
    }

    public static Msg msgInitWithSize(int messageSize) {
        return new Msg(messageSize);
    }

    public static int msgSize(Msg msg) {
        return msg.size();
    }

    public static int getMessageOption(Msg msg, int option2) {
        switch (option2) {
            case 1: {
                return msg.hasMore() ? 1 : 0;
            }
        }
        throw new IllegalArgumentException();
    }

    public static String getMessageMetadata(Msg msg, String property) {
        String data = null;
        Metadata metadata2 = msg.getMetadata();
        if (metadata2 != null) {
            data = metadata2.get(property);
        }
        return data;
    }

    public boolean setMessageRoutingId(Msg msg, int routingId) {
        return msg.setRoutingId(routingId);
    }

    public int getMessageRoutingId(Msg msg) {
        return msg.getRoutingId();
    }

    public boolean setMessageGroup(Msg msg, String group) {
        return msg.setGroup(group);
    }

    public String getMessageGroup(Msg msg) {
        return msg.getGroup();
    }

    public static void sleep(long seconds) {
        ZMQ.sleep(seconds, TimeUnit.SECONDS);
    }

    public static void msleep(long milliseconds) {
        ZMQ.sleep(milliseconds, TimeUnit.MILLISECONDS);
    }

    public static void sleep(long amount, TimeUnit unit) {
        LockSupport.parkNanos(TimeUnit.NANOSECONDS.convert(amount, unit));
    }

    public static int poll(Selector selector, PollItem[] items, long timeout) {
        return ZMQ.poll(selector, items, items.length, timeout);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int poll(Selector selector, PollItem[] items, int count, long timeout) {
        Utils.checkArgument(items != null, "items have to be supplied for polling");
        if (count == 0) {
            if (timeout <= 0L) {
                return 0;
            }
            LockSupport.parkNanos(TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS));
            return 0;
        }
        long now = 0L;
        long end = 0L;
        HashMap<SelectableChannel, SelectionKey> saved = new HashMap<SelectableChannel, SelectionKey>();
        for (SelectionKey key : selector.keys()) {
            if (!key.isValid()) continue;
            saved.put(key.channel(), key);
        }
        for (int i = 0; i < count; ++i) {
            PollItem item = items[i];
            if (item == null) continue;
            SelectableChannel ch = item.getChannel();
            SelectionKey key = (SelectionKey)saved.remove(ch);
            if (key != null) {
                if (key.interestOps() != item.interestOps()) {
                    key.interestOps(item.interestOps());
                }
                key.attach(item);
                continue;
            }
            try {
                ch.register(selector, item.interestOps(), item);
                continue;
            }
            catch (ClosedSelectorException e) {
                return -1;
            }
            catch (ClosedChannelException e) {
                throw new ZError.IOException(e);
            }
        }
        if (!saved.isEmpty()) {
            for (SelectionKey deprecated : saved.values()) {
                deprecated.cancel();
            }
        }
        boolean firstPass = true;
        int nevents = 0;
        while (true) {
            long waitMillis;
            if (firstPass) {
                waitMillis = 0L;
            } else if (timeout < 0L) {
                waitMillis = -1L;
            } else {
                waitMillis = TimeUnit.NANOSECONDS.toMillis(end - now);
                if (waitMillis == 0L) {
                    waitMillis = 1L;
                }
            }
            try {
                int rc = waitMillis < 0L ? selector.select(0L) : (waitMillis == 0L ? selector.selectNow() : selector.select(waitMillis));
                for (SelectionKey key : selector.keys()) {
                    PollItem item = (PollItem)key.attachment();
                    int ready = item.readyOps(key, rc);
                    if (ready < 0) {
                        return -1;
                    }
                    if (ready <= 0) continue;
                    ++nevents;
                }
                selector.selectedKeys().clear();
            }
            catch (ClosedSelectorException e) {
                return -1;
            }
            catch (IOException e) {
                throw new ZError.IOException(e);
            }
            if (timeout == 0L || nevents > 0) return nevents;
            if (timeout < 0L) {
                if (!firstPass) continue;
                firstPass = false;
                continue;
            }
            if (firstPass) {
                now = Clock.nowNS();
                if (now == (end = now + TimeUnit.MILLISECONDS.toNanos(timeout))) return nevents;
                firstPass = false;
                continue;
            }
            now = Clock.nowNS();
            if (now >= end) return nevents;
        }
    }

    public static boolean proxy(SocketBase frontend, SocketBase backend, SocketBase capture) {
        Utils.checkArgument(frontend != null, "Frontend socket has to be present for proxy");
        Utils.checkArgument(backend != null, "Backend socket has to be present for proxy");
        return Proxy.proxy(frontend, backend, capture, null);
    }

    public static boolean proxy(SocketBase frontend, SocketBase backend, SocketBase capture, SocketBase control) {
        Utils.checkArgument(frontend != null, "Frontend socket has to be present for proxy");
        Utils.checkArgument(backend != null, "Backend socket has to be present for proxy");
        return Proxy.proxy(frontend, backend, capture, control);
    }

    public static boolean device(int device, SocketBase frontend, SocketBase backend) {
        Utils.checkArgument(frontend != null, "Frontend socket has to be present for proxy");
        Utils.checkArgument(backend != null, "Backend socket has to be present for proxy");
        return Proxy.proxy(frontend, backend, null, null);
    }

    public static long startStopwatch() {
        return System.nanoTime();
    }

    public static long stopStopwatch(long watch) {
        return (System.nanoTime() - watch) / 1000L;
    }

    public static int makeVersion(int major, int minor, int patch) {
        return major * 10000 + minor * 100 + patch;
    }

    public static String strerror(int errno) {
        return "Errno = " + errno;
    }

    static {
        String preferIPv4Stack = System.getProperty("java.net.preferIPv4Stack");
        String preferIPv6Addresses = System.getProperty("java.net.preferIPv6Addresses");
        PREFER_IPV6 = "false".equalsIgnoreCase(preferIPv4Stack) || "true".equalsIgnoreCase(preferIPv6Addresses);
    }

    public static class Event {
        private static final int VALUE_INTEGER = 1;
        private static final int VALUE_CHANNEL = 2;
        public final int event;
        public final String addr;
        public final Object arg;
        private final int flag;

        public Event(int event, String addr, Object arg) {
            this.event = event;
            this.addr = addr;
            this.arg = arg;
            this.flag = arg instanceof Integer ? 1 : (arg instanceof SelectableChannel ? 2 : 0);
        }

        private Event(int event, String addr, Object arg, int flag2) {
            this.event = event;
            this.addr = addr;
            this.arg = arg;
            this.flag = flag2;
        }

        public boolean write(SocketBase s) {
            Msg msg = new Msg(this.serialize(s.getCtx()));
            return s.send(msg, 0);
        }

        private ByteBuffer serialize(Ctx ctx) {
            int size = 5 + this.addr.length() + 1;
            if (this.flag == 1 || this.flag == 2) {
                size += 4;
            }
            ByteBuffer buffer = ByteBuffer.allocate(size).order(ByteOrder.BIG_ENDIAN);
            buffer.putInt(this.event);
            buffer.put((byte)this.addr.length());
            buffer.put(this.addr.getBytes(CHARSET));
            buffer.put((byte)this.flag);
            if (this.flag == 1) {
                buffer.putInt((Integer)this.arg);
            } else if (this.flag == 2) {
                int channeldId = ctx.forwardChannel((SelectableChannel)this.arg);
                buffer.putInt(channeldId);
            }
            buffer.flip();
            return buffer;
        }

        public SelectableChannel getChannel(SocketBase socket) {
            return this.getChannel(socket.getCtx());
        }

        public SelectableChannel getChannel(Ctx ctx) {
            if (this.flag == 2) {
                return ctx.getForwardedChannel((Integer)this.arg);
            }
            return null;
        }

        public static Event read(SocketBase s, int flags) {
            Msg msg = s.recv(flags);
            if (msg == null) {
                return null;
            }
            ByteBuffer buffer = msg.buf();
            int event = buffer.getInt();
            byte len = buffer.get();
            byte[] addr = new byte[len];
            buffer.get(addr);
            byte flag2 = buffer.get();
            Integer arg = null;
            if (flag2 == 1 || flag2 == 2) {
                arg = buffer.getInt();
            }
            return new Event(event, new String(addr, CHARSET), arg, flag2);
        }

        public static Event read(SocketBase s) {
            return Event.read(s, 0);
        }
    }

    public static interface EventConsummer {
        public void consume(Event var1);

        default public void close() {
        }
    }
}

