/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.connection.throwable.info.ErrorInfo;
import com.intellij.database.datagrid.CoreGrid;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridAppearance;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.datagrid.GridUtil;
import com.intellij.database.editor.TableEditorBase;
import com.intellij.database.run.ui.DataGridRequestPlace;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.command.undo.DocumentReference;
import com.intellij.openapi.command.undo.DocumentReferenceManager;
import com.intellij.openapi.command.undo.DocumentReferenceProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import java.awt.Component;
import java.util.Collection;
import java.util.Collections;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TableFileEditor
extends TableEditorBase
implements DocumentReferenceProvider {
    private final VirtualFile myFile;

    protected TableFileEditor(@NotNull Project project, @NotNull VirtualFile file) {
        if (project == null) {
            TableFileEditor.$$$reportNull$$$0(0);
        }
        if (file == null) {
            TableFileEditor.$$$reportNull$$$0(1);
        }
        super(project);
        this.myFile = file;
    }

    public Collection<DocumentReference> getDocumentReferences() {
        return Collections.singletonList(DocumentReferenceManager.getInstance().create(this.myFile));
    }

    @Override
    public boolean isValid() {
        return this.myFile.isValid();
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            TableFileEditor.$$$reportNull$$$0(2);
        }
        return virtualFile;
    }

    protected abstract void configure(@NotNull DataGrid var1, @NotNull DataGridAppearance var2);

    @NotNull
    protected final DataGrid createDataGrid(@NotNull GridDataHookUp<GridRow, GridColumn> hookUp) {
        if (hookUp == null) {
            TableFileEditor.$$$reportNull$$$0(3);
        }
        return this.createDataGrid(hookUp, GridUtil.getGridPopupActions(), false);
    }

    @NotNull
    protected final DataGrid createDataGrid(@NotNull GridDataHookUp<GridRow, GridColumn> hookUp, @NotNull ActionGroup popupActions, boolean isHierarchical) {
        if (hookUp == null) {
            TableFileEditor.$$$reportNull$$$0(4);
        }
        if (popupActions == null) {
            TableFileEditor.$$$reportNull$$$0(5);
        }
        final DataGrid grid = GridUtil.createDataGrid(this.getProject(), hookUp, popupActions, ((BiConsumer<DataGrid, DataGridAppearance>)this::configure).andThen(GridUtil::configureFullSizeTable), isHierarchical);
        Disposer.register((Disposable)this, (Disposable)grid);
        Disposer.register((Disposable)this, (Disposable)UiNotifyConnector.Once.installOn((Component)grid.getPanel().getComponent(), (Activatable)new Activatable(){

            public void showNotify() {
                grid.getDataHookup().getLoader().loadFirstPage(new GridRequestSource((GridRequestSource.RequestPlace)new DataGridRequestPlace((CoreGrid)grid)));
            }
        }));
        grid.getDataHookup().addRequestListener((GridDataHookUp.RequestListener)new GridDataHookUp.RequestListener<GridRow, GridColumn>(){

            public void requestStarted(@NotNull GridRequestSource source) {
                if (source == null) {
                    2.$$$reportNull$$$0(0);
                }
                this.getLoadingPanel().startLoading();
            }

            public void error(@NotNull GridRequestSource source, @NotNull ErrorInfo errorInfo) {
                if (source == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (errorInfo == null) {
                    2.$$$reportNull$$$0(2);
                }
            }

            public void requestProgress(@NotNull GridRequestSource source, @Nullable String progress) {
                if (source == null) {
                    2.$$$reportNull$$$0(3);
                }
                this.getLoadingPanel().setLoadingText(progress);
            }

            public void updateCountReceived(@NotNull GridRequestSource source, int updateCount) {
                if (source == null) {
                    2.$$$reportNull$$$0(4);
                }
            }

            public void requestFinished(@NotNull GridRequestSource source, boolean success) {
                if (source == null) {
                    2.$$$reportNull$$$0(5);
                }
                this.getLoadingPanel().setLoadingText(null);
                this.getLoadingPanel().stopLoading();
            }

            @NotNull
            private JBLoadingPanel getLoadingPanel() {
                JBLoadingPanel jBLoadingPanel = grid.getPanel().getComponent();
                if (jBLoadingPanel == null) {
                    2.$$$reportNull$$$0(6);
                }
                return jBLoadingPanel;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 6 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "source";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "errorInfo";
                        break;
                    }
                    case 6: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/database/editor/TableFileEditor$2";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/database/editor/TableFileEditor$2";
                        break;
                    }
                    case 6: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getLoadingPanel";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "requestStarted";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray;
                        objectArray[2] = "error";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray;
                        objectArray[2] = "requestProgress";
                        break;
                    }
                    case 4: {
                        objectArray = objectArray;
                        objectArray[2] = "updateCountReceived";
                        break;
                    }
                    case 5: {
                        objectArray = objectArray;
                        objectArray[2] = "requestFinished";
                        break;
                    }
                    case 6: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 6 -> new IllegalStateException(string);
                };
            }
        }, (Disposable)grid);
        DataGrid dataGrid = grid;
        if (dataGrid == null) {
            TableFileEditor.$$$reportNull$$$0(6);
        }
        return dataGrid;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/editor/TableFileEditor";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hookUp";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "popupActions";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/editor/TableFileEditor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "createDataGrid";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDataGrid";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 6 -> new IllegalStateException(string);
        };
    }
}

