/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jpa.model.annotations.mapping;

import com.intellij.jam.JamElement;
import com.intellij.jam.JamService;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.jam.model.common.ManualModelMergerUtil;
import com.intellij.jam.reflect.JamAttributeMeta;
import com.intellij.jam.reflect.JamClassMeta;
import com.intellij.jam.reflect.JamEnumAttributeMeta;
import com.intellij.jam.reflect.JamMemberArchetype;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.javaee.model.annotations.AnnotationGenericValue;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.javaee.utils.JavaeeType;
import com.intellij.jpa.PersistenceAttributesProvider;
import com.intellij.jpa.model.annotations.mapping.AccessTypeDetector;
import com.intellij.jpa.model.annotations.mapping.AttributeBaseImpl;
import com.intellij.jpa.model.annotations.mapping.JamAttributeBase;
import com.intellij.jpa.model.common.persistence.JpaAnnotationConstants;
import com.intellij.jpa.model.xml.persistence.mapping.AccessType;
import com.intellij.jpa.util.JpaUtil;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.persistence.facet.PersistencePackageDefaults;
import com.intellij.persistence.model.PersistentAttribute;
import com.intellij.persistence.model.PersistentObject;
import com.intellij.persistence.model.helpers.PersistentObjectModelHelper;
import com.intellij.persistence.roles.PersistenceClassRole;
import com.intellij.persistence.util.PersistenceCommonUtil;
import com.intellij.persistence.util.PersistenceModelBrowser;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.ref.AnnotationChildLink;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyMemberType;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.NullableFunction;
import com.intellij.util.xml.GenericValue;
import com.intellij.util.xml.ModelMergerUtil;
import com.intellij.util.xml.ReadOnlyGenericValue;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PersistentObjectImpl
extends CommonModelElement.PsiBase
implements com.intellij.jpa.model.common.persistence.mapping.PersistentObject,
PersistentObjectModelHelper,
JamElement {
    public static final JamEnumAttributeMeta.Single<AccessType> ACCESS_VALUE_ATTR_META = JamAttributeMeta.singleEnum((String)"value", AccessType.class);
    public static final JamMemberArchetype<PsiClass, PersistentObjectImpl> PERSISTENT_OBJECT_ARCHETYPE = new JamMemberArchetype(null);
    private final PsiClass myPsiClass;
    private final PsiElementRef<PsiAnnotation> myAnno;
    protected JavaeeType myJavaeeType;
    private final CachedValue<AccessType> myAccessType;
    private CachedValue<PropertyMemberType> myDefaultAccessModeValue;

    protected PersistentObjectImpl(@NotNull PsiElementRef<?> psiRef, @NotNull JavaeeClass anno) {
        PsiClass aClass;
        if (psiRef == null) {
            PersistentObjectImpl.$$$reportNull$$$0(0);
        }
        if (anno == null) {
            PersistentObjectImpl.$$$reportNull$$$0(1);
        }
        this.myPsiClass = aClass = (PsiClass)Objects.requireNonNull(psiRef.getPsiElement());
        this.myJavaeeType = anno.typeFromAnnotated((PsiModifierListOwner)aClass);
        this.myAnno = AnnotationChildLink.createRef((PsiModifierListOwner)aClass, (String)anno.fqn(this.myJavaeeType));
        this.myAccessType = CachedValuesManager.getManager((Project)this.myPsiClass.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)((Object)AccessTypeDetector.calculateAccessType(this.myPsiClass)), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
    }

    public PsiClass getPsiClass() {
        return this.myPsiClass;
    }

    @NotNull
    public PsiElement getPsiElement() {
        PsiClass psiClass = this.myPsiClass;
        if (psiClass == null) {
            PersistentObjectImpl.$$$reportNull$$$0(2);
        }
        return psiClass;
    }

    public abstract JamClassMeta<? extends PersistentObjectImpl> getJamMeta();

    protected PsiElementRef<PsiAnnotation> getAnnoRef() {
        return this.myAnno;
    }

    public boolean isValid() {
        try {
            return super.isValid() && Comparing.equal((Object)((PersistentObjectImpl)this.getJamMeta().getJamElement((PsiModifierListOwner)this.getPsiClass())), (Object)this);
        }
        catch (IndexNotReadyException e) {
            return false;
        }
    }

    @Override
    @Nullable
    public AccessType getEffectiveAccessType() {
        return (AccessType)ACCESS_VALUE_ATTR_META.getJam(this.getJavaeeAnnotationRef(JpaAnnotationConstants.ACCESS_ANNO), (Enum)((AccessType)((Object)this.myAccessType.getValue()))).getValue();
    }

    @Override
    public GenericValue<PsiClass> getClazz() {
        return AnnotationGenericValue.getInstance((Object)this.getPsiClass(), (PsiAnnotation)((PsiAnnotation)this.getAnnoRef().getPsiElement()), null);
    }

    public List<JamAttributeBase> getAllAttributes() {
        ArrayList<JamAttributeBase> all = new ArrayList<JamAttributeBase>();
        JamService service = JamService.getJamService((Project)this.myPsiClass.getProject());
        for (JamMemberMeta<PsiMember, ? extends JamAttributeBase> meta : PersistenceAttributesProvider.getAllJamMetas()) {
            all.addAll(service.getAnnotatedMembersList(this.myPsiClass, 6, new JamMemberMeta[]{meta}));
        }
        Set annotatedMembers = all.stream().map(base -> base.getPsiMember()).collect(Collectors.toSet());
        for (PsiField field : this.myPsiClass.getFields()) {
            if (annotatedMembers.contains(field) || annotatedMembers.contains(PropertyUtilBase.findGetterForField((PsiField)field)) || field.hasModifierProperty("static") || !JpaUtil.isBasicPersistentAttributeType(field.getType(), false)) continue;
            all.add((JamAttributeBase)CachedValuesManager.getCachedValue((PsiElement)field, () -> CachedValueProvider.Result.create((Object)new AttributeBaseImpl.BasicAttr((PsiMember)field), (Object[])new Object[]{field.getContainingFile()})));
        }
        return all;
    }

    @NotNull
    public PersistentObjectModelHelper getObjectModelHelper() {
        PersistentObjectImpl persistentObjectImpl = this;
        if (persistentObjectImpl == null) {
            PersistentObjectImpl.$$$reportNull$$$0(3);
        }
        return persistentObjectImpl;
    }

    @NotNull
    public List<? extends PersistentAttribute> getAttributes() {
        List<JamAttributeBase> list = this.getAllAttributes();
        if (list == null) {
            PersistentObjectImpl.$$$reportNull$$$0(4);
        }
        return list;
    }

    public PropertyMemberType getDefaultAccessMode() {
        if (this.myDefaultAccessModeValue == null) {
            this.myDefaultAccessModeValue = CachedValuesManager.getManager((Project)this.myPsiClass.getProject()).createCachedValue(() -> CachedValueProvider.Result.create((Object)this.calcDefaultAccessMode(), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}), false);
        }
        return (PropertyMemberType)this.myDefaultAccessModeValue.getValue();
    }

    private PropertyMemberType calcDefaultAccessMode() {
        PersistentObject object;
        AccessType effectiveAccessType = null;
        PersistenceModelBrowser browser = PersistenceCommonUtil.createSameUnitsModelBrowser((PsiElement)this.getPsiElement());
        Iterator iterator = browser.queryPersistentObjectHierarchy((PersistentObject)this).findAll().iterator();
        while (iterator.hasNext() && (effectiveAccessType = (AccessType)((Object)ManualModelMergerUtil.findLast((List)((List)ModelMergerUtil.getImplementations((Object)(object = (PersistentObject)iterator.next()), com.intellij.jpa.model.common.persistence.mapping.PersistentObject.class)), o -> o.getEffectiveAccessType(), null))) == null) {
        }
        if (effectiveAccessType != null) {
            return effectiveAccessType == AccessType.FIELD ? PropertyMemberType.FIELD : PropertyMemberType.GETTER;
        }
        PropertyMemberType defaultAccess = (PropertyMemberType)PersistentObjectImpl.getCurrentValueOrDefault(AnnotationGenericValue.nullInstance(), persistencePackageDefaults -> persistencePackageDefaults.getAccess(), this.getPsiClass()).getValue();
        return defaultAccess == null ? PropertyMemberType.FIELD : defaultAccess;
    }

    public boolean isAccessModeFixed() {
        return this.getEffectiveAccessType() != null;
    }

    static <T> GenericValue<T> getCurrentValueOrDefault(GenericValue<T> currentValue, NullableFunction<? super PersistencePackageDefaults, ? extends T> processor, PsiClass psiClass) {
        if (currentValue.getValue() != null) {
            return currentValue;
        }
        if (psiClass == null) {
            return currentValue;
        }
        T value3 = PersistentObjectImpl.getDefaultValue((PsiMember)psiClass, processor);
        if (value3 != null) {
            return ReadOnlyGenericValue.getInstance(value3);
        }
        return currentValue;
    }

    @Nullable
    public static <T> T getDefaultValue(PsiMember psiMember, NullableFunction<? super PersistencePackageDefaults, ? extends T> processor) {
        PsiClass psiClass = psiMember instanceof PsiClass ? (PsiClass)psiMember : psiMember.getContainingClass();
        for (PersistenceClassRole role : PersistenceCommonUtil.getPersistenceRoles((PsiClass)psiClass)) {
            PersistencePackageDefaults defaults;
            Object t;
            if (role.getPersistentObject() == null || (t = processor.fun((Object)(defaults = role.getFacet().getPersistenceUnitDefaults(role.getPersistenceUnit())))) == null) continue;
            return (T)t;
        }
        return null;
    }

    @NotNull
    protected PsiElementRef<PsiAnnotation> getJavaeeAnnotationRef(@NotNull JavaeeClass javaeeClass) {
        if (javaeeClass == null) {
            PersistentObjectImpl.$$$reportNull$$$0(5);
        }
        PsiElementRef<PsiAnnotation> psiElementRef = PersistentObjectImpl.getJavaeeAnnotationRef(javaeeClass, (PsiMember)this.getPsiClass(), this.myJavaeeType);
        if (psiElementRef == null) {
            PersistentObjectImpl.$$$reportNull$$$0(6);
        }
        return psiElementRef;
    }

    public static PsiElementRef<PsiAnnotation> getJavaeeAnnotationRef(@NotNull JavaeeClass javaeeClass, PsiMember psiMember, @NotNull JavaeeType javaeeType) {
        if (javaeeClass == null) {
            PersistentObjectImpl.$$$reportNull$$$0(7);
        }
        if (javaeeType == null) {
            PersistentObjectImpl.$$$reportNull$$$0(8);
        }
        return new AnnotationChildLink(javaeeType.equals((Object)JavaeeType.JAVAX) ? javaeeClass.javax() : javaeeClass.jakarta()).createChildRef((PsiElement)psiMember);
    }

    protected boolean isJavax() {
        return this.myJavaeeType.equals((Object)JavaeeType.JAVAX);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PersistentObjectImpl object = (PersistentObjectImpl)o;
        return Objects.equals(this.myPsiClass, object.myPsiClass) && Objects.equals(this.myAnno, object.myAnno);
    }

    public int hashCode() {
        return Objects.hash(this.myPsiClass, this.myAnno);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiRef";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "anno";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/jpa/model/annotations/mapping/PersistentObjectImpl";
                break;
            }
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/jpa/model/annotations/mapping/PersistentObjectImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPsiElement";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getObjectModelHelper";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAttributes";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getJavaeeAnnotationRef";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 6: {
                break;
            }
            case 5: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getJavaeeAnnotationRef";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 6 -> new IllegalStateException(string);
        };
    }
}

