/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.actions;

import com.intellij.dsm.DsmBundle;
import com.intellij.dsm.actions.AbstractDsmAction;
import com.intellij.dsm.model.DsmModel;
import com.intellij.dsm.model.DsmModelUtil;
import com.intellij.dsm.model.classes.DsmPsiNode;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmTable;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.packageDependencies.FindDependencyUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfoToUsageConverter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.SwingUtilities;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NotNull;

final class DepsFindUsagesAction<N extends DsmPsiNode>
extends AbstractDsmAction<N> {
    DepsFindUsagesAction() {
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            DepsFindUsagesAction.$$$reportNull$$$0(0);
        }
        DataContext dataContext = e.getDataContext();
        DsmTable table = this.getTable(e);
        assert (table != null);
        this.perform(table, (Project)CommonDataKeys.PROJECT.getData(dataContext));
    }

    private void perform(@NotNull DsmTable<N> table, final Project project) {
        if (table == null) {
            DepsFindUsagesAction.$$$reportNull$$$0(1);
        }
        Collection<DsmSelection<N>> selections = table.getSelectionModel().getSelection();
        DataGraph<DsmPsiNode, Integer> graph = table.getModel().getGraph();
        HashSet fromAll = new HashSet();
        HashSet toAll = new HashSet();
        Object fromTitle = "";
        Object toTitle = "";
        for (DsmSelection<N> selection : selections) {
            Set f = selection.node2;
            Set t = selection.node1;
            if (!((String)fromTitle).isEmpty()) {
                fromTitle = (String)fromTitle + ", ";
            }
            fromTitle = (String)fromTitle + DsmModelUtil.getShortName(f);
            if (!((String)toTitle).isEmpty()) {
                toTitle = (String)toTitle + ", ";
            }
            toTitle = (String)toTitle + DsmModelUtil.getShortName(t);
            DsmModelUtil.collectLeafData(f, fromAll);
            DsmModelUtil.collectLeafData(t, toAll);
        }
        HashSet<DsmPsiNode> from = new HashSet<DsmPsiNode>();
        HashSet<DsmPsiNode> to = new HashSet<DsmPsiNode>();
        for (DsmPsiNode n2 : toAll) {
            for (DsmPsiNode n1 : fromAll) {
                if (graph.edge(n1, n2) == null) continue;
                from.add(n1);
                to.add(n2);
            }
        }
        final HashSet<PsiFile> psiFilesFrom = DepsFindUsagesAction.convertToPsiFiles(from);
        final HashSet<PsiFile> psiFilesTo = DepsFindUsagesAction.convertToPsiFiles(to);
        final String title = DsmBundle.message("usages.of.0.in.1", toTitle, fromTitle);
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(project, DsmBundle.message("looking.for.usages", new Object[0]), true){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                Usage[] usages = (Usage[])ReadAction.compute(() -> {
                    UsageInfo[] usageInfos = FindDependencyUtil.findDependencies((List)null, (Set)psiFilesFrom, (Set)psiFilesTo);
                    PsiElement[] elements = PsiUtilCore.toPsiElementArray((Collection)psiFilesFrom);
                    return UsageInfoToUsageConverter.convert((PsiElement[])elements, (UsageInfo[])usageInfos);
                });
                UsageViewPresentation presentation = new UsageViewPresentation();
                presentation.setCodeUsagesString(title);
                presentation.setTabName(title);
                presentation.setTabText(title);
                SwingUtilities.invokeLater(() -> UsageViewManager.getInstance((Project)project).showUsages(UsageTarget.EMPTY_ARRAY, usages, presentation));
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/dsm/actions/DepsFindUsagesAction$1", "run"));
            }
        });
    }

    private static <N extends DsmPsiNode> HashSet<PsiFile> convertToPsiFiles(Set<N> nodes) {
        return nodes.stream().map(DsmPsiNode::getContainingFile).filter(Objects::nonNull).collect(Collectors.toCollection(HashSet::new));
    }

    @Override
    protected boolean isEnabled(AnActionEvent e) {
        if (!super.isEnabled(e)) {
            return false;
        }
        DsmModel model = this.getModel(e);
        Class nodeClass = model.getNodeClass();
        if (!DsmPsiNode.class.isAssignableFrom(nodeClass)) {
            return false;
        }
        Collection selections = this.getSelection(e);
        if (selections.size() != 1) {
            return false;
        }
        for (DsmSelection selection : selections) {
            if (selection.type == DsmSelection.Type.CELL) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
        }
        objectArray2[1] = "com/intellij/dsm/actions/DepsFindUsagesAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "actionPerformed";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "perform";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

