/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.classes.ClassNode;
import com.intellij.dsm.model.classes.TopToBottomTreeStructure;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleGrouper;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.function.Predicate;
import javax.swing.Icon;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

final class ModuleSplitter
implements TopToBottomTreeStructure.TreeSplitter<ClassNode> {
    private final ModuleGrouper myGrouper;

    ModuleSplitter(@Nullable ModuleGrouper grouper) {
        this.myGrouper = grouper;
    }

    @Override
    public @Unmodifiable List<Pair<Predicate<ClassNode>, TopToBottomTreeStructure.NodeData>> split(DataGraph<ClassNode, Integer> dataGraph, Predicate<ClassNode> memberFunction, TopToBottomTreeStructure.NodeData parentData) {
        if (parentData instanceof MyNodeData) {
            return List.of(new Pair(memberFunction, null));
        }
        HashSet<Couple> containerNamesSet = new HashSet<Couple>();
        HashMap<String, Icon> name2icon = new HashMap<String, Icon>();
        for (int i = 0; i < dataGraph.V(); ++i) {
            ClassNode classNode = dataGraph.getNode(i);
            if (!memberFunction.test(classNode)) continue;
            Module module = classNode.getModule();
            if (module != null) {
                String moduleName = module.getName();
                containerNamesSet.add(Couple.of((Object)(this.myGrouper != null ? this.myGrouper.getShortenedName(module) : moduleName), (Object)moduleName));
                name2icon.put(moduleName, AllIcons.Nodes.Module);
                continue;
            }
            String containerName = classNode.getContainerName();
            containerNamesSet.add(Couple.of((Object)containerName, (Object)containerName));
            if (name2icon.containsKey(containerName)) continue;
            name2icon.put(containerName, classNode.getContainerIcon());
        }
        return ContainerUtil.map(containerNamesSet, pair -> new Pair(memberFunction.and(classNode -> classNode.getContainerName().equals(pair.second)), (Object)new MyNodeData((String)pair.first, (String)pair.second, (Icon)name2icon.get(pair.second))));
    }

    private static final class MyNodeData
    extends TopToBottomTreeStructure.NodeData {
        MyNodeData(String shortName, String fullName, @NotNull Icon icon) {
            if (icon == null) {
                MyNodeData.$$$reportNull$$$0(0);
            }
            super(shortName, fullName, icon);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/dsm/model/classes/ModuleSplitter$MyNodeData", "<init>"));
        }
    }
}

