/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.model.classes;

import com.intellij.dsm.model.DsmModelUtil;
import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.model.classes.NodeImpl;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.util.ArrayUtil;
import icons.DsmIcons;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import javax.swing.Icon;
import org.gga.graph.Graph;
import org.gga.graph.Morph;
import org.gga.graph.Subgraph;
import org.gga.graph.connection.StrongComponents;
import org.gga.graph.maps.DataGraph;
import org.jetbrains.annotations.NonNls;

final class NodePartitioner {
    private NodePartitioner() {
    }

    private static <N, TNode extends DsmTreeStructure.TreeNode<N>> DataGraph<TNode, Integer> prepareGraphToPartition(TNode[] nodes, DataGraph<N, Integer> dataGraph) {
        int[] vertexMap = new int[dataGraph.V()];
        Arrays.fill(vertexMap, -1);
        for (int i = 0; i < nodes.length; ++i) {
            DsmModelUtil.fillLeafMap(nodes[i], i, vertexMap);
        }
        return Morph.morph(dataGraph, v -> nodes[vertexMap[dataGraph.getIndex(v)]], l -> l.stream().mapToInt(Integer::intValue).sum(), v -> vertexMap[dataGraph.getIndex(v)] >= 0, nodes);
    }

    private static <N, TNode extends DsmTreeStructure.TreeNode<N>> SortNode<N, TNode>[] createSortNodes(TNode[] nodes, DataGraph<TNode, Integer> dGraphToPartition) {
        Graph graphToPartition = dGraphToPartition.getIntGraph();
        int[] componentMap = new int[graphToPartition.V()];
        StrongComponents.strongComponents(graphToPartition, componentMap, new int[graphToPartition.V()]);
        Object[] sortNodes = new SortNode[nodes.length];
        for (int i = 0; i < nodes.length; ++i) {
            DsmTreeStructure.TreeNode node = (DsmTreeStructure.TreeNode)dGraphToPartition.getNode(i);
            sortNodes[i] = new SortNode(node, componentMap[i]);
        }
        Arrays.sort(sortNodes);
        return sortNodes;
    }

    private static <N, TNode extends DsmTreeStructure.TreeNode<N>> DataGraph<TNode, Integer> getPartitionGraph(TNode[] nodes, DataGraph<N, Integer> dataGraph) {
        Arrays.sort(nodes, (o1, o2) -> -o1.getShortName().compareTo(o2.getShortName()));
        return NodePartitioner.prepareGraphToPartition(nodes, dataGraph);
    }

    public static <N, TNode extends NodeImpl<N>> TNode[] partition(TNode[] nodes, DataGraph<N, Integer> dataGraph, TNode parent) {
        if (nodes.length == 1) {
            return nodes;
        }
        DataGraph dGraphToPartition = NodePartitioner.getPartitionGraph(nodes, dataGraph);
        SortNode[] sortNodes = NodePartitioner.createSortNodes(nodes, (DataGraph)dGraphToPartition);
        ArrayList<NodeImpl> result = new ArrayList<NodeImpl>();
        int sccStart = 0;
        for (int i = 0; i < sortNodes.length; ++i) {
            int cycleIndex;
            int prevCycleIndex;
            SortNode sortNode = sortNodes[i];
            if (i <= 0 || (prevCycleIndex = sortNodes[i - 1].myScc) == (cycleIndex = sortNode.myScc)) continue;
            int cycleLength = i - sccStart;
            if (cycleLength > 1) {
                result.add(new CycleTreeNode(sortNodes, sccStart, i - 1, parent, dGraphToPartition));
            } else {
                result.add((NodeImpl)sortNodes[i - 1].myNode);
            }
            sccStart = i;
        }
        if (sccStart != sortNodes.length - 1) {
            result.add(new CycleTreeNode(sortNodes, sccStart, sortNodes.length - 1, parent, dGraphToPartition));
        } else {
            result.add((NodeImpl)sortNodes[sortNodes.length - 1].myNode);
        }
        return result.toArray(new NodeImpl[0]);
    }

    private static final class SortNode<N, TNode extends DsmTreeStructure.TreeNode<N>>
    implements Comparable<SortNode<N, TNode>> {
        private final TNode myNode;
        private final int myScc;

        SortNode(TNode node, int scc) {
            this.myNode = node;
            this.myScc = scc;
        }

        @Override
        public int compareTo(SortNode<N, TNode> o) {
            if (this.myScc == o.myScc) {
                return this.myNode.getShortName().compareTo(o.myNode.getShortName());
            }
            return this.myScc < o.myScc ? 1 : -1;
        }
    }

    private static final class CycleTreeNode<N, TNode extends NodeImpl<N>>
    extends NodeImpl<N> {
        private TNode[] myChildren;

        CycleTreeNode(SortNode<N, TNode>[] sortNodes, int startIndex, int endIndex, DsmTreeStructure.TreeNode<N> parent, DataGraph<TNode, Integer> graph) {
            super(parent);
            this.myChildren = new NodeImpl[endIndex - startIndex + 1];
            for (int i = 0; i < this.myChildren.length; ++i) {
                this.myChildren[i] = (NodeImpl)sortNodes[i + startIndex].myNode;
                ((NodeImpl)this.myChildren[i]).setParent(this);
            }
            Set nodes = Set.of(this.myChildren);
            Pair<DataGraph<NodeImpl, Integer>, int[]> g = Subgraph.subgraph(graph, tNode -> nodes.contains(tNode), null, DataGraph.Implementation.FULL);
            this.optimizeChildrenOrder((DataGraph)g.first);
        }

        private void optimizeChildrenOrder(DataGraph<TNode, Integer> graph) {
            int i;
            int n = this.myChildren.length;
            int[][] data = new int[n][];
            for (i = 0; i < n; ++i) {
                data[i] = new int[n];
            }
            for (i = 0; i < this.myChildren.length; ++i) {
                TNode c1 = this.myChildren[i];
                for (int j = 0; j < this.myChildren.length; ++j) {
                    TNode c2 = this.myChildren[j];
                    Integer integer = graph.edge(c1, c2);
                    if (integer == null) continue;
                    data[i][j] = integer;
                }
            }
            if (n > 50) {
                this.greedOptimize(n, data);
            } else {
                this.swapOptimize(n, data);
            }
        }

        private void swapOptimize(int n, int[][] data) {
            int[] indices = new int[n];
            for (int i = 0; i < indices.length; ++i) {
                indices[i] = i;
            }
            while (true) {
                int gain = 0;
                int r1 = -1;
                int r2 = -1;
                for (int i = 0; i < n; ++i) {
                    for (int j = i + 1; j < n; ++j) {
                        int g = CycleTreeNode.reorderGain(i, j, data, indices);
                        if (gain >= g) continue;
                        gain = g;
                        r1 = i;
                        r2 = j;
                    }
                }
                if (gain <= 0) break;
                ArrayUtil.swap((Object[])this.myChildren, (int)r1, (int)r2);
                ArrayUtil.swap((int[])indices, (int)r1, (int)r2);
            }
        }

        private void greedOptimize(int n, int[][] data) {
            int[] order = new int[n];
            Arrays.fill(order, -1);
            int count = 0;
            while (count < n) {
                int maxSum = -1;
                int next = -1;
                for (int i = 0; i < n; ++i) {
                    if (order[i] >= 0) continue;
                    int outboundSum = 0;
                    for (int j = 0; j < n; ++j) {
                        if (j == i || order[j] >= 0) continue;
                        outboundSum += data[i][j];
                    }
                    if (outboundSum <= maxSum) continue;
                    maxSum = outboundSum;
                    next = i;
                }
                assert (next >= 0);
                order[next] = count++;
            }
            NodeImpl[] newChildren = new NodeImpl[n];
            for (int i = 0; i < n; ++i) {
                newChildren[order[i]] = this.myChildren[i];
            }
            this.myChildren = newChildren;
        }

        private static int reorderGain(int i, int j, int[][] data, int[] indices) {
            int upperSum = 0;
            int lowerSum = 0;
            for (int v = i + 1; v <= j - 1; ++v) {
                upperSum += CycleTreeNode.get(data, v, i, indices);
                upperSum += CycleTreeNode.get(data, j, v, indices);
                lowerSum += CycleTreeNode.get(data, v, j, indices);
                lowerSum += CycleTreeNode.get(data, i, v, indices);
            }
            return (upperSum += CycleTreeNode.get(data, j, i, indices)) - (lowerSum += CycleTreeNode.get(data, i, j, indices));
        }

        private static int get(int[][] data, int i, int j, int[] indices) {
            return data[indices[i]][indices[j]];
        }

        @Override
        public boolean isLeaf() {
            return false;
        }

        @Override
        public N getLeafData() {
            throw new UnsupportedOperationException("Method getLeafData not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        public int getLeafIndex() {
            throw new UnsupportedOperationException("Method getLeafIndex not implemented in " + String.valueOf(this.getClass()));
        }

        @Override
        public DsmTreeStructure.TreeNode<N>[] getChildren() {
            return this.myChildren;
        }

        @Override
        public DsmTreeStructure.TreeNode<N>[] getRawChildren() {
            return this.getChildren();
        }

        @Override
        public String getShortName() {
            return "";
        }

        @Override
        public String getFullName() {
            return this.toString();
        }

        @Override
        public Couple<Integer> getCycle() {
            return Couple.of((Object)0, (Object)(this.myChildren.length - 1));
        }

        @NonNls
        public String toString() {
            return "Cycle";
        }

        @Override
        public boolean isAutoExpand() {
            return true;
        }

        @Override
        public Icon getIcon() {
            return DsmIcons.ToggleCycles;
        }
    }
}

