/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmTableImpl;
import com.intellij.dsm.ui.MaxWidthVisitor;
import com.intellij.dsm.ui.NodeVisitor;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

final class Cache<N> {
    final List<DsmTreeStructure.TreeNode<N>> myRows;
    final Object2IntMap<DsmTreeStructure.TreeNode<N>> rowIndices = new Object2IntOpenHashMap();
    final int maxRowHeaderWidth;
    final Map<DsmTreeStructure.TreeNode<N>, Rectangle> rowHeaderBounds = new HashMap<DsmTreeStructure.TreeNode<N>, Rectangle>();
    final int myTableSize;

    Cache(final DsmTableImpl<N> dsmTable) {
        MaxWidthVisitor<N> mv = new MaxWidthVisitor<N>(dsmTable);
        dsmTable.acceptNodes(mv);
        this.maxRowHeaderWidth = mv.myMaxWidth;
        this.myRows = mv.myRows;
        for (int i = 0; i < this.myRows.size(); ++i) {
            this.rowIndices.put(this.myRows.get(i), i);
        }
        this.rowIndices.defaultReturnValue(-1);
        dsmTable.acceptNodes(new NodeVisitor<N>(){

            @Override
            public void visitLeaf(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
                this.visitNode(node, x, y, height);
            }

            @Override
            public void visitExpanded(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
                Cache.this.rowHeaderBounds.put(node, new Rectangle(x, y, dsmTable.myBoxSize, height));
            }

            @Override
            public void visitCollapsed(DsmTreeStructure.TreeNode<N> node, int x, int y, int height, boolean isFirst, boolean isLast) {
                this.visitNode(node, x, y, height);
            }

            private void visitNode(DsmTreeStructure.TreeNode<N> node, int x, int y, int height) {
                Cache.this.rowHeaderBounds.put(node, new Rectangle(x, y, Cache.this.maxRowHeaderWidth - x, height));
            }
        });
        this.myTableSize = this.myRows.size() * dsmTable.myBoxSize;
    }
}

