/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dsm.ui;

import com.intellij.dsm.model.DsmTreeStructure;
import com.intellij.dsm.ui.DsmSelection;
import com.intellij.dsm.ui.DsmSelectionModelImpl;
import com.intellij.dsm.ui.DsmTableImpl;
import java.awt.event.MouseEvent;

final class TableMouseHandler<N> {
    private final DsmTableImpl<N> myDsmTable;
    private final DsmSelectionModelImpl<N> mySelectionModel;

    TableMouseHandler(DsmTableImpl<N> dsmTable) {
        this.myDsmTable = dsmTable;
        this.mySelectionModel = this.myDsmTable.mySelectionModel;
    }

    public void processMouseEvent(MouseEvent e) {
        if (e.isConsumed() && !e.isPopupTrigger()) {
            return;
        }
        if (e.getID() == 501 && e.getButton() == 1 || e.isPopupTrigger()) {
            DsmTreeStructure.TreeNode<N> row = this.myDsmTable.row(e.getY());
            DsmTreeStructure.TreeNode<N> col = this.myDsmTable.col(e.getX());
            if (row != null && col != null) {
                if (e.getClickCount() == 1) {
                    this.processSelectionEvent(e, row, col);
                } else if (e.getClickCount() == 2) {
                    if (!row.isLeaf()) {
                        this.myDsmTable.expand(row);
                    }
                    if (!col.isLeaf()) {
                        this.myDsmTable.expand(col);
                    }
                    this.myDsmTable.scrollCellToVisible(row, col);
                }
            }
            this.myDsmTable.update();
        }
    }

    private void processSelectionEvent(MouseEvent e, DsmTreeStructure.TreeNode<N> row, DsmTreeStructure.TreeNode<N> col) {
        if (e.isPopupTrigger()) {
            if (this.mySelectionModel.isSelected(row) && this.mySelectionModel.isSelected(col)) {
                return;
            }
            this.mySelectionModel.clear();
        } else if (!(e.isControlDown() || e.isMetaDown() || e.isShiftDown())) {
            this.mySelectionModel.clear();
        }
        if (row == col) {
            DsmSelection<N> s = DsmSelection.createRowSelection(row, this.myDsmTable.myCache.rowIndices.getInt(row));
            if (e.isShiftDown()) {
                this.mySelectionModel.expandSelection(s);
            } else {
                this.mySelectionModel.addSelection(s);
            }
        } else {
            DsmSelection<N> s = this.mySelectionModel.createCellSelection(row, col);
            if (!e.isShiftDown()) {
                this.mySelectionModel.addSelection(s);
            } else {
                this.mySelectionModel.expandSelection(s);
            }
        }
    }

    public void processMouseMotionEvent(MouseEvent e) {
        if (e.getID() == 506 && e.getButton() == 1) {
            DsmTreeStructure.TreeNode<N> row = this.myDsmTable.row(e.getY());
            DsmTreeStructure.TreeNode<N> col = this.myDsmTable.col(e.getX());
            if (row != null && col != null) {
                this.mySelectionModel.expandSelection(this.mySelectionModel.createCellSelection(row, col));
            }
        }
    }
}

