/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.EventId3;
import com.intellij.internal.statistic.service.fus.collectors.ProjectUsagesCollector;
import com.intellij.kubernetes.api.KubernetesApiModel;
import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.api.KubernetesApiProvider;
import com.intellij.kubernetes.api.KubernetesApiProviderInterface;
import com.intellij.kubernetes.api.PersistentState;
import com.intellij.kubernetes.api.settings.KubernetesApiProjectSettings;
import com.intellij.kubernetes.api.settings.KubernetesApiSettings;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0014J\b\u0010\u0015\u001a\u00020\u0005H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\r0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\b0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/intellij/kubernetes/KubernetesProjectMetricsCollector;", "Lcom/intellij/internal/statistic/service/fus/collectors/ProjectUsagesCollector;", "<init>", "()V", "GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "MODELS_COUNT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "AVAILABLE_CONTEXTS", "CONFIG_FILES", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "NAMESPACES_STAT", "", "WATCH_INFO", "Lcom/intellij/internal/statistic/eventLog/events/EventId3;", "getMetrics", "", "Lcom/intellij/internal/statistic/beans/MetricEvent;", "project", "Lcom/intellij/openapi/project/Project;", "getGroup", "intellij.clouds.kubernetes"})
@SourceDebugExtension(value={"SMAP\nKubernetesFeatureUsagesCollectors.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KubernetesFeatureUsagesCollectors.kt\ncom/intellij/kubernetes/KubernetesProjectMetricsCollector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,96:1\n1563#2:97\n1634#2,3:98\n1563#2:101\n1634#2,3:102\n1#3:105\n*S KotlinDebug\n*F\n+ 1 KubernetesFeatureUsagesCollectors.kt\ncom/intellij/kubernetes/KubernetesProjectMetricsCollector\n*L\n82#1:97\n82#1:98,3\n86#1:101\n86#1:102,3\n*E\n"})
public final class KubernetesProjectMetricsCollector
extends ProjectUsagesCollector {
    @NotNull
    private final EventLogGroup GROUP = new EventLogGroup("kubernetes.project.metrics", 3, null, 4, null);
    @NotNull
    private final EventId1<Integer> MODELS_COUNT = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"apiModels.size.used", (EventField)((EventField)EventFields.RoundedInt((String)"count")), null, (int)4, null);
    @NotNull
    private final EventId1<Integer> AVAILABLE_CONTEXTS = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"available.contexts.used", (EventField)((EventField)EventFields.RoundedInt((String)"count")), null, (int)4, null);
    @NotNull
    private final EventId2<Integer, Integer> CONFIG_FILES = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"config.files.used", (EventField)((EventField)EventFields.RoundedInt((String)"settings")), (EventField)((EventField)EventFields.RoundedInt((String)"attached")), null, (int)8, null);
    @NotNull
    private final EventId2<Integer, Double> NAMESPACES_STAT = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"namespaces.count.used", (EventField)((EventField)EventFields.RoundedInt((String)"max")), (EventField)((EventField)EventFields.Double((String)"avr")), null, (int)8, null);
    @NotNull
    private final EventId3<Integer, Integer, Integer> WATCH_INFO = EventLogGroup.registerEvent$default((EventLogGroup)this.GROUP, (String)"watch.info", (EventField)((EventField)EventFields.RoundedInt((String)"starts")), (EventField)((EventField)EventFields.RoundedInt((String)"stops")), (EventField)((EventField)EventFields.RoundedInt((String)"startFails")), null, (int)16, null);

    /*
     * WARNING - void declaration
     */
    @NotNull
    protected Set<MetricEvent> getMetrics(@NotNull Project project) {
        void $this$mapTo$iv$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Set set;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Set $this$getMetrics_u24lambda_u245 = set = SetsKt.createSetBuilder();
        boolean bl = false;
        KubernetesApiProviderInterface apiProvider = KubernetesApiProvider.Companion.getInstance(project);
        $this$getMetrics_u24lambda_u245.add(this.MODELS_COUNT.metric((Object)apiProvider.getApiModels().size()));
        $this$getMetrics_u24lambda_u245.add(this.AVAILABLE_CONTEXTS.metric((Object)apiProvider.getKubeconfigFilesState().getAvailableContexts().size()));
        Integer n = ((KubernetesApiSettings.State)KubernetesApiProjectSettings.Companion.getInstance(project).getState()).getConfigPaths().size();
        Intrinsics.checkNotNull((Object)apiProvider, (String)"null cannot be cast to non-null type com.intellij.kubernetes.api.KubernetesApiProvider");
        $this$getMetrics_u24lambda_u245.add(this.CONFIG_FILES.metric((Object)n, (Object)((PersistentState)((KubernetesApiProvider)apiProvider).getState()).getConfiguredContexts().size()));
        Iterable $this$map$iv = ((KubernetesApiProvider)apiProvider).getApiModels();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            KubernetesApiModelInterface kubernetesApiModelInterface = (KubernetesApiModelInterface)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl2 = false;
            collection.add(it.getKnownNamespaces().size());
        }
        List namespacesCount = (List)destination$iv$iv;
        if (!((Collection)namespacesCount).isEmpty()) {
            $this$getMetrics_u24lambda_u245.add(this.NAMESPACES_STAT.metric((Object)CollectionsKt.maxOrThrow((Iterable)namespacesCount), (Object)CollectionsKt.averageOfInt((Iterable)namespacesCount)));
        }
        Iterable $this$map$iv2 = ((KubernetesApiProvider)apiProvider).getApiModels();
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo22 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KubernetesApiModelInterface bl2 = (KubernetesApiModelInterface)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type com.intellij.kubernetes.api.KubernetesApiModel");
            collection.add(((KubernetesApiModel)it).getWatchApiUsageStatistic().getRoundedSnapShot());
        }
        List watchesCount = (List)destination$iv$iv2;
        if (!((Collection)watchesCount).isEmpty()) {
            int n2;
            int n3;
            int n4;
            Iterable iterable2 = watchesCount;
            EventId3<Integer, Integer, Integer> eventId3 = this.WATCH_INFO;
            collection = $this$getMetrics_u24lambda_u245;
            int n5 = 0;
            for (Object t : iterable2) {
                void it;
                List $i$f$mapTo22 = (List)t;
                n4 = n5;
                boolean bl4 = false;
                n3 = ((Number)it.get(0)).intValue();
                n5 = n4 + n3;
            }
            n4 = n5;
            iterable2 = watchesCount;
            Integer n6 = n4;
            n5 = 0;
            for (Object t : iterable2) {
                List it = (List)t;
                n3 = n5;
                boolean bl5 = false;
                n2 = ((Number)it.get(1)).intValue();
                n5 = n3 + n2;
            }
            n3 = n5;
            iterable2 = watchesCount;
            Integer n7 = n3;
            n5 = 0;
            for (Object t : iterable2) {
                List it = (List)t;
                n2 = n5;
                boolean bl6 = false;
                int n8 = ((Number)it.get(2)).intValue();
                n5 = n2 + n8;
            }
            n2 = n5;
            collection.add(eventId3.metric((Object)n6, (Object)n7, (Object)n2));
        }
        return SetsKt.build((Set)set);
    }

    @NotNull
    public EventLogGroup getGroup() {
        return this.GROUP;
    }
}

