/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.kubernetes.view.ui;

import com.intellij.kubernetes.api.KubernetesApiModelInterface;
import com.intellij.kubernetes.i18n.KubernetesBundle;
import com.intellij.kubernetes.view.mappers.KubernetesResourceMapper;
import com.intellij.kubernetes.view.ui.KubernetesConsoleViewPanel;
import com.intellij.kubernetes.view.ui.KubernetesDeploymentLogPanel;
import com.intellij.kubernetes.view.ui.KubernetesPodForwardingPortsPanelKt;
import com.intellij.kubernetes.view.ui.KubernetesResourceContent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import io.kubernetes.client.common.KubernetesObject;
import io.kubernetes.client.openapi.models.V1Deployment;
import io.kubernetes.client.openapi.models.V1ObjectMeta;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B;\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\u0002\u0012\u0002\b\u00030\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/kubernetes/view/ui/KubernetesDeploymentContent;", "Lcom/intellij/kubernetes/view/ui/KubernetesResourceContent;", "Lio/kubernetes/client/openapi/models/V1Deployment;", "deployment", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "apiModel", "Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;", "mapper", "Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;", "toolbarActionGroup", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "<init>", "(Lio/kubernetes/client/openapi/models/V1Deployment;Lcom/intellij/openapi/Disposable;Lcom/intellij/kubernetes/api/KubernetesApiModelInterface;Lcom/intellij/kubernetes/view/mappers/KubernetesResourceMapper;Lcom/intellij/openapi/actionSystem/ActionGroup;)V", "createLogPanel", "Lcom/intellij/kubernetes/view/ui/KubernetesDeploymentLogPanel;", "intellij.clouds.kubernetes"})
public final class KubernetesDeploymentContent
extends KubernetesResourceContent<V1Deployment> {
    public KubernetesDeploymentContent(@NotNull V1Deployment deployment, @NotNull Disposable parentDisposable, @NotNull KubernetesApiModelInterface apiModel, @NotNull KubernetesResourceMapper<V1Deployment, ?> mapper, @Nullable ActionGroup toolbarActionGroup) {
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Intrinsics.checkNotNullParameter((Object)apiModel, (String)"apiModel");
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        super((KubernetesObject)deployment, parentDisposable, apiModel, mapper, toolbarActionGroup);
        KubernetesPodForwardingPortsPanelKt.installPortForwardingTabsSupport(this, (KubernetesObject)deployment);
    }

    @RequiresEdt
    @NotNull
    public final KubernetesDeploymentLogPanel createLogPanel(@NotNull V1Deployment deployment) {
        Intrinsics.checkNotNullParameter((Object)deployment, (String)"deployment");
        KubernetesDeploymentLogPanel panel2 = new KubernetesDeploymentLogPanel(deployment, this, this.getProject());
        KubernetesConsoleViewPanel kubernetesConsoleViewPanel = panel2;
        Object[] objectArray = new Object[1];
        V1ObjectMeta v1ObjectMeta = deployment.getMetadata();
        Intrinsics.checkNotNull((Object)v1ObjectMeta);
        objectArray[0] = v1ObjectMeta.getName();
        this.addConsoleTab(deployment, kubernetesConsoleViewPanel, KubernetesBundle.message("KubernetesDeploymentContent.log.title", objectArray));
        return panel2;
    }
}

