/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.sshAgentProxy;

import com.intellij.community.wintools.ErrorToolsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.codeWithMe.model.SshRequesterProcessInfo;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.portForwarding.utils.ProcessInfoUtil;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpc;
import com.jetbrains.rdserver.sshAgentProxy.SshAgentIpcService;
import com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.Kernel32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.platform.win32.WinNT;
import com.sun.jna.ptr.IntByReference;
import com.sun.jna.win32.W32APIOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\u0018\u0000 '2\u00020\u0001:\u0005&'()*B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0016J\b\u0010\u0017\u001a\u00020\u0018H\u0016J\u0006\u0010\u0019\u001a\u00020\u001aJ\u0010\u0010\u001b\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\b\u0010#\u001a\u00020\u0012H\u0002J\b\u0010$\u001a\u00020\u0012H\u0016J\b\u0010%\u001a\u00020\u0012H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u00158VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0016R\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010 \u001a\u00020\u001f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b!\u0010\"\u00a8\u0006+"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc;", "pipePath", "", "WindowsNamedPipeAgentIpc", "(Ljava/lang/String;)V", "key", "getKey", "()Ljava/lang/String;", "hPipe", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lock", "", "connectionThread", "Ljava/lang/Thread;", "state", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "assertConnectionThread", "", "open", "isOpen", "", "()Z", "accept", "Lcom/jetbrains/rdserver/sshAgentProxy/SshAgentIpc$Streams;", "getRequesterPid", "", "isSshProcess", "process", "Lcom/jetbrains/rdserver/portForwarding/utils/ProcessInfoUtil$ProcessInfo;", "requestorProcessValue", "Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "requesterProcessInfo", "getRequesterProcessInfo", "()Lcom/jetbrains/codeWithMe/model/SshRequesterProcessInfo;", "disconnect", "close", "cleanup", "NamedPipeState", "Companion", "Kernel32Ex", "PipeReadableByteChannel", "PipeWritableByteChannel", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n1#2:392\n24#3:393\n24#3:394\n24#3:395\n24#3:396\n24#3:397\n24#3:398\n24#3:399\n24#3:400\n24#3:401\n24#3:402\n24#3:403\n24#3:404\n24#3:405\n24#3:406\n24#3:407\n24#3:408\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc\n*L\n131#1:393\n142#1:394\n151#1:395\n161#1:396\n179#1:397\n203#1:398\n208#1:399\n228#1:400\n236#1:401\n238#1:402\n249#1:403\n264#1:404\n274#1:405\n284#1:406\n288#1:407\n290#1:408\n*E\n"})
public final class WindowsNamedPipeAgentIpc
extends SshAgentIpc {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final String pipePath;
    @NotNull
    private final String key;
    @NotNull
    private WinNT.HANDLE hPipe;
    @NotNull
    private final Object lock;
    @Nullable
    private Thread connectionThread;
    @NotNull
    private NamedPipeState state;
    @NotNull
    private SshRequesterProcessInfo requestorProcessValue;
    private static final String[] c;
    private static final String[] d;

    public WindowsNamedPipeAgentIpc(@NotNull String pipePath) {
        long l2 = 26680522150445L;
        Intrinsics.checkNotNullParameter((Object)pipePath, (String)WindowsNamedPipeAgentIpc.b(-185332980 - -22511, 185332980 - 23248, (int)l2));
        this.key = this.pipePath = pipePath;
        WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
        Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-185332980 - -22510, 185332980 - 25167, (int)l2));
        this.hPipe = hANDLE;
        this.lock = new Object();
        this.state = NamedPipeState.Initial;
        this.requestorProcessValue = SshAgentIpc.Companion.getMissingProcessInfo();
    }

    @Override
    @NotNull
    public String getKey() {
        return this.key;
    }

    private final void assertConnectionThread() {
        block3: {
            boolean bl;
            Thread thread;
            long l2;
            block2: {
                l2 = 132221558939076L;
                thread = Thread.currentThread();
                boolean bl2 = SshAgentIpcService.V();
                try {
                    bl = Intrinsics.areEqual((Object)thread, (Object)this.connectionThread);
                    if (bl2) break block2;
                    if (bl) break block3;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                bl = false;
            }
            boolean bl3 = bl;
            Thread thread2 = thread;
            Thread thread3 = this.connectionThread;
            String string = this.pipePath;
            String string2 = WindowsNamedPipeAgentIpc.b(-990758130 - -29186, 990758130 - 24046, (int)l2) + string + WindowsNamedPipeAgentIpc.b(-990758130 - -29187, 990758130 - 25532, (int)l2) + thread3 + WindowsNamedPipeAgentIpc.b(-990758130 - -29192, -990758130 - -((char)-20304), (int)l2) + thread2;
            throw new IllegalArgumentException(string2.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() {
        block17: {
            boolean bl;
            block19: {
                block18: {
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
                    boolean bl2;
                    long l2;
                    block15: {
                        block16: {
                            l2 = 14540038027374L;
                            Object object = this.lock;
                            synchronized (object) {
                                boolean bl3;
                                bl2 = SshAgentIpcService.X();
                                boolean bl4 = false;
                                try {
                                    bl3 = this.connectionThread == null;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl3) {
                                    boolean bl5 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-1573757490 - -27375, -1573757490 - -((char)-29877), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1573757490 - -27376, 1573757490 - 24638, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.connectionThread = Thread.currentThread();
                                Unit unit = Unit.INSTANCE;
                            }
                            try {
                                try {
                                    WinNT.HANDLE hANDLE = Kernel32.INSTANCE.CreateNamedPipe(this.pipePath, 3, 0, 1, 16384, 16384, 0, null);
                                    Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1573757490 - -27377, -1573757490 - -17581, (int)l2));
                                    this.hPipe = hANDLE;
                                    windowsNamedPipeAgentIpc = this;
                                    if (!bl2) break block15;
                                    if (Intrinsics.areEqual((Object)windowsNamedPipeAgentIpc.hPipe, (Object)WinNT.INVALID_HANDLE_VALUE)) {
                                    }
                                    break block16;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                throw new RuntimeException(WindowsNamedPipeAgentIpc.b(-1573757490 - -27362, -1573757490 - -24225, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1573757490 - -27363, -1573757490 - -32038, (int)l2) + ErrorToolsKt.kernel32LastError());
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        this.state = NamedPipeState.Open;
                        windowsNamedPipeAgentIpc = this;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = windowsNamedPipeAgentIpc;
                    boolean bl6 = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1573757490 - -27364, 1573757490 - (char)-29204, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1573757490 - -27362, -1573757490 - -24225, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1573757490 - -27365, -1573757490 - -12580, (int)l2));
                            if (!ActionTimestamp.V()) break block17;
                            if (!bl2) break block18;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block19;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            SshAgentIpcService.V(bl);
        }
    }

    @Override
    public boolean isOpen() {
        int n;
        block8: {
            block7: {
                boolean bl;
                block6: {
                    long l2 = 37232920605381L;
                    bl = SshAgentIpcService.V();
                    try {
                        try {
                            n = this.state.compareTo((Enum)NamedPipeState.Open);
                            if (bl) break block6;
                            if (n < 0) break block7;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = this.state.compareTo((Enum)NamedPipeState.Disconnecting);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                try {
                    if (bl) break block8;
                    if (n > 0) break block7;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                n = 1;
                break block8;
            }
            n = 0;
        }
        return n != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    @NotNull
    public SshAgentIpc.Streams accept() {
        SshAgentIpc.Streams streams;
        block32: {
            boolean bl;
            block34: {
                block33: {
                    Object object;
                    Object object2;
                    boolean bl2;
                    long l2;
                    block28: {
                        block29: {
                            l2 = 19762735202675L;
                            boolean bl3 = SshAgentIpcService.X();
                            this.assertConnectionThread();
                            bl2 = bl3;
                            Object object3 = this.lock;
                            synchronized (object3) {
                                boolean bl4;
                                NamedPipeState namedPipeState;
                                NamedPipeState namedPipeState2;
                                block26: {
                                    block27: {
                                        boolean bl5 = false;
                                        try {
                                            namedPipeState2 = this.state;
                                            namedPipeState = NamedPipeState.Closing;
                                            if (!bl2) break block26;
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block27;
                                        }
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                                        boolean bl6 = false;
                                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1590665520 + -11559, 1590665520 + 7655, (int)l2));
                                        logger.info(WindowsNamedPipeAgentIpc.b(-1590665520 + -11555, -1590665520 + -6494, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1590665520 + -11560, 1590665520 - 8009, (int)l2) + this.state);
                                        throw new ClosedChannelException();
                                    }
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Open;
                                }
                                try {
                                    bl4 = namedPipeState2 == namedPipeState;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                if (!bl4) {
                                    boolean bl7 = false;
                                    String string = WindowsNamedPipeAgentIpc.b(-1590665520 + -11555, -1590665520 + -6494, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1590665520 + -11557, 1590665520 - 4135, (int)l2) + this.state;
                                    throw new IllegalArgumentException(string.toString());
                                }
                                this.state = NamedPipeState.Connecting;
                                Unit unit = Unit.INSTANCE;
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                            boolean bl8 = false;
                            try {
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1590665520 + -11559, 1590665520 + 7655, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1590665520 + -11555, -1590665520 + -6494, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1590665520 + -11558, 1590665520 + 3626, (int)l2));
                                object2 = Kernel32.INSTANCE;
                                if (!bl2) break block28;
                                if (object2.ConnectNamedPipe(this.hPipe, null)) break block29;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            int n = Kernel32.INSTANCE.GetLastError();
                            if (n == 535) {
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                                boolean bl9 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1590665520 + -11559, 1590665520 + 7655, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1590665520 + -11555, -1590665520 + -6494, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1590665520 + -11547, -1590665520 + -23952, (int)l2));
                            } else {
                                throw new IllegalStateException((WindowsNamedPipeAgentIpc.b(-1590665520 + -11555, -1590665520 + -6494, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1590665520 + -11548, 1590665520 - 4530, (int)l2) + ErrorToolsKt.prettyHRESULT(n)).toString());
                            }
                        }
                        object2 = this.lock;
                    }
                    Kernel32 kernel32 = object2;
                    synchronized (kernel32) {
                        boolean bl10;
                        NamedPipeState namedPipeState;
                        NamedPipeState namedPipeState3;
                        block30: {
                            block31: {
                                boolean bl11 = false;
                                namedPipeState3 = this.state;
                                namedPipeState = NamedPipeState.Closing;
                                if (!bl2) break block30;
                                try {
                                    block35: {
                                        if (namedPipeState3.compareTo((Enum)namedPipeState) < 0) break block31;
                                        break block35;
                                        catch (IllegalArgumentException illegalArgumentException) {
                                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                        }
                                    }
                                    throw new ClosedChannelException();
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                            }
                            namedPipeState3 = this.state;
                            namedPipeState = NamedPipeState.Connecting;
                        }
                        try {
                            bl10 = namedPipeState3 == namedPipeState;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        if (!bl10) {
                            boolean bl12 = false;
                            String string = WindowsNamedPipeAgentIpc.b(-1590665520 + -11555, -1590665520 + -6494, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1590665520 + -11557, 1590665520 - 4135, (int)l2) + this.state;
                            throw new IllegalArgumentException(string.toString());
                        }
                        this.state = NamedPipeState.Connected;
                        object = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc = this;
                    boolean bl13 = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1590665520 + -11559, 1590665520 + 7655, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1590665520 + -11555, -1590665520 + -6494, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1590665520 + -11545, 1590665520 + 6063, (int)l2));
                    long l3 = this.getRequesterPid();
                    this.requestorProcessValue = this.calcRequesterProcessInfo(l3);
                    object = new PipeReadableByteChannel(this);
                    PipeWritableByteChannel pipeWritableByteChannel = new PipeWritableByteChannel(this);
                    try {
                        try {
                            streams = new SshAgentIpc.Streams((PipeReadableByteChannel)object, pipeWritableByteChannel, this){
                                final /* synthetic */ PipeReadableByteChannel $read;
                                final /* synthetic */ PipeWritableByteChannel $write;
                                final /* synthetic */ WindowsNamedPipeAgentIpc this$0;
                                private static final String[] a;
                                private static final String[] b;
                                {
                                    this.$read = $read;
                                    this.$write = $write;
                                    this.this$0 = $receiver;
                                }

                                public InputStream getInputStream() {
                                    long l2 = 75836420149118L;
                                    InputStream inputStream = Channels.newInputStream(this.$read);
                                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)accept.3.a(-182580510 + -10288, -182580510 + -32717, (int)l2));
                                    return inputStream;
                                }

                                public OutputStream getOutputStream() {
                                    long l2 = 76705643839805L;
                                    OutputStream outputStream = Channels.newOutputStream(this.$write);
                                    Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)accept.3.a(-1822921560 - -((char)-32696), -1822921560 - -16728, (int)l2));
                                    return outputStream;
                                }

                                public void close() {
                                    WindowsNamedPipeAgentIpc.access$disconnect(this.this$0);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                static {
                                    block13: {
                                        var5 = new String[2];
                                        var3_1 = 0;
                                        var2_2 = ">\u0000^:\u00b2\u0003\u00ed\u00c8\u0087\u00da\u0001J)\u0080\u00e2L\u0012\u00f6\u000e\u0014TW\u0013\u00d6\u0000\\\u00c6\u00a6`\u00118\u00e7\u00cc\u00cc\u009fNPpA\u0098";
                                        var4_3 = ">\u0000^:\u00b2\u0003\u00ed\u00c8\u0087\u00da\u0001J)\u0080\u00e2L\u0012\u00f6\u000e\u0014TW\u0013\u00d6\u0000\\\u00c6\u00a6`\u00118\u00e7\u00cc\u00cc\u009fNPpA\u0098".length();
                                        var1_4 = 19;
                                        var0_5 = -1;
lbl7:
                                        // 2 sources

                                        while (true) {
                                            continue;
                                            break;
                                        }
lbl9:
                                        // 1 sources

                                        while (true) {
                                            var5[var3_1++] = new String(v0).intern();
                                            if ((var0_5 += var1_4) < var4_3) {
                                                var1_4 = var2_2.charAt(var0_5);
                                                ** continue;
                                            }
                                            break block13;
                                            break;
                                        }
                                        v1 = ++var0_5;
                                        v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                                        v3 = v2.length;
                                        var6_6 = 0;
                                        v4 = 50;
                                        v5 = v2;
                                        v6 = v3;
                                        if (v3 > 1) ** GOTO lbl67
                                        do {
                                            v7 = v4;
                                            v5 = v5;
                                            v8 = v5;
                                            v9 = v4;
                                            v10 = var6_6;
                                            while (true) {
                                                switch (var6_6 % 7) {
                                                    case 0: {
                                                        v11 = 123;
                                                        break;
                                                    }
                                                    case 1: {
                                                        v11 = 37;
                                                        break;
                                                    }
                                                    case 2: {
                                                        v11 = 86;
                                                        break;
                                                    }
                                                    case 3: {
                                                        v11 = 106;
                                                        break;
                                                    }
                                                    case 4: {
                                                        v11 = 48;
                                                        break;
                                                    }
                                                    case 5: {
                                                        v11 = 109;
                                                        break;
                                                    }
                                                    default: {
                                                        v11 = 31;
                                                    }
                                                }
                                                v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                                                ++var6_6;
                                                v4 = v7;
                                                if (v7 != 0) break;
                                                v7 = v4;
                                                v5 = v5;
                                                v10 = v4;
                                                v8 = v5;
                                                v9 = v4;
                                            }
lbl67:
                                            // 2 sources

                                            v0 = v5;
                                            v6 = v6;
                                        } while (v6 > var6_6);
                                        ** while (true)
                                    }
                                    accept.3.a = var5;
                                    accept.3.b = new String[2];
                                }

                                private static String a(int n, int n2, int n3) {
                                    int n4 = (n ^ n3 ^ 0xFFFFADCC) & 0xFFFF;
                                    if (b[n4] == null) {
                                        int n5;
                                        char[] cArray = a[n4].toCharArray();
                                        int n6 = switch (cArray[0] & 0xFF) {
                                            case 0 -> 177;
                                            case 1 -> 114;
                                            case 2 -> 233;
                                            case 3 -> 197;
                                            case 4 -> 31;
                                            case 5 -> 68;
                                            case 6 -> 85;
                                            case 7 -> 165;
                                            case 8 -> 25;
                                            case 9 -> 234;
                                            case 10 -> 138;
                                            case 11 -> 181;
                                            case 12 -> 139;
                                            case 13 -> 153;
                                            case 14 -> 186;
                                            case 15 -> 184;
                                            case 16 -> 120;
                                            case 17 -> 122;
                                            case 18 -> 182;
                                            case 19 -> 26;
                                            case 20 -> 160;
                                            case 21 -> 111;
                                            case 22 -> 168;
                                            case 23 -> 64;
                                            case 24 -> 47;
                                            case 25 -> 89;
                                            case 26 -> 194;
                                            case 27 -> 13;
                                            case 28 -> 67;
                                            case 29 -> 202;
                                            case 30 -> 19;
                                            case 31 -> 213;
                                            case 32 -> 32;
                                            case 33 -> 167;
                                            case 34 -> 232;
                                            case 35 -> 53;
                                            case 36 -> 158;
                                            case 37 -> 24;
                                            case 38 -> 16;
                                            case 39 -> 8;
                                            case 40 -> 222;
                                            case 41 -> 88;
                                            case 42 -> 212;
                                            case 43 -> 154;
                                            case 44 -> 246;
                                            case 45 -> 174;
                                            case 46 -> 90;
                                            case 47 -> 238;
                                            case 48 -> 150;
                                            case 49 -> 240;
                                            case 50 -> 253;
                                            case 51 -> 17;
                                            case 52 -> 252;
                                            case 53 -> 188;
                                            case 54 -> 56;
                                            case 55 -> 161;
                                            case 56 -> 169;
                                            case 57 -> 159;
                                            case 58 -> 172;
                                            case 59 -> 76;
                                            case 60 -> 97;
                                            case 61 -> 103;
                                            case 62 -> 135;
                                            case 63 -> 193;
                                            case 64 -> 210;
                                            case 65 -> 79;
                                            case 66 -> 71;
                                            case 67 -> 237;
                                            case 68 -> 195;
                                            case 69 -> 115;
                                            case 70 -> 148;
                                            case 71 -> 55;
                                            case 72 -> 81;
                                            case 73 -> 239;
                                            case 74 -> 206;
                                            case 75 -> 38;
                                            case 76 -> 225;
                                            case 77 -> 48;
                                            case 78 -> 251;
                                            case 79 -> 100;
                                            case 80 -> 220;
                                            case 81 -> 128;
                                            case 82 -> 224;
                                            case 83 -> 27;
                                            case 84 -> 11;
                                            case 85 -> 147;
                                            case 86 -> 142;
                                            case 87 -> 156;
                                            case 88 -> 192;
                                            case 89 -> 107;
                                            case 90 -> 155;
                                            case 91 -> 217;
                                            case 92 -> 41;
                                            case 93 -> 215;
                                            case 94 -> 86;
                                            case 95 -> 137;
                                            case 96 -> 40;
                                            case 97 -> 183;
                                            case 98 -> 3;
                                            case 99 -> 60;
                                            case 100 -> 75;
                                            case 101 -> 12;
                                            case 102 -> 49;
                                            case 103 -> 175;
                                            case 104 -> 94;
                                            case 105 -> 146;
                                            case 106 -> 6;
                                            case 107 -> 109;
                                            case 108 -> 36;
                                            case 109 -> 1;
                                            case 110 -> 22;
                                            case 111 -> 69;
                                            case 112 -> 83;
                                            case 113 -> 200;
                                            case 114 -> 21;
                                            case 115 -> 92;
                                            case 116 -> 211;
                                            case 117 -> 10;
                                            case 118 -> 42;
                                            case 119 -> 82;
                                            case 120 -> 255;
                                            case 121 -> 15;
                                            case 122 -> 5;
                                            case 123 -> 242;
                                            case 124 -> 125;
                                            case 125 -> 152;
                                            case 126 -> 180;
                                            case 127 -> 9;
                                            case 128 -> 176;
                                            case 129 -> 126;
                                            case 130 -> 207;
                                            case 131 -> 221;
                                            case 132 -> 189;
                                            case 133 -> 0;
                                            case 134 -> 39;
                                            case 135 -> 44;
                                            case 136 -> 245;
                                            case 137 -> 228;
                                            case 138 -> 93;
                                            case 139 -> 223;
                                            case 140 -> 187;
                                            case 141 -> 72;
                                            case 142 -> 208;
                                            case 143 -> 249;
                                            case 144 -> 130;
                                            case 145 -> 58;
                                            case 146 -> 133;
                                            case 147 -> 105;
                                            case 148 -> 236;
                                            case 149 -> 28;
                                            case 150 -> 124;
                                            case 151 -> 173;
                                            case 152 -> 101;
                                            case 153 -> 250;
                                            case 154 -> 229;
                                            case 155 -> 54;
                                            case 156 -> 51;
                                            case 157 -> 244;
                                            case 158 -> 84;
                                            case 159 -> 87;
                                            case 160 -> 46;
                                            case 161 -> 170;
                                            case 162 -> 196;
                                            case 163 -> 57;
                                            case 164 -> 91;
                                            case 165 -> 179;
                                            case 166 -> 190;
                                            case 167 -> 98;
                                            case 168 -> 95;
                                            case 169 -> 73;
                                            case 170 -> 112;
                                            case 171 -> 132;
                                            case 172 -> 7;
                                            case 173 -> 185;
                                            case 174 -> 201;
                                            case 175 -> 121;
                                            case 176 -> 45;
                                            case 177 -> 157;
                                            case 178 -> 243;
                                            case 179 -> 2;
                                            case 180 -> 66;
                                            case 181 -> 65;
                                            case 182 -> 141;
                                            case 183 -> 78;
                                            case 184 -> 4;
                                            case 185 -> 198;
                                            case 186 -> 205;
                                            case 187 -> 235;
                                            case 188 -> 136;
                                            case 189 -> 218;
                                            case 190 -> 102;
                                            case 191 -> 104;
                                            case 192 -> 230;
                                            case 193 -> 178;
                                            case 194 -> 203;
                                            case 195 -> 23;
                                            case 196 -> 143;
                                            case 197 -> 247;
                                            case 198 -> 140;
                                            case 199 -> 14;
                                            case 200 -> 254;
                                            case 201 -> 74;
                                            case 202 -> 144;
                                            case 203 -> 110;
                                            case 204 -> 227;
                                            case 205 -> 20;
                                            case 206 -> 199;
                                            case 207 -> 231;
                                            case 208 -> 113;
                                            case 209 -> 50;
                                            case 210 -> 119;
                                            case 211 -> 131;
                                            case 212 -> 70;
                                            case 213 -> 219;
                                            case 214 -> 99;
                                            case 215 -> 59;
                                            case 216 -> 116;
                                            case 217 -> 96;
                                            case 218 -> 166;
                                            case 219 -> 163;
                                            case 220 -> 37;
                                            case 221 -> 118;
                                            case 222 -> 209;
                                            case 223 -> 171;
                                            case 224 -> 191;
                                            case 225 -> 204;
                                            case 226 -> 145;
                                            case 227 -> 134;
                                            case 228 -> 214;
                                            case 229 -> 248;
                                            case 230 -> 33;
                                            case 231 -> 43;
                                            case 232 -> 106;
                                            case 233 -> 63;
                                            case 234 -> 149;
                                            case 235 -> 151;
                                            case 236 -> 117;
                                            case 237 -> 77;
                                            case 238 -> 34;
                                            case 239 -> 62;
                                            case 240 -> 29;
                                            case 241 -> 61;
                                            case 242 -> 216;
                                            case 243 -> 35;
                                            case 244 -> 80;
                                            case 245 -> 123;
                                            case 246 -> 18;
                                            case 247 -> 127;
                                            case 248 -> 108;
                                            case 249 -> 164;
                                            case 250 -> 52;
                                            case 251 -> 30;
                                            case 252 -> 129;
                                            case 253 -> 162;
                                            case 254 -> 241;
                                            default -> 226;
                                        };
                                        int n7 = ((n2 ^= n3) & 0xFF) - n6;
                                        if (n7 < 0) {
                                            n7 += 256;
                                        }
                                        if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                                            n5 += 256;
                                        }
                                        int n8 = 0;
                                        while (n8 < cArray.length) {
                                            int n9 = n8 % 2;
                                            int n10 = n8;
                                            char[] cArray2 = cArray;
                                            char c2 = cArray[n10];
                                            if (n9 == 0) {
                                                cArray2[n10] = (char)(c2 ^ n7);
                                                n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                                            } else {
                                                cArray2[n10] = (char)(c2 ^ n5);
                                                n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                                            }
                                            ++n8;
                                        }
                                        accept.3.b[n4] = new String(cArray).intern();
                                    }
                                    return b[n4];
                                }
                            };
                            if (bl2) break block32;
                            if (ActionTimestamp.V()) break block33;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = false;
                        break block34;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = true;
            }
            ActionTimestamp.V(bl);
        }
        return streams;
    }

    public final long getRequesterPid() {
        long l2;
        block4: {
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            int n;
            long l3;
            block2: {
                block3: {
                    l3 = 101614500521737L;
                    WinDef.ULONGByReference uLONGByReference = new WinDef.ULONGByReference();
                    boolean bl2 = SshAgentIpcService.V();
                    try {
                        n = Kernel32.INSTANCE.GetNamedPipeClientProcessId(this.hPipe, uLONGByReference);
                        if (bl2) break block2;
                        if (n == 0) break block3;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    WinDef.ULONG uLONG = uLONGByReference.getValue();
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(130676790 + (char)-8291, -130676790 + -((char)-20899), (int)l3));
                    logger.info(WindowsNamedPipeAgentIpc.b(130676790 + (char)-8287, 130676790 + (char)-21806, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(130676790 + (char)-8298, 130676790 + (char)-9508, (int)l3) + uLONG);
                    l2 = uLONGByReference.getValue().longValue();
                    break block4;
                }
                n = Kernel32.INSTANCE.GetLastError();
            }
            int n2 = n;
            windowsNamedPipeAgentIpc = this;
            bl = false;
            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(130676790 + (char)-8291, -130676790 + -((char)-20899), (int)l3));
            logger.warn(WindowsNamedPipeAgentIpc.b(130676790 + (char)-8287, 130676790 + (char)-21806, (int)l3) + this.pipePath + WindowsNamedPipeAgentIpc.b(130676790 + (char)-8299, -130676790 + -((char)-15998), (int)l3) + ErrorToolsKt.prettyHRESULT(n2));
            l2 = -1L;
        }
        long l4 = l2;
        return l4;
    }

    @Override
    protected boolean isSshProcess(@NotNull ProcessInfoUtil.ProcessInfo process2) {
        boolean bl;
        block14: {
            block12: {
                block15: {
                    String string;
                    Object object;
                    boolean bl2;
                    block13: {
                        long l2 = 73072750038074L;
                        boolean bl3 = SshAgentIpcService.X();
                        Intrinsics.checkNotNullParameter((Object)process2, (String)WindowsNamedPipeAgentIpc.b(1823576910 - (char)-27051, 1823576910 - (char)-14045, (int)l2));
                        bl2 = bl3;
                        try {
                            try {
                                try {
                                    try {
                                        if (!bl2 || (object = process2.getExecutable()) == null) break block12;
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                    if ((object = object.getFileName()) == null) break block12;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                String string2 = object.toString();
                                string = string2;
                                object = string2;
                                if (!bl2) break block13;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            if (string == null) break block12;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        string = WindowsNamedPipeAgentIpc.b(1823576910 - (char)-27052, 1823576910 - (char)-7956, (int)l2);
                    }
                    try {
                        try {
                            bl = StringsKt.equals((String)object, (String)string, (boolean)true);
                            if (!bl2) break block14;
                            if (!bl) break block15;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        bl = true;
                        break block14;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                bl = false;
                break block14;
            }
            bl = false;
        }
        return bl;
    }

    @Override
    @NotNull
    public SshRequesterProcessInfo getRequesterProcessInfo() {
        return this.requestorProcessValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private final void disconnect() {
        Object object;
        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
        boolean bl;
        long l2;
        block25: {
            block26: {
                l2 = 127432667115707L;
                this.assertConnectionThread();
                Object object2 = this.lock;
                synchronized (object2) {
                    boolean bl2;
                    NamedPipeState namedPipeState;
                    NamedPipeState namedPipeState2;
                    block23: {
                        block24: {
                            block21: {
                                block22: {
                                    bl = SshAgentIpcService.X();
                                    boolean bl3 = false;
                                    namedPipeState2 = this.state;
                                    namedPipeState = NamedPipeState.Closing;
                                    if (!bl) break block21;
                                    try {
                                        block29: {
                                            if (namedPipeState2.compareTo((Enum)namedPipeState) < 0) break block22;
                                            break block29;
                                            catch (IllegalArgumentException illegalArgumentException) {
                                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                            }
                                        }
                                        throw new ClosedChannelException();
                                    }
                                    catch (IllegalArgumentException illegalArgumentException) {
                                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                    }
                                }
                                namedPipeState2 = this.state;
                                namedPipeState = NamedPipeState.Open;
                            }
                            try {
                                if (!bl) break block23;
                                if (namedPipeState2 != namedPipeState) break block24;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2 = this;
                            boolean bl4 = false;
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31355), 987481380 - 30277, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31351), -987481380 - -31198, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31330), 987481380 - 27997, (int)l2));
                            return;
                        }
                        namedPipeState2 = this.state;
                        namedPipeState = NamedPipeState.Connected;
                    }
                    try {
                        bl2 = namedPipeState2 == namedPipeState;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    if (!bl2) {
                        boolean bl5 = false;
                        String string = WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31351), -987481380 - -31198, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31353), 987481380 - 25699, (int)l2) + this.state;
                        throw new IllegalArgumentException(string.toString());
                    }
                    this.state = NamedPipeState.Disconnecting;
                    Unit unit = Unit.INSTANCE;
                }
                windowsNamedPipeAgentIpc = this;
                boolean bl6 = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31355), 987481380 - 30277, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31351), -987481380 - -31198, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31335), 987481380 - (char)-32447, (int)l2));
                    object = Kernel32.INSTANCE;
                    if (!bl) break block25;
                    if (object.DisconnectNamedPipe(this.hPipe)) break block26;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
                windowsNamedPipeAgentIpc = this;
                bl6 = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31355), 987481380 - 30277, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31351), -987481380 - -31198, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31336), -987481380 - -((char)-25158), (int)l2) + ErrorToolsKt.kernel32LastError());
                return;
            }
            object = this.lock;
        }
        Kernel32 kernel32 = object;
        synchronized (kernel32) {
            block27: {
                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3;
                block28: {
                    boolean bl7 = false;
                    windowsNamedPipeAgentIpc3 = this;
                    if (!bl) break block27;
                    try {
                        block30: {
                            if (windowsNamedPipeAgentIpc3.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block28;
                            break block30;
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                            }
                        }
                        throw new ClosedChannelException();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                }
                windowsNamedPipeAgentIpc3 = this;
            }
            windowsNamedPipeAgentIpc3.state = NamedPipeState.Open;
            Unit unit = Unit.INSTANCE;
        }
        windowsNamedPipeAgentIpc = this;
        boolean bl8 = false;
        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31355), 987481380 - 30277, (int)l2));
        logger.info(WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31351), -987481380 - -31198, (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-987481380 - -((char)-31333), 987481380 - (char)-20836, (int)l2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        block17: {
            int n;
            boolean bl;
            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc;
            long l2;
            block15: {
                boolean bl2;
                block16: {
                    l2 = 67870178026346L;
                    Object object = this.lock;
                    bl2 = SshAgentIpcService.V();
                    synchronized (object) {
                        block13: {
                            WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc2;
                            block14: {
                                boolean bl3 = false;
                                try {
                                    windowsNamedPipeAgentIpc2 = this;
                                    if (bl2) break block13;
                                    if (windowsNamedPipeAgentIpc2.state.compareTo((Enum)NamedPipeState.Closing) < 0) break block14;
                                }
                                catch (IllegalArgumentException illegalArgumentException) {
                                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                                }
                                WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc3 = this;
                                boolean bl4 = false;
                                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1104789030 + -28202, 1104789030 + (char)-24856, (int)l2));
                                logger.info(WindowsNamedPipeAgentIpc.b(-1104789030 + -28198, -1104789030 + -((char)-26001), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1104789030 + -28211, 1104789030 + 28660, (int)l2) + this.state + WindowsNamedPipeAgentIpc.b(-1104789030 + -28218, -1104789030 + -((char)-28512), (int)l2));
                                return;
                            }
                            windowsNamedPipeAgentIpc2 = this;
                        }
                        windowsNamedPipeAgentIpc2.state = NamedPipeState.Closing;
                        Unit unit = Unit.INSTANCE;
                    }
                    WindowsNamedPipeAgentIpc.Companion.connectToPipe(this.pipePath);
                    windowsNamedPipeAgentIpc = this;
                    bl = false;
                    try {
                        try {
                            Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1104789030 + -28202, 1104789030 + (char)-24856, (int)l2));
                            logger.info(WindowsNamedPipeAgentIpc.b(-1104789030 + -28198, -1104789030 + -((char)-26001), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1104789030 + -28217, -1104789030 + -27186, (int)l2));
                            n = Kernel32Ex.Companion.getINSTANCE().CancelIoEx(this.hPipe, null);
                            if (bl2) break block15;
                            if (n != 0) break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                        }
                        n = Kernel32.INSTANCE.GetLastError();
                        if (bl2) break block15;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                    }
                    int n2 = n;
                    if (n2 != 1168) {
                        WindowsNamedPipeAgentIpc windowsNamedPipeAgentIpc4 = this;
                        boolean bl5 = false;
                        Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1104789030 + -28202, 1104789030 + (char)-24856, (int)l2));
                        logger.info(WindowsNamedPipeAgentIpc.b(-1104789030 + -28198, -1104789030 + -((char)-26001), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1104789030 + -28216, -1104789030 + -((char)-22708), (int)l2) + ErrorToolsKt.prettyHRESULT(n2));
                    }
                }
                windowsNamedPipeAgentIpc = this;
                bl = false;
                try {
                    Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1104789030 + -28202, 1104789030 + (char)-24856, (int)l2));
                    logger.info(WindowsNamedPipeAgentIpc.b(-1104789030 + -28198, -1104789030 + -((char)-26001), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1104789030 + -28215, 1104789030 + (char)-26777, (int)l2));
                    if (bl2) break block17;
                    n = Kernel32.INSTANCE.CloseHandle(this.hPipe) ? 1 : 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw WindowsNamedPipeAgentIpc.a(illegalArgumentException);
                }
            }
            if (n == 0) {
                windowsNamedPipeAgentIpc = this;
                bl = false;
                Logger logger = Logger.getInstance(WindowsNamedPipeAgentIpc.class);
                Intrinsics.checkNotNullExpressionValue((Object)logger, (String)WindowsNamedPipeAgentIpc.b(-1104789030 + -28202, 1104789030 + (char)-24856, (int)l2));
                logger.warn(WindowsNamedPipeAgentIpc.b(-1104789030 + -28198, -1104789030 + -((char)-26001), (int)l2) + this.pipePath + WindowsNamedPipeAgentIpc.b(-1104789030 + -28222, -1104789030 + -21191, (int)l2) + ErrorToolsKt.kernel32LastError());
            }
            WinNT.HANDLE hANDLE = WinNT.INVALID_HANDLE_VALUE;
            Intrinsics.checkNotNullExpressionValue((Object)hANDLE, (String)WindowsNamedPipeAgentIpc.b(-1104789030 + -28221, -1104789030 + -((char)-30290), (int)l2));
            this.hPipe = hANDLE;
            this.state = NamedPipeState.Closed;
        }
    }

    @Override
    public void cleanup() {
    }

    public static final /* synthetic */ String access$getPipePath$p(WindowsNamedPipeAgentIpc $this) {
        return $this.pipePath;
    }

    /*
     * Unable to fully structure code
     */
    static {
        block20: {
            block19: {
                var5 = new String[34];
                var3_1 = 0;
                var2_2 = "c]_z\u0095\u00ad\u00c2\u00a1\u0014\u00938y1\u00afL*\u0087\u00d38\u0085z1\u0098\u008d\u00baywC$\u0006\u00cc{\u00aa\u00beAt\u0018\u0097\u00b2\u0099P1\u00a5\u00fbz!\u00fa\u00d4R}bVg\u00ab\u00a57\u00e3\u0005',-\tL\u00b8|\u00a0\u00e6$\u0019\u0002A\u0005\n\u00d9r\u00ea@\b\u00c4\u009b\u00ab\u00d3Y\u00be]!\u0014\u0013\u0081\u0011\u009d\u00cf\u00d1\u0013\u00a3\u009aa\u0007\u00e5+\u00c8u]tX\u001b\u0083\u0005\u0001\u00bf\u0013&l\u001e\u00c4\"\u00be\u00f1DU\u00f7\u001e\u0005b\u001b\u00c6\u00c8\u00d0BU\u00c8r\u0089\u00ed~\u00c9O=A\u007f\u00fd\u00e2\u00c0\u00f1\u0010\u001d?a\u0097\u00e8\u00ab\u00948\u0014\u0014\u00b4\u00f5;\u00e3\u0093\u00ac\t\u00f88<\u00a1\u00bd#T}\u0006\u0010\u001c\u0014A\u00f2\u00ec\u0007\u0014\u00ad\u0004\u00a6\u00b6\u00a3{)\u009b\u00f5?\u00aed\u00fb9\u00e1E\u00c6pR~\u00b4\u00be\u0082)6S\u0083\u00d7\u009d\u009cr\u00b5\u00b5\u00d4\u000e\u00aa\u0019\u00eckf\u00d7j\bX\u0017Zb\u009d\u00cf\u00c0<\u00ed|\u00ea\u00d3\u008e\u00e6L #Qw\u00b0\u00c1\u00e16\u00d7L\u0097\u0005,\u00c2\u001c\b\u00a1\u00b5\u0007\u0016\u00cc\u0006\u00ef6\f\u00e4\u0001\u00bf\u009b\u00c6\u00d5@K\u00a72\u00905F\u0082#s\u00df_]sZ\u00c1\u001cV4Hpp^\u00b7\u0011\u001b\u00eb\u00b0\t\u00eeqS5A\u0014\u00dfP{\u0090\u00a1\u00b1\u00e0FFS\u00e0\u00ddJ[9\u00c7\u00a5\u00ae|5\u0094\u00f4\u00a1'A]\u00c9\u00beM)R\u0015\u00a7\u00a91\u00ee\u001cD\u00eaY=T\u001fZ\u00a7mA>C\u00b8\u00dc\u00ec:&\u00cdo\u00ac\u00bdkL]d\u00c2\b\u00acV:\u0003O\u00a2(6YD\u000b\u00c3\u00a0[\u00afZS\u00d3\u009b\u00d5$\u00d4\u0015\u0091F\u0011p\u0014\u00c0\u00f6\u0094O%O\u00e5\u00fc\u0005\u00d2\bZ\u00a5{\u00a4\u00dd)\u00bd\u00e3\u0091\u00c9\u00a1RK\u00fe\u0092~\u00e9E\u0092\u00b7\u009c\r7\u0019\u00d0\u00edn1\\\u0091-s\u00b0\u00d7[Rk\u00ee]\u00db\u0019\u0086gVO\u00d4\u001c\u0007\u00c8Y5\u0084\u0011\u00a6\u00c6\u0007\u00fcB\u00d7\u008b\u00aa\u00a8\u00a7(\u008f\u00f5\u009b*PD\u0083\u001b\u00fb\u0015\u00ee\u001eQ]\u00a6\u00d3wov`\u00db\u00be\u0085\u00ab\u0086\u0088s\u00d3\u0014\u00b2Y\u00eb\u00e0\u00100R\u00f8\u00b1/\u00db\u000f>e\u00e3\u0011\u00b7O\u00da\u00b9\u00a5\u00cc\u0084t\u00bcD\u0085\"\u00a8k3\u00d8\u00f5p\u00c1\u00ba\u00c3\u00f6\u00c3T\u00d4\u00990\u0006IQ\u0095\u00a6,X\u00b4\u00ec\u00a3\u0088\u00acv\u00fcT=)\u00b9\u00d0\u000eI\u0000\r\u00bdj\u00daa\u000b\u00d2\u009aj\u00bem\u0017\u001b\u00beg\u00f4T\u00aeRlF$\u00b49zW\u00b9f\u0014+\u00b9d')\\g\u00ca\u0092!\u00df\n3E\u0081\u0017\u0014\u00de\u00e8\u00fd\u001f\u00a1\u0018g\u00ab\u00cf\u00c0\u00c8|\u0081\u00dd\u0087\u000e\u008f\u00b28\u00f3w|~\u00b5\u0019\u00df\u00fe\b\u00c6\u0013)\u00f9\u00f2\u0019\u00eb\u00b0\u0016iv\u00d6oag\u0087\u00fa\u00a1\u00df\u00ee64\u00cd\u00c8%\u00c1\u001f\u00eb0\u00f5S\u00a0\u009e\u00af\u00e6\u00e0\u0004{\u00e9\u00f5\u009f\u001d\u00edV\t&\u0089\u00e7\u0089\u00cc\u00e9,\u007f\u00b4";
                var4_3 = "c]_z\u0095\u00ad\u00c2\u00a1\u0014\u00938y1\u00afL*\u0087\u00d38\u0085z1\u0098\u008d\u00baywC$\u0006\u00cc{\u00aa\u00beAt\u0018\u0097\u00b2\u0099P1\u00a5\u00fbz!\u00fa\u00d4R}bVg\u00ab\u00a57\u00e3\u0005',-\tL\u00b8|\u00a0\u00e6$\u0019\u0002A\u0005\n\u00d9r\u00ea@\b\u00c4\u009b\u00ab\u00d3Y\u00be]!\u0014\u0013\u0081\u0011\u009d\u00cf\u00d1\u0013\u00a3\u009aa\u0007\u00e5+\u00c8u]tX\u001b\u0083\u0005\u0001\u00bf\u0013&l\u001e\u00c4\"\u00be\u00f1DU\u00f7\u001e\u0005b\u001b\u00c6\u00c8\u00d0BU\u00c8r\u0089\u00ed~\u00c9O=A\u007f\u00fd\u00e2\u00c0\u00f1\u0010\u001d?a\u0097\u00e8\u00ab\u00948\u0014\u0014\u00b4\u00f5;\u00e3\u0093\u00ac\t\u00f88<\u00a1\u00bd#T}\u0006\u0010\u001c\u0014A\u00f2\u00ec\u0007\u0014\u00ad\u0004\u00a6\u00b6\u00a3{)\u009b\u00f5?\u00aed\u00fb9\u00e1E\u00c6pR~\u00b4\u00be\u0082)6S\u0083\u00d7\u009d\u009cr\u00b5\u00b5\u00d4\u000e\u00aa\u0019\u00eckf\u00d7j\bX\u0017Zb\u009d\u00cf\u00c0<\u00ed|\u00ea\u00d3\u008e\u00e6L #Qw\u00b0\u00c1\u00e16\u00d7L\u0097\u0005,\u00c2\u001c\b\u00a1\u00b5\u0007\u0016\u00cc\u0006\u00ef6\f\u00e4\u0001\u00bf\u009b\u00c6\u00d5@K\u00a72\u00905F\u0082#s\u00df_]sZ\u00c1\u001cV4Hpp^\u00b7\u0011\u001b\u00eb\u00b0\t\u00eeqS5A\u0014\u00dfP{\u0090\u00a1\u00b1\u00e0FFS\u00e0\u00ddJ[9\u00c7\u00a5\u00ae|5\u0094\u00f4\u00a1'A]\u00c9\u00beM)R\u0015\u00a7\u00a91\u00ee\u001cD\u00eaY=T\u001fZ\u00a7mA>C\u00b8\u00dc\u00ec:&\u00cdo\u00ac\u00bdkL]d\u00c2\b\u00acV:\u0003O\u00a2(6YD\u000b\u00c3\u00a0[\u00afZS\u00d3\u009b\u00d5$\u00d4\u0015\u0091F\u0011p\u0014\u00c0\u00f6\u0094O%O\u00e5\u00fc\u0005\u00d2\bZ\u00a5{\u00a4\u00dd)\u00bd\u00e3\u0091\u00c9\u00a1RK\u00fe\u0092~\u00e9E\u0092\u00b7\u009c\r7\u0019\u00d0\u00edn1\\\u0091-s\u00b0\u00d7[Rk\u00ee]\u00db\u0019\u0086gVO\u00d4\u001c\u0007\u00c8Y5\u0084\u0011\u00a6\u00c6\u0007\u00fcB\u00d7\u008b\u00aa\u00a8\u00a7(\u008f\u00f5\u009b*PD\u0083\u001b\u00fb\u0015\u00ee\u001eQ]\u00a6\u00d3wov`\u00db\u00be\u0085\u00ab\u0086\u0088s\u00d3\u0014\u00b2Y\u00eb\u00e0\u00100R\u00f8\u00b1/\u00db\u000f>e\u00e3\u0011\u00b7O\u00da\u00b9\u00a5\u00cc\u0084t\u00bcD\u0085\"\u00a8k3\u00d8\u00f5p\u00c1\u00ba\u00c3\u00f6\u00c3T\u00d4\u00990\u0006IQ\u0095\u00a6,X\u00b4\u00ec\u00a3\u0088\u00acv\u00fcT=)\u00b9\u00d0\u000eI\u0000\r\u00bdj\u00daa\u000b\u00d2\u009aj\u00bem\u0017\u001b\u00beg\u00f4T\u00aeRlF$\u00b49zW\u00b9f\u0014+\u00b9d')\\g\u00ca\u0092!\u00df\n3E\u0081\u0017\u0014\u00de\u00e8\u00fd\u001f\u00a1\u0018g\u00ab\u00cf\u00c0\u00c8|\u0081\u00dd\u0087\u000e\u008f\u00b28\u00f3w|~\u00b5\u0019\u00df\u00fe\b\u00c6\u0013)\u00f9\u00f2\u0019\u00eb\u00b0\u0016iv\u00d6oag\u0087\u00fa\u00a1\u00df\u00ee64\u00cd\u00c8%\u00c1\u001f\u00eb0\u00f5S\u00a0\u009e\u00af\u00e6\u00e0\u0004{\u00e9\u00f5\u009f\u001d\u00edV\t&\u0089\u00e7\u0089\u00cc\u00e9,\u007f\u00b4".length();
                var1_4 = 8;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    v0 = 28;
                    v1 = ++var0_5;
                    v2 = var2_2.substring(v1, v1 + var1_4);
                    v3 = -1;
                    break block19;
                    break;
                }
lbl13:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    var2_2 = "\u00fb\u0012-\u0083BoC-\u00e7p3\u00f0\u00b9|\u0012{\u00ec\u00daP\u00a0e\u00c3\u00f3ir\u0096#\u00b6\u009e\u0014\u0018\u00ce|\u009b{m\u00c4\u00d7zF\u00c4\u00c1m\u009br\u00ae\u00f2\u0081F\u008e";
                    var4_3 = "\u00fb\u0012-\u0083BoC-\u00e7p3\u00f0\u00b9|\u0012{\u00ec\u00daP\u00a0e\u00c3\u00f3ir\u0096#\u00b6\u009e\u0014\u0018\u00ce|\u009b{m\u00c4\u00d7zF\u00c4\u00c1m\u009br\u00ae\u00f2\u0081F\u008e".length();
                    var1_4 = 29;
                    var0_5 = -1;
lbl22:
                    // 2 sources

                    while (true) {
                        v0 = 46;
                        v5 = ++var0_5;
                        v2 = var2_2.substring(v5, v5 + var1_4);
                        v3 = 0;
                        break block19;
                        break;
                    }
                    break;
                }
lbl28:
                // 1 sources

                while (true) {
                    var5[var3_1++] = v4.intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block20;
                    break;
                }
            }
            v6 = v2.toCharArray();
            v7 = v6.length;
            var6_6 = 0;
            v8 = v0;
            v9 = v6;
            v10 = v7;
            if (v7 > 1) ** GOTO lbl85
            do {
                v11 = v8;
                v9 = v9;
                v12 = v9;
                v13 = v8;
                v14 = var6_6;
                while (true) {
                    switch (var6_6 % 7) {
                        case 0: {
                            v15 = 45;
                            break;
                        }
                        case 1: {
                            v15 = 9;
                            break;
                        }
                        case 2: {
                            v15 = 7;
                            break;
                        }
                        case 3: {
                            v15 = 78;
                            break;
                        }
                        case 4: {
                            v15 = 47;
                            break;
                        }
                        case 5: {
                            v15 = 28;
                            break;
                        }
                        default: {
                            v15 = 36;
                        }
                    }
                    v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                    ++var6_6;
                    v8 = v11;
                    if (v11 != 0) break;
                    v11 = v8;
                    v9 = v9;
                    v14 = v8;
                    v12 = v9;
                    v13 = v8;
                }
lbl85:
                // 2 sources

                v16 = v9;
                v10 = v10;
            } while (v10 > var6_6);
            v4 = new String(v16);
            switch (v3) {
                default: {
                    ** continue;
                }
                ** case 0:
lbl95:
                // 1 sources

                ** continue;
            }
        }
        WindowsNamedPipeAgentIpc.c = var5;
        WindowsNamedPipeAgentIpc.d = new String[34];
        WindowsNamedPipeAgentIpc.Companion = new Companion(null);
    }

    private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
        return illegalArgumentException;
    }

    private static String b(int n, int n2, int n3) {
        int n4 = (n ^ n3 ^ 0xFFFFF0D6) & 0xFFFF;
        if (d[n4] == null) {
            int n5;
            char[] cArray = c[n4].toCharArray();
            int n6 = switch (cArray[0] & 0xFF) {
                case 0 -> 149;
                case 1 -> 131;
                case 2 -> 34;
                case 3 -> 224;
                case 4 -> 167;
                case 5 -> 5;
                case 6 -> 196;
                case 7 -> 151;
                case 8 -> 141;
                case 9 -> 29;
                case 10 -> 18;
                case 11 -> 61;
                case 12 -> 223;
                case 13 -> 234;
                case 14 -> 19;
                case 15 -> 35;
                case 16 -> 124;
                case 17 -> 249;
                case 18 -> 152;
                case 19 -> 113;
                case 20 -> 111;
                case 21 -> 204;
                case 22 -> 251;
                case 23 -> 186;
                case 24 -> 91;
                case 25 -> 123;
                case 26 -> 162;
                case 27 -> 244;
                case 28 -> 25;
                case 29 -> 178;
                case 30 -> 137;
                case 31 -> 76;
                case 32 -> 226;
                case 33 -> 172;
                case 34 -> 180;
                case 35 -> 69;
                case 36 -> 146;
                case 37 -> 206;
                case 38 -> 237;
                case 39 -> 24;
                case 40 -> 46;
                case 41 -> 182;
                case 42 -> 78;
                case 43 -> 243;
                case 44 -> 221;
                case 45 -> 26;
                case 46 -> 84;
                case 47 -> 53;
                case 48 -> 193;
                case 49 -> 67;
                case 50 -> 210;
                case 51 -> 238;
                case 52 -> 106;
                case 53 -> 112;
                case 54 -> 198;
                case 55 -> 33;
                case 56 -> 211;
                case 57 -> 250;
                case 58 -> 229;
                case 59 -> 44;
                case 60 -> 199;
                case 61 -> 59;
                case 62 -> 20;
                case 63 -> 163;
                case 64 -> 236;
                case 65 -> 45;
                case 66 -> 220;
                case 67 -> 153;
                case 68 -> 132;
                case 69 -> 105;
                case 70 -> 140;
                case 71 -> 92;
                case 72 -> 175;
                case 73 -> 219;
                case 74 -> 207;
                case 75 -> 72;
                case 76 -> 218;
                case 77 -> 99;
                case 78 -> 235;
                case 79 -> 155;
                case 80 -> 189;
                case 81 -> 60;
                case 82 -> 231;
                case 83 -> 168;
                case 84 -> 96;
                case 85 -> 255;
                case 86 -> 86;
                case 87 -> 174;
                case 88 -> 83;
                case 89 -> 16;
                case 90 -> 88;
                case 91 -> 126;
                case 92 -> 232;
                case 93 -> 9;
                case 94 -> 8;
                case 95 -> 254;
                case 96 -> 115;
                case 97 -> 10;
                case 98 -> 103;
                case 99 -> 107;
                case 100 -> 184;
                case 101 -> 148;
                case 102 -> 28;
                case 103 -> 116;
                case 104 -> 0;
                case 105 -> 2;
                case 106 -> 49;
                case 107 -> 188;
                case 108 -> 6;
                case 109 -> 100;
                case 110 -> 165;
                case 111 -> 23;
                case 112 -> 75;
                case 113 -> 125;
                case 114 -> 102;
                case 115 -> 68;
                case 116 -> 90;
                case 117 -> 50;
                case 118 -> 130;
                case 119 -> 202;
                case 120 -> 241;
                case 121 -> 98;
                case 122 -> 246;
                case 123 -> 166;
                case 124 -> 38;
                case 125 -> 41;
                case 126 -> 200;
                case 127 -> 56;
                case 128 -> 4;
                case 129 -> 192;
                case 130 -> 159;
                case 131 -> 40;
                case 132 -> 57;
                case 133 -> 134;
                case 134 -> 156;
                case 135 -> 31;
                case 136 -> 93;
                case 137 -> 181;
                case 138 -> 133;
                case 139 -> 73;
                case 140 -> 139;
                case 141 -> 97;
                case 142 -> 62;
                case 143 -> 187;
                case 144 -> 208;
                case 145 -> 212;
                case 146 -> 121;
                case 147 -> 164;
                case 148 -> 176;
                case 149 -> 63;
                case 150 -> 64;
                case 151 -> 245;
                case 152 -> 150;
                case 153 -> 138;
                case 154 -> 171;
                case 155 -> 191;
                case 156 -> 95;
                case 157 -> 117;
                case 158 -> 160;
                case 159 -> 239;
                case 160 -> 129;
                case 161 -> 81;
                case 162 -> 157;
                case 163 -> 66;
                case 164 -> 214;
                case 165 -> 21;
                case 166 -> 108;
                case 167 -> 3;
                case 168 -> 77;
                case 169 -> 195;
                case 170 -> 194;
                case 171 -> 240;
                case 172 -> 227;
                case 173 -> 118;
                case 174 -> 12;
                case 175 -> 248;
                case 176 -> 15;
                case 177 -> 217;
                case 178 -> 80;
                case 179 -> 170;
                case 180 -> 177;
                case 181 -> 201;
                case 182 -> 190;
                case 183 -> 54;
                case 184 -> 110;
                case 185 -> 122;
                case 186 -> 37;
                case 187 -> 42;
                case 188 -> 79;
                case 189 -> 32;
                case 190 -> 222;
                case 191 -> 17;
                case 192 -> 82;
                case 193 -> 89;
                case 194 -> 147;
                case 195 -> 119;
                case 196 -> 209;
                case 197 -> 185;
                case 198 -> 114;
                case 199 -> 144;
                case 200 -> 242;
                case 201 -> 169;
                case 202 -> 128;
                case 203 -> 43;
                case 204 -> 71;
                case 205 -> 154;
                case 206 -> 85;
                case 207 -> 55;
                case 208 -> 36;
                case 209 -> 253;
                case 210 -> 7;
                case 211 -> 120;
                case 212 -> 13;
                case 213 -> 58;
                case 214 -> 74;
                case 215 -> 161;
                case 216 -> 216;
                case 217 -> 213;
                case 218 -> 173;
                case 219 -> 109;
                case 220 -> 94;
                case 221 -> 70;
                case 222 -> 215;
                case 223 -> 225;
                case 224 -> 11;
                case 225 -> 233;
                case 226 -> 27;
                case 227 -> 30;
                case 228 -> 14;
                case 229 -> 247;
                case 230 -> 179;
                case 231 -> 52;
                case 232 -> 22;
                case 233 -> 101;
                case 234 -> 127;
                case 235 -> 87;
                case 236 -> 145;
                case 237 -> 47;
                case 238 -> 48;
                case 239 -> 104;
                case 240 -> 230;
                case 241 -> 143;
                case 242 -> 228;
                case 243 -> 1;
                case 244 -> 252;
                case 245 -> 203;
                case 246 -> 65;
                case 247 -> 135;
                case 248 -> 183;
                case 249 -> 136;
                case 250 -> 197;
                case 251 -> 142;
                case 252 -> 205;
                case 253 -> 51;
                case 254 -> 39;
                default -> 158;
            };
            int n7 = ((n2 ^= n3) & 0xFF) - n6;
            if (n7 < 0) {
                n7 += 256;
            }
            if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                n5 += 256;
            }
            int n8 = 0;
            while (n8 < cArray.length) {
                int n9 = n8 % 2;
                int n10 = n8;
                char[] cArray2 = cArray;
                char c2 = cArray[n10];
                if (n9 == 0) {
                    cArray2[n10] = (char)(c2 ^ n7);
                    n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                } else {
                    cArray2[n10] = (char)(c2 ^ n5);
                    n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                }
                ++n8;
            }
            WindowsNamedPipeAgentIpc.d[n4] = new String(cArray).intern();
        }
        return d[n4];
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion;", "", "WindowsNamedPipeAgentIpc$Companion", "()V", "connectToPipeTest", "", "pipePath", "", "connectToPipe", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Companion\n*L\n84#1:392\n*E\n"})
    public static final class Companion {
        private static final String[] a;
        private static final String[] b;

        private Companion() {
        }

        @TestOnly
        public final void connectToPipeTest(@NotNull String pipePath) {
            long l2 = 116421135156965L;
            Intrinsics.checkNotNullParameter((Object)pipePath, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1751619480 + 6372, -1751619480 + -3015, (int)l2));
            this.connectToPipe(pipePath);
        }

        private final void connectToPipe(String pipePath) {
            block6: {
                boolean bl;
                WinNT.HANDLE hANDLE;
                block7: {
                    long l2;
                    block5: {
                        WinNT.HANDLE hANDLE2;
                        boolean bl2;
                        block4: {
                            l2 = 140575506880415L;
                            hANDLE = Kernel32.INSTANCE.CreateFile(pipePath, -1073741824, 0, null, 3, 0, null);
                            bl2 = SshAgentIpcService.V();
                            try {
                                hANDLE2 = hANDLE;
                                if (bl2) break block4;
                                if (hANDLE2 == null) break block5;
                            }
                            catch (RuntimeException runtimeException) {
                                throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                            }
                            hANDLE2 = WinNT.INVALID_HANDLE_VALUE;
                        }
                        try {
                            bl = Intrinsics.areEqual((Object)hANDLE2, (Object)hANDLE);
                            if (bl2) break block6;
                            if (!bl) break block7;
                        }
                        catch (RuntimeException runtimeException) {
                            throw com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(runtimeException);
                        }
                    }
                    Companion companion = this;
                    boolean bl3 = false;
                    Logger logger = Logger.getInstance(Companion.class);
                    Intrinsics.checkNotNullExpressionValue((Object)logger, (String)com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1227208410 + (char)-5587, -1227208410 + -((char)-2894), (int)l2));
                    logger.info(com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1227208410 + (char)-5590, -1227339480 - -((char)-15287), (int)l2) + pipePath + com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a(1227208410 + (char)-5589, -1227208410 + -((char)-11010), (int)l2));
                }
                bl = Kernel32.INSTANCE.CloseHandle(hANDLE);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[4];
                    var3_1 = 0;
                    var2_2 = "\u00c4Z\u00c3\t7\u0092\u00adu\u0010\u0080c\u00ba\u008f\u00a2\u00f9\u00e6A\u00d4S?,\u001b\u00e3\u00a4\"";
                    var4_3 = "\u00c4Z\u00c3\t7\u0092\u00adu\u0010\u0080c\u00ba\u008f\u00a2\u00f9\u00e6A\u00d4S?,\u001b\u00e3\u00a4\"".length();
                    var1_4 = 8;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 119;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00c2V\u0096\u001dx5\u0085\ni\u00faU\u00fb\u0095?X\u00b2\u00a9E\u00ab\u00b1\"w\u00e2\u009c\u0082\u00a0#\u0011(\u00e9\u00da\u0006X\u00fduo8\n\u00ad,\t3\u007fg.Pt~Dk|SE\u00a1N\u00ce\u0094\u0012K";
                        var4_3 = "\u00c2V\u0096\u001dx5\u0085\ni\u00faU\u00fb\u0095?X\u00b2\u00a9E\u00ab\u00b1\"w\u00e2\u009c\u0082\u00a0#\u0011(\u00e9\u00da\u0006X\u00fduo8\n\u00ad,\t3\u007fg.Pt~Dk|SE\u00a1N\u00ce\u0094\u0012K".length();
                        var1_4 = 5;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 41;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 23;
                                break;
                            }
                            case 1: {
                                v15 = 110;
                                break;
                            }
                            case 2: {
                                v15 = 46;
                                break;
                            }
                            case 3: {
                                v15 = 55;
                                break;
                            }
                            case 4: {
                                v15 = 61;
                                break;
                            }
                            case 5: {
                                v15 = 100;
                                break;
                            }
                            default: {
                                v15 = 91;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.a = var5;
            com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b = new String[4];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x7699) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 191;
                    case 1 -> 177;
                    case 2 -> 71;
                    case 3 -> 43;
                    case 4 -> 17;
                    case 5 -> 135;
                    case 6 -> 90;
                    case 7 -> 251;
                    case 8 -> 214;
                    case 9 -> 156;
                    case 10 -> 46;
                    case 11 -> 138;
                    case 12 -> 106;
                    case 13 -> 163;
                    case 14 -> 184;
                    case 15 -> 85;
                    case 16 -> 121;
                    case 17 -> 170;
                    case 18 -> 57;
                    case 19 -> 160;
                    case 20 -> 247;
                    case 21 -> 15;
                    case 22 -> 149;
                    case 23 -> 21;
                    case 24 -> 104;
                    case 25 -> 126;
                    case 26 -> 119;
                    case 27 -> 180;
                    case 28 -> 76;
                    case 29 -> 185;
                    case 30 -> 166;
                    case 31 -> 84;
                    case 32 -> 120;
                    case 33 -> 114;
                    case 34 -> 183;
                    case 35 -> 181;
                    case 36 -> 63;
                    case 37 -> 182;
                    case 38 -> 109;
                    case 39 -> 4;
                    case 40 -> 24;
                    case 41 -> 62;
                    case 42 -> 200;
                    case 43 -> 232;
                    case 44 -> 245;
                    case 45 -> 51;
                    case 46 -> 190;
                    case 47 -> 61;
                    case 48 -> 249;
                    case 49 -> 0;
                    case 50 -> 20;
                    case 51 -> 95;
                    case 52 -> 162;
                    case 53 -> 105;
                    case 54 -> 240;
                    case 55 -> 234;
                    case 56 -> 30;
                    case 57 -> 65;
                    case 58 -> 175;
                    case 59 -> 22;
                    case 60 -> 224;
                    case 61 -> 3;
                    case 62 -> 159;
                    case 63 -> 86;
                    case 64 -> 67;
                    case 65 -> 171;
                    case 66 -> 60;
                    case 67 -> 72;
                    case 68 -> 2;
                    case 69 -> 26;
                    case 70 -> 134;
                    case 71 -> 250;
                    case 72 -> 41;
                    case 73 -> 16;
                    case 74 -> 75;
                    case 75 -> 93;
                    case 76 -> 164;
                    case 77 -> 167;
                    case 78 -> 124;
                    case 79 -> 155;
                    case 80 -> 174;
                    case 81 -> 80;
                    case 82 -> 205;
                    case 83 -> 255;
                    case 84 -> 97;
                    case 85 -> 13;
                    case 86 -> 115;
                    case 87 -> 92;
                    case 88 -> 252;
                    case 89 -> 10;
                    case 90 -> 194;
                    case 91 -> 118;
                    case 92 -> 202;
                    case 93 -> 233;
                    case 94 -> 204;
                    case 95 -> 5;
                    case 96 -> 89;
                    case 97 -> 244;
                    case 98 -> 192;
                    case 99 -> 218;
                    case 100 -> 229;
                    case 101 -> 147;
                    case 102 -> 241;
                    case 103 -> 31;
                    case 104 -> 141;
                    case 105 -> 243;
                    case 106 -> 122;
                    case 107 -> 38;
                    case 108 -> 74;
                    case 109 -> 78;
                    case 110 -> 150;
                    case 111 -> 23;
                    case 112 -> 14;
                    case 113 -> 211;
                    case 114 -> 53;
                    case 115 -> 18;
                    case 116 -> 198;
                    case 117 -> 87;
                    case 118 -> 199;
                    case 119 -> 33;
                    case 120 -> 217;
                    case 121 -> 69;
                    case 122 -> 133;
                    case 123 -> 9;
                    case 124 -> 248;
                    case 125 -> 219;
                    case 126 -> 131;
                    case 127 -> 139;
                    case 128 -> 45;
                    case 129 -> 179;
                    case 130 -> 176;
                    case 131 -> 220;
                    case 132 -> 55;
                    case 133 -> 239;
                    case 134 -> 91;
                    case 135 -> 158;
                    case 136 -> 77;
                    case 137 -> 209;
                    case 138 -> 165;
                    case 139 -> 197;
                    case 140 -> 12;
                    case 141 -> 27;
                    case 142 -> 7;
                    case 143 -> 143;
                    case 144 -> 110;
                    case 145 -> 142;
                    case 146 -> 49;
                    case 147 -> 196;
                    case 148 -> 70;
                    case 149 -> 68;
                    case 150 -> 253;
                    case 151 -> 83;
                    case 152 -> 189;
                    case 153 -> 238;
                    case 154 -> 130;
                    case 155 -> 39;
                    case 156 -> 242;
                    case 157 -> 107;
                    case 158 -> 58;
                    case 159 -> 8;
                    case 160 -> 215;
                    case 161 -> 81;
                    case 162 -> 96;
                    case 163 -> 73;
                    case 164 -> 112;
                    case 165 -> 193;
                    case 166 -> 246;
                    case 167 -> 102;
                    case 168 -> 148;
                    case 169 -> 145;
                    case 170 -> 236;
                    case 171 -> 169;
                    case 172 -> 64;
                    case 173 -> 231;
                    case 174 -> 140;
                    case 175 -> 108;
                    case 176 -> 113;
                    case 177 -> 19;
                    case 178 -> 151;
                    case 179 -> 188;
                    case 180 -> 223;
                    case 181 -> 225;
                    case 182 -> 29;
                    case 183 -> 226;
                    case 184 -> 144;
                    case 185 -> 99;
                    case 186 -> 103;
                    case 187 -> 54;
                    case 188 -> 34;
                    case 189 -> 168;
                    case 190 -> 206;
                    case 191 -> 35;
                    case 192 -> 195;
                    case 193 -> 213;
                    case 194 -> 212;
                    case 195 -> 11;
                    case 196 -> 101;
                    case 197 -> 82;
                    case 198 -> 157;
                    case 199 -> 79;
                    case 200 -> 28;
                    case 201 -> 132;
                    case 202 -> 125;
                    case 203 -> 59;
                    case 204 -> 216;
                    case 205 -> 123;
                    case 206 -> 254;
                    case 207 -> 56;
                    case 208 -> 111;
                    case 209 -> 153;
                    case 210 -> 47;
                    case 211 -> 136;
                    case 212 -> 221;
                    case 213 -> 173;
                    case 214 -> 117;
                    case 215 -> 32;
                    case 216 -> 201;
                    case 217 -> 207;
                    case 218 -> 237;
                    case 219 -> 42;
                    case 220 -> 230;
                    case 221 -> 208;
                    case 222 -> 203;
                    case 223 -> 52;
                    case 224 -> 100;
                    case 225 -> 25;
                    case 226 -> 172;
                    case 227 -> 36;
                    case 228 -> 154;
                    case 229 -> 210;
                    case 230 -> 6;
                    case 231 -> 178;
                    case 232 -> 187;
                    case 233 -> 161;
                    case 234 -> 50;
                    case 235 -> 227;
                    case 236 -> 186;
                    case 237 -> 44;
                    case 238 -> 128;
                    case 239 -> 1;
                    case 240 -> 137;
                    case 241 -> 48;
                    case 242 -> 129;
                    case 243 -> 40;
                    case 244 -> 235;
                    case 245 -> 66;
                    case 246 -> 94;
                    case 247 -> 116;
                    case 248 -> 37;
                    case 249 -> 88;
                    case 250 -> 127;
                    case 251 -> 222;
                    case 252 -> 98;
                    case 253 -> 152;
                    case 254 -> 228;
                    default -> 146;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Companion.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u0000 \b2\u00020\u0001:\u0001\bJ\u001c\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\t\u00c0\u0006\u0001"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "Lcom/sun/jna/platform/win32/Kernel32;", "CancelIoEx", "", "hFile", "Lcom/sun/jna/platform/win32/WinNT$HANDLE;", "lpOverlapped", "Lcom/sun/jna/Pointer;", "Companion", "intellij.platform.backend.split"})
    public static interface Kernel32Ex
    extends Kernel32 {
        @NotNull
        public static final Companion Companion = Companion.$$INSTANCE;

        public boolean CancelIoEx(@Nullable WinNT.HANDLE var1, @Nullable Pointer var2);

        @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex$Companion;", "", "WindowsNamedPipeAgentIpc$Kernel32Ex$Companion", "()V", "INSTANCE", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "getINSTANCE", "()Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$Kernel32Ex;", "intellij.platform.backend.split"})
        public static final class Companion {
            static final /* synthetic */ Companion $$INSTANCE;
            @NotNull
            private static final Kernel32Ex INSTANCE;

            private Companion() {
            }

            @NotNull
            public final Kernel32Ex getINSTANCE() {
                return INSTANCE;
            }

            /*
             * Unable to fully structure code
             */
            static {
                block13: {
                    var7 = 113606710925429L;
                    var0_1 = new String[2];
                    var4_2 = 0;
                    var3_3 = "7\u001fR3c-Qn\t0\u0015A9.oLrS";
                    var5_4 = "7\u001fR3c-Qn\t0\u0015A9.oLrS".length();
                    var2_5 = 8;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        continue;
                        break;
                    }
lbl10:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = new String(v0).intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block13;
                        break;
                    }
                    v1 = ++var1_6;
                    v2 = var3_3.substring(v1, v1 + var2_5).toCharArray();
                    v3 = v2.length;
                    var6_7 = 0;
                    v4 = 77;
                    v5 = v2;
                    v6 = v3;
                    if (v3 > 1) ** GOTO lbl68
                    do {
                        v7 = v4;
                        v5 = v5;
                        v8 = v5;
                        v9 = v4;
                        v10 = var6_7;
                        while (true) {
                            switch (var6_7 % 7) {
                                case 0: {
                                    v11 = 17;
                                    break;
                                }
                                case 1: {
                                    v11 = 55;
                                    break;
                                }
                                case 2: {
                                    v11 = 109;
                                    break;
                                }
                                case 3: {
                                    v11 = 16;
                                    break;
                                }
                                case 4: {
                                    v11 = 75;
                                    break;
                                }
                                case 5: {
                                    v11 = 12;
                                    break;
                                }
                                default: {
                                    v11 = 47;
                                }
                            }
                            v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                            ++var6_7;
                            v4 = v7;
                            if (v7 != 0) break;
                            v7 = v4;
                            v5 = v5;
                            v10 = v4;
                            v8 = v5;
                            v9 = v4;
                        }
lbl68:
                        // 2 sources

                        v0 = v5;
                        v6 = v6;
                    } while (v6 > var6_7);
                    ** while (true)
                }
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.$$INSTANCE = new Companion();
                v12 = Native.load((String)var0_1[0], Kernel32Ex.class, (Map)W32APIOptions.DEFAULT_OPTIONS);
                Intrinsics.checkNotNullExpressionValue((Object)v12, (String)var0_1[1]);
                com.jetbrains.rdserver.sshAgentProxy.WindowsNamedPipeAgentIpc$Kernel32Ex$Companion.INSTANCE = (Kernel32Ex)v12;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$NamedPipeState;", "", "WindowsNamedPipeAgentIpc$NamedPipeState", "(Ljava/lang/String;I)V", "Initial", "Open", "Connecting", "Connected", "Disconnecting", "Closing", "Closed", "intellij.platform.backend.split"})
    public static final class NamedPipeState
    extends Enum<NamedPipeState> {
        public static final /* enum */ NamedPipeState Initial;
        public static final /* enum */ NamedPipeState Open;
        public static final /* enum */ NamedPipeState Connecting;
        public static final /* enum */ NamedPipeState Connected;
        public static final /* enum */ NamedPipeState Disconnecting;
        public static final /* enum */ NamedPipeState Closing;
        public static final /* enum */ NamedPipeState Closed;
        private static final /* synthetic */ NamedPipeState[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static NamedPipeState[] values() {
            return (NamedPipeState[])$VALUES.clone();
        }

        public static NamedPipeState valueOf(String value) {
            return Enum.valueOf(NamedPipeState.class, value);
        }

        @NotNull
        public static EnumEntries<NamedPipeState> getEntries() {
            return $ENTRIES;
        }

        private static final /* synthetic */ NamedPipeState[] $values() {
            NamedPipeState[] namedPipeStateArray = new NamedPipeState[]{Initial, Open, Connecting, Connected, Disconnecting, Closing, Closed};
            return namedPipeStateArray;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var7 = 81638676258337L;
                    var0_1 = new String[7];
                    var4_2 = 0;
                    var3_3 = "7JG]oI\\\u00041TKG\n=K@GcKD\u0017JI\t=K@GcKD\u001b@\r:M]JiF^\u001bGZ@hO";
                    var5_4 = "7JG]oI\\\u00041TKG\n=K@GcKD\u0017JI\t=K@GcKD\u001b@\r:M]JiF^\u001bGZ@hO".length();
                    var2_5 = 7;
                    var1_6 = -1;
lbl8:
                    // 2 sources

                    while (true) {
                        v0 = 77;
                        v1 = ++var1_6;
                        v2 = var3_3.substring(v1, v1 + var2_5);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl14:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        var3_3 = "\u0007r{`U|m\u0006\u0007r{`Yv";
                        var5_4 = "\u0007r{`U|m\u0006\u0007r{`Yv".length();
                        var2_5 = 7;
                        var1_6 = -1;
lbl23:
                        // 2 sources

                        while (true) {
                            v0 = 119;
                            v5 = ++var1_6;
                            v2 = var3_3.substring(v5, v5 + var2_5);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl29:
                    // 1 sources

                    while (true) {
                        var0_1[var4_2++] = v4.intern();
                        if ((var1_6 += var2_5) < var5_4) {
                            var2_5 = var3_3.charAt(var1_6);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_7 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl86
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_7;
                    while (true) {
                        switch (var6_7 % 7) {
                            case 0: {
                                v15 = 51;
                                break;
                            }
                            case 1: {
                                v15 = 105;
                                break;
                            }
                            case 2: {
                                v15 = 99;
                                break;
                            }
                            case 3: {
                                v15 = 100;
                                break;
                            }
                            case 4: {
                                v15 = 75;
                                break;
                            }
                            case 5: {
                                v15 = 101;
                                break;
                            }
                            default: {
                                v15 = 125;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_7;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl86:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_7);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl96:
                    // 1 sources

                    ** continue;
                }
            }
            NamedPipeState.Initial = new NamedPipeState();
            NamedPipeState.Open = new NamedPipeState();
            NamedPipeState.Connecting = new NamedPipeState();
            NamedPipeState.Connected = new NamedPipeState();
            NamedPipeState.Disconnecting = new NamedPipeState();
            NamedPipeState.Closing = new NamedPipeState();
            NamedPipeState.Closed = new NamedPipeState();
            NamedPipeState.$VALUES = NamedPipeState.$values();
            NamedPipeState.$ENTRIES = EnumEntriesKt.enumEntries((Enum[])NamedPipeState.$VALUES);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel;", "Ljava/nio/channels/ReadableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeReadableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "read", "", "dst", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nWindowsNamedPipeAgentIpc.kt\nKotlin\n*S Kotlin\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,391:1\n24#2:392\n24#2:393\n*S KotlinDebug\n*F\n+ 1 WindowsNamedPipeAgentIpc.kt\ncom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeReadableByteChannel\n*L\n315#1:392\n320#1:393\n*E\n"})
    private static final class PipeReadableByteChannel
    implements ReadableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeReadableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 106029941873539L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeReadableByteChannel.a(84278010 - (char)-1591, -84278010 - -((char)-12117), (int)l2));
            this.agent = agent;
        }

        /*
         * Exception decompiling
         */
        @Override
        public int read(@NotNull ByteBuffer dst) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK]], but top level block is 5[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 61167011308537L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeReadableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block20: {
                block19: {
                    var5 = new String[9];
                    var3_1 = 0;
                    var2_2 = "\u0084P\u0004\u008c\u00e4\u0003\u0018\u00a8#\u0005\u00bb\u0017\u00c5\u00a0?\r\u00ce\u00e6]\u00d4\u00d9\u00f2\u00c4\u0083jf\u000b\u007f\u008e\u0010\u00e2\u0096\u001f1\u00ae\u00db\u0001\u009b\u001b\u00e1\u00c6\u00c2\u00d1Xcf\u0005\u0012e\u00f0\u00ee\u009939&\u0084\u00f1\b\u0087\u00e5\u0004\u00fa\u00efq*\u00e1\u0014I\u00f0\u00c3\u00e2\u00fc\u000f\u00b8\u00e9\u009b\u0002\u00f2\u00c9\u00d4\u00a1Q\u00f6\u00ff\u00f1\u00b9\u0095\u0098d\u0011\u00b3\u00c6\u00ed\u0094`B<\u00b1^\u00bfJk\u0088f";
                    var4_3 = "\u0084P\u0004\u008c\u00e4\u0003\u0018\u00a8#\u0005\u00bb\u0017\u00c5\u00a0?\r\u00ce\u00e6]\u00d4\u00d9\u00f2\u00c4\u0083jf\u000b\u007f\u008e\u0010\u00e2\u0096\u001f1\u00ae\u00db\u0001\u009b\u001b\u00e1\u00c6\u00c2\u00d1Xcf\u0005\u0012e\u00f0\u00ee\u009939&\u0084\u00f1\b\u0087\u00e5\u0004\u00fa\u00efq*\u00e1\u0014I\u00f0\u00c3\u00e2\u00fc\u000f\u00b8\u00e9\u009b\u0002\u00f2\u00c9\u00d4\u00a1Q\u00f6\u00ff\u00f1\u00b9\u0095\u0098d\u0011\u00b3\u00c6\u00ed\u0094`B<\u00b1^\u00bfJk\u0088f".length();
                    var1_4 = 5;
                    var0_5 = -1;
lbl7:
                    // 2 sources

                    while (true) {
                        v0 = 95;
                        v1 = ++var0_5;
                        v2 = var2_2.substring(v1, v1 + var1_4);
                        v3 = -1;
                        break block19;
                        break;
                    }
lbl13:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        var2_2 = "\u00ad\u00f7q\u009a\u00e4)\u00cfBE]\u008a\u00d2\u00df\u00dd%QL\u00ebXN\u00a5)\u0006\u0018\u00c96\u00bfH7\u0089\u00ef|n\u00e7g\u0000\u00ce\u00c828\\\"nl\u0014;\u008e\u00da\u0016\u008a\u0000\bM\u00b6\u00cf\u008f\u0083\f\u00d7\u00190H\u0086\u00cc\u00eep\u00afjQ\u00ec\u00d2\u00b6|\u0013\u00eb\u00c6\u00dc<\u00a2l\u00d0\u00f8\u0085\u0098\u000e\u00f93$%\u00031\u0091\u0093";
                        var4_3 = "\u00ad\u00f7q\u009a\u00e4)\u00cfBE]\u008a\u00d2\u00df\u00dd%QL\u00ebXN\u00a5)\u0006\u0018\u00c96\u00bfH7\u0089\u00ef|n\u00e7g\u0000\u00ce\u00c828\\\"nl\u0014;\u008e\u00da\u0016\u008a\u0000\bM\u00b6\u00cf\u008f\u0083\f\u00d7\u00190H\u0086\u00cc\u00eep\u00afjQ\u00ec\u00d2\u00b6|\u0013\u00eb\u00c6\u00dc<\u00a2l\u00d0\u00f8\u0085\u0098\u000e\u00f93$%\u00031\u0091\u0093".length();
                        var1_4 = 16;
                        var0_5 = -1;
lbl22:
                        // 2 sources

                        while (true) {
                            v0 = 17;
                            v5 = ++var0_5;
                            v2 = var2_2.substring(v5, v5 + var1_4);
                            v3 = 0;
                            break block19;
                            break;
                        }
                        break;
                    }
lbl28:
                    // 1 sources

                    while (true) {
                        var5[var3_1++] = v4.intern();
                        if ((var0_5 += var1_4) < var4_3) {
                            var1_4 = var2_2.charAt(var0_5);
                            ** continue;
                        }
                        break block20;
                        break;
                    }
                }
                v6 = v2.toCharArray();
                v7 = v6.length;
                var6_6 = 0;
                v8 = v0;
                v9 = v6;
                v10 = v7;
                if (v7 > 1) ** GOTO lbl85
                do {
                    v11 = v8;
                    v9 = v9;
                    v12 = v9;
                    v13 = v8;
                    v14 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v15 = 2;
                                break;
                            }
                            case 1: {
                                v15 = 124;
                                break;
                            }
                            case 2: {
                                v15 = 72;
                                break;
                            }
                            case 3: {
                                v15 = 88;
                                break;
                            }
                            case 4: {
                                v15 = 100;
                                break;
                            }
                            case 5: {
                                v15 = 81;
                                break;
                            }
                            default: {
                                v15 = 59;
                            }
                        }
                        v12[v14] = (char)(v12[v14] ^ (v13 ^ v15));
                        ++var6_6;
                        v8 = v11;
                        if (v11 != 0) break;
                        v11 = v8;
                        v9 = v9;
                        v14 = v8;
                        v12 = v9;
                        v13 = v8;
                    }
lbl85:
                    // 2 sources

                    v16 = v9;
                    v10 = v10;
                } while (v10 > var6_6);
                v4 = new String(v16);
                switch (v3) {
                    default: {
                        ** continue;
                    }
                    ** case 0:
lbl95:
                    // 1 sources

                    ** continue;
                }
            }
            PipeReadableByteChannel.a = var5;
            PipeReadableByteChannel.b = new String[9];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x5AB2) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 40;
                    case 1 -> 0;
                    case 2 -> 31;
                    case 3 -> 23;
                    case 4 -> 159;
                    case 5 -> 69;
                    case 6 -> 234;
                    case 7 -> 60;
                    case 8 -> 18;
                    case 9 -> 68;
                    case 10 -> 99;
                    case 11 -> 108;
                    case 12 -> 143;
                    case 13 -> 74;
                    case 14 -> 14;
                    case 15 -> 173;
                    case 16 -> 115;
                    case 17 -> 88;
                    case 18 -> 62;
                    case 19 -> 83;
                    case 20 -> 191;
                    case 21 -> 150;
                    case 22 -> 12;
                    case 23 -> 239;
                    case 24 -> 79;
                    case 25 -> 13;
                    case 26 -> 27;
                    case 27 -> 42;
                    case 28 -> 208;
                    case 29 -> 55;
                    case 30 -> 2;
                    case 31 -> 121;
                    case 32 -> 19;
                    case 33 -> 48;
                    case 34 -> 219;
                    case 35 -> 114;
                    case 36 -> 111;
                    case 37 -> 65;
                    case 38 -> 252;
                    case 39 -> 35;
                    case 40 -> 34;
                    case 41 -> 182;
                    case 42 -> 224;
                    case 43 -> 151;
                    case 44 -> 177;
                    case 45 -> 212;
                    case 46 -> 94;
                    case 47 -> 29;
                    case 48 -> 197;
                    case 49 -> 63;
                    case 50 -> 183;
                    case 51 -> 199;
                    case 52 -> 112;
                    case 53 -> 100;
                    case 54 -> 127;
                    case 55 -> 3;
                    case 56 -> 171;
                    case 57 -> 50;
                    case 58 -> 147;
                    case 59 -> 218;
                    case 60 -> 95;
                    case 61 -> 250;
                    case 62 -> 209;
                    case 63 -> 54;
                    case 64 -> 255;
                    case 65 -> 85;
                    case 66 -> 32;
                    case 67 -> 102;
                    case 68 -> 28;
                    case 69 -> 57;
                    case 70 -> 156;
                    case 71 -> 167;
                    case 72 -> 17;
                    case 73 -> 97;
                    case 74 -> 237;
                    case 75 -> 238;
                    case 76 -> 44;
                    case 77 -> 131;
                    case 78 -> 172;
                    case 79 -> 51;
                    case 80 -> 166;
                    case 81 -> 178;
                    case 82 -> 129;
                    case 83 -> 118;
                    case 84 -> 145;
                    case 85 -> 227;
                    case 86 -> 160;
                    case 87 -> 220;
                    case 88 -> 24;
                    case 89 -> 233;
                    case 90 -> 8;
                    case 91 -> 37;
                    case 92 -> 221;
                    case 93 -> 247;
                    case 94 -> 92;
                    case 95 -> 251;
                    case 96 -> 21;
                    case 97 -> 248;
                    case 98 -> 155;
                    case 99 -> 75;
                    case 100 -> 169;
                    case 101 -> 246;
                    case 102 -> 58;
                    case 103 -> 204;
                    case 104 -> 25;
                    case 105 -> 216;
                    case 106 -> 78;
                    case 107 -> 149;
                    case 108 -> 76;
                    case 109 -> 202;
                    case 110 -> 124;
                    case 111 -> 186;
                    case 112 -> 1;
                    case 113 -> 146;
                    case 114 -> 119;
                    case 115 -> 225;
                    case 116 -> 165;
                    case 117 -> 120;
                    case 118 -> 253;
                    case 119 -> 98;
                    case 120 -> 104;
                    case 121 -> 123;
                    case 122 -> 72;
                    case 123 -> 126;
                    case 124 -> 6;
                    case 125 -> 130;
                    case 126 -> 249;
                    case 127 -> 138;
                    case 128 -> 181;
                    case 129 -> 137;
                    case 130 -> 140;
                    case 131 -> 232;
                    case 132 -> 30;
                    case 133 -> 236;
                    case 134 -> 223;
                    case 135 -> 134;
                    case 136 -> 80;
                    case 137 -> 188;
                    case 138 -> 243;
                    case 139 -> 180;
                    case 140 -> 38;
                    case 141 -> 198;
                    case 142 -> 5;
                    case 143 -> 93;
                    case 144 -> 53;
                    case 145 -> 161;
                    case 146 -> 56;
                    case 147 -> 73;
                    case 148 -> 226;
                    case 149 -> 106;
                    case 150 -> 196;
                    case 151 -> 16;
                    case 152 -> 116;
                    case 153 -> 244;
                    case 154 -> 217;
                    case 155 -> 190;
                    case 156 -> 187;
                    case 157 -> 39;
                    case 158 -> 254;
                    case 159 -> 193;
                    case 160 -> 142;
                    case 161 -> 206;
                    case 162 -> 11;
                    case 163 -> 70;
                    case 164 -> 213;
                    case 165 -> 59;
                    case 166 -> 179;
                    case 167 -> 245;
                    case 168 -> 241;
                    case 169 -> 152;
                    case 170 -> 184;
                    case 171 -> 71;
                    case 172 -> 43;
                    case 173 -> 128;
                    case 174 -> 195;
                    case 175 -> 89;
                    case 176 -> 207;
                    case 177 -> 205;
                    case 178 -> 84;
                    case 179 -> 36;
                    case 180 -> 81;
                    case 181 -> 101;
                    case 182 -> 64;
                    case 183 -> 230;
                    case 184 -> 10;
                    case 185 -> 175;
                    case 186 -> 176;
                    case 187 -> 26;
                    case 188 -> 22;
                    case 189 -> 20;
                    case 190 -> 222;
                    case 191 -> 96;
                    case 192 -> 192;
                    case 193 -> 105;
                    case 194 -> 154;
                    case 195 -> 148;
                    case 196 -> 158;
                    case 197 -> 91;
                    case 198 -> 86;
                    case 199 -> 33;
                    case 200 -> 163;
                    case 201 -> 231;
                    case 202 -> 228;
                    case 203 -> 139;
                    case 204 -> 87;
                    case 205 -> 185;
                    case 206 -> 174;
                    case 207 -> 4;
                    case 208 -> 47;
                    case 209 -> 77;
                    case 210 -> 15;
                    case 211 -> 132;
                    case 212 -> 66;
                    case 213 -> 67;
                    case 214 -> 103;
                    case 215 -> 170;
                    case 216 -> 41;
                    case 217 -> 122;
                    case 218 -> 133;
                    case 219 -> 82;
                    case 220 -> 157;
                    case 221 -> 135;
                    case 222 -> 210;
                    case 223 -> 107;
                    case 224 -> 194;
                    case 225 -> 7;
                    case 226 -> 215;
                    case 227 -> 201;
                    case 228 -> 189;
                    case 229 -> 49;
                    case 230 -> 164;
                    case 231 -> 242;
                    case 232 -> 162;
                    case 233 -> 117;
                    case 234 -> 141;
                    case 235 -> 200;
                    case 236 -> 144;
                    case 237 -> 214;
                    case 238 -> 240;
                    case 239 -> 235;
                    case 240 -> 136;
                    case 241 -> 168;
                    case 242 -> 109;
                    case 243 -> 113;
                    case 244 -> 153;
                    case 245 -> 61;
                    case 246 -> 9;
                    case 247 -> 110;
                    case 248 -> 90;
                    case 249 -> 52;
                    case 250 -> 211;
                    case 251 -> 45;
                    case 252 -> 203;
                    case 253 -> 125;
                    case 254 -> 229;
                    default -> 46;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeReadableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc$PipeWritableByteChannel;", "Ljava/nio/channels/WritableByteChannel;", "agent", "Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;", "WindowsNamedPipeAgentIpc$PipeWritableByteChannel", "(Lcom/jetbrains/rdserver/sshAgentProxy/WindowsNamedPipeAgentIpc;)V", "write", "", "src", "Ljava/nio/ByteBuffer;", "isOpen", "", "close", "", "intellij.platform.backend.split"})
    private static final class PipeWritableByteChannel
    implements WritableByteChannel {
        @NotNull
        private final WindowsNamedPipeAgentIpc agent;
        private static final String[] a;
        private static final String[] b;

        public PipeWritableByteChannel(@NotNull WindowsNamedPipeAgentIpc agent) {
            long l2 = 87880810843852L;
            Intrinsics.checkNotNullParameter((Object)agent, (String)PipeWritableByteChannel.a(1485023100 - (char)-24906, -1485023100 - -((char)-30140), (int)l2));
            this.agent = agent;
        }

        @Override
        public int write(@NotNull ByteBuffer src) {
            int n;
            block7: {
                IntByReference intByReference;
                block8: {
                    long l2 = 3681209494435L;
                    boolean bl = SshAgentIpcService.V();
                    Intrinsics.checkNotNullParameter((Object)src, (String)PipeWritableByteChannel.a(422569680 - 31016, 422569680 - (char)-29057, (int)l2));
                    boolean bl2 = bl;
                    try {
                        if (!this.agent.isOpen()) {
                            throw new ClosedChannelException();
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                    intByReference = new IntByReference();
                    byte[] byArray = new byte[src.remaining()];
                    try {
                        try {
                            src.get(byArray);
                            n = Kernel32.INSTANCE.WriteFile(this.agent.hPipe, byArray, byArray.length, intByReference, null);
                            if (bl2) break block7;
                            if (n != 0) break block8;
                        }
                        catch (RuntimeException runtimeException) {
                            throw PipeWritableByteChannel.a(runtimeException);
                        }
                        return -1;
                    }
                    catch (RuntimeException runtimeException) {
                        throw PipeWritableByteChannel.a(runtimeException);
                    }
                }
                n = intByReference.getValue();
            }
            return n;
        }

        @Override
        public boolean isOpen() {
            boolean bl;
            long l2 = 113727472947600L;
            try {
                bl = this.agent.state == NamedPipeState.Connected;
            }
            catch (RuntimeException runtimeException) {
                throw PipeWritableByteChannel.a(runtimeException);
            }
            return bl;
        }

        @Override
        public void close() {
            this.agent.disconnect();
        }

        private static RuntimeException a(RuntimeException runtimeException) {
            return runtimeException;
        }

        /*
         * Unable to fully structure code
         */
        static {
            block13: {
                var5 = new String[2];
                var3_1 = 0;
                var2_2 = "\u0001\u00f1\u00c9\u0090\u001f\u0003\u00d5\u000b\u0005";
                var4_3 = "\u0001\u00f1\u00c9\u0090\u001f\u0003\u00d5\u000b\u0005".length();
                var1_4 = 5;
                var0_5 = -1;
lbl7:
                // 2 sources

                while (true) {
                    continue;
                    break;
                }
lbl9:
                // 1 sources

                while (true) {
                    var5[var3_1++] = new String(v0).intern();
                    if ((var0_5 += var1_4) < var4_3) {
                        var1_4 = var2_2.charAt(var0_5);
                        ** continue;
                    }
                    break block13;
                    break;
                }
                v1 = ++var0_5;
                v2 = var2_2.substring(v1, v1 + var1_4).toCharArray();
                v3 = v2.length;
                var6_6 = 0;
                v4 = 51;
                v5 = v2;
                v6 = v3;
                if (v3 > 1) ** GOTO lbl67
                do {
                    v7 = v4;
                    v5 = v5;
                    v8 = v5;
                    v9 = v4;
                    v10 = var6_6;
                    while (true) {
                        switch (var6_6 % 7) {
                            case 0: {
                                v11 = 7;
                                break;
                            }
                            case 1: {
                                v11 = 89;
                                break;
                            }
                            case 2: {
                                v11 = 116;
                                break;
                            }
                            case 3: {
                                v11 = 53;
                                break;
                            }
                            case 4: {
                                v11 = 64;
                                break;
                            }
                            case 5: {
                                v11 = 67;
                                break;
                            }
                            default: {
                                v11 = 96;
                            }
                        }
                        v8[v10] = (char)(v8[v10] ^ (v9 ^ v11));
                        ++var6_6;
                        v4 = v7;
                        if (v7 != 0) break;
                        v7 = v4;
                        v5 = v5;
                        v10 = v4;
                        v8 = v5;
                        v9 = v4;
                    }
lbl67:
                    // 2 sources

                    v0 = v5;
                    v6 = v6;
                } while (v6 > var6_6);
                ** while (true)
            }
            PipeWritableByteChannel.a = var5;
            PipeWritableByteChannel.b = new String[2];
        }

        private static String a(int n, int n2, int n3) {
            int n4 = (n ^ n3 ^ 0x460A) & 0xFFFF;
            if (b[n4] == null) {
                int n5;
                char[] cArray = a[n4].toCharArray();
                int n6 = switch (cArray[0] & 0xFF) {
                    case 0 -> 219;
                    case 1 -> 75;
                    case 2 -> 241;
                    case 3 -> 235;
                    case 4 -> 210;
                    case 5 -> 168;
                    case 6 -> 124;
                    case 7 -> 190;
                    case 8 -> 115;
                    case 9 -> 3;
                    case 10 -> 31;
                    case 11 -> 120;
                    case 12 -> 66;
                    case 13 -> 21;
                    case 14 -> 149;
                    case 15 -> 18;
                    case 16 -> 137;
                    case 17 -> 147;
                    case 18 -> 29;
                    case 19 -> 67;
                    case 20 -> 59;
                    case 21 -> 99;
                    case 22 -> 7;
                    case 23 -> 254;
                    case 24 -> 106;
                    case 25 -> 87;
                    case 26 -> 244;
                    case 27 -> 24;
                    case 28 -> 159;
                    case 29 -> 230;
                    case 30 -> 30;
                    case 31 -> 129;
                    case 32 -> 162;
                    case 33 -> 41;
                    case 34 -> 239;
                    case 35 -> 138;
                    case 36 -> 51;
                    case 37 -> 141;
                    case 38 -> 199;
                    case 39 -> 110;
                    case 40 -> 42;
                    case 41 -> 0;
                    case 42 -> 193;
                    case 43 -> 9;
                    case 44 -> 47;
                    case 45 -> 247;
                    case 46 -> 140;
                    case 47 -> 98;
                    case 48 -> 156;
                    case 49 -> 101;
                    case 50 -> 65;
                    case 51 -> 217;
                    case 52 -> 251;
                    case 53 -> 176;
                    case 54 -> 62;
                    case 55 -> 117;
                    case 56 -> 5;
                    case 57 -> 77;
                    case 58 -> 131;
                    case 59 -> 68;
                    case 60 -> 50;
                    case 61 -> 221;
                    case 62 -> 252;
                    case 63 -> 72;
                    case 64 -> 37;
                    case 65 -> 203;
                    case 66 -> 214;
                    case 67 -> 23;
                    case 68 -> 179;
                    case 69 -> 128;
                    case 70 -> 80;
                    case 71 -> 185;
                    case 72 -> 118;
                    case 73 -> 238;
                    case 74 -> 146;
                    case 75 -> 82;
                    case 76 -> 192;
                    case 77 -> 49;
                    case 78 -> 79;
                    case 79 -> 39;
                    case 80 -> 161;
                    case 81 -> 32;
                    case 82 -> 246;
                    case 83 -> 226;
                    case 84 -> 22;
                    case 85 -> 81;
                    case 86 -> 186;
                    case 87 -> 127;
                    case 88 -> 94;
                    case 89 -> 12;
                    case 90 -> 178;
                    case 91 -> 57;
                    case 92 -> 83;
                    case 93 -> 8;
                    case 94 -> 172;
                    case 95 -> 243;
                    case 96 -> 255;
                    case 97 -> 17;
                    case 98 -> 233;
                    case 99 -> 134;
                    case 100 -> 231;
                    case 101 -> 224;
                    case 102 -> 189;
                    case 103 -> 158;
                    case 104 -> 44;
                    case 105 -> 25;
                    case 106 -> 207;
                    case 107 -> 249;
                    case 108 -> 36;
                    case 109 -> 73;
                    case 110 -> 97;
                    case 111 -> 64;
                    case 112 -> 133;
                    case 113 -> 177;
                    case 114 -> 237;
                    case 115 -> 114;
                    case 116 -> 250;
                    case 117 -> 228;
                    case 118 -> 153;
                    case 119 -> 164;
                    case 120 -> 121;
                    case 121 -> 240;
                    case 122 -> 84;
                    case 123 -> 76;
                    case 124 -> 150;
                    case 125 -> 139;
                    case 126 -> 225;
                    case 127 -> 191;
                    case 128 -> 222;
                    case 129 -> 170;
                    case 130 -> 11;
                    case 131 -> 136;
                    case 132 -> 154;
                    case 133 -> 28;
                    case 134 -> 232;
                    case 135 -> 71;
                    case 136 -> 229;
                    case 137 -> 34;
                    case 138 -> 132;
                    case 139 -> 89;
                    case 140 -> 160;
                    case 141 -> 180;
                    case 142 -> 74;
                    case 143 -> 157;
                    case 144 -> 163;
                    case 145 -> 198;
                    case 146 -> 43;
                    case 147 -> 151;
                    case 148 -> 171;
                    case 149 -> 204;
                    case 150 -> 206;
                    case 151 -> 197;
                    case 152 -> 90;
                    case 153 -> 142;
                    case 154 -> 135;
                    case 155 -> 148;
                    case 156 -> 63;
                    case 157 -> 14;
                    case 158 -> 248;
                    case 159 -> 15;
                    case 160 -> 152;
                    case 161 -> 125;
                    case 162 -> 216;
                    case 163 -> 20;
                    case 164 -> 46;
                    case 165 -> 112;
                    case 166 -> 88;
                    case 167 -> 56;
                    case 168 -> 10;
                    case 169 -> 173;
                    case 170 -> 195;
                    case 171 -> 209;
                    case 172 -> 48;
                    case 173 -> 27;
                    case 174 -> 100;
                    case 175 -> 45;
                    case 176 -> 95;
                    case 177 -> 103;
                    case 178 -> 122;
                    case 179 -> 16;
                    case 180 -> 208;
                    case 181 -> 196;
                    case 182 -> 253;
                    case 183 -> 26;
                    case 184 -> 107;
                    case 185 -> 4;
                    case 186 -> 54;
                    case 187 -> 215;
                    case 188 -> 166;
                    case 189 -> 92;
                    case 190 -> 55;
                    case 191 -> 245;
                    case 192 -> 234;
                    case 193 -> 19;
                    case 194 -> 183;
                    case 195 -> 212;
                    case 196 -> 181;
                    case 197 -> 102;
                    case 198 -> 144;
                    case 199 -> 194;
                    case 200 -> 205;
                    case 201 -> 236;
                    case 202 -> 61;
                    case 203 -> 175;
                    case 204 -> 202;
                    case 205 -> 218;
                    case 206 -> 86;
                    case 207 -> 105;
                    case 208 -> 130;
                    case 209 -> 143;
                    case 210 -> 111;
                    case 211 -> 165;
                    case 212 -> 200;
                    case 213 -> 155;
                    case 214 -> 58;
                    case 215 -> 70;
                    case 216 -> 2;
                    case 217 -> 38;
                    case 218 -> 227;
                    case 219 -> 169;
                    case 220 -> 93;
                    case 221 -> 242;
                    case 222 -> 116;
                    case 223 -> 1;
                    case 224 -> 53;
                    case 225 -> 96;
                    case 226 -> 33;
                    case 227 -> 40;
                    case 228 -> 223;
                    case 229 -> 145;
                    case 230 -> 52;
                    case 231 -> 35;
                    case 232 -> 109;
                    case 233 -> 78;
                    case 234 -> 123;
                    case 235 -> 104;
                    case 236 -> 60;
                    case 237 -> 201;
                    case 238 -> 220;
                    case 239 -> 126;
                    case 240 -> 184;
                    case 241 -> 187;
                    case 242 -> 174;
                    case 243 -> 188;
                    case 244 -> 213;
                    case 245 -> 6;
                    case 246 -> 211;
                    case 247 -> 182;
                    case 248 -> 85;
                    case 249 -> 91;
                    case 250 -> 119;
                    case 251 -> 69;
                    case 252 -> 167;
                    case 253 -> 113;
                    case 254 -> 13;
                    default -> 108;
                };
                int n7 = ((n2 ^= n3) & 0xFF) - n6;
                if (n7 < 0) {
                    n7 += 256;
                }
                if ((n5 = ((n2 & 0xFFFF) >>> 8) - n6) < 0) {
                    n5 += 256;
                }
                int n8 = 0;
                while (n8 < cArray.length) {
                    int n9 = n8 % 2;
                    int n10 = n8;
                    char[] cArray2 = cArray;
                    char c2 = cArray[n10];
                    if (n9 == 0) {
                        cArray2[n10] = (char)(c2 ^ n7);
                        n7 = ((n7 >>> 3 | n7 << 5) ^ cArray[n8]) & 0xFF;
                    } else {
                        cArray2[n10] = (char)(c2 ^ n5);
                        n5 = ((n5 >>> 3 | n5 << 5) ^ cArray[n8]) & 0xFF;
                    }
                    ++n8;
                }
                PipeWritableByteChannel.b[n4] = new String(cArray).intern();
            }
            return b[n4];
        }
    }
}

