/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.highlighting;

import com.intellij.cdi.constants.CdiAnnoConstants;
import com.intellij.cdi.highlighting.CdiBaseInspection;
import com.intellij.cdi.manager.CdiDescriptorsFactory;
import com.intellij.cdi.resources.CdiInspectionBundle;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiManagedBeanValidationUtils;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiModifierListOwner;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CdiManagedBeanInconsistencyInspection
extends CdiBaseInspection {
    @Override
    protected void checkClass(@NotNull PsiClass aClass, @NotNull ProblemsHolder holder, @NotNull Module module) {
        if (aClass == null) {
            CdiManagedBeanInconsistencyInspection.$$$reportNull$$$0(0);
        }
        if (holder == null) {
            CdiManagedBeanInconsistencyInspection.$$$reportNull$$$0(1);
        }
        if (module == null) {
            CdiManagedBeanInconsistencyInspection.$$$reportNull$$$0(2);
        }
        if (aClass.isAnnotationType() || CdiCommonUtils.isManagedBean(aClass)) {
            return;
        }
        List<String> allAnnotations = CdiCommonUtils.collectCdiBeansAnnotations(module);
        if (CdiCommonUtils.isClassContainsCdiAnnotations(aClass, allAnnotations)) {
            String unallowedAncestor;
            if (CdiManagedBeanValidationUtils.isConcreteClass(aClass) && !CdiManagedBeanValidationUtils.hasAppropriateConstructor(aClass)) {
                CdiManagedBeanInconsistencyInspection.registerProblem(holder, CdiManagedBeanInconsistencyInspection.getIdentifyingElement((PsiModifierListOwner)aClass), CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.no.appropriate.constructor", new Object[0]));
            }
            if (!aClass.hasModifierProperty("abstract") && CdiManagedBeanValidationUtils.isParameterizedType(aClass) && !CdiManagedBeanInconsistencyInspection.isDependentScoped(aClass, module)) {
                CdiManagedBeanInconsistencyInspection.registerProblem(holder, CdiManagedBeanInconsistencyInspection.getIdentifyingElement((PsiModifierListOwner)aClass), CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.parameterized.class", new Object[0]));
            }
            if (CdiManagedBeanValidationUtils.isNonStaticInner(aClass)) {
                CdiManagedBeanInconsistencyInspection.registerProblem(holder, CdiManagedBeanInconsistencyInspection.getIdentifyingElement((PsiModifierListOwner)aClass), CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.static.inner.class", new Object[0]));
            }
            if ((unallowedAncestor = CdiManagedBeanValidationUtils.getDisallowedAncestor(aClass)) != null) {
                CdiManagedBeanInconsistencyInspection.registerProblem(holder, CdiManagedBeanInconsistencyInspection.getIdentifyingElement((PsiModifierListOwner)aClass), CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.unallowed.ancestor", unallowedAncestor));
            }
        }
        if (AnnotationUtil.isAnnotated((PsiModifierListOwner)aClass, allAnnotations, (int)0) && !CdiManagedBeanValidationUtils.isConcreteClass(aClass) && !CdiManagedBeanValidationUtils.isDecoratorClass(aClass) && !CdiManagedBeanValidationUtils.isAnnotatedAsCustomBean(aClass)) {
            CdiManagedBeanInconsistencyInspection.registerProblem(holder, CdiManagedBeanInconsistencyInspection.getIdentifyingElement((PsiModifierListOwner)aClass), CdiInspectionBundle.message("CdiManagedBeanInconsistencyInspection.not.concrete.class", new Object[0]));
        }
    }

    private static boolean isDependentScoped(@NotNull PsiClass aClass, @NotNull Module module) {
        PsiClass type;
        if (aClass == null) {
            CdiManagedBeanInconsistencyInspection.$$$reportNull$$$0(3);
        }
        if (module == null) {
            CdiManagedBeanInconsistencyInspection.$$$reportNull$$$0(4);
        }
        return (type = CdiDescriptorsFactory.createCdiBeanDescriptor(aClass).getScopeType()) != null && CdiAnnoConstants.DEPENDENT_ANNOTATION.fqn(module).equals(type.getQualifiedName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "holder";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        objectArray2[1] = "com/intellij/cdi/highlighting/CdiManagedBeanInconsistencyInspection";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "checkClass";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "isDependentScoped";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

