/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.config;

import com.intellij.jpa.jpb.model.core.pg.PgKeepClassMembers;
import com.intellij.liquibase.common.LiquibaseChangeIdentifierManager;
import com.intellij.liquibase.common.config.LiquibaseChange;
import com.intellij.liquibase.common.config.LiquibaseChangeIdentifier;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.xmlb.XmlSerializer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="JpaLiquibaseChangesConfig", storages={@Storage(value="jpb-settings.xml"), @Storage(value="../.jpb/jpb-settings.xml", deprecated=true)})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0007\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0002H\u0016J\u0010\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0002H\u0016J\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u0010\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0017\u001a\u00020\u0018J\u0018\u0010\u001a\u001a\u00020\u00162\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\bJ\u0010\u0010\u001e\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\bJ\u000e\u0010\u001f\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001cJ\u000e\u0010!\u001a\u00020\u00132\u0006\u0010 \u001a\u00020\u001cR \u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR \u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\f\u00a8\u0006#"}, d2={"Lcom/intellij/liquibase/common/config/LiquibaseChangesConfig;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lorg/jdom/Element;", "Lcom/intellij/jpa/jpb/model/core/pg/PgKeepClassMembers;", "<init>", "()V", "liquibaseChanges", "", "Lcom/intellij/liquibase/common/config/LiquibaseChange;", "getLiquibaseChanges", "()Ljava/util/List;", "setLiquibaseChanges", "(Ljava/util/List;)V", "excludeChanges", "Lcom/intellij/liquibase/common/config/LiquibaseChangeIdentifier;", "getExcludeChanges", "setExcludeChanges", "getState", "loadState", "", "state", "isChangeEnabled", "", "tagName", "", "findChangeByTagName", "isChangeIgnored", "changeTag", "Lcom/intellij/psi/xml/XmlTag;", "change", "isChangeHidden", "removeFromExcluded", "tag", "excludeChange", "Companion", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nLiquibaseChangesConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseChangesConfig.kt\ncom/intellij/liquibase/common/config/LiquibaseChangesConfig\n+ 2 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,254:1\n37#2:255\n36#2,3:256\n774#3:259\n865#3:260\n866#3:262\n1878#3,3:263\n1#4:261\n*S KotlinDebug\n*F\n+ 1 LiquibaseChangesConfig.kt\ncom/intellij/liquibase/common/config/LiquibaseChangesConfig\n*L\n75#1:255\n75#1:256,3\n80#1:259\n80#1:260\n80#1:262\n99#1:263,3\n*E\n"})
public final class LiquibaseChangesConfig
implements PersistentStateComponent<Element>,
PgKeepClassMembers {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private List<LiquibaseChange> liquibaseChanges;
    @NotNull
    private List<LiquibaseChangeIdentifier> excludeChanges;
    @NotNull
    public static final String LIQUIBASE_CHANGE_TAG_NAME = "liquibase-change";
    @NotNull
    public static final String EXCLUDE_CHANGE_TAG_NAME = "exclude-change";
    @NotNull
    public static final String INCLUDE_CHANGE_LOG_TAG_NAME = "include-changelog-file";
    @NotNull
    private static final List<LiquibaseChange> DEFAULT_LIQUIBASE_CHANGES;

    public LiquibaseChangesConfig() {
        Collection $this$toTypedArray$iv = DEFAULT_LIQUIBASE_CHANGES;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        LiquibaseChange[] liquibaseChangeArray = thisCollection$iv.toArray(new LiquibaseChange[0]);
        this.liquibaseChanges = CollectionsKt.mutableListOf((Object[])Arrays.copyOf(liquibaseChangeArray, liquibaseChangeArray.length));
        this.excludeChanges = new ArrayList();
    }

    @NotNull
    public final List<LiquibaseChange> getLiquibaseChanges() {
        return this.liquibaseChanges;
    }

    public final void setLiquibaseChanges(@NotNull List<LiquibaseChange> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.liquibaseChanges = list;
    }

    @NotNull
    public final List<LiquibaseChangeIdentifier> getExcludeChanges() {
        return this.excludeChanges;
    }

    public final void setExcludeChanges(@NotNull List<LiquibaseChangeIdentifier> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.excludeChanges = list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public Element getState() {
        void $this$filterTo$iv$iv;
        Element state = new Element("state");
        Iterable $this$filter$iv = this.liquibaseChanges;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            LiquibaseChange defaultChange;
            Object v0;
            LiquibaseChange liquibaseChange;
            block4: {
                liquibaseChange = (LiquibaseChange)element$iv$iv;
                boolean bl = false;
                Iterable iterable2 = DEFAULT_LIQUIBASE_CHANGES;
                for (Object t : iterable2) {
                    LiquibaseChange it = (LiquibaseChange)t;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)liquibaseChange.getName())) continue;
                    v0 = t;
                    break block4;
                }
                v0 = null;
            }
            if (!((defaultChange = (LiquibaseChange)v0) == null || !Intrinsics.areEqual((Object)defaultChange, (Object)liquibaseChange))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List toSaveChanges = (List)destination$iv$iv;
        for (LiquibaseChange toSaveChange : toSaveChanges) {
            state.addContent(XmlSerializer.serialize((Object)toSaveChange));
        }
        for (LiquibaseChangeIdentifier excludeChange : this.excludeChanges) {
            state.addContent(XmlSerializer.serialize((Object)excludeChange));
        }
        return state;
    }

    /*
     * WARNING - void declaration
     */
    public void loadState(@NotNull Element state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        List liquibaseChangeElements = state.getChildren(LIQUIBASE_CHANGE_TAG_NAME);
        for (Element changeElem : liquibaseChangeElements) {
            Object object = XmlSerializer.deserialize((Element)changeElem, LiquibaseChange.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deserialize(...)");
            LiquibaseChange deserializeChange = (LiquibaseChange)object;
            Iterable $this$forEachIndexed$iv = this.liquibaseChanges;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void liquibaseChange;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                LiquibaseChange liquibaseChange2 = (LiquibaseChange)item$iv;
                int index = n;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)liquibaseChange.getName(), (Object)deserializeChange.getName())) continue;
                this.liquibaseChanges.set(index, deserializeChange);
            }
        }
        this.excludeChanges.clear();
        for (Element excludeElem : state.getChildren(EXCLUDE_CHANGE_TAG_NAME)) {
            Object object = XmlSerializer.deserialize((Element)excludeElem, LiquibaseChangeIdentifier.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"deserialize(...)");
            this.excludeChanges.add((LiquibaseChangeIdentifier)object);
        }
    }

    public final boolean isChangeEnabled(@NotNull String tagName) {
        Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
        LiquibaseChange liquibaseChange = this.findChangeByTagName(tagName);
        return (liquibaseChange != null ? liquibaseChange.getLocation() : null) != LiquibaseChange.Location.IGNORE;
    }

    @Nullable
    public final LiquibaseChange findChangeByTagName(@NotNull String tagName) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            Iterable iterable = this.liquibaseChanges;
            for (Object t : iterable) {
                LiquibaseChange it = (LiquibaseChange)t;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getName(), (Object)tagName)) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    public final boolean isChangeIgnored(@NotNull XmlTag changeTag, @Nullable LiquibaseChange change) {
        Intrinsics.checkNotNullParameter((Object)changeTag, (String)"changeTag");
        LiquibaseChange liquibaseChange = change;
        if ((liquibaseChange != null ? liquibaseChange.getLocation() : null) == LiquibaseChange.Location.IGNORE) {
            return true;
        }
        Project project = changeTag.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        LiquibaseChangeIdentifierManager identifierManager = LiquibaseChangeIdentifierManager.Companion.getInstance(project);
        return CollectionsKt.contains((Iterable)this.excludeChanges, (Object)identifierManager.createIdentifier(changeTag));
    }

    public final boolean isChangeHidden(@Nullable LiquibaseChange change) {
        LiquibaseChange liquibaseChange = change;
        return (liquibaseChange != null ? liquibaseChange.getLocation() : null) == LiquibaseChange.Location.HIDE;
    }

    public final void removeFromExcluded(@NotNull XmlTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Project project = tag.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        LiquibaseChangeIdentifierManager identifierManager = LiquibaseChangeIdentifierManager.Companion.getInstance(project);
        LiquibaseChangeIdentifier liquibaseChangeIdentifier = identifierManager.createIdentifier(tag);
        if (liquibaseChangeIdentifier == null) {
            return;
        }
        LiquibaseChangeIdentifier excludeChange = liquibaseChangeIdentifier;
        this.excludeChanges.remove(excludeChange);
    }

    public final void excludeChange(@NotNull XmlTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Project project = tag.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        LiquibaseChangeIdentifierManager identifierManager = LiquibaseChangeIdentifierManager.Companion.getInstance(project);
        LiquibaseChangeIdentifier liquibaseChangeIdentifier = identifierManager.createIdentifier(tag);
        if (liquibaseChangeIdentifier == null) {
            return;
        }
        LiquibaseChangeIdentifier excludeChange = liquibaseChangeIdentifier;
        if (!this.excludeChanges.contains(excludeChange)) {
            this.excludeChanges.add(excludeChange);
        }
    }

    @JvmStatic
    @NotNull
    public static final LiquibaseChangesConfig getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u247;
        LiquibaseChange $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u246;
        LiquibaseChange $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u245;
        LiquibaseChange $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u244;
        LiquibaseChange liquibaseChange;
        Companion = new Companion(null);
        Object[] objectArray = new LiquibaseChange[21];
        objectArray[0] = new LiquibaseChange(LiquibaseChange.Category.COLUMN, "addColumn", LiquibaseChange.DangerLevel.SAFE);
        objectArray[1] = new LiquibaseChange(LiquibaseChange.Category.COLUMN, "dropColumn", LiquibaseChange.DangerLevel.DANGER);
        objectArray[2] = new LiquibaseChange(LiquibaseChange.Category.COLUMN, "addNotNullConstraint", LiquibaseChange.DangerLevel.CAUTION);
        objectArray[3] = new LiquibaseChange(LiquibaseChange.Category.COLUMN, "dropNotNullConstraint", LiquibaseChange.DangerLevel.SAFE);
        objectArray[4] = new LiquibaseChange(LiquibaseChange.Category.COLUMN, "addAutoIncrement", LiquibaseChange.DangerLevel.SAFE);
        objectArray[5] = new LiquibaseChange(LiquibaseChange.Category.COLUMN, "addDefaultValue", LiquibaseChange.DangerLevel.SAFE);
        objectArray[6] = new LiquibaseChange(LiquibaseChange.Category.COLUMN, "modifyDataType", LiquibaseChange.DangerLevel.DANGER);
        LiquibaseChange liquibaseChange2 = liquibaseChange = new LiquibaseChange(LiquibaseChange.Category.COMMENT, "setTableRemarks", LiquibaseChange.DangerLevel.CAUTION);
        int n = 7;
        Object[] objectArray2 = objectArray;
        boolean bl = false;
        $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u244.setLocation(LiquibaseChange.Location.HIDE);
        Unit unit = Unit.INSTANCE;
        objectArray2[n] = liquibaseChange;
        $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u244 = liquibaseChange = new LiquibaseChange(LiquibaseChange.Category.COMMENT, "setColumnRemarks", LiquibaseChange.DangerLevel.CAUTION);
        n = 8;
        objectArray2 = objectArray;
        boolean bl2 = false;
        $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u245.setLocation(LiquibaseChange.Location.HIDE);
        unit = Unit.INSTANCE;
        objectArray2[n] = liquibaseChange;
        objectArray[9] = new LiquibaseChange(LiquibaseChange.Category.FOREIGN_KEY, "addForeignKeyConstraint", LiquibaseChange.DangerLevel.SAFE);
        objectArray[10] = new LiquibaseChange(LiquibaseChange.Category.FOREIGN_KEY, "dropForeignKeyConstraint", LiquibaseChange.DangerLevel.SAFE);
        objectArray[11] = new LiquibaseChange(LiquibaseChange.Category.INDEX, "createIndex", LiquibaseChange.DangerLevel.SAFE);
        $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u245 = liquibaseChange = new LiquibaseChange(LiquibaseChange.Category.INDEX, "dropIndex", LiquibaseChange.DangerLevel.SAFE);
        n = 12;
        objectArray2 = objectArray;
        boolean bl3 = false;
        $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u246.setLocation(LiquibaseChange.Location.IGNORE);
        unit = Unit.INSTANCE;
        objectArray2[n] = liquibaseChange;
        objectArray[13] = new LiquibaseChange(LiquibaseChange.Category.PRIMARY_KEY, "addPrimaryKey", LiquibaseChange.DangerLevel.SAFE);
        objectArray[14] = new LiquibaseChange(LiquibaseChange.Category.PRIMARY_KEY, "dropPrimaryKey", LiquibaseChange.DangerLevel.SAFE);
        objectArray[15] = new LiquibaseChange(LiquibaseChange.Category.SEQUENCE, "createSequence", LiquibaseChange.DangerLevel.SAFE);
        objectArray[16] = new LiquibaseChange(LiquibaseChange.Category.SEQUENCE, "dropSequence", LiquibaseChange.DangerLevel.DANGER);
        objectArray[17] = new LiquibaseChange(LiquibaseChange.Category.TABLE, "createTable", LiquibaseChange.DangerLevel.SAFE);
        objectArray[18] = new LiquibaseChange(LiquibaseChange.Category.TABLE, "dropTable", LiquibaseChange.DangerLevel.DANGER);
        objectArray[19] = new LiquibaseChange(LiquibaseChange.Category.UNIQUE_CONSTRAINT, "addUniqueConstraint", LiquibaseChange.DangerLevel.CAUTION);
        $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u246 = liquibaseChange = new LiquibaseChange(LiquibaseChange.Category.UNIQUE_CONSTRAINT, "dropUniqueConstraint", LiquibaseChange.DangerLevel.SAFE);
        n = 20;
        objectArray2 = objectArray;
        boolean bl4 = false;
        $this$DEFAULT_LIQUIBASE_CHANGES_u24lambda_u247.setLocation(LiquibaseChange.Location.IGNORE);
        unit = Unit.INSTANCE;
        objectArray2[n] = liquibaseChange;
        DEFAULT_LIQUIBASE_CHANGES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/liquibase/common/config/LiquibaseChangesConfig$Companion;", "", "<init>", "()V", "LIQUIBASE_CHANGE_TAG_NAME", "", "EXCLUDE_CHANGE_TAG_NAME", "INCLUDE_CHANGE_LOG_TAG_NAME", "getInstance", "Lcom/intellij/liquibase/common/config/LiquibaseChangesConfig;", "project", "Lcom/intellij/openapi/project/Project;", "DEFAULT_LIQUIBASE_CHANGES", "", "Lcom/intellij/liquibase/common/config/LiquibaseChange;", "getDEFAULT_LIQUIBASE_CHANGES", "()Ljava/util/List;", "intellij.liquibase.common"})
    @SourceDebugExtension(value={"SMAP\nLiquibaseChangesConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiquibaseChangesConfig.kt\ncom/intellij/liquibase/common/config/LiquibaseChangesConfig$Companion\n+ 2 services.kt\ncom/intellij/openapi/components/ServicesKt\n*L\n1#1,254:1\n30#2,2:255\n*S KotlinDebug\n*F\n+ 1 LiquibaseChangesConfig.kt\ncom/intellij/liquibase/common/config/LiquibaseChangesConfig$Companion\n*L\n33#1:255,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final LiquibaseChangesConfig getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<LiquibaseChangesConfig> serviceClass$iv = LiquibaseChangesConfig.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
            }
            return (LiquibaseChangesConfig)object;
        }

        @NotNull
        public final List<LiquibaseChange> getDEFAULT_LIQUIBASE_CHANGES() {
            return DEFAULT_LIQUIBASE_CHANGES;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

