/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.ddl;

import com.google.common.collect.ImmutableMap;
import com.intellij.jpa.jpb.model.db.HibernateSqlType;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Datatypes;
import com.intellij.liquibase.common.ddl.DbMappingSettings;
import com.intellij.liquibase.common.ddl.DbMappingSettingsKt;
import com.intellij.liquibase.common.ddl.LiquibaseTypes;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u0017H\u0016J\u0017\u0010\u001c\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u001b\u001a\u00020\u0017H\u0016\u00a2\u0006\u0002\u0010\u001dJ1\u0010\u001e\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\b\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010#J(\u0010$\u001a\u00020\u001a2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\n2\u0006\u0010(\u001a\u00020\n2\u0006\u0010)\u001a\u00020\u0017H\u0016J1\u0010*\u001a\u00020\u001a2\u0006\u0010+\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\n2\b\u0010,\u001a\u0004\u0018\u00010\u00172\b\u0010-\u001a\u0004\u0018\u00010\u0017H\u0016\u00a2\u0006\u0002\u0010.J1\u0010/\u001a\u00020\u001a2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00172\b\u0010 \u001a\u0004\u0018\u00010\u00172\u0006\u0010!\u001a\u00020\n2\u0006\u0010\"\u001a\u00020\nH\u0016\u00a2\u0006\u0002\u0010#R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\b\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\u000b0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR \u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\t8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\rR \u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR \u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\n0\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\r\u00a8\u00060"}, d2={"Lcom/intellij/liquibase/common/ddl/MssqlMappingSettings;", "Lcom/intellij/liquibase/common/ddl/DbMappingSettings;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "liquibaseTypes", "Lcom/intellij/liquibase/common/ddl/LiquibaseTypes;", "sqlSynonymTypes", "", "", "", "getSqlSynonymTypes", "()Ljava/util/Map;", "mappingTypes", "Lcom/intellij/jpa/jpb/model/model/Datatypes$BasicDatatype;", "getMappingTypes", "jdbcTypeCodeMappings", "Lcom/intellij/jpa/jpb/model/db/HibernateSqlType;", "getJdbcTypeCodeMappings", "defaultValues", "getDefaultValues", "getMaxVarcharLength", "", "sqlType", "isJdbcTypeCodeLengthAvailable", "", "jdbcTypeCode", "getSpecificLengthByJdbcTypeCode", "(I)Ljava/lang/Integer;", "precisionChanged", "attributeColumnSize", "dbColumnSizeInt", "attributeSqlType", "dbSqlType", "(Ljava/lang/Integer;Ljava/lang/Integer;Ljava/lang/String;Ljava/lang/String;)Z", "typeChanged", "datatype", "Lcom/intellij/jpa/jpb/model/model/Datatype;", "attrMappedSqlType", "dbType", "oldLength", "lengthChanged", "attrSqlType", "attrColumnSize", "dbColumnSize", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/Integer;Ljava/lang/Integer;)Z", "scaleChanged", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nDbMappingSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DbMappingSettings.kt\ncom/intellij/liquibase/common/ddl/MssqlMappingSettings\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,1521:1\n1869#2,2:1522\n1869#2,2:1524\n1869#2,2:1526\n12637#3,2:1528\n*S KotlinDebug\n*F\n+ 1 DbMappingSettings.kt\ncom/intellij/liquibase/common/ddl/MssqlMappingSettings\n*L\n1019#1:1522,2\n1020#1:1524,2\n1026#1:1526,2\n1047#1:1528,2\n*E\n"})
public final class MssqlMappingSettings
implements DbMappingSettings {
    @NotNull
    private final LiquibaseTypes liquibaseTypes;
    @NotNull
    private final Map<String, Collection<String>> sqlSynonymTypes;
    @NotNull
    private final Map<HibernateSqlType, String> jdbcTypeCodeMappings;
    @NotNull
    private final Map<Datatypes.BasicDatatype, String> defaultValues;

    /*
     * WARNING - void declaration
     */
    public MssqlMappingSettings(@NotNull Project project) {
        Datatypes.BasicDatatype it;
        void $this$defaultValues_u24lambda_u246;
        void it2;
        Pair[] $this$sqlSynonymTypes_u24lambda_u240;
        Pair[] pairArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.liquibaseTypes = new LiquibaseTypes(project);
        Pair[] pairArray2 = pairArray = (Pair[])new LinkedHashMap();
        MssqlMappingSettings mssqlMappingSettings = this;
        boolean bl = false;
        Object[] objectArray = new String[]{"long", "long identity", "bigint identity"};
        $this$sqlSynonymTypes_u24lambda_u240.put("BIGINT", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"binary varying", "varbinary", "binary varying", "varbinary(max)", "timestamp", "rowversion", "binary", "IMAGE"};
        $this$sqlSynonymTypes_u24lambda_u240.put("BLOB", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"TINYINT", "BIT"};
        $this$sqlSynonymTypes_u24lambda_u240.put("BOOLEAN", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"character", "NCHAR"};
        $this$sqlSynonymTypes_u24lambda_u240.put("CHAR", CollectionsKt.listOf((Object[])objectArray));
        $this$sqlSynonymTypes_u24lambda_u240.put("DATE", CollectionsKt.emptyList());
        objectArray = new String[]{"datetime2", "datetimeoffset", "smalldatetime"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DATETIME", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"dec", "numeric", "money", "smallmoney", "CURRENCY", "NUMBER"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DECIMAL", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"DOUBLE PRECISION", "FLOAT", "real"};
        $this$sqlSynonymTypes_u24lambda_u240.put("DOUBLE", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"int4", "integer", "int identity", "TINYINT", "SMALLINT", "MEDIUMINT"};
        $this$sqlSynonymTypes_u24lambda_u240.put("INT", CollectionsKt.listOf((Object[])objectArray));
        objectArray = new String[]{"character varying", "NVARCHAR", "text", "varchar(max)", "nvarchar(max)", "ntext", "CLOB", "NCLOB"};
        $this$sqlSynonymTypes_u24lambda_u240.put("VARCHAR", CollectionsKt.listOf((Object[])objectArray));
        $this$sqlSynonymTypes_u24lambda_u240.put("TIME", CollectionsKt.emptyList());
        $this$sqlSynonymTypes_u24lambda_u240.put("TIMESTAMP", CollectionsKt.emptyList());
        $this$sqlSynonymTypes_u24lambda_u240.put("UUID", CollectionsKt.listOf((Object)"UNIQUEIDENTIFIER"));
        $this$sqlSynonymTypes_u24lambda_u240.put("XML", CollectionsKt.emptyList());
        $this$sqlSynonymTypes_u24lambda_u240 = pairArray;
        boolean $i$a$-let-MssqlMappingSettings$sqlSynonymTypes$32 = false;
        mssqlMappingSettings.sqlSynonymTypes = DbMappingSettingsKt.access$createSynonymMap(project, (Map)it2);
        pairArray = new Pair[]{TuplesKt.to((Object)HibernateSqlType.JSON, (Object)"longvarchar"), TuplesKt.to((Object)HibernateSqlType.TIMESTAMP_WITH_TIMEZONE, (Object)"datetimeoffset"), TuplesKt.to((Object)HibernateSqlType.TIME_WITH_TIMEZONE, (Object)"datetime"), TuplesKt.to((Object)HibernateSqlType.TIMESTAMP, (Object)"datetime2"), TuplesKt.to((Object)HibernateSqlType.TIMESTAMP_UTC, (Object)"datetimeoffset"), TuplesKt.to((Object)HibernateSqlType.LONGVARCHAR, (Object)"longvarchar"), TuplesKt.to((Object)HibernateSqlType.LONGNVARCHAR, (Object)"nvarchar(MAX)"), TuplesKt.to((Object)HibernateSqlType.LONG32NVARCHAR, (Object)"nvarchar(MAX)"), TuplesKt.to((Object)HibernateSqlType.FLOAT, (Object)"REAL")};
        this.jdbcTypeCodeMappings = MapsKt.plus(this.liquibaseTypes.getJDBC_TYPE_CODE_TYPES(), (Map)MapsKt.mapOf((Pair[])pairArray));
        Map $i$a$-let-MssqlMappingSettings$sqlSynonymTypes$32 = new LinkedHashMap();
        mssqlMappingSettings = this;
        boolean bl2 = false;
        Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.Boolean;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"Boolean");
        $this$defaultValues_u24lambda_u246.put(basicDatatype, "0");
        Datatypes.BasicDatatype basicDatatype2 = Datatypes.BasicDatatype.ByteArray;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype2, (String)"ByteArray");
        $this$defaultValues_u24lambda_u246.put(basicDatatype2, "''");
        Iterable $this$forEach$iv = DbMappingSettingsKt.access$getDATE_TYPES$p();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl3 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u246.put(it, "convert (date, current_timestamp)");
        }
        $this$forEach$iv = DbMappingSettingsKt.access$getDATATIME_TYPES$p();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl4 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u246.put(it, "current_timestamp");
        }
        Datatypes.BasicDatatype basicDatatype3 = Datatypes.BasicDatatype.BigDecimal;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype3, (String)"BigDecimal");
        $this$defaultValues_u24lambda_u246.put(basicDatatype3, "0");
        Datatypes.BasicDatatype basicDatatype4 = Datatypes.BasicDatatype.Double;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype4, (String)"Double");
        $this$defaultValues_u24lambda_u246.put(basicDatatype4, "0");
        Datatypes.BasicDatatype basicDatatype5 = Datatypes.BasicDatatype.Integer;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype5, (String)"Integer");
        $this$defaultValues_u24lambda_u246.put(basicDatatype5, "0");
        Datatypes.BasicDatatype basicDatatype6 = Datatypes.BasicDatatype.Long;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype6, (String)"Long");
        $this$defaultValues_u24lambda_u246.put(basicDatatype6, "0");
        Datatypes.BasicDatatype basicDatatype7 = Datatypes.BasicDatatype.String;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype7, (String)"String");
        $this$defaultValues_u24lambda_u246.put(basicDatatype7, "''");
        $this$forEach$iv = DbMappingSettingsKt.access$getTIME_TYPES$p();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (Datatypes.BasicDatatype)element$iv;
            boolean bl5 = false;
            Intrinsics.checkNotNull((Object)it);
            $this$defaultValues_u24lambda_u246.put(it, "convert (date, current_timestamp)");
        }
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)$this$defaultValues_u24lambda_u246);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"run(...)");
        mssqlMappingSettings.defaultValues = (Map)immutableMap;
    }

    @Override
    @NotNull
    public Map<String, Collection<String>> getSqlSynonymTypes() {
        return this.sqlSynonymTypes;
    }

    @Override
    @NotNull
    public Map<Datatypes.BasicDatatype, String> getMappingTypes() {
        Map $this$_get_mappingTypes__u24lambda_u242 = new LinkedHashMap();
        boolean bl = false;
        $this$_get_mappingTypes__u24lambda_u242.putAll(this.liquibaseTypes.DATABASE_INDEPENDENT_TYPES);
        Datatypes.BasicDatatype basicDatatype = Datatypes.BasicDatatype.OffsetDateTime;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype, (String)"OffsetDateTime");
        $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype, "datetimeoffset");
        Datatypes.BasicDatatype basicDatatype2 = Datatypes.BasicDatatype.ZonedDateTime;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype2, (String)"ZonedDateTime");
        $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype2, "datetimeoffset");
        Datatypes.BasicDatatype basicDatatype3 = Datatypes.BasicDatatype.Calendar;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype3, (String)"Calendar");
        $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype3, "datetimeoffset");
        Datatypes.BasicDatatype basicDatatype4 = Datatypes.BasicDatatype.Byte;
        Intrinsics.checkNotNullExpressionValue((Object)basicDatatype4, (String)"Byte");
        $this$_get_mappingTypes__u24lambda_u242.put(basicDatatype4, "SMALLINT");
        ImmutableMap immutableMap = ImmutableMap.copyOf((Map)$this$_get_mappingTypes__u24lambda_u242);
        Intrinsics.checkNotNullExpressionValue((Object)immutableMap, (String)"run(...)");
        return (Map)immutableMap;
    }

    @Override
    @NotNull
    public Map<HibernateSqlType, String> getJdbcTypeCodeMappings() {
        return this.jdbcTypeCodeMappings;
    }

    @Override
    @NotNull
    public Map<Datatypes.BasicDatatype, String> getDefaultValues() {
        return this.defaultValues;
    }

    @Override
    public int getMaxVarcharLength(@NotNull String sqlType) {
        Intrinsics.checkNotNullParameter((Object)sqlType, (String)"sqlType");
        String string = sqlType;
        Object[] objectArray = new String[]{"nchar", "nvarchar", "ntext"};
        return CollectionsKt.listOf((Object[])objectArray).contains(string) ? 0x3FFFFFFF : Integer.MAX_VALUE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isJdbcTypeCodeLengthAvailable(int jdbcTypeCode) {
        if (DbMappingSettings.super.isJdbcTypeCodeLengthAvailable(jdbcTypeCode)) return true;
        HibernateSqlType[] hibernateSqlTypeArray = new HibernateSqlType[]{HibernateSqlType.BINARY, HibernateSqlType.GEOMETRY, HibernateSqlType.GEOGRAPHY, HibernateSqlType.INET, HibernateSqlType.POINT, HibernateSqlType.VARBINARY};
        HibernateSqlType[] $this$any$iv = hibernateSqlTypeArray;
        boolean $i$f$any = false;
        int n = 0;
        int n2 = $this$any$iv.length;
        while (n < n2) {
            HibernateSqlType element$iv;
            HibernateSqlType it = element$iv = $this$any$iv[n];
            boolean bl = false;
            if (it.equalsByCode(Integer.valueOf(jdbcTypeCode))) {
                return true;
            }
            ++n;
        }
        return false;
    }

    @Override
    @Nullable
    public Integer getSpecificLengthByJdbcTypeCode(int jdbcTypeCode) {
        return HibernateSqlType.INET.equalsByCode(Integer.valueOf(jdbcTypeCode)) ? Integer.valueOf(19) : DbMappingSettings.super.getSpecificLengthByJdbcTypeCode(jdbcTypeCode);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean precisionChanged(@Nullable Integer attributeColumnSize, @Nullable Integer dbColumnSizeInt, @NotNull String attributeSqlType, @NotNull String dbSqlType) {
        Intrinsics.checkNotNullParameter((Object)attributeSqlType, (String)"attributeSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        if (Intrinsics.areEqual((Object)"money", (Object)dbSqlType)) {
            Integer n = attributeColumnSize;
            int n2 = 19;
            if (n != null) {
                if (n == n2) return false;
            }
            if (attributeColumnSize != null) return true;
            Integer n3 = dbColumnSizeInt;
            n2 = 19;
            if (n3 == null) return true;
            if (n3 != n2) return true;
            if (StringsKt.equals((String)"CURRENCY", (String)attributeSqlType, (boolean)true)) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)"smallmoney", (Object)dbSqlType)) {
            Integer n = attributeColumnSize;
            int n4 = 10;
            if (n == null) return true;
            if (n == n4) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)dbColumnSizeInt, (Object)attributeColumnSize)) return false;
        Integer n = dbColumnSizeInt;
        int n5 = 18;
        if (n == null) return true;
        if (n != n5) return true;
        if (attributeColumnSize == null) return false;
        if (attributeColumnSize == 0) return false;
        return true;
    }

    @Override
    public boolean typeChanged(@NotNull Datatype datatype, @NotNull String attrMappedSqlType, @NotNull String dbType, int oldLength) {
        Intrinsics.checkNotNullParameter((Object)datatype, (String)"datatype");
        Intrinsics.checkNotNullParameter((Object)attrMappedSqlType, (String)"attrMappedSqlType");
        Intrinsics.checkNotNullParameter((Object)dbType, (String)"dbType");
        String string = dbType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        String columnDbType = string;
        String string2 = attrMappedSqlType.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        String attributeType = string2;
        return !(!Intrinsics.areEqual((Object)"char", (Object)columnDbType) && !Intrinsics.areEqual((Object)"nchar", (Object)columnDbType) || !Intrinsics.areEqual((Object)"varchar", (Object)attributeType) && !Intrinsics.areEqual((Object)"nvarchar", (Object)attributeType) || oldLength <= 1) ? false : !this.isConvertibleType(attributeType, columnDbType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean lengthChanged(@NotNull String attrSqlType, @NotNull String dbSqlType, @Nullable Integer attrColumnSize, @Nullable Integer dbColumnSize) {
        Intrinsics.checkNotNullParameter((Object)attrSqlType, (String)"attrSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        boolean lengthChanged = DbMappingSettings.super.lengthChanged(attrSqlType, dbSqlType, attrColumnSize, dbColumnSize);
        if (lengthChanged && LiquibaseTypes.Companion.isClobType(attrSqlType) && attrColumnSize == null) {
            Integer n = dbColumnSize;
            int n2 = -1;
            if (n != null && n == n2) {
                return false;
            }
        }
        boolean bl = lengthChanged;
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean scaleChanged(@Nullable Integer attributeColumnSize, @Nullable Integer dbColumnSizeInt, @NotNull String attributeSqlType, @NotNull String dbSqlType) {
        Intrinsics.checkNotNullParameter((Object)attributeSqlType, (String)"attributeSqlType");
        Intrinsics.checkNotNullParameter((Object)dbSqlType, (String)"dbSqlType");
        boolean scaleChanged = DbMappingSettings.super.scaleChanged(attributeColumnSize, dbColumnSizeInt, attributeSqlType, dbSqlType);
        if (scaleChanged && Intrinsics.areEqual((Object)"money", (Object)dbSqlType)) {
            Integer n = dbColumnSizeInt;
            int n2 = 4;
            if (n != null && n == n2 && attributeColumnSize == null && StringsKt.equals((String)"CURRENCY", (String)attributeSqlType, (boolean)true)) {
                return false;
            }
        }
        boolean bl = scaleChanged;
        return bl;
    }
}

