/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.liquibase.common.gui;

import com.intellij.liquibase.common.gui.AbstractMergePanel;
import com.intellij.liquibase.common.gui.AntagonistChangesCache;
import com.intellij.liquibase.common.gui.ChangeLogPreviewDialog;
import com.intellij.liquibase.common.gui.ChangeLogTree;
import com.intellij.liquibase.common.gui.ChangeLogTreeKt;
import com.intellij.liquibase.common.gui.ChangeModel;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.psi.xml.XmlTag;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.components.DropDownLink;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.tree.DefaultMutableTreeNode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b&\u0018\u0000 \u00182\u00020\u0001:\u0002\u0018\u0019B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\b\u001a\u00020\tJ\u0018\u0010\n\u001a\u00020\t2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0005H\u0004J\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J:\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\u00122\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0012H\u0002J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00050\u0012H\u0002\u00a8\u0006\u001a"}, d2={"Lcom/intellij/liquibase/common/gui/MergeTablePanel;", "Lcom/intellij/liquibase/common/gui/AbstractMergePanel;", "dialog", "Lcom/intellij/liquibase/common/gui/ChangeLogPreviewDialog;", "targetNode", "Ljavax/swing/tree/DefaultMutableTreeNode;", "<init>", "(Lcom/intellij/liquibase/common/gui/ChangeLogPreviewDialog;Ljavax/swing/tree/DefaultMutableTreeNode;)V", "init", "", "updateXmlTag", "dropTableNode", "createTableNode", "findAndShowDependsChanges", "oldTableName", "", "newTableName", "findUnnecessaryChanges", "", "changeNodes", "", "finders", "Lcom/intellij/liquibase/common/gui/MergeTablePanel$UnnecessaryChangeFinder;", "getPopupChangeNodes", "Companion", "UnnecessaryChangeFinder", "intellij.liquibase.common"})
@SourceDebugExtension(value={"SMAP\nMergeTablePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MergeTablePanel.kt\ncom/intellij/liquibase/common/gui/MergeTablePanel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,172:1\n1869#2,2:173\n*S KotlinDebug\n*F\n+ 1 MergeTablePanel.kt\ncom/intellij/liquibase/common/gui/MergeTablePanel\n*L\n103#1:173,2\n*E\n"})
public abstract class MergeTablePanel
extends AbstractMergePanel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final List<UnnecessaryChangeFinder> UNNECESSARY_CHANGE_FINDER;

    public MergeTablePanel(@NotNull ChangeLogPreviewDialog dialog, @NotNull DefaultMutableTreeNode targetNode) {
        Intrinsics.checkNotNullParameter((Object)((Object)dialog), (String)"dialog");
        Intrinsics.checkNotNullParameter((Object)targetNode, (String)"targetNode");
        super(dialog, targetNode);
    }

    public final void init() {
        DropDownLink addColumnFiled2 = new DropDownLink((Object)this.getDropDownCaption(), arg_0 -> MergeTablePanel.init$lambda$2(this, arg_0));
        this.addMergeComponent((Component)addColumnFiled2);
    }

    protected final void updateXmlTag(@NotNull DefaultMutableTreeNode dropTableNode, @NotNull DefaultMutableTreeNode createTableNode) {
        Intrinsics.checkNotNullParameter((Object)dropTableNode, (String)"dropTableNode");
        Intrinsics.checkNotNullParameter((Object)createTableNode, (String)"createTableNode");
        Object object = createTableNode.getUserObject();
        ChangeModel changeModel = object instanceof ChangeModel ? (ChangeModel)object : null;
        if (changeModel == null || (changeModel = changeModel.getXmlTag()) == null) {
            return;
        }
        ChangeModel createTag = changeModel;
        Object object2 = dropTableNode.getUserObject();
        ChangeModel changeModel2 = object2 instanceof ChangeModel ? (ChangeModel)object2 : null;
        if (changeModel2 == null || (changeModel2 = changeModel2.getXmlTag()) == null) {
            return;
        }
        ChangeModel dropTag = changeModel2;
        String oldTableName = dropTag.getAttributeValue("tableName");
        String newTableName = createTag.getAttributeValue("tableName");
        String newTagSource = "<renameTable newTableName=\"" + newTableName + "\" oldTableName=\"" + oldTableName + "\"";
        String newSchemaName = createTag.getAttributeValue("schemaName");
        CharSequence charSequence = newSchemaName;
        if (!(charSequence == null || StringsKt.isBlank((CharSequence)charSequence))) {
            newTagSource = newTagSource + " schemaName=\"" + newSchemaName + "\"";
        }
        newTagSource = newTagSource + "/>";
        this.replaceDropTag(createTableNode, (XmlTag)dropTag, newTagSource);
        this.removeDropAndSelectAdd(dropTableNode, createTableNode);
        if (oldTableName != null && newTableName != null) {
            this.findAndShowDependsChanges(oldTableName, newTableName);
        }
    }

    private final void findAndShowDependsChanges(String oldTableName, String newTableName) {
        ChangeLogTree tree = this.getDialog().getTree();
        Collection<DefaultMutableTreeNode> changeNodes = ChangeLogTreeKt.getChildrenNodeByUserObjectType(tree.getRootNode(), ChangeModel.class, true);
        List<DefaultMutableTreeNode> dependsChanges = this.findUnnecessaryChanges(oldTableName, newTableName, changeNodes, UNNECESSARY_CHANGE_FINDER);
        this.showUnnecessaryDialog(dependsChanges);
    }

    private final List<DefaultMutableTreeNode> findUnnecessaryChanges(String oldTableName, String newTableName, Collection<? extends DefaultMutableTreeNode> changeNodes, List<UnnecessaryChangeFinder> finders) {
        List dependsChanges = new ArrayList();
        Iterable $this$forEach$iv = changeNodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ChangeModel changeModel;
            DefaultMutableTreeNode changeNode = (DefaultMutableTreeNode)element$iv;
            boolean bl = false;
            Object object = changeNode.getUserObject();
            if ((object instanceof ChangeModel ? (ChangeModel)object : null) == null) continue;
            changeModel = changeModel;
            String changeTagName = changeModel.getTagName();
            if (changeModel.getXmlTag() == null) continue;
            for (UnnecessaryChangeFinder changeFinder : finders) {
                XmlTag changeXmlTag;
                if (!Intrinsics.areEqual((Object)changeFinder.getTagName(), (Object)changeTagName)) continue;
                String tableName = changeXmlTag.getAttributeValue(changeFinder.getTableAttrName());
                if ((!changeFinder.isNewTableName() || !Intrinsics.areEqual((Object)tableName, (Object)newTableName)) && (changeFinder.isNewTableName() || !Intrinsics.areEqual((Object)tableName, (Object)oldTableName))) continue;
                dependsChanges.add(changeNode);
                for (UnnecessaryChangeFinder subDependent : changeFinder.getSubDependents()) {
                    String dependentTableName;
                    if (changeXmlTag.getAttributeValue(subDependent.getTableAttrName()) == null) continue;
                    dependsChanges.addAll((Collection)this.findUnnecessaryChanges(dependentTableName, dependentTableName, changeNodes, changeFinder.getSubDependents()));
                }
            }
        }
        return dependsChanges;
    }

    private final List<DefaultMutableTreeNode> getPopupChangeNodes() {
        AntagonistChangesCache.ChangeItem changeItem = this.getTree().getAntagonistChangesCache().getTables();
        return this.isCreateChange() ? changeItem.getDropChanges() : changeItem.getCreateChanges();
    }

    private static final Unit init$lambda$2$lambda$0(MergeTablePanel this$0, DefaultMutableTreeNode selectedNode) {
        Intrinsics.checkNotNull((Object)selectedNode);
        this$0.updateXmlTag(selectedNode);
        return Unit.INSTANCE;
    }

    private static final void init$lambda$2$lambda$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final JBPopup init$lambda$2(MergeTablePanel this$0, DropDownLink it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List<DefaultMutableTreeNode> allPopupChangeNodes = this$0.getPopupChangeNodes();
        JBPopup jBPopup = JBPopupFactory.getInstance().createPopupChooserBuilder(allPopupChangeNodes).setSelectionMode(0).setRenderer((ListCellRenderer)new ColoredListCellRenderer<DefaultMutableTreeNode>(){

            protected void customizeCellRenderer(JList<? extends DefaultMutableTreeNode> list, DefaultMutableTreeNode value, int index, boolean selected, boolean hasFocus) {
                Intrinsics.checkNotNullParameter(list, (String)"list");
                DefaultMutableTreeNode defaultMutableTreeNode = value;
                Object object = defaultMutableTreeNode != null ? defaultMutableTreeNode.getUserObject() : null;
                ChangeModel changeModel = object instanceof ChangeModel ? (ChangeModel)object : null;
                if (changeModel == null) {
                    return;
                }
                ChangeModel valueChangeModel = changeModel;
                this.append(valueChangeModel.getPresentableName());
            }
        }).setItemChosenCallback(arg_0 -> MergeTablePanel.init$lambda$2$lambda$1(arg_0 -> MergeTablePanel.init$lambda$2$lambda$0(this$0, arg_0), arg_0)).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"createPopup(...)");
        return jBPopup;
    }

    static {
        Object[] objectArray = new UnnecessaryChangeFinder[]{new UnnecessaryChangeFinder("addForeignKeyConstraint", "baseTableName", true, null, 8, null), new UnnecessaryChangeFinder("dropForeignKeyConstraint", "baseTableName", false, null, 8, null), new UnnecessaryChangeFinder("addForeignKeyConstraint", "referencedTableName", true, CollectionsKt.listOf((Object)new UnnecessaryChangeFinder("dropForeignKeyConstraint", "baseTableName", false, null, 8, null))), new UnnecessaryChangeFinder("createIndex", "tableName", true, null, 8, null), new UnnecessaryChangeFinder("dropIndex", "tableName", false, null, 8, null), new UnnecessaryChangeFinder("addUniqueConstraint", "tableName", true, null, 8, null), new UnnecessaryChangeFinder("dropUniqueConstraint", "tableName", false, null, 8, null)};
        UNNECESSARY_CHANGE_FINDER = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/intellij/liquibase/common/gui/MergeTablePanel$Companion;", "", "<init>", "()V", "UNNECESSARY_CHANGE_FINDER", "", "Lcom/intellij/liquibase/common/gui/MergeTablePanel$UnnecessaryChangeFinder;", "getUNNECESSARY_CHANGE_FINDER", "()Ljava/util/List;", "intellij.liquibase.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<UnnecessaryChangeFinder> getUNNECESSARY_CHANGE_FINDER() {
            return UNNECESSARY_CHANGE_FINDER;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\t\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\fR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u000eR\u0017\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00000\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/intellij/liquibase/common/gui/MergeTablePanel$UnnecessaryChangeFinder;", "", "tagName", "", "tableAttrName", "isNewTableName", "", "subDependents", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;ZLjava/util/List;)V", "getTagName", "()Ljava/lang/String;", "getTableAttrName", "()Z", "getSubDependents", "()Ljava/util/List;", "intellij.liquibase.common"})
    public static final class UnnecessaryChangeFinder {
        @NotNull
        private final String tagName;
        @NotNull
        private final String tableAttrName;
        private final boolean isNewTableName;
        @NotNull
        private final List<UnnecessaryChangeFinder> subDependents;

        public UnnecessaryChangeFinder(@NotNull String tagName, @NotNull String tableAttrName, boolean isNewTableName, @NotNull List<UnnecessaryChangeFinder> subDependents) {
            Intrinsics.checkNotNullParameter((Object)tagName, (String)"tagName");
            Intrinsics.checkNotNullParameter((Object)tableAttrName, (String)"tableAttrName");
            Intrinsics.checkNotNullParameter(subDependents, (String)"subDependents");
            this.tagName = tagName;
            this.tableAttrName = tableAttrName;
            this.isNewTableName = isNewTableName;
            this.subDependents = subDependents;
        }

        public /* synthetic */ UnnecessaryChangeFinder(String string, String string2, boolean bl, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            this(string, string2, bl, list);
        }

        @NotNull
        public final String getTagName() {
            return this.tagName;
        }

        @NotNull
        public final String getTableAttrName() {
            return this.tableAttrName;
        }

        public final boolean isNewTableName() {
            return this.isNewTableName;
        }

        @NotNull
        public final List<UnnecessaryChangeFinder> getSubDependents() {
            return this.subDependents;
        }
    }
}

