/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.command;

import com.intellij.jpa.jpb.model.core.model.dbtype.DbType;
import com.intellij.jpa.jpb.model.model.DbIdentifierHelper;
import com.intellij.liquibase.common.LiquibaseGenerationContext;
import com.intellij.liquibase.common.LiquibaseGenerationContextRegistry;
import com.intellij.liquibase.common.LiquibaseManager;
import com.intellij.liquibase.common.config.DiffGenerationConfig;
import com.intellij.liquibase.common.config.LiquibaseChange;
import com.intellij.liquibase.common.config.LiquibaseChangesConfig;
import com.intellij.liquibase.common.ddl.LiquibaseGenerator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import liquibase.ContextExpression;
import liquibase.Scope;
import liquibase.change.AddColumnConfig;
import liquibase.change.Change;
import liquibase.change.ChangeFactory;
import liquibase.change.ChangeParameterMetaData;
import liquibase.change.ColumnConfig;
import liquibase.change.ConstraintsConfig;
import liquibase.change.DatabaseChange;
import liquibase.change.core.AddColumnChange;
import liquibase.change.core.AddForeignKeyConstraintChange;
import liquibase.change.core.AddNotNullConstraintChange;
import liquibase.change.core.AddPrimaryKeyChange;
import liquibase.change.core.AddUniqueConstraintChange;
import liquibase.change.core.CreateIndexChange;
import liquibase.change.core.CreateTableChange;
import liquibase.change.core.DropColumnChange;
import liquibase.change.core.DropIndexChange;
import liquibase.change.core.DropPrimaryKeyChange;
import liquibase.change.core.DropUniqueConstraintChange;
import liquibase.change.core.ModifyDataTypeChange;
import liquibase.changelog.ChangeSet;
import liquibase.database.Database;
import liquibase.database.jvm.JdbcConnection;
import liquibase.diff.DiffResult;
import liquibase.diff.output.DiffOutputControl;
import liquibase.diff.output.changelog.ChangeGenerator;
import liquibase.diff.output.changelog.DiffToChangeLog;
import liquibase.diff.output.changelog.UnexpectedObjectChangeGenerator;
import liquibase.ext.intellij.LiquibaseUtils;
import liquibase.ext.intellij.database.DatabaseWrapper;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.diff.UnexpectedIndexChangeGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Column;
import liquibase.structure.core.Index;
import liquibase.structure.core.Relation;
import liquibase.structure.core.View;
import liquibase.util.StringUtil;
import one.util.streamex.StreamEx;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class HDiffToChangeLog
extends DiffToChangeLog {
    private final DiffResult diffResult;
    private final DiffOutputControl diffOutputControl;
    private final Database referenceDatabase;
    @Nullable
    protected final IntellijDatabase intellijDatabase;

    public HDiffToChangeLog(DiffResult diffResult, DiffOutputControl diffOutputControl, Database referenceDatabase) {
        super(diffResult, diffOutputControl);
        this.diffResult = diffResult;
        this.diffOutputControl = diffOutputControl;
        this.referenceDatabase = referenceDatabase;
        this.intellijDatabase = this.getIntellijDatabase();
    }

    protected String getChangeSetAuthor() {
        Project project = this.getProject();
        if (project != null) {
            String liquibaseAuthor;
            if (this.intellijDatabase != null && com.intellij.openapi.util.text.StringUtil.isNotEmpty((String)(liquibaseAuthor = DiffGenerationConfig.Companion.getInstance(project).getLiquibaseAuthor()))) {
                return liquibaseAuthor;
            }
            return LiquibaseManager.getInstance(project).getChangeSetAuthor();
        }
        return super.getChangeSetAuthor();
    }

    public List<ChangeSet> generateChangeSets() {
        this.filterDiff();
        HashSet columns = new HashSet(this.diffResult.getMissingObjects(Column.class));
        columns.addAll(this.diffResult.getChangedObjects(Column.class).keySet());
        columns.addAll(this.diffResult.getUnexpectedObjects(Column.class));
        for (Column column : columns) {
            UUID generationContextId = (UUID)column.getAttribute("generationContext", UUID.class);
            if (generationContextId == null) continue;
            LiquibaseGenerationContext context = LiquibaseGenerationContextRegistry.INSTANCE.get(generationContextId);
            String typeName = column.getType().getTypeName();
            column.setType(context.getType(typeName).toLiquibaseDataType(context));
        }
        List changeSets = super.generateChangeSets();
        this.removeDbViewTables(changeSets);
        HDiffToChangeLog.removeExcessAddForeignKeyConstraintChange(changeSets);
        HDiffToChangeLog.removeEmptyAssociatedWith(changeSets);
        this.compactChangeSetsByGroup(changeSets);
        this.compactAddFKConstraintAndCreateIndexChangeSet(changeSets);
        this.compactDropColumnChangeSet(changeSets);
        this.compactAddColumnChangeSet(changeSets);
        this.modifyColumnType(changeSets);
        this.addDropIndexIfNeed(changeSets);
        this.removeDefaultSchemaName(changeSets);
        this.removeDropPkConstraintAndIndex(changeSets);
        HDiffToChangeLog.removeDeleteCascade(changeSets);
        this.removeDropIndex(changeSets);
        this.removeHiddenChangesets(changeSets);
        this.sortDropIndexChanges(changeSets);
        this.reorderNotNullAndUniqueConstraints(changeSets);
        return changeSets;
    }

    private static void removeEmptyAssociatedWith(List<ChangeSet> changeSets) {
        changeSets.forEach(changeSet -> {
            if (changeSet.getChanges() != null) {
                changeSet.getChanges().forEach(change -> {
                    CreateIndexChange indexChange;
                    if (change instanceof CreateIndexChange && (indexChange = (CreateIndexChange)change).getAssociatedWith() != null && indexChange.getAssociatedWith().isEmpty()) {
                        indexChange.setAssociatedWith(null);
                    }
                });
            }
        });
    }

    private static void removeDeleteCascade(List<ChangeSet> changeSets) {
        for (ChangeSet changeSet : changeSets) {
            for (Change change : changeSet.getChanges()) {
                if (!(change instanceof AddColumnChange)) continue;
                for (AddColumnConfig columnConfig : ((AddColumnChange)change).getColumns()) {
                    ConstraintsConfig constraints = columnConfig.getConstraints();
                    if (constraints == null || constraints.isDeleteCascade() != Boolean.FALSE) continue;
                    constraints.setDeleteCascade((Boolean)null);
                }
            }
        }
    }

    private void reorderNotNullAndUniqueConstraints(List<ChangeSet> changeSets) {
        DatabaseSnapshot comparisonSnapshot = this.diffResult.getComparisonSnapshot();
        Database comparisonDatabase = comparisonSnapshot.getDatabase();
        if (LiquibaseUtils.getDatabaseType(comparisonDatabase) != DbType.DB2) {
            return;
        }
        ArrayList<MoveChangeSetInfo> moveChangeSets = new ArrayList<MoveChangeSetInfo>();
        HashMap<String, Pair> tableName2UniqueColumns = new HashMap<String, Pair>();
        for (ChangeSet changeSet : changeSets) {
            List changes = changeSet.getChanges();
            for (Change change : changes) {
                String tableName;
                if (change instanceof AddUniqueConstraintChange) {
                    tableName = ((AddUniqueConstraintChange)change).getTableName();
                    String columnNames = ((AddUniqueConstraintChange)change).getColumnNames();
                    List columnNameList = StringUtil.splitAndTrim((String)columnNames, (String)",");
                    if (!com.intellij.openapi.util.text.StringUtil.isNotEmpty((String)tableName) || columnNameList.isEmpty()) continue;
                    Set uniqueColumns = (Set)tableName2UniqueColumns.computeIfAbsent(tableName, (Function<String, Pair>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$reorderNotNullAndUniqueConstraints$2(liquibase.changelog.ChangeSet java.lang.String ), (Ljava/lang/String;)Lcom/intellij/openapi/util/Pair;)((ChangeSet)changeSet)).second;
                    uniqueColumns.addAll(columnNameList);
                    continue;
                }
                if (!(change instanceof AddNotNullConstraintChange)) continue;
                tableName = ((AddNotNullConstraintChange)change).getTableName();
                String columnName = ((AddNotNullConstraintChange)change).getColumnName();
                Pair uniqueColumns = (Pair)tableName2UniqueColumns.get(tableName);
                if (uniqueColumns == null || !com.intellij.openapi.util.text.StringUtil.isNotEmpty((String)columnName) || !((Set)uniqueColumns.second).contains(columnName)) continue;
                moveChangeSets.add(new MoveChangeSetInfo(changeSet, (ChangeSet)uniqueColumns.first));
            }
        }
        HDiffToChangeLog.moveChangeSet(changeSets, moveChangeSets);
    }

    private void sortDropIndexChanges(List<ChangeSet> changeSets) {
        DatabaseSnapshot comparisonSnapshot = this.diffResult.getComparisonSnapshot();
        Database comparisonDatabase = comparisonSnapshot.getDatabase();
        Set indexes = comparisonSnapshot.get(Index.class);
        if (indexes == null || indexes.isEmpty()) {
            return;
        }
        List dropColumnModels = StreamEx.of(changeSets).map(changeSet -> {
            List changes = changeSet.getChanges();
            String tableName = null;
            HashSet<String> columnNames = new HashSet<String>();
            for (Change change : changes) {
                if (!(change instanceof DropColumnChange)) continue;
                if (tableName == null) {
                    tableName = ((DropColumnChange)change).getTableName();
                }
                columnNames.addAll(this.collectDropColumnNames((DropColumnChange)change));
            }
            if (tableName != null && !columnNames.isEmpty()) {
                DropColumnModel dropColumnModel = new DropColumnModel();
                dropColumnModel.changeSet = changeSet;
                dropColumnModel.tableName = tableName;
                dropColumnModel.columnNames = columnNames;
                return dropColumnModel;
            }
            return null;
        }).nonNull().toList();
        if (dropColumnModels.isEmpty()) {
            return;
        }
        ArrayList<ChangeSet> toRemoveChangeSets = new ArrayList<ChangeSet>();
        ArrayList<MoveChangeSetInfo> moveChangeSets = new ArrayList<MoveChangeSetInfo>();
        for (int idxChangeSetIdx = 0; idxChangeSetIdx < changeSets.size(); ++idxChangeSetIdx) {
            ChangeSet idxChangeSet = changeSets.get(idxChangeSetIdx);
            List changes = idxChangeSet.getChanges();
            for (Change change : changes) {
                DropColumnModel foundDropColumnModel;
                if (!(change instanceof DropIndexChange)) continue;
                String indexName = ((DropIndexChange)change).getIndexName();
                String indexTableName = ((DropIndexChange)change).getTableName();
                Index foundIndex = StreamEx.of((Collection)indexes).findFirst(index -> {
                    Relation idxRelation = index.getRelation();
                    return idxRelation != null && DbIdentifierHelper.compareIdentifier((String)index.getName(), (String)indexName) && DbIdentifierHelper.compareIdentifier((String)idxRelation.getName(), (String)indexTableName);
                }).orElse(null);
                if (foundIndex == null || (foundDropColumnModel = HDiffToChangeLog.findDropColumnModel(foundIndex, dropColumnModels)) == null) continue;
                if (LiquibaseUtils.getDatabaseType(comparisonDatabase) != DbType.MSSQL && foundIndex.getColumns().size() == 1 && changes.size() == 1) {
                    toRemoveChangeSets.add(idxChangeSet);
                    continue;
                }
                if (idxChangeSetIdx <= changeSets.indexOf(foundDropColumnModel.changeSet)) continue;
                moveChangeSets.add(new MoveChangeSetInfo(idxChangeSet, foundDropColumnModel.changeSet));
            }
        }
        changeSets.removeAll(toRemoveChangeSets);
        HDiffToChangeLog.moveChangeSet(changeSets, moveChangeSets);
    }

    private static void moveChangeSet(List<ChangeSet> changeSets, List<MoveChangeSetInfo> moveChangeSetInfos) {
        for (MoveChangeSetInfo moveInfo : moveChangeSetInfos) {
            int anchorIdx = changeSets.indexOf(moveInfo.anchor);
            if (anchorIdx == -1) continue;
            ChangeSet target = moveInfo.target;
            changeSets.remove(target);
            changeSets.add(anchorIdx, target);
        }
    }

    @Nullable
    private static DropColumnModel findDropColumnModel(Index index, List<DropColumnModel> models) {
        return StreamEx.of(models).findFirst(dropColumnModel -> DbIdentifierHelper.compareIdentifier((String)dropColumnModel.tableName, (String)index.getRelation().getName()) && index.getColumns().stream().anyMatch(idxColumn -> dropColumnModel.columnNames.stream().anyMatch(dropColumnName -> DbIdentifierHelper.compareIdentifier((String)idxColumn.getName(), (String)dropColumnName)))).orElse(null);
    }

    private void removeDropIndex(List<ChangeSet> changeSets) {
        DatabaseSnapshot comparisonSnapshot = this.diffResult.getComparisonSnapshot();
        Database comparisonDatabase = comparisonSnapshot.getDatabase();
        if (LiquibaseUtils.getDatabaseType(comparisonDatabase) != DbType.DB2) {
            return;
        }
        Set dropUniqueConstraintNames = StreamEx.of(changeSets).flatMap(changeSet -> changeSet.getChanges().stream()).select(DropUniqueConstraintChange.class).map(DropUniqueConstraintChange::getConstraintName).nonNull().toSet();
        if (dropUniqueConstraintNames.isEmpty()) {
            return;
        }
        List toRemoveChangeSets = ((StreamEx)StreamEx.of(changeSets).filter(changeSet -> {
            List changes = changeSet.getChanges();
            return changes.stream().anyMatch(change -> change instanceof DropIndexChange && dropUniqueConstraintNames.contains(((DropIndexChange)change).getIndexName()));
        })).toList();
        if (toRemoveChangeSets.isEmpty()) {
            return;
        }
        changeSets.removeAll(toRemoveChangeSets);
    }

    private void removeHiddenChangesets(List<ChangeSet> changeSets) {
        Project project = this.getProject();
        if (project == null) {
            return;
        }
        LiquibaseChangesConfig liquibaseChangesConfig = LiquibaseChangesConfig.getInstance(project);
        List toRemoveChangeSets = ((StreamEx)StreamEx.of(changeSets).filter(changeSet -> {
            List changes = changeSet.getChanges();
            return changes.stream().allMatch(change -> {
                String changeName = change.getClass().getAnnotation(DatabaseChange.class).name();
                LiquibaseChange changeConfig = liquibaseChangesConfig.findChangeByTagName(changeName);
                return changeConfig != null && liquibaseChangesConfig.isChangeHidden(changeConfig);
            });
        })).toList();
        changeSets.removeAll(toRemoveChangeSets);
    }

    private void removeDropPkConstraintAndIndex(List<ChangeSet> changeSets) {
        List addPrimaryKeyChanges = StreamEx.of(changeSets).flatMap(changeSet -> changeSet.getChanges().stream()).select(AddPrimaryKeyChange.class).toList();
        if (addPrimaryKeyChanges.isEmpty()) {
            return;
        }
        DatabaseSnapshot comparisonSnapshot = this.diffResult.getComparisonSnapshot();
        Database comparisonDatabase = comparisonSnapshot.getDatabase();
        boolean isRequiredDropConstraints = LiquibaseUtils.getDatabaseType(comparisonDatabase) == DbType.MSSQL;
        HashMap<String, ChangeSet> dropPkChangeSets = new HashMap<String, ChangeSet>();
        ArrayList<ChangeSet> toRemoveChangeSets = new ArrayList<ChangeSet>();
        for (int i = 0; i < changeSets.size(); ++i) {
            ChangeSet changeSet2 = changeSets.get(i);
            List changes = changeSet2.getChanges();
            for (AddPrimaryKeyChange addPrimaryKeyChange : addPrimaryKeyChanges) {
                boolean isCreateIndexDetected = false;
                for (Change change2 : changes) {
                    boolean isDropPkFromAddPk = HDiffToChangeLog.isDropPkFromAddPk(change2, addPrimaryKeyChange);
                    boolean isCreateIdxForAddPk = HDiffToChangeLog.isCreateIdxForAddPk(change2, addPrimaryKeyChange);
                    if (!isDropPkFromAddPk && !isCreateIdxForAddPk) continue;
                    if (isDropPkFromAddPk && isRequiredDropConstraints) {
                        dropPkChangeSets.put(addPrimaryKeyChange.getTableName(), changeSet2);
                        continue;
                    }
                    if (changes.size() <= 1) {
                        toRemoveChangeSets.add(changeSet2);
                    } else {
                        changeSets.set(i, this.copyChangeSetWithoutChange(changeSet2, change2));
                    }
                    if (isCreateIndexDetected) continue;
                    isCreateIndexDetected = isCreateIdxForAddPk;
                }
                if (!isCreateIndexDetected || LiquibaseUtils.getDatabaseType(comparisonDatabase) != DbType.ORACLE) continue;
                addPrimaryKeyChange.setForIndexName(null);
            }
        }
        changeSets.removeAll(toRemoveChangeSets);
        for (Map.Entry dropPkChangeSet : dropPkChangeSets.entrySet()) {
            ChangeSet targetChangeSet;
            int targetIdx;
            String tableName = (String)dropPkChangeSet.getKey();
            int anchorIdx = -1;
            for (int i = 0; i < changeSets.size(); ++i) {
                ChangeSet changeSet3 = changeSets.get(i);
                if (!changeSet3.getChanges().stream().anyMatch(change -> change instanceof DropColumnChange && com.intellij.openapi.util.text.StringUtil.equalsIgnoreCase((CharSequence)((DropColumnChange)change).getTableName(), (CharSequence)tableName))) continue;
                anchorIdx = i;
                break;
            }
            if (anchorIdx < 0 || (targetIdx = changeSets.indexOf(targetChangeSet = (ChangeSet)dropPkChangeSet.getValue())) <= anchorIdx) continue;
            changeSets.remove(targetChangeSet);
            changeSets.add(anchorIdx, targetChangeSet);
        }
    }

    private static boolean isCreateIdxForAddPk(Change change, AddPrimaryKeyChange addPrimaryKeyChange) {
        if (!(change instanceof CreateIndexChange)) {
            return false;
        }
        CreateIndexChange indexChange = (CreateIndexChange)change;
        String addPkConstraintName = addPrimaryKeyChange.getConstraintName();
        String idxName = indexChange.getIndexName();
        return com.intellij.openapi.util.text.StringUtil.equalsIgnoreCase((CharSequence)addPrimaryKeyChange.getTableName(), (CharSequence)indexChange.getTableName()) && (com.intellij.openapi.util.text.StringUtil.equalsIgnoreCase((CharSequence)addPkConstraintName, (CharSequence)idxName) || com.intellij.openapi.util.text.StringUtil.equalsIgnoreCase((CharSequence)("IX_" + addPkConstraintName), (CharSequence)idxName));
    }

    private static boolean isDropPkFromAddPk(Change change, AddPrimaryKeyChange addPrimaryKeyChange) {
        return change instanceof DropPrimaryKeyChange && com.intellij.openapi.util.text.StringUtil.equalsIgnoreCase((CharSequence)addPrimaryKeyChange.getTableName(), (CharSequence)((DropPrimaryKeyChange)change).getTableName());
    }

    private void removeDefaultSchemaName(List<ChangeSet> changeSets) {
        DatabaseSnapshot comparisonSnapshot = this.diffResult.getComparisonSnapshot();
        Database comparisonDatabase = comparisonSnapshot.getDatabase();
        String defaultSchemaName = comparisonDatabase.getDefaultSchemaName();
        if (com.intellij.openapi.util.text.StringUtil.isEmpty((String)defaultSchemaName) || comparisonDatabase.getOutputDefaultSchema()) {
            return;
        }
        StreamEx.of(changeSets).flatMap(changeSet -> changeSet.getChanges().stream()).forEach(change -> {
            ChangeParameterMetaData fieldMetaData = StreamEx.of((Object[])new String[]{"schemaName", "baseTableSchemaName", "referencedTableSchemaName", "existingTableSchemaName", "newTableSchemaName", "forIndexSchemaName"}).map(propName -> (ChangeParameterMetaData)((ChangeFactory)Scope.getCurrentScope().getSingleton(ChangeFactory.class)).getChangeMetaData(change).getParameters().get(propName)).nonNull().findFirst().orElse(null);
            if (fieldMetaData == null || !Objects.equals(fieldMetaData.getCurrentValue(change), defaultSchemaName)) {
                return;
            }
            fieldMetaData.setValue(change, null);
        });
    }

    private void filterDiff() {
        if (this.intellijDatabase == null) {
            return;
        }
        LiquibaseGenerationContext generationContext = this.intellijDatabase.getGenerationContext();
        for (DatabaseObject databaseObject : new ArrayList(this.diffResult.getUnexpectedObjects())) {
            if (!generationContext.isIgnoreDatabaseObject(databaseObject)) continue;
            this.diffResult.getUnexpectedObjects().remove(databaseObject);
        }
        for (DatabaseObject databaseObject : new ArrayList(this.diffResult.getMissingObjects())) {
            if (!generationContext.isIgnoreDatabaseObject(databaseObject)) continue;
            this.diffResult.getMissingObjects().remove(databaseObject);
        }
        for (Map.Entry entry : new HashMap(this.diffResult.getChangedObjects()).entrySet()) {
            DatabaseObject object = (DatabaseObject)entry.getKey();
            if (!generationContext.isIgnoreDatabaseObject(object)) continue;
            this.diffResult.getChangedObjects().remove(object);
        }
    }

    private void addDropIndexIfNeed(List<ChangeSet> changeSets) {
        DatabaseSnapshot comparisonSnapshot = this.diffResult.getComparisonSnapshot();
        Database comparisonDatabase = comparisonSnapshot.getDatabase();
        if (LiquibaseUtils.getDatabaseType(comparisonDatabase) != DbType.MSSQL) {
            return;
        }
        LinkedHashMap<String, Set> toCreateIndexes = new LinkedHashMap<String, Set>();
        for (ChangeSet changeSet2 : changeSets) {
            String changeSetId = changeSet2.getId();
            if (com.intellij.openapi.util.text.StringUtil.isEmpty((String)changeSetId)) continue;
            for (Change change : changeSet2.getChanges()) {
                Set indexes;
                String columnName;
                if (!(change instanceof DropColumnChange) || com.intellij.openapi.util.text.StringUtil.isEmpty((String)(columnName = ((DropColumnChange)change).getColumnName())) || (indexes = comparisonSnapshot.get(Index.class)) == null) continue;
                Set allIndexWithColumnName = ((StreamEx)StreamEx.of((Collection)indexes).filter(index -> index.getColumns().stream().anyMatch(column -> DbIdentifierHelper.compareIdentifier((String)column.getName(), (String)columnName)))).toSet();
                toCreateIndexes.put(changeSetId, allIndexWithColumnName);
            }
        }
        for (Map.Entry entry : toCreateIndexes.entrySet()) {
            Pair<Integer, ChangeSet> foundChangeSet = HDiffToChangeLog.findChangeSetIndexById(changeSets, (String)entry.getKey());
            if (foundChangeSet == null) continue;
            ChangeSet newChangeSet = this.copyChangeSet((ChangeSet)foundChangeSet.second, ((ChangeSet)foundChangeSet.second).getId() + "-drop-indexes");
            for (Index index2 : (Set)entry.getValue()) {
                UnexpectedIndexChangeGenerator changeGenerator;
                Change[] indexChanges;
                if (changeSets.stream().anyMatch(changeSet -> changeSet.getChanges().stream().anyMatch(change -> change instanceof DropIndexChange && com.intellij.openapi.util.text.StringUtil.equalsIgnoreCase((CharSequence)((DropIndexChange)change).getIndexName(), (CharSequence)index2.getName()))) || (indexChanges = (changeGenerator = new UnexpectedIndexChangeGenerator()).fixUnexpected((DatabaseObject)index2, this.diffOutputControl, this.diffResult.getReferenceSnapshot().getDatabase(), comparisonDatabase, null)) == null) continue;
                for (Change indexChange : indexChanges) {
                    newChangeSet.addChange(indexChange);
                }
            }
            if (newChangeSet.getChanges().isEmpty()) continue;
            changeSets.add((Integer)foundChangeSet.first, newChangeSet);
        }
    }

    @Nullable
    private static Pair<Integer, ChangeSet> findChangeSetIndexById(List<ChangeSet> changeSets, String changeSetId) {
        for (int i = 0; i < changeSets.size(); ++i) {
            ChangeSet changeSet = changeSets.get(i);
            if (!Objects.equals(changeSet.getId(), changeSetId)) continue;
            return Pair.create((Object)i, (Object)changeSet);
        }
        return null;
    }

    protected List<Class<? extends DatabaseObject>> getOrderedOutputTypes(Class<? extends ChangeGenerator> generatorType) {
        int indexIdx;
        List orderedOutputTypes = super.getOrderedOutputTypes(generatorType);
        if (UnexpectedObjectChangeGenerator.class.isAssignableFrom(generatorType) && (indexIdx = orderedOutputTypes.indexOf(Index.class)) > 0) {
            Collections.swap(orderedOutputTypes, indexIdx, indexIdx - 1);
        }
        return orderedOutputTypes;
    }

    @Nullable
    private IntellijDatabase getIntellijDatabase() {
        Database database = this.diffResult.getReferenceSnapshot().getDatabase();
        if (database instanceof IntellijDatabase && database.getConnection() instanceof JdbcConnection) {
            return (IntellijDatabase)database;
        }
        database = this.diffResult.getComparisonSnapshot().getDatabase();
        if (database instanceof IntellijDatabase && database.getConnection() instanceof JdbcConnection) {
            return (IntellijDatabase)database;
        }
        return null;
    }

    private Project getProject() {
        if (this.intellijDatabase != null) {
            return this.intellijDatabase.getProject();
        }
        if (this.diffResult.getReferenceSnapshot().getDatabase() instanceof DatabaseWrapper) {
            return ((DatabaseWrapper)this.diffResult.getReferenceSnapshot().getDatabase()).getProject();
        }
        if (this.diffResult.getComparisonSnapshot().getDatabase() instanceof DatabaseWrapper) {
            return ((DatabaseWrapper)this.diffResult.getComparisonSnapshot().getDatabase()).getProject();
        }
        return null;
    }

    private void modifyColumnType(List<ChangeSet> changeSets) {
        if (this.intellijDatabase == null) {
            return;
        }
        LiquibaseGenerator liquibaseGenerator = this.intellijDatabase.getLiquibaseGenerator();
        for (ChangeSet changeSet : changeSets) {
            for (Change change : changeSet.getChanges()) {
                ModifyDataTypeChange modifyDataTypeChange;
                String newDataType;
                String tableName;
                if (change instanceof CreateTableChange) {
                    CreateTableChange createTableChange = (CreateTableChange)change;
                    this.modifyColumnType(liquibaseGenerator, createTableChange.getSchemaName(), createTableChange.getTableName(), createTableChange.getColumns());
                    continue;
                }
                if (change instanceof AddColumnChange) {
                    AddColumnChange addColumnChange = (AddColumnChange)change;
                    this.modifyColumnType(liquibaseGenerator, addColumnChange.getSchemaName(), addColumnChange.getTableName(), addColumnChange.getColumns());
                    continue;
                }
                if (change instanceof AddNotNullConstraintChange) {
                    AddNotNullConstraintChange addNotNullConstraintChange = (AddNotNullConstraintChange)change;
                    String columnDataType = addNotNullConstraintChange.getColumnDataType();
                    if (!com.intellij.openapi.util.text.StringUtil.isNotEmpty((String)columnDataType)) continue;
                    tableName = addNotNullConstraintChange.getTableName();
                    String schemaName = addNotNullConstraintChange.getSchemaName();
                    addNotNullConstraintChange.setColumnDataType(this.getProcessedColumnType(liquibaseGenerator, schemaName, tableName, addNotNullConstraintChange.getColumnName(), columnDataType));
                    continue;
                }
                if (!(change instanceof ModifyDataTypeChange) || !com.intellij.openapi.util.text.StringUtil.isNotEmpty((String)(newDataType = (modifyDataTypeChange = (ModifyDataTypeChange)change).getNewDataType()))) continue;
                tableName = modifyDataTypeChange.getTableName();
                String columnName = modifyDataTypeChange.getColumnName();
                String schemaName = modifyDataTypeChange.getSchemaName();
                modifyDataTypeChange.setNewDataType(this.getProcessedColumnType(liquibaseGenerator, schemaName, tableName, columnName, newDataType));
            }
        }
    }

    private void modifyColumnType(LiquibaseGenerator liquibaseGenerator, @Nullable String schemaName, String tableName, Collection<? extends ColumnConfig> columnConfigs) {
        for (ColumnConfig columnConfig : columnConfigs) {
            String columnType = columnConfig.getType();
            if (!com.intellij.openapi.util.text.StringUtil.isNotEmpty((String)columnType)) continue;
            columnConfig.setType(this.getProcessedColumnType(liquibaseGenerator, schemaName, tableName, columnConfig.getName(), columnType));
        }
    }

    @NotNull
    private String getProcessedColumnType(@NotNull LiquibaseGenerator liquibaseGenerator, @Nullable String schemaName, @NotNull String tableName, @NotNull String columnName, @NotNull String columnType) {
        String mappedType;
        if (liquibaseGenerator == null) {
            HDiffToChangeLog.$$$reportNull$$$0(0);
        }
        if (tableName == null) {
            HDiffToChangeLog.$$$reportNull$$$0(1);
        }
        if (columnName == null) {
            HDiffToChangeLog.$$$reportNull$$$0(2);
        }
        if (columnType == null) {
            HDiffToChangeLog.$$$reportNull$$$0(3);
        }
        if (com.intellij.openapi.util.text.StringUtil.isEmpty((String)(mappedType = liquibaseGenerator.getColumnDefinition(schemaName, tableName, columnName, ((IntellijDatabase)this.referenceDatabase).getOrmEntitiesToProcess())))) {
            String string = columnType;
            if (string == null) {
                HDiffToChangeLog.$$$reportNull$$$0(4);
            }
            return string;
        }
        String string = mappedType;
        if (string == null) {
            HDiffToChangeLog.$$$reportNull$$$0(5);
        }
        return string;
    }

    private String getSingleChangeGroupId(ChangeSet changeSet) {
        if (changeSet.getChanges().size() != 1) {
            return null;
        }
        Change singleChange = (Change)changeSet.getChanges().get(0);
        return (String)singleChange.get("changeSetGroupId", String.class);
    }

    private void compactChangeSetsByGroup(List<ChangeSet> changeSets) {
        for (int i = 0; i < changeSets.size(); ++i) {
            ChangeSet currentChangeSet = changeSets.get(i);
            String groupId = this.getSingleChangeGroupId(currentChangeSet);
            if (StringUtils.isEmpty((CharSequence)groupId)) continue;
            for (int j = i + 1; j < changeSets.size(); ++j) {
                ChangeSet mergeCandidate = changeSets.get(j);
                String mergeCandidateGroupId = this.getSingleChangeGroupId(mergeCandidate);
                if (!groupId.equals(mergeCandidateGroupId)) continue;
                currentChangeSet.addChange((Change)mergeCandidate.getChanges().get(0));
                changeSets.remove(j);
                --j;
            }
        }
    }

    private void compactAddColumnChangeSet(List<ChangeSet> changeSets) {
        Map<String, Set<String>> dropChanges = this.mapAllDropChanges(changeSets);
        HashMap<String, AddColumnChange> table2FirstAddColumnChange = new HashMap<String, AddColumnChange>();
        ArrayList<ChangeSet> toRemoveChangeSets = new ArrayList<ChangeSet>();
        for (int i = 0; i < changeSets.size(); ++i) {
            String tableName;
            ChangeSet changeSet = changeSets.get(i);
            List changes = changeSet.getChanges();
            AddColumnChange currentAddColumnChange = HDiffToChangeLog.findChange(changes, AddColumnChange.class);
            if (currentAddColumnChange == null || currentAddColumnChange.get("changeSetGroupId", String.class) != null || com.intellij.openapi.util.text.StringUtil.isEmpty((String)(tableName = currentAddColumnChange.getTableName()))) continue;
            Set<String> dropColumns = dropChanges.get(tableName);
            List currAddColumns = currentAddColumnChange.getColumns();
            if (dropColumns != null && dropColumns.stream().anyMatch(dropColumnName -> currAddColumns.stream().anyMatch(addColumnConfig -> Objects.equals(addColumnConfig.getName(), dropColumnName)))) continue;
            AddColumnChange firstAddColumnChange = (AddColumnChange)table2FirstAddColumnChange.get(tableName);
            if (firstAddColumnChange == null) {
                table2FirstAddColumnChange.put(tableName, currentAddColumnChange);
                continue;
            }
            currAddColumns.forEach(arg_0 -> ((AddColumnChange)firstAddColumnChange).addColumn(arg_0));
            if (changes.size() <= 1) {
                toRemoveChangeSets.add(changeSet);
                continue;
            }
            changeSets.set(i, this.copyChangeSetWithoutChange(changeSet, (Change)currentAddColumnChange));
        }
        changeSets.removeAll(toRemoveChangeSets);
    }

    private Map<String, Set<String>> mapAllDropChanges(List<ChangeSet> changeSets) {
        List allDropChanges = StreamEx.of(changeSets).flatMap(changeSet -> changeSet.getChanges().stream()).select(DropColumnChange.class).toList();
        HashMap<String, Set<String>> result = new HashMap<String, Set<String>>();
        for (DropColumnChange dropChange : allDropChanges) {
            String tableName = dropChange.getTableName();
            Set dropColumns = result.computeIfAbsent(tableName, k -> new HashSet());
            dropColumns.addAll(this.collectDropColumnNames(dropChange));
        }
        return result;
    }

    private Set<String> collectDropColumnNames(DropColumnChange dropChange) {
        HashSet<String> dropColumns = new HashSet<String>();
        dropColumns.add(dropChange.getColumnName());
        for (ColumnConfig column : dropChange.getColumns()) {
            dropColumns.add(column.getName());
        }
        return dropColumns;
    }

    private void compactDropColumnChangeSet(List<ChangeSet> changeSets) {
        HashMap<String, ChangeSet> table2FirstDropColumnChangeSet = new HashMap<String, ChangeSet>();
        ArrayList<ChangeSet> toRemoveChangeSets = new ArrayList<ChangeSet>();
        for (int i = 0; i < changeSets.size(); ++i) {
            String tableName;
            ChangeSet changeSet = changeSets.get(i);
            List changes = changeSet.getChanges();
            DropColumnChange dropColumnChange = HDiffToChangeLog.findChange(changes, DropColumnChange.class);
            if (dropColumnChange == null || com.intellij.openapi.util.text.StringUtil.isEmpty((String)(tableName = dropColumnChange.getTableName()))) continue;
            ChangeSet firstDropColumnChangeSet = (ChangeSet)table2FirstDropColumnChangeSet.get(tableName);
            if (firstDropColumnChangeSet == null) {
                table2FirstDropColumnChangeSet.put(tableName, changeSet);
                continue;
            }
            firstDropColumnChangeSet.addChange((Change)dropColumnChange);
            if (changes.size() <= 1) {
                toRemoveChangeSets.add(changeSet);
                continue;
            }
            changeSets.set(i, this.copyChangeSetWithoutChange(changeSet, (Change)dropColumnChange));
        }
        changeSets.removeAll(toRemoveChangeSets);
    }

    private ChangeSet copyChangeSetWithoutChange(ChangeSet changeSet, Change theChange) {
        List newChanges = ((StreamEx)StreamEx.of((Collection)changeSet.getChanges()).filter(change -> !change.equals(theChange))).toList();
        ChangeSet newChangeSet = this.copyChangeSet(changeSet, null);
        for (Change change2 : newChanges) {
            newChangeSet.addChange(change2);
        }
        return newChangeSet;
    }

    @NotNull
    private ChangeSet copyChangeSet(ChangeSet changeSet, @Nullable String newId) {
        ContextExpression contexts = changeSet.getContexts();
        String contextValue = contexts == null ? null : StreamEx.of((Collection)contexts.getContexts()).joining((CharSequence)",");
        ChangeSet newChangeSet = new ChangeSet(newId == null ? changeSet.getId() : newId, changeSet.getAuthor(), changeSet.isAlwaysRun(), changeSet.isRunOnChange(), changeSet.getFilePath(), com.intellij.openapi.util.text.StringUtil.nullize((String)contextValue, (boolean)true), null, changeSet.isRunInTransaction(), changeSet.getObjectQuotingStrategy(), null);
        newChangeSet.setCreated(changeSet.getCreated());
        newChangeSet.setLabels(changeSet.getLabels());
        ChangeSet changeSet2 = newChangeSet;
        if (changeSet2 == null) {
            HDiffToChangeLog.$$$reportNull$$$0(6);
        }
        return changeSet2;
    }

    private void compactAddFKConstraintAndCreateIndexChangeSet(List<ChangeSet> changeSets) {
        ArrayList<ChangeSet> toRemoveChangeSets = new ArrayList<ChangeSet>();
        for (ChangeSet changeSet : changeSets) {
            ChangeSet indexChangeSet;
            Pair<ChangeSet, CreateIndexChange> foundIndex;
            ColumnConfig[] columnConfigs;
            List changes = changeSet.getChanges();
            AddForeignKeyConstraintChange addForeignKeyConstraintChange = HDiffToChangeLog.findChange(changes, AddForeignKeyConstraintChange.class);
            if (addForeignKeyConstraintChange == null) continue;
            String baseTableName = addForeignKeyConstraintChange.getBaseTableName();
            String baseColumnNames = addForeignKeyConstraintChange.getBaseColumnNames();
            if (com.intellij.openapi.util.text.StringUtil.isEmpty((String)baseTableName) || com.intellij.openapi.util.text.StringUtil.isEmpty((String)baseColumnNames) || (columnConfigs = ColumnConfig.arrayFromNames((String)baseColumnNames)).length == 0 || (foundIndex = HDiffToChangeLog.findCreateIndexChange(changeSets, baseTableName, columnConfigs)) == null || changeSet.equals((Object)(indexChangeSet = (ChangeSet)foundIndex.first))) continue;
            changeSet.addChange((Change)foundIndex.second);
            if (indexChangeSet.getChanges().size() <= 1) {
                toRemoveChangeSets.add(indexChangeSet);
                continue;
            }
            int indexChangeSetIdx = changeSets.indexOf(indexChangeSet);
            if (indexChangeSetIdx >= 0) {
                changeSets.set(indexChangeSetIdx, this.copyChangeSetWithoutChange(indexChangeSet, (Change)foundIndex.second));
                continue;
            }
            toRemoveChangeSets.add(indexChangeSet);
        }
        changeSets.removeAll(toRemoveChangeSets);
    }

    @Nullable
    private static Pair<ChangeSet, CreateIndexChange> findCreateIndexChange(List<ChangeSet> changeSets, String baseTableName, ColumnConfig[] fkColumnConfigs) {
        for (ChangeSet changeSet : changeSets) {
            Set fkColumns;
            Set indexColumns;
            CreateIndexChange createIndexChange = HDiffToChangeLog.findChange(changeSet.getChanges(), CreateIndexChange.class);
            if (createIndexChange == null || !Objects.equals(baseTableName, createIndexChange.getTableName()) || !(indexColumns = StreamEx.of((Collection)createIndexChange.getColumns()).map(ColumnConfig::getName).nonNull().map(String::toLowerCase).toSet()).equals(fkColumns = StreamEx.of((Object[])fkColumnConfigs).map(ColumnConfig::getName).nonNull().map(String::toLowerCase).toSet())) continue;
            return Pair.create((Object)changeSet, (Object)createIndexChange);
        }
        return null;
    }

    private void removeDbViewTables(List<ChangeSet> changeSets) {
        if (this.intellijDatabase == null) {
            return;
        }
        DatabaseSnapshot comparisonSnapshot = this.diffResult.getComparisonSnapshot();
        Set views = comparisonSnapshot.get(View.class);
        if (views.isEmpty()) {
            return;
        }
        Set allDbViews = StreamEx.of((Collection)views).map(Relation::getName).toSet();
        changeSets.removeIf(changeSet -> {
            for (Change change : changeSet.getChanges()) {
                if (!(change instanceof CreateTableChange) || !allDbViews.stream().anyMatch(s -> s.equalsIgnoreCase(((CreateTableChange)change).getTableName()))) continue;
                return true;
            }
            return false;
        });
    }

    private static void removeExcessAddForeignKeyConstraintChange(List<ChangeSet> changeSets) {
        HashSet<? extends String> existAddColumnConstraints = new HashSet<String>();
        for (ChangeSet changeSet2 : changeSets) {
            for (Change change : changeSet2.getChanges()) {
                if (!(change instanceof AddColumnChange)) continue;
                existAddColumnConstraints.addAll(HDiffToChangeLog.getExistAddColumnConstraints((AddColumnChange)change));
            }
        }
        if (!existAddColumnConstraints.isEmpty()) {
            changeSets.removeIf(changeSet -> {
                List changes = changeSet.getChanges();
                if (changes.size() != 1) {
                    return false;
                }
                Change change = (Change)changes.get(0);
                if (!(change instanceof AddForeignKeyConstraintChange)) {
                    return false;
                }
                return existAddColumnConstraints.contains(((AddForeignKeyConstraintChange)change).getConstraintName());
            });
        }
    }

    private static <T extends Change> T findChange(List<Change> changes, Class<T> changeClass) {
        return (T)((Change)StreamEx.of(changes).select(changeClass).findFirst().orElse(null));
    }

    private static Collection<? extends String> getExistAddColumnConstraints(AddColumnChange change) {
        HashSet<String> existAddColumnConstraints = new HashSet<String>();
        for (AddColumnConfig column : change.getColumns()) {
            String foreignKeyName;
            ConstraintsConfig constraints = column.getConstraints();
            if (constraints == null || !com.intellij.openapi.util.text.StringUtil.isNotEmpty((String)(foreignKeyName = constraints.getForeignKeyName()))) continue;
            existAddColumnConstraints.add(foreignKeyName);
        }
        return existAddColumnConstraints;
    }

    private static /* synthetic */ Pair lambda$reorderNotNullAndUniqueConstraints$2(ChangeSet changeSet, String k) {
        return Pair.create((Object)changeSet, new HashSet());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liquibaseGenerator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tableName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columnType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "liquibase/ext/intellij/command/HDiffToChangeLog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "liquibase/ext/intellij/command/HDiffToChangeLog";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getProcessedColumnType";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "copyChangeSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getProcessedColumnType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4, 5, 6 -> new IllegalStateException(string);
        };
    }

    private static class MoveChangeSetInfo {
        private final ChangeSet target;
        private final ChangeSet anchor;

        public MoveChangeSetInfo(ChangeSet target, ChangeSet anchor) {
            this.target = target;
            this.anchor = anchor;
        }
    }

    private static class DropColumnModel {
        private String tableName;
        private Set<String> columnNames;
        private ChangeSet changeSet;

        private DropColumnModel() {
        }
    }
}

