/*
 * Decompiled with CFR 0.152.
 */
package liquibase.ext.intellij.snapshot;

import com.intellij.jpa.jpb.model.model.CollectionTableAttribute;
import com.intellij.jpa.jpb.model.model.Datatype;
import com.intellij.jpa.jpb.model.model.Entity;
import com.intellij.jpa.jpb.model.model.EntityAttribute;
import com.intellij.jpa.jpb.model.model.JoinTableAttribute;
import com.intellij.jpa.jpb.model.model.SoftDeleteModel;
import com.intellij.jpa.jpb.model.model.audit.AuditEntity;
import com.intellij.jpa.jpb.model.model.audit.RevTypeAttribute;
import com.intellij.jpa.jpb.model.model.audit.SetOrdinalAttribute;
import com.intellij.jpa.jpb.model.orm.model.OrmEntity;
import com.intellij.jpa.jpb.model.orm.model.OrmEntityAttribute;
import com.intellij.jpa.jpb.model.reference.PossiblyPkTableEntityAttribute;
import com.intellij.jpa.jpb.model.util.OrmUtil;
import com.intellij.jpa.jpb.model.util.annotation.JoinTable;
import com.intellij.liquibase.common.LiquibaseModelObjectFactory;
import com.intellij.liquibase.common.config.DatabaseMigrationConfig;
import com.intellij.liquibase.common.config.DatabaseMigrationState;
import com.intellij.liquibase.common.config.PkConstraintName;
import com.intellij.liquibase.common.ddl.LiquibaseGenerator;
import com.intellij.liquibase.common.orm.OrmDiffModelProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import liquibase.exception.DatabaseException;
import liquibase.ext.intellij.database.IntellijDatabase;
import liquibase.ext.intellij.snapshot.IntellijSnapshotGenerator;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.InvalidExampleException;
import liquibase.structure.DatabaseObject;
import liquibase.structure.core.Index;
import liquibase.structure.core.PrimaryKey;
import liquibase.structure.core.Relation;
import liquibase.structure.core.Table;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

public class PrimaryKeySnapshotGenerator
extends IntellijSnapshotGenerator {
    public static final String IDX_PREFIX = "IX_";

    public PrimaryKeySnapshotGenerator() {
        super(PrimaryKey.class, new Class[]{Table.class});
    }

    @Override
    protected DatabaseObject snapshotObject(DatabaseObject example, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        return example;
    }

    @Override
    protected void addTo(DatabaseObject foundObject, DatabaseSnapshot snapshot) throws DatabaseException, InvalidExampleException {
        if (!snapshot.getSnapshotControl().shouldInclude(PrimaryKey.class)) {
            return;
        }
        if (!(foundObject instanceof Table)) {
            return;
        }
        Table table = (Table)foundObject;
        OrmEntity entity = this.findOrmEntity((DatabaseObject)table, snapshot);
        IntellijDatabase database = (IntellijDatabase)snapshot.getDatabase();
        LiquibaseGenerator liquibaseGenerator = database.getLiquibaseGenerator();
        LiquibaseModelObjectFactory dbObjectFactory = database.getDbObjectFactory();
        if (entity == null) {
            JoinTableAttribute joinTableAttribute = liquibaseGenerator.findJoinTableAttribute(foundObject.getName(), database.getOrmEntitiesToProcess());
            if (joinTableAttribute != null) {
                List<EntityAttribute> joinTableAttributes = liquibaseGenerator.getJoinTableAttributes(joinTableAttribute);
                SoftDeleteModel softDeleteModel = joinTableAttribute.getAttribute().getSoftDelete();
                List keys = ((StreamEx)StreamEx.of(joinTableAttributes).filter(it -> {
                    if (softDeleteModel != null && softDeleteModel.getColumnName().equals(it.getColumn())) {
                        return false;
                    }
                    if (joinTableAttribute.getEntity() instanceof AuditEntity) {
                        return !(it instanceof RevTypeAttribute);
                    }
                    return !(it instanceof PossiblyPkTableEntityAttribute) || ((PossiblyPkTableEntityAttribute)it).isPkAttribute();
                })).toList();
                String tableName = joinTableAttribute.getAttribute().getJoinTable().getName();
                if (joinTableAttribute.getAttribute().getJoinTable() == JoinTable.NULL_ANNOTATION) {
                    tableName = table.getName();
                }
                PrimaryKeySnapshotGenerator.addPkToTable(liquibaseGenerator, dbObjectFactory, table, tableName, keys);
            } else {
                CollectionTableAttribute collectionTableAttribute = liquibaseGenerator.findCollectionTableAttribute(foundObject.getName(), database.getOrmEntitiesToProcess());
                if (collectionTableAttribute != null) {
                    List<EntityAttribute> collectionTableAttributes = liquibaseGenerator.getCollectionTableAttributes(collectionTableAttribute);
                    List idAttributes = ((StreamEx)StreamEx.of(collectionTableAttributes).filter(idAttr -> {
                        Entity entityType;
                        if (!(collectionTableAttribute.getEntity() instanceof AuditEntity)) {
                            return idAttr instanceof PossiblyPkTableEntityAttribute && ((PossiblyPkTableEntityAttribute)idAttr).isPkAttribute();
                        }
                        Datatype patt4836$temp = collectionTableAttribute.getAttribute().getType();
                        if (patt4836$temp instanceof Entity && (entityType = (Entity)patt4836$temp).isEmbeddable()) {
                            return idAttr instanceof PossiblyPkTableEntityAttribute || idAttr instanceof RevTypeAttribute || idAttr instanceof SetOrdinalAttribute;
                        }
                        return !(idAttr instanceof RevTypeAttribute);
                    })).toList();
                    PrimaryKeySnapshotGenerator.addPkToTable(liquibaseGenerator, dbObjectFactory, table, collectionTableAttribute.getTableName(), idAttributes);
                }
            }
        } else {
            List<OrmEntityAttribute> idAttributes = liquibaseGenerator.getIdAttributes(entity);
            if (idAttributes.isEmpty()) {
                return;
            }
            PrimaryKey pk = new PrimaryKey();
            OrmDiffModelProvider ormDiffModelProvider = OrmDiffModelProvider.Companion.getForFramework(entity.getOrmFramework());
            Entity jpaEntity = OrmUtil.INSTANCE.getEntityByOrmEntity(entity);
            if (jpaEntity != null) {
                pk.setName(PrimaryKeySnapshotGenerator.generateConstraintName(liquibaseGenerator, jpaEntity.getTable()));
            } else {
                pk.setName(PrimaryKeySnapshotGenerator.generateConstraintName(liquibaseGenerator, ormDiffModelProvider.getTableName(entity)));
            }
            pk.setTable(table);
            StreamEx.of(idAttributes).flatMap(attr -> ormDiffModelProvider.getColumnNames(liquibaseGenerator.getProject(), entity, (OrmEntityAttribute)attr).stream()).forEach(s -> pk.getColumns().add(dbObjectFactory.createColumn((String)s).setRelation((Relation)table)));
            LOG.info("Found primary key " + pk.getName());
            table.setPrimaryKey(pk);
            Index index = new Index();
            index.setName(IDX_PREFIX + pk.getName());
            index.setRelation((Relation)table);
            index.setColumns(pk.getColumns());
            index.setUnique(Boolean.valueOf(true));
            pk.setBackingIndex(index);
            table.getIndexes().add(index);
        }
    }

    private static void addPkToTable(LiquibaseGenerator liquibaseGenerator, LiquibaseModelObjectFactory dbObjectFactory, Table table, String tableName, Collection<EntityAttribute> idAttributes) {
        if (idAttributes.isEmpty()) {
            return;
        }
        PrimaryKey pk = new PrimaryKey();
        pk.setName(PrimaryKeySnapshotGenerator.generateConstraintName(liquibaseGenerator, tableName));
        pk.setTable(table);
        idAttributes.forEach(entityAttribute -> {
            String columnName = entityAttribute.getColumn() != null ? entityAttribute.getColumn() : entityAttribute.getName();
            pk.getColumns().add(dbObjectFactory.createColumn(columnName).setRelation((Relation)table));
        });
        LOG.debug("Found primary key " + pk.getName());
        table.setPrimaryKey(pk);
    }

    @Nullable
    private static String generateConstraintName(LiquibaseGenerator liquibaseGenerator, String tableName) {
        Project project = liquibaseGenerator.getProject();
        DatabaseMigrationState state = DatabaseMigrationConfig.getInstance(project).getState();
        PkConstraintName pkConstraintName = state.getPkConstraintName();
        if (pkConstraintName == null) {
            return null;
        }
        Object pkName = liquibaseGenerator.generateConstraintName(pkConstraintName.getPrefix(), tableName, null, Collections.emptyList());
        String postfix = pkConstraintName.getPostfix();
        if (StringUtil.isNotEmpty((String)postfix)) {
            pkName = (String)pkName + "_" + postfix;
        }
        return pkName;
    }
}

