/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.ejb.model;

import com.intellij.javaee.constants.JavaeeAnnotationConstants;
import com.intellij.javaee.ejb.model.EjbAnnotationConstants;
import com.intellij.javaee.utils.JavaeeType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public enum InterceptorMethodType {
    AROUND_INVOKE("AroundInvoke"),
    POST_CONSTRUCT("PostConstruct"),
    PRE_DESTROY("PreDestroy"),
    PRE_PASSIVATE("PrePassivate"),
    POST_ACTIVATE("PostActivate");

    @NotNull
    private final String typeName;

    private InterceptorMethodType(String typeName) {
        if (typeName == null) {
            InterceptorMethodType.$$$reportNull$$$0(0);
        }
        this.typeName = typeName;
    }

    @NotNull
    public String getTypeName() {
        String string = this.typeName;
        if (string == null) {
            InterceptorMethodType.$$$reportNull$$$0(1);
        }
        return string;
    }

    @NonNls
    public String getMethodStandardName() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case AROUND_INVOKE -> "aroundInvoke";
            case POST_ACTIVATE -> "ejbActivate";
            case POST_CONSTRUCT -> "ejbCreate";
            case PRE_DESTROY -> "ejbRemove";
            case PRE_PASSIVATE -> "ejbPassivate";
        };
    }

    @NonNls
    public String getMethodAnnotation(@NotNull JavaeeType javaeeType) {
        if (javaeeType == null) {
            InterceptorMethodType.$$$reportNull$$$0(2);
        }
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case AROUND_INVOKE -> JavaeeAnnotationConstants.AROUND_INVOKE_ANNO.fqn(javaeeType);
            case POST_ACTIVATE -> EjbAnnotationConstants.POST_ACTIVATE_ANNO.fqn(javaeeType);
            case POST_CONSTRUCT -> JavaeeAnnotationConstants.POST_CONSTRUCT_ANNO.fqn(javaeeType);
            case PRE_DESTROY -> JavaeeAnnotationConstants.PRE_DESTROY_ANNO.fqn(javaeeType);
            case PRE_PASSIVATE -> EjbAnnotationConstants.PRE_PASSIVATE_ANNO.fqn(javaeeType);
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeName";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/javaee/ejb/model/InterceptorMethodType";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "javaeeType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/javaee/ejb/model/InterceptorMethodType";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getMethodAnnotation";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

