/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.re.ui.settings;

import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.jpa.jpb.model.StateConfigurable;
import com.intellij.jpa.jpb.model.backend.persistenceunit.PersistenceUnitLoader;
import com.intellij.jpa.jpb.model.config.FieldAccessModifier;
import com.intellij.jpa.jpb.model.config.JpaPluginProjectConfig;
import com.intellij.jpa.jpb.model.config.PersistenceUnit;
import com.intellij.jpa.jpb.model.config.ProjectState;
import com.intellij.jpa.jpb.model.help.JpaHelpConstants;
import com.intellij.jpa.jpb.model.ui.VerticalLayoutPanel;
import com.intellij.jpa.jpb.model.ui.swing.StudioTable;
import com.intellij.jpa.jpb.model.util.JpaUtils;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.re.msg.ReBundle;
import com.intellij.re.ui.settings.NameTemplatesTable;
import com.intellij.re.ui.settings.PersistenceUnitToPathTable;
import com.intellij.re.ui.settings.PersistenceUnitToPathTableModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.JavaReferenceEditorUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBRadioButton;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTextField;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.Border;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public final class EntityDeclarationConfigurable
extends StateConfigurable<ProjectState>
implements SearchableConfigurable {
    public static final @NlsContexts.ConfigurableName String DISPLAY_NAME = ReBundle.message("DisplayName.entityDeclaration", new Object[0]);
    public static final String ID = "com.intellij.re.entityDeclaration";
    private Project project;
    private JBRadioButton protectedAccessModifier = new JBRadioButton(ReBundle.message("SettingsPage.accessModifierProtected", new Object[0]));
    private JBRadioButton privateAccessModifier = new JBRadioButton(ReBundle.message("SettingsPage.accessModifierPrivate", new Object[0]));
    private NameTemplatesTable nameTemplatesTable = new NameTemplatesTable();
    private JBCheckBox generateJpaOnGetter = new JBCheckBox();
    private JBCheckBox generateSerialVersionUID = new JBCheckBox();
    private JBCheckBox generateTypeOnEntity = new JBCheckBox();
    private JBCheckBox useConstantsForEntities = new JBCheckBox();
    private JBCheckBox useBuilderSetters = new JBCheckBox();
    private JBCheckBox useConstantsOnColumnName = new JBCheckBox();
    private JBCheckBox useConstantsOnEntityName = new JBCheckBox();
    private JBCheckBox useConstantsOnTableName = new JBCheckBox();
    private JBCheckBox lombokGetterAndSetter = new JBCheckBox();
    private JBCheckBox useLazy = new JBCheckBox();
    private JBCheckBox lombokToString = new JBCheckBox();
    private JBCheckBox lombokBuilderField = new JBCheckBox();
    private JBCheckBox lombokAllArgsConstructorField = new JBCheckBox();
    private JBCheckBox lombokNoArgsConstructorField = new JBCheckBox();
    private JBCheckBox lombokOnlyExplicitlyIncluded = new JBCheckBox();
    private JBTextField innerClassField = new JBTextField();
    private JBLabel interfaceLabel = EntityDeclarationConfigurable.createLeftInsetsLabel(ReBundle.message("SettingsPage.interfaceName", new Object[0]));
    private JBLabel classLabel = EntityDeclarationConfigurable.createLeftInsetsLabel(ReBundle.message("SettingsPage.className", new Object[0]));
    private JBLabel innerClassLabel = EntityDeclarationConfigurable.createLeftInsetsLabel(ReBundle.message("SettingsPage.innerClassName", new Object[0]));
    private ComboBox<ProjectState.ConstantGenerationStrategy> generationStrategy = new ComboBox();
    private ComboBox<ProjectState.ScaffoldingLanguage> scaffoldingLanguageCombo = new ComboBox();
    private ComboBox<ProjectState.NameCase> indexCaseCombo = new ComboBox();
    private EditorTextField interfaceField;
    private EditorTextField classField;
    private PersistenceUnitToPathTable persistenceUnitToPathTable;
    private JPanel decoratedTable;

    public EntityDeclarationConfigurable(Project project) {
        this.project = project;
        StreamEx.of((Object[])ProjectState.ConstantGenerationStrategy.values()).forEach(arg_0 -> this.generationStrategy.addItem(arg_0));
    }

    @NotNull
    protected ProjectState getState() {
        ProjectState projectState = JpaPluginProjectConfig.getInstance((Project)this.project).getState();
        if (projectState == null) {
            EntityDeclarationConfigurable.$$$reportNull$$$0(0);
        }
        return projectState;
    }

    protected void saveToState(@NotNull ProjectState state) {
        if (state == null) {
            EntityDeclarationConfigurable.$$$reportNull$$$0(1);
        }
        state.accessModifier = this.protectedAccessModifier.isSelected() ? FieldAccessModifier.PROTECTED : FieldAccessModifier.PRIVATE;
        this.nameTemplatesTable.saveState(state);
        state.generateJpaOnGetter = this.generateJpaOnGetter.isSelected();
        state.generateSerialVersionUID = this.generateSerialVersionUID.isSelected();
        state.generateTypeOnEntity = this.generateTypeOnEntity.isSelected();
        state.useConstantsForEntities = this.useConstantsForEntities.isSelected();
        state.useBuilderSetters = this.useBuilderSetters.isSelected();
        state.generationStrategy = (ProjectState.ConstantGenerationStrategy)this.generationStrategy.getSelectedItem();
        state.constantsOnColumnName = this.useConstantsOnColumnName.isSelected();
        state.useLazyOnToOneAssociations = this.useLazy.isSelected();
        state.constantsOnEntityName = this.useConstantsOnEntityName.isSelected();
        state.constantsOnTableName = this.useConstantsOnTableName.isSelected();
        state.isLombokGetterAndSetter = this.lombokGetterAndSetter.isSelected();
        state.isLombokToString = this.lombokToString.isSelected();
        state.isLombokOnlyExplicitlyIncluded = this.lombokOnlyExplicitlyIncluded.isSelected();
        state.isLombokBuilder = this.lombokBuilderField.isSelected();
        state.isLombokAllArgsConstructor = this.lombokAllArgsConstructorField.isSelected();
        state.isLombokNoArgsConstructor = this.lombokNoArgsConstructorField.isSelected();
        state.scaffoldingLanguage = (ProjectState.ScaffoldingLanguage)this.scaffoldingLanguageCombo.getSelectedItem();
        state.indexCase = (ProjectState.NameCase)this.indexCaseCombo.getItem();
        this.saveFieldsToState(state);
        this.saveUnits();
    }

    protected void loadFromState(@NotNull ProjectState state) {
        if (state == null) {
            EntityDeclarationConfigurable.$$$reportNull$$$0(2);
        }
        this.protectedAccessModifier.setSelected(state.accessModifier == FieldAccessModifier.PROTECTED);
        this.privateAccessModifier.setSelected(state.accessModifier == FieldAccessModifier.PRIVATE);
        this.nameTemplatesTable.loadFromState(state);
        this.generateJpaOnGetter.setSelected(state.generateJpaOnGetter);
        this.generateSerialVersionUID.setSelected(state.generateSerialVersionUID);
        this.generateTypeOnEntity.setSelected(state.generateTypeOnEntity);
        if (!DumbService.getInstance((Project)this.project).isDumb()) {
            ReadAction.nonBlocking(() -> PersistenceUnitLoader.getInstance((Project)this.project).getPersistenceUnitsWithConstantsClass()).finishOnUiThread(ModalityState.stateForComponent((Component)((Object)this.persistenceUnitToPathTable)), it -> this.persistenceUnitToPathTable.setItems((List<PersistenceUnit>)it)).submit((Executor)AppExecutorUtil.getAppExecutorService());
        }
        this.useConstantsForEntities.setSelected(state.useConstantsForEntities);
        this.useBuilderSetters.setSelected(state.useBuilderSetters);
        this.innerClassField.setText(state.innerClass);
        this.interfaceField.setText(state.singlePerProjectInterface);
        this.classField.setText(state.singlePerProjectClass);
        this.generationStrategy.setSelectedItem((Object)state.generationStrategy);
        this.scaffoldingLanguageCombo.setSelectedItem((Object)state.scaffoldingLanguage);
        this.useConstantsOnColumnName.setSelected(state.constantsOnColumnName);
        this.useConstantsOnEntityName.setSelected(state.constantsOnEntityName);
        this.useConstantsOnTableName.setSelected(state.constantsOnTableName);
        this.lombokGetterAndSetter.setSelected(state.isLombokGetterAndSetter);
        this.useLazy.setSelected(state.useLazyOnToOneAssociations);
        this.lombokToString.setSelected(state.isLombokToString);
        boolean isLombokBuilder = state.isLombokBuilder;
        this.lombokBuilderField.setSelected(isLombokBuilder);
        boolean isLombokAllArgsConstructor = state.isLombokAllArgsConstructor;
        this.lombokAllArgsConstructorField.setSelected(isLombokAllArgsConstructor);
        if (isLombokBuilder && isLombokAllArgsConstructor) {
            this.lombokAllArgsConstructorField.setEnabled(false);
        }
        boolean isLombokNoArgsConstructor = state.isLombokNoArgsConstructor;
        this.lombokNoArgsConstructorField.setSelected(isLombokNoArgsConstructor);
        if (isLombokAllArgsConstructor && isLombokNoArgsConstructor) {
            this.lombokNoArgsConstructorField.setEnabled(false);
        }
        this.lombokOnlyExplicitlyIncluded.setSelected(state.isLombokOnlyExplicitlyIncluded);
        this.lombokOnlyExplicitlyIncluded.setEnabled(this.lombokToString.isSelected());
        this.indexCaseCombo.setSelectedItem((Object)state.indexCase);
        this.constantsCheckBoxChanged();
    }

    @NotNull
    public JComponent createComponent() {
        this.interfaceField = this.initEditorField();
        this.classField = this.initEditorField();
        FormBuilder builder = FormBuilder.createFormBuilder();
        builder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.generateJpaOnGetter", new Object[0]), (JComponent)this.generateJpaOnGetter);
        builder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.generateSerialVersionUID", new Object[0]), (JComponent)this.generateSerialVersionUID);
        builder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.registerTypesOnEntity", new Object[0]), (JComponent)this.generateTypeOnEntity);
        builder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.useLazy", new Object[0]), (JComponent)this.useLazy);
        builder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.useBuilderSetters", new Object[0]), (JComponent)this.useBuilderSetters);
        this.generationStrategy.addItemListener(e -> this.validateConstantElements());
        ButtonGroup group = new ButtonGroup();
        group.add((AbstractButton)this.privateAccessModifier);
        group.add((AbstractButton)this.protectedAccessModifier);
        HorizontalBox radioButtonBox = new HorizontalBox();
        radioButtonBox.add((Component)this.privateAccessModifier);
        radioButtonBox.add(Box.createRigidArea((Dimension)new JBDimension(8, 0)));
        radioButtonBox.add((Component)this.protectedAccessModifier);
        if (JpaUtils.isKotlinSupport((Project)this.project)) {
            this.scaffoldingLanguageCombo.setModel((ComboBoxModel)new EnumComboBoxModel(ProjectState.ScaffoldingLanguage.class));
            builder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.generationLanguage", new Object[0]), this.scaffoldingLanguageCombo);
        }
        this.indexCaseCombo.setModel((ComboBoxModel)new EnumComboBoxModel(ProjectState.NameCase.class));
        builder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.accessModifier", new Object[0]), (JComponent)radioButtonBox);
        this.initNameTemplatesForm(builder);
        this.initLombokForm(builder);
        this.initConstantsForm(builder);
        this.decoratedTable = this.initTable();
        builder.addComponent((JComponent)this.decoratedTable);
        this.initModifyListeners();
        this.validateConstantElements();
        JPanel wrapPanel = new JPanel(new BorderLayout());
        wrapPanel.add((Component)builder.getPanel(), "North");
        JPanel jPanel = wrapPanel;
        if (jPanel == null) {
            EntityDeclarationConfigurable.$$$reportNull$$$0(3);
        }
        return jPanel;
    }

    private void initNameTemplatesForm(FormBuilder builder) {
        builder.addComponent((JComponent)new TitledSeparator(ReBundle.message("SettingsPage.templatesSeparator", new Object[0])));
        VerticalLayoutPanel nameTemplatePanel = new VerticalLayoutPanel();
        nameTemplatePanel.add((Component)new JBScrollPane((Component)((Object)this.nameTemplatesTable)));
        nameTemplatePanel.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.indexConstraintNameCase", new Object[0]), this.indexCaseCombo);
        builder.addComponent((JComponent)nameTemplatePanel);
    }

    private void initConstantsForm(FormBuilder builder) {
        builder.addComponent((JComponent)new TitledSeparator(ReBundle.message("SettingsPage.constantsSeparator", new Object[0])));
        FormBuilder constantGenerationBuilder = FormBuilder.createFormBuilder();
        constantGenerationBuilder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.putValuesIntoConstants", new Object[0]), (JComponent)this.useConstantsForEntities);
        constantGenerationBuilder.addLabeledComponent((JComponent)EntityDeclarationConfigurable.createLeftInsetsLabel(ReBundle.messageWithColon("SettingsPage.constants.entityNames", new Object[0])), (JComponent)this.useConstantsOnEntityName);
        constantGenerationBuilder.addLabeledComponent((JComponent)EntityDeclarationConfigurable.createLeftInsetsLabel(ReBundle.messageWithColon("SettingsPage.constants.tableNames", new Object[0])), (JComponent)this.useConstantsOnTableName);
        constantGenerationBuilder.addLabeledComponent((JComponent)EntityDeclarationConfigurable.createLeftInsetsLabel(ReBundle.messageWithColon("SettingsPage.constants.columnNames", new Object[0])), (JComponent)this.useConstantsOnColumnName);
        constantGenerationBuilder.addLabeledComponent((JComponent)EntityDeclarationConfigurable.createLeftInsetsLabel(ReBundle.messageWithColon("SettingsPage.placeToGenerate", new Object[0])), this.generationStrategy);
        constantGenerationBuilder.addLabeledComponent((JComponent)this.interfaceLabel, (JComponent)this.interfaceField);
        constantGenerationBuilder.addLabeledComponent((JComponent)this.classLabel, (JComponent)this.classField);
        constantGenerationBuilder.addLabeledComponent((JComponent)this.innerClassLabel, (JComponent)this.innerClassField);
        builder.addComponent((JComponent)constantGenerationBuilder.getPanel());
    }

    private void initLombokForm(FormBuilder builder) {
        builder.addComponent((JComponent)new TitledSeparator(ReBundle.message("SettingsPage.lombok.separator", new Object[0])));
        FormBuilder lombokBuilder = FormBuilder.createFormBuilder();
        lombokBuilder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.lombok.getterAndSetter", new Object[0]), (JComponent)this.lombokGetterAndSetter);
        lombokBuilder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.lombok.builder", new Object[0]), (JComponent)this.lombokBuilderField);
        lombokBuilder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.lombok.allArgsConstructor", new Object[0]), (JComponent)this.lombokAllArgsConstructorField);
        lombokBuilder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.lombok.noArgsConstructor", new Object[0]), (JComponent)this.lombokNoArgsConstructorField);
        lombokBuilder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.lombok.toString", new Object[0]), (JComponent)this.lombokToString);
        lombokBuilder.addLabeledComponent(ReBundle.messageWithColon("SettingsPage.lombok.onlyExplicitlyIncluded", new Object[0]), (JComponent)this.lombokOnlyExplicitlyIncluded);
        builder.addComponent((JComponent)lombokBuilder.getPanel());
    }

    public void apply() throws ConfigurationException {
        super.apply();
        this.nameTemplatesTable.loadFromState(this.getState());
    }

    private static JBLabel createLeftInsetsLabel(@NlsContexts.Label String caption) {
        JBLabel label = new JBLabel(caption);
        label.setBorder((Border)JBUI.Borders.emptyLeft((int)15));
        return label;
    }

    private JPanel initTable() {
        this.persistenceUnitToPathTable = new PersistenceUnitToPathTable(this.project);
        return ToolbarDecorator.createDecorator((JTable)((Object)this.persistenceUnitToPathTable)).setAddAction(anActionButton -> {
            ((PersistenceUnitToPathTableModel)this.persistenceUnitToPathTable.getModel()).addRow(new StudioTable.ValueWrapper((Object)new PersistenceUnit()));
            this.persistenceUnitToPathTable.changeSelection(this.persistenceUnitToPathTable.getRowCount() - 1, 0, false, false);
            this.persistenceUnitToPathTable.requestFocus();
            this.persistenceUnitToPathTable.editingStopped(null);
            this.persistenceUnitToPathTable.setEditingRow(this.persistenceUnitToPathTable.getRowCount() - 1);
        }).setRemoveAction(anActionButton -> this.persistenceUnitToPathTable.removeSelectedRows()).createPanel();
    }

    private EditorTextField initEditorField() {
        Document document = JavaReferenceEditorUtil.createDocument((String)"", (Project)this.project, (boolean)true, (JavaCodeFragment.VisibilityChecker)JavaCodeFragment.VisibilityChecker.PROJECT_SCOPE_VISIBLE);
        return new EditorTextField(document, this.project, (FileType)JavaFileType.INSTANCE);
    }

    private void constantsCheckBoxChanged() {
        boolean selected = this.useConstantsForEntities.isSelected();
        this.generationStrategy.setEnabled(selected);
        this.persistenceUnitToPathTable.setEnabled(selected);
        this.useConstantsOnEntityName.setEnabled(selected);
        this.useConstantsOnTableName.setEnabled(selected);
        this.useConstantsOnColumnName.setEnabled(selected);
        this.validateConstantElements();
    }

    private void validateConstantElements() {
        ProjectState.ConstantGenerationStrategy selectedItem = (ProjectState.ConstantGenerationStrategy)this.generationStrategy.getSelectedItem();
        this.setEnabledAndVisible((JComponent)this.innerClassField, selectedItem == ProjectState.ConstantGenerationStrategy.INNER_CLASS);
        this.setEnabledAndVisible((JComponent)this.innerClassLabel, selectedItem == ProjectState.ConstantGenerationStrategy.INNER_CLASS);
        this.setEnabledAndVisible((JComponent)this.interfaceField, selectedItem == ProjectState.ConstantGenerationStrategy.INTERFACE_PER_PROJECT);
        this.setEnabledAndVisible((JComponent)this.interfaceLabel, selectedItem == ProjectState.ConstantGenerationStrategy.INTERFACE_PER_PROJECT);
        this.setEnabledAndVisible(this.decoratedTable, selectedItem == ProjectState.ConstantGenerationStrategy.SINGLE_PER_UNIT);
        this.setEnabledAndVisible((JComponent)this.classField, selectedItem == ProjectState.ConstantGenerationStrategy.CLASS_PER_PROJECT);
        this.setEnabledAndVisible((JComponent)this.classLabel, selectedItem == ProjectState.ConstantGenerationStrategy.CLASS_PER_PROJECT);
    }

    private void setEnabledAndVisible(JComponent component, boolean enabled) {
        component.setVisible(enabled);
        component.setEnabled(this.useConstantsForEntities.isSelected() && enabled);
    }

    private void saveUnits() {
        if (this.useConstantsForEntities.isSelected() && this.generationStrategy.getSelectedItem() == ProjectState.ConstantGenerationStrategy.SINGLE_PER_UNIT) {
            PersistenceUnitLoader persistenceUnitLoader = PersistenceUnitLoader.getInstance((Project)this.project);
            StreamEx.of((Collection)persistenceUnitLoader.getPersistenceUnits()).forEach(unit -> {
                Optional first = StreamEx.of(this.persistenceUnitToPathTable.getItems()).findFirst(edited -> edited.getName().equals(unit.getName()));
                if (first.isPresent()) {
                    unit.setConstantClass(((PersistenceUnit)first.get()).getConstantClass());
                } else {
                    unit.setConstantClass("");
                }
                persistenceUnitLoader.savePersistenceUnit(unit.getName(), unit, null);
            });
            this.persistenceUnitToPathTable.getItems().forEach(unit -> persistenceUnitLoader.savePersistenceUnit(unit.getName(), unit, null));
        }
    }

    public boolean isModified() {
        return super.isModified() || this.nameTemplatesTable.isModified();
    }

    private void initModifyListeners() {
        this.generateJpaOnGetter.addActionListener(this.modifyListener);
        this.protectedAccessModifier.addActionListener(this.modifyListener);
        this.privateAccessModifier.addActionListener(this.modifyListener);
        this.generateSerialVersionUID.addActionListener(this.modifyListener);
        this.generateTypeOnEntity.addActionListener(this.modifyListener);
        this.useLazy.addActionListener(this.modifyListener);
        this.useConstantsForEntities.addActionListener(e -> {
            this.modifyListener.actionPerformed(e);
            this.constantsCheckBoxChanged();
        });
        this.persistenceUnitToPathTable.addModificationListener(this.modifyListener);
        this.innerClassField.addActionListener(this.modifyListener);
        this.generationStrategy.addActionListener(this.modifyListener);
        this.scaffoldingLanguageCombo.addActionListener(this.modifyListener);
        this.indexCaseCombo.addActionListener(this.modifyListener);
        DocumentListener documentListener = new DocumentListener(){

            public void documentChanged(@NotNull DocumentEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                EntityDeclarationConfigurable.this.modifyListener.actionPerformed(null);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/re/ui/settings/EntityDeclarationConfigurable$1", "documentChanged"));
            }
        };
        this.interfaceField.addDocumentListener(documentListener);
        this.classField.addDocumentListener(documentListener);
        this.useConstantsOnEntityName.addActionListener(this.modifyListener);
        this.useConstantsOnTableName.addActionListener(this.modifyListener);
        this.useConstantsOnColumnName.addActionListener(this.modifyListener);
        this.useBuilderSetters.addActionListener(this.modifyListener);
        this.lombokGetterAndSetter.addActionListener(this.modifyListener);
        this.lombokToString.addActionListener(e -> {
            this.modifyListener.actionPerformed(e);
            this.lombokOnlyExplicitlyIncluded.setEnabled(this.lombokToString.isSelected());
        });
        this.lombokBuilderField.addActionListener(this.modifyListener);
        this.lombokAllArgsConstructorField.addActionListener(this.modifyListener);
        this.lombokNoArgsConstructorField.addActionListener(this.modifyListener);
        this.lombokOnlyExplicitlyIncluded.addActionListener(this.modifyListener);
        LombokConstructorListener lombokConstructorListener = new LombokConstructorListener();
        this.lombokBuilderField.addActionListener((ActionListener)lombokConstructorListener);
        this.lombokAllArgsConstructorField.addActionListener((ActionListener)lombokConstructorListener);
    }

    private void saveFieldsToState(ProjectState state) {
        if (this.useConstantsForEntities.isSelected()) {
            switch ((ProjectState.ConstantGenerationStrategy)this.generationStrategy.getSelectedItem()) {
                case CLASS_PER_PROJECT: {
                    state.singlePerProjectClass = this.classField.getText();
                    break;
                }
                case INTERFACE_PER_PROJECT: {
                    state.singlePerProjectInterface = this.interfaceField.getText();
                    break;
                }
                case INNER_CLASS: {
                    state.innerClass = this.innerClassField.getText();
                }
            }
        }
    }

    protected void validate() throws ConfigurationException {
        if (this.useConstantsForEntities.isSelected()) {
            switch ((ProjectState.ConstantGenerationStrategy)this.generationStrategy.getSelectedItem()) {
                case SINGLE_PER_UNIT: {
                    boolean invalid = ContainerUtil.or(this.persistenceUnitToPathTable.getItems(), it -> it.getConstantClass().isEmpty());
                    if (!invalid) break;
                    throw new ConfigurationException(ReBundle.message("SettingsPage.constants.error", new Object[0]));
                }
                case CLASS_PER_PROJECT: {
                    if (StringUtil.isEmpty((String)this.classField.getText())) {
                        throw new ConfigurationException(ReBundle.message("SettingsPage.className.error", new Object[0]));
                    }
                    if (JavaPsiFacade.getInstance((Project)this.project).findClass(this.classField.getText(), GlobalSearchScope.projectScope((Project)this.project)) != null) break;
                    throw new ConfigurationException(ReBundle.message("SettingsPage.className.notFoundError", new Object[0]));
                }
                case INTERFACE_PER_PROJECT: {
                    if (StringUtil.isEmpty((String)this.interfaceField.getText())) {
                        throw new ConfigurationException(ReBundle.message("SettingsPage.className.error", new Object[0]));
                    }
                    PsiClass psiClass = JavaPsiFacade.getInstance((Project)this.project).findClass(this.interfaceField.getText(), GlobalSearchScope.projectScope((Project)this.project));
                    if (psiClass == null) {
                        throw new ConfigurationException(ReBundle.message("SettingsPage.className.notFoundError", new Object[0]));
                    }
                    if (psiClass.isInterface()) break;
                    throw new ConfigurationException(ReBundle.message("SettingsPage.interfaceName.notInterface", new Object[0]));
                }
                case INNER_CLASS: {
                    if (!StringUtil.isEmpty((String)this.innerClassField.getText())) break;
                    throw new ConfigurationException(ReBundle.message("SettingsPage.className.error", new Object[0]));
                }
            }
        }
    }

    public String getDisplayName() {
        return DISPLAY_NAME;
    }

    @NotNull
    public String getHelpTopic() {
        String string = JpaHelpConstants.PluginDoc.EntityDesignerSettings;
        if (string == null) {
            EntityDeclarationConfigurable.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getId() {
        return ID;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/re/ui/settings/EntityDeclarationConfigurable";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getState";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/re/ui/settings/EntityDeclarationConfigurable";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getHelpTopic";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "saveToState";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "loadFromState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    private class LombokConstructorListener
    implements ActionListener {
        private LombokConstructorListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == EntityDeclarationConfigurable.this.lombokBuilderField) {
                boolean isBuilder = EntityDeclarationConfigurable.this.lombokBuilderField.isSelected();
                EntityDeclarationConfigurable.this.lombokAllArgsConstructorField.setSelected(isBuilder);
                EntityDeclarationConfigurable.this.lombokAllArgsConstructorField.setEnabled(!isBuilder);
            }
            boolean isAllArgs = EntityDeclarationConfigurable.this.lombokAllArgsConstructorField.isSelected();
            EntityDeclarationConfigurable.this.lombokNoArgsConstructorField.setSelected(isAllArgs);
            EntityDeclarationConfigurable.this.lombokNoArgsConstructorField.setEnabled(!isAllArgs);
        }
    }
}

