/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.event;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.event.Key;
import org.jetbrains.letsPlot.commons.event.ModifierKey;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u00002\u00020\u0001B#\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B\u001d\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0002\u0010\tJ\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\u000e\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0006J\b\u0010\u0013\u001a\u00020\u0014H\u0016J'\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u00032\u0012\u0010\u0004\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u0005\"\u00020\u0006\u00a2\u0006\u0002\u0010\u0016J\u000e\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0000J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u00002\u0006\u0010\u0002\u001a\u00020\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/letsPlot/commons/event/KeyStroke;", "", "key", "Lorg/jetbrains/letsPlot/commons/event/Key;", "modifiers", "", "Lorg/jetbrains/letsPlot/commons/event/ModifierKey;", "(Lorg/jetbrains/letsPlot/commons/event/Key;[Lorg/jetbrains/letsPlot/commons/event/ModifierKey;)V", "", "(Lorg/jetbrains/letsPlot/commons/event/Key;Ljava/util/Collection;)V", "getKey", "()Lorg/jetbrains/letsPlot/commons/event/Key;", "", "getModifiers", "()Ljava/util/Set;", "equals", "", "other", "has", "hashCode", "", "is", "(Lorg/jetbrains/letsPlot/commons/event/Key;[Lorg/jetbrains/letsPlot/commons/event/ModifierKey;)Z", "matches", "keyStroke", "toString", "", "with", "commons"})
public final class KeyStroke {
    @NotNull
    private final Key key;
    @NotNull
    private final Set<ModifierKey> modifiers;

    @NotNull
    public final Key getKey() {
        return this.key;
    }

    @NotNull
    public final Set<ModifierKey> getModifiers() {
        return this.modifiers;
    }

    public KeyStroke(@NotNull Key key, ModifierKey ... modifiers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        this(key, ArraysKt.asList((Object[])modifiers));
    }

    public KeyStroke(@NotNull Key key, @NotNull Collection<? extends ModifierKey> modifiers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter(modifiers, (String)"modifiers");
        this.key = key;
        this.modifiers = new HashSet<ModifierKey>(modifiers);
    }

    public final boolean has(@NotNull ModifierKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        return this.modifiers.contains((Object)key);
    }

    public final boolean is(@NotNull Key key, ModifierKey ... modifiers) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        Intrinsics.checkNotNullParameter((Object)modifiers, (String)"modifiers");
        return this.matches(new KeyStroke(key, Arrays.copyOf(modifiers, modifiers.length)));
    }

    public final boolean matches(@NotNull KeyStroke keyStroke) {
        Intrinsics.checkNotNullParameter((Object)keyStroke, (String)"keyStroke");
        return this.equals(keyStroke);
    }

    @NotNull
    public final KeyStroke with(@NotNull ModifierKey key) {
        Intrinsics.checkNotNullParameter((Object)((Object)key), (String)"key");
        HashSet<ModifierKey> keys = new HashSet<ModifierKey>((Collection)this.modifiers);
        keys.add(key);
        return new KeyStroke(this.key, (Collection<? extends ModifierKey>)keys);
    }

    public int hashCode() {
        return this.key.hashCode() * 31 + ((Object)this.modifiers).hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof KeyStroke)) {
            return false;
        }
        KeyStroke otherKeyStroke = (KeyStroke)other;
        return this.key == otherKeyStroke.key && Intrinsics.areEqual(this.modifiers, otherKeyStroke.modifiers);
    }

    @NotNull
    public String toString() {
        return "" + (Object)((Object)this.key) + ' ' + this.modifiers;
    }
}

