/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.commons.markdown;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.letsPlot.commons.markdown.Lexer;
import org.jetbrains.letsPlot.commons.markdown.Parser;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0003\u0018\u0019\u001aB\u0015\b\u0002\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u0010\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\u000b\u001a\u00020\t2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\f\u001a\u00020\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u001e\u0010\r\u001a\u00020\u00072\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\b\u001a\u00020\tH\u0002J\u001c\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000fH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00100\u0003H\u0002J.\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u000f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\b\b\u0002\u0010\u0017\u001a\u00020\tH\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser;", "", "tokens", "", "Lorg/jetbrains/letsPlot/commons/markdown/Lexer$Token;", "(Ljava/util/List;)V", "canCloseEmphasis", "", "index", "", "canOpenEmphasis", "delimiterRunLength", "isLeftFlankingDelimiterRun", "isRightFlankingDelimiterRun", "joinTextNodes", "", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node;", "nodes", "parse", "processEmphasis", "", "delimiters", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$DelimiterRun;", "stackBottom", "Companion", "DelimiterRun", "Node", "commons"})
@SourceDebugExtension(value={"SMAP\nParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Parser.kt\norg/jetbrains/letsPlot/commons/markdown/Parser\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,305:1\n1#2:306\n350#3,7:307\n350#3,7:314\n*S KotlinDebug\n*F\n+ 1 Parser.kt\norg/jetbrains/letsPlot/commons/markdown/Parser\n*L\n130#1:307,7\n131#1:314,7\n*E\n"})
public final class Parser {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Lexer.Token> tokens;

    private Parser(List<Lexer.Token> tokens) {
        this.tokens = tokens;
    }

    private final List<Node> parse() {
        List delimiters = new ArrayList();
        List nodes = new ArrayList();
        int i = 0;
        block9: while (i < this.tokens.size()) {
            Lexer.Token token = this.tokens.get(i);
            switch (WhenMappings.$EnumSwitchMapping$0[token.getType().ordinal()]) {
                case 4: {
                    ((Collection)nodes).add(Node.LineBreak.INSTANCE);
                    int n = i;
                    i = n + 1;
                    continue block9;
                }
                case 5: {
                    ((Collection)nodes).add(Node.SoftBreak.INSTANCE);
                    int n = i;
                    i = n + 1;
                    continue block9;
                }
                case 3: {
                    Node.Text text2;
                    Lexer.Token nextToken2 = (Lexer.Token)CollectionsKt.getOrNull(this.tokens, (int)(i + 1));
                    Collection collection = nodes;
                    if (nextToken2 == null) {
                        Node.Text text3;
                        Node.Text it = text3 = new Node.Text(token.getValue());
                        boolean bl = false;
                        ++i;
                        text2 = text3;
                    } else {
                        switch (WhenMappings.$EnumSwitchMapping$0[nextToken2.getType().ordinal()]) {
                            case 1: 
                            case 2: 
                            case 3: {
                                Node.Text text4;
                                Node.Text it = text4 = new Node.Text(nextToken2.getValue());
                                boolean bl = false;
                                i += 2;
                                text2 = text4;
                                break;
                            }
                            default: {
                                Node.Text text5;
                                Node.Text it = text5 = new Node.Text(token.getValue());
                                boolean bl = false;
                                ++i;
                                text2 = text5;
                            }
                        }
                    }
                    Node.Text text6 = text2;
                    collection.add(text6);
                    continue block9;
                }
                case 1: 
                case 2: {
                    int count = this.delimiterRunLength(this.tokens, i);
                    boolean canOpen = this.canOpenEmphasis(i);
                    boolean canClose = this.canCloseEmphasis(i);
                    Node.Text text7 = new Node.Text(StringsKt.repeat((CharSequence)token.getValue(), (int)count));
                    ((Collection)nodes).add(text7);
                    if (canOpen || canClose) {
                        ((Collection)delimiters).add(new DelimiterRun(token.getType(), text7, count, false, canOpen, canClose, 8, null));
                    }
                    i += count;
                    continue block9;
                }
            }
            ((Collection)nodes).add(new Node.Text(token.getValue()));
            int n = i;
            i = n + 1;
        }
        if (delimiters.size() > 1) {
            Parser.processEmphasis$default(this, delimiters, nodes, 0, 4, null);
        }
        return this.joinTextNodes(nodes);
    }

    private final List<Node> joinTextNodes(List<Node> nodes) {
        Node currentTextNode = null;
        int i = 0;
        while (i < nodes.size()) {
            String string;
            Node.Text text2;
            Node.Text node;
            Node node2 = nodes.get(i);
            Node.Text text3 = node = node2 instanceof Node.Text ? (Node.Text)node2 : null;
            if (node == null) {
                Node it = node2 = null;
                boolean bl = false;
                ++i;
                currentTextNode = node2;
                continue;
            }
            if (currentTextNode == null) {
                Node.Text it = text2 = node;
                boolean bl = false;
                ++i;
                currentTextNode = text2;
                continue;
            }
            text2 = currentTextNode;
            String bl = string = node.getText();
            StringBuilder stringBuilder = new StringBuilder().append(text2.getText());
            Node.Text text4 = text2;
            boolean bl2 = false;
            nodes.remove(i);
            Unit unit = Unit.INSTANCE;
            text4.setText(stringBuilder.append(string).toString());
        }
        return nodes;
    }

    private final void processEmphasis(List<DelimiterRun> delimiters, List<Node> nodes, int stackBottom) {
        if (delimiters.isEmpty()) {
            return;
        }
        Map openersBottom = new LinkedHashMap();
        int closerPosition = stackBottom;
        Object closer = null;
        closer = CollectionsKt.getOrNull(delimiters, (int)closerPosition);
        while (closer != null) {
            if (((DelimiterRun)closer).getCanClose()) {
                Object object;
                int openerBottomIndex = ((DelimiterRun)closer).getTokenType().ordinal() * 10 + (((DelimiterRun)closer).getCanOpen() ? 3 : 0) + ((DelimiterRun)closer).getCount() % 3;
                int openerPosition = closerPosition - 1;
                Object opener = null;
                opener = CollectionsKt.getOrNull(delimiters, (int)openerPosition);
                boolean openerFound = false;
                while (opener != null) {
                    Integer n = (Integer)openersBottom.get(openerBottomIndex);
                    if (openerPosition < (n != null ? n : stackBottom)) break;
                    if (((DelimiterRun)opener).getCanOpen() && ((DelimiterRun)opener).getTokenType() == ((DelimiterRun)closer).getTokenType() && (!((DelimiterRun)closer).getCanOpen() && !((DelimiterRun)opener).getCanClose() || ((DelimiterRun)closer).getCount() % 3 == 0 || (((DelimiterRun)opener).getCount() + ((DelimiterRun)closer).getCount()) % 3 != 0)) {
                        openerFound = true;
                        break;
                    }
                    opener = CollectionsKt.getOrNull(delimiters, (int)(--openerPosition));
                }
                if (openerFound) {
                    int n;
                    int n2;
                    List<Node> list2;
                    boolean strong;
                    block14: {
                        int n3;
                        boolean bl;
                        Node it;
                        List<Node> $this$indexOfFirst$iv;
                        int index$iv;
                        boolean $i$f$indexOfFirst;
                        block13: {
                            Object object2 = opener;
                            Intrinsics.checkNotNull((Object)object2);
                            strong = ((DelimiterRun)object2).getCount() >= 2 && ((DelimiterRun)closer).getCount() >= 2;
                            object = nodes;
                            list2 = nodes;
                            $i$f$indexOfFirst = false;
                            index$iv = 0;
                            for (Object e : $this$indexOfFirst$iv) {
                                it = (Node)e;
                                bl = false;
                                if (it == ((DelimiterRun)opener).getNode()) {
                                    n3 = index$iv;
                                    break block13;
                                }
                                ++index$iv;
                            }
                            n3 = -1;
                        }
                        n2 = n3;
                        list2.add(n2 + 1, strong ? (Node)Node.Strong.INSTANCE : (Node)Node.Em.INSTANCE);
                        $this$indexOfFirst$iv = nodes;
                        list2 = nodes;
                        $i$f$indexOfFirst = false;
                        index$iv = 0;
                        for (Object object3 : $this$indexOfFirst$iv) {
                            it = (Node)object3;
                            bl = false;
                            if (it == ((DelimiterRun)closer).getNode()) {
                                n = index$iv;
                                break block14;
                            }
                            ++index$iv;
                        }
                        n = -1;
                    }
                    n2 = n;
                    list2.add(n2, strong ? (Node)Node.CloseStrong.INSTANCE : (Node)Node.CloseEm.INSTANCE);
                    ((DelimiterRun)opener).shrink(strong);
                    ((DelimiterRun)closer).shrink(strong);
                    if (((DelimiterRun)opener).getCount() == 0) {
                        delimiters.remove(opener);
                        nodes.remove(((DelimiterRun)opener).getNode());
                    }
                    if (((DelimiterRun)closer).getCount() == 0) {
                        delimiters.remove(closer);
                        nodes.remove(((DelimiterRun)closer).getNode());
                    }
                    closer = CollectionsKt.getOrNull(delimiters, (int)(--closerPosition));
                    continue;
                }
                object = openerBottomIndex;
                Integer n = closerPosition;
                openersBottom.put(object, n);
                if (!((DelimiterRun)closer).getCanOpen()) {
                    delimiters.remove(closer);
                }
                closer = CollectionsKt.getOrNull(delimiters, (int)(++closerPosition));
                continue;
            }
            closer = CollectionsKt.getOrNull(delimiters, (int)(++closerPosition));
        }
    }

    static /* synthetic */ void processEmphasis$default(Parser parser, List list2, List list3, int n, int n2, Object object) {
        if ((n2 & 4) != 0) {
            n = 0;
        }
        parser.processEmphasis(list2, list3, n);
    }

    private final int delimiterRunLength(List<Lexer.Token> tokens, int index) {
        Lexer.TokenType type = tokens.get(index).getType();
        return SequencesKt.count((Sequence)SequencesKt.takeWhile((Sequence)SequencesKt.drop((Sequence)CollectionsKt.asSequence((Iterable)tokens), (int)index), (Function1)((Function1)new Function1<Lexer.Token, Boolean>(type){
            final /* synthetic */ Lexer.TokenType $type;
            {
                this.$type = $type;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull Lexer.Token it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return it.getType() == this.$type;
            }
        })));
    }

    private final boolean canOpenEmphasis(int index) {
        Lexer.TokenType token = this.tokens.get(index).getType();
        boolean leftFlankingDelimiterRun = this.isLeftFlankingDelimiterRun(this.tokens, index);
        if (token == Lexer.TokenType.ASTERISK) {
            return leftFlankingDelimiterRun;
        }
        if (token == Lexer.TokenType.UNDERSCORE) {
            boolean rightFlankingDelimiterRun = this.isRightFlankingDelimiterRun(this.tokens, index);
            Lexer.Token token2 = (Lexer.Token)CollectionsKt.getOrNull(this.tokens, (int)(index - 1));
            boolean precededByPunctuation = (token2 != null ? token2.getType() : null) == Lexer.TokenType.PUNCTUATION;
            boolean res = leftFlankingDelimiterRun && (!rightFlankingDelimiterRun || rightFlankingDelimiterRun && precededByPunctuation);
            return res;
        }
        return false;
    }

    private final boolean canCloseEmphasis(int index) {
        Lexer.TokenType token = this.tokens.get(index).getType();
        boolean rightFlankingDelimiterRun = this.isRightFlankingDelimiterRun(this.tokens, index);
        if (token == Lexer.TokenType.ASTERISK) {
            return rightFlankingDelimiterRun;
        }
        if (token == Lexer.TokenType.UNDERSCORE) {
            boolean leftFlankingDelimiterRun = this.isLeftFlankingDelimiterRun(this.tokens, index);
            int length = this.delimiterRunLength(this.tokens, index);
            Lexer.Token token2 = (Lexer.Token)CollectionsKt.getOrNull(this.tokens, (int)(index + length));
            boolean followedByPunctuation = (token2 != null ? token2.getType() : null) == Lexer.TokenType.PUNCTUATION;
            boolean res = rightFlankingDelimiterRun && (!leftFlankingDelimiterRun || leftFlankingDelimiterRun && followedByPunctuation);
            return res;
        }
        return false;
    }

    private final boolean isLeftFlankingDelimiterRun(List<Lexer.Token> tokens, int index) {
        Object nextTokenType;
        int runLength = this.delimiterRunLength(tokens, index);
        Object object = (Lexer.Token)CollectionsKt.getOrNull(tokens, (int)(index + runLength));
        if (object == null || (object = object.getType()) == null) {
            object = Lexer.TokenType.WHITE_SPACE;
        }
        if ((nextTokenType = object) == Lexer.TokenType.WHITE_SPACE) {
            return false;
        }
        if (nextTokenType != Lexer.TokenType.PUNCTUATION) {
            return true;
        }
        if (nextTokenType == Lexer.TokenType.PUNCTUATION) {
            Object prevTokenType;
            Object object2 = (Lexer.Token)CollectionsKt.getOrNull(tokens, (int)(index - 1));
            if (object2 == null || (object2 = object2.getType()) == null) {
                object2 = Lexer.TokenType.WHITE_SPACE;
            }
            if ((prevTokenType = object2) == Lexer.TokenType.WHITE_SPACE || prevTokenType == Lexer.TokenType.PUNCTUATION) {
                return true;
            }
        }
        return false;
    }

    private final boolean isRightFlankingDelimiterRun(List<Lexer.Token> tokens, int index) {
        Object prevTokenType;
        int runLength = this.delimiterRunLength(tokens, index);
        Object object = (Lexer.Token)CollectionsKt.getOrNull(tokens, (int)(index - 1));
        if (object == null || (object = object.getType()) == null) {
            object = Lexer.TokenType.WHITE_SPACE;
        }
        if ((prevTokenType = object) == Lexer.TokenType.WHITE_SPACE) {
            return false;
        }
        if (prevTokenType != Lexer.TokenType.PUNCTUATION) {
            return true;
        }
        if (prevTokenType == Lexer.TokenType.PUNCTUATION) {
            Object nextTokenType;
            Object object2 = (Lexer.Token)CollectionsKt.getOrNull(tokens, (int)(index + runLength));
            if (object2 == null || (object2 = object2.getType()) == null) {
                object2 = Lexer.TokenType.WHITE_SPACE;
            }
            if ((nextTokenType = object2) == Lexer.TokenType.WHITE_SPACE || nextTokenType == Lexer.TokenType.PUNCTUATION) {
                return true;
            }
        }
        return false;
    }

    public /* synthetic */ Parser(List tokens, DefaultConstructorMarker $constructor_marker) {
        this(tokens);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser$Companion;", "", "()V", "parse", "", "tokens", "", "Lorg/jetbrains/letsPlot/commons/markdown/Lexer$Token;", "commons"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String parse(@NotNull List<Lexer.Token> tokens) {
            Intrinsics.checkNotNullParameter(tokens, (String)"tokens");
            List nodes = new Parser(tokens, null).parse();
            return CollectionsKt.joinToString$default((Iterable)nodes, (CharSequence)"", null, null, (int)0, null, (Function1)parse.1.INSTANCE, (int)30, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0012\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u0012\u0006\u0010\u000b\u001a\u00020\t\u00a2\u0006\u0002\u0010\fJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\tJ\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u000b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000eR\u0011\u0010\n\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000eR\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006 "}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser$DelimiterRun;", "", "tokenType", "Lorg/jetbrains/letsPlot/commons/markdown/Lexer$TokenType;", "node", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$Text;", "count", "", "active", "", "canOpen", "canClose", "(Lorg/jetbrains/letsPlot/commons/markdown/Lexer$TokenType;Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$Text;IZZZ)V", "getActive", "()Z", "setActive", "(Z)V", "getCanClose", "getCanOpen", "getCount", "()I", "setCount", "(I)V", "getNode", "()Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$Text;", "getTokenType", "()Lorg/jetbrains/letsPlot/commons/markdown/Lexer$TokenType;", "shrink", "", "bool", "toString", "", "commons"})
    public static final class DelimiterRun {
        @NotNull
        private final Lexer.TokenType tokenType;
        @NotNull
        private final Node.Text node;
        private int count;
        private boolean active;
        private final boolean canOpen;
        private final boolean canClose;

        public DelimiterRun(@NotNull Lexer.TokenType tokenType, @NotNull Node.Text node, int count, boolean active, boolean canOpen, boolean canClose) {
            Intrinsics.checkNotNullParameter((Object)((Object)tokenType), (String)"tokenType");
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            this.tokenType = tokenType;
            this.node = node;
            this.count = count;
            this.active = active;
            this.canOpen = canOpen;
            this.canClose = canClose;
        }

        public /* synthetic */ DelimiterRun(Lexer.TokenType tokenType, Node.Text text2, int n, boolean bl, boolean bl2, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 8) != 0) {
                bl = true;
            }
            this(tokenType, text2, n, bl, bl2, bl3);
        }

        @NotNull
        public final Lexer.TokenType getTokenType() {
            return this.tokenType;
        }

        @NotNull
        public final Node.Text getNode() {
            return this.node;
        }

        public final int getCount() {
            return this.count;
        }

        public final void setCount(int n) {
            this.count = n;
        }

        public final boolean getActive() {
            return this.active;
        }

        public final void setActive(boolean bl) {
            this.active = bl;
        }

        public final boolean getCanOpen() {
            return this.canOpen;
        }

        public final boolean getCanClose() {
            return this.canClose;
        }

        public final void shrink(boolean bool) {
            int toDrop = RangesKt.coerceAtMost((int)(bool ? 2 : 1), (int)this.count);
            this.count -= toDrop;
            this.node.setText(StringsKt.dropLast((String)this.node.getText(), (int)toDrop));
        }

        @NotNull
        public String toString() {
            return "DelimiterRun(tokenType=" + (Object)((Object)this.tokenType) + ", node=" + this.node + ", count=" + this.count + ", active=" + this.active + ", opener=" + this.canOpen + ", closer=" + this.canClose + ')';
        }
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0007\u0003\u0004\u0005\u0006\u0007\b\tB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0007\n\u000b\f\r\u000e\u000f\u0010\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node;", "", "()V", "CloseEm", "CloseStrong", "Em", "LineBreak", "SoftBreak", "Strong", "Text", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$CloseEm;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$CloseStrong;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$Em;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$LineBreak;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$SoftBreak;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$Strong;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$Text;", "commons"})
    public static abstract class Node {
        private Node() {
        }

        public /* synthetic */ Node(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$CloseEm;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "commons"})
        public static final class CloseEm
        extends Node {
            @NotNull
            public static final CloseEm INSTANCE = new CloseEm();

            private CloseEm() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "CloseEm";
            }

            public int hashCode() {
                return -430940131;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CloseEm)) {
                    return false;
                }
                CloseEm cfr_ignored_0 = (CloseEm)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$CloseStrong;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "commons"})
        public static final class CloseStrong
        extends Node {
            @NotNull
            public static final CloseStrong INSTANCE = new CloseStrong();

            private CloseStrong() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "CloseStrong";
            }

            public int hashCode() {
                return -1590360180;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof CloseStrong)) {
                    return false;
                }
                CloseStrong cfr_ignored_0 = (CloseStrong)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$Em;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "commons"})
        public static final class Em
        extends Node {
            @NotNull
            public static final Em INSTANCE = new Em();

            private Em() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Em";
            }

            public int hashCode() {
                return -372109525;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Em)) {
                    return false;
                }
                Em cfr_ignored_0 = (Em)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$LineBreak;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "commons"})
        public static final class LineBreak
        extends Node {
            @NotNull
            public static final LineBreak INSTANCE = new LineBreak();

            private LineBreak() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "LineBreak";
            }

            public int hashCode() {
                return 1138378120;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof LineBreak)) {
                    return false;
                }
                LineBreak cfr_ignored_0 = (LineBreak)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$SoftBreak;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "commons"})
        public static final class SoftBreak
        extends Node {
            @NotNull
            public static final SoftBreak INSTANCE = new SoftBreak();

            private SoftBreak() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "SoftBreak";
            }

            public int hashCode() {
                return 862401298;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof SoftBreak)) {
                    return false;
                }
                SoftBreak cfr_ignored_0 = (SoftBreak)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\n\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006H\u00d6\u0003J\t\u0010\u0007\u001a\u00020\bH\u00d6\u0001J\t\u0010\t\u001a\u00020\nH\u00d6\u0001\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$Strong;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node;", "()V", "equals", "", "other", "", "hashCode", "", "toString", "", "commons"})
        public static final class Strong
        extends Node {
            @NotNull
            public static final Strong INSTANCE = new Strong();

            private Strong() {
                super(null);
            }

            @NotNull
            public String toString() {
                return "Strong";
            }

            public int hashCode() {
                return -1626570854;
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Strong)) {
                    return false;
                }
                Strong cfr_ignored_0 = (Strong)other;
                return true;
            }
        }

        @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node$Text;", "Lorg/jetbrains/letsPlot/commons/markdown/Parser$Node;", "text", "", "(Ljava/lang/String;)V", "getText", "()Ljava/lang/String;", "setText", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "commons"})
        public static final class Text
        extends Node {
            @NotNull
            private String text;

            public Text(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                super(null);
                this.text = text2;
            }

            @NotNull
            public final String getText() {
                return this.text;
            }

            public final void setText(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
                this.text = string;
            }

            @NotNull
            public final String component1() {
                return this.text;
            }

            @NotNull
            public final Text copy(@NotNull String text2) {
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                return new Text(text2);
            }

            public static /* synthetic */ Text copy$default(Text text2, String string, int n, Object object) {
                if ((n & 1) != 0) {
                    string = text2.text;
                }
                return text2.copy(string);
            }

            @NotNull
            public String toString() {
                return "Text(text=" + this.text + ')';
            }

            public int hashCode() {
                return this.text.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof Text)) {
                    return false;
                }
                Text text2 = (Text)other;
                return Intrinsics.areEqual((Object)this.text, (Object)text2.text);
            }
        }
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Lexer.TokenType.values().length];
            try {
                nArray[Lexer.TokenType.ASTERISK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lexer.TokenType.UNDERSCORE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lexer.TokenType.BACKSLASH.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lexer.TokenType.LINE_BREAK.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Lexer.TokenType.SOFT_BREAK.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

