/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.letsPlot.core.plot.builder.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.letsPlot.commons.geometry.DoubleRectangle;
import org.jetbrains.letsPlot.commons.geometry.DoubleVector;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendArrangement;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendBoxJustification;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendJustification;
import org.jetbrains.letsPlot.core.plot.base.guide.LegendPosition;
import org.jetbrains.letsPlot.core.plot.base.theme.LegendTheme;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxInfo;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendBoxesLayout;
import org.jetbrains.letsPlot.core.plot.builder.layout.LegendsBlockInfo;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\b\u001a\u00020\tJ,\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J&\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ.\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cJ,\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000b0\u00062\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006!"}, d2={"Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxesLayoutUtil;", "", "()V", "arrangeLegendBoxes", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendsBlockInfo;", "infos", "", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxInfo;", "theme", "Lorg/jetbrains/letsPlot/core/plot/base/theme/LegendTheme;", "horizontalStack", "Lorg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxesLayout$BoxWithLocation;", "boxInfos", "spacing", "", "boxJustification", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendBoxJustification;", "legendBoxJustification", "legendArrangement", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendArrangement;", "overlayLegendOriginInsidePlot", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleVector;", "plotBounds", "Lorg/jetbrains/letsPlot/commons/geometry/DoubleRectangle;", "legendSize", "legendPosition", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendPosition;", "legendJustification", "Lorg/jetbrains/letsPlot/core/plot/base/guide/LegendJustification;", "overlayLegendOriginOutsidePlot", "innerBounds", "outerBounds", "verticalStack", "plot-builder"})
@SourceDebugExtension(value={"SMAP\nLegendBoxesLayoutUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LegendBoxesLayoutUtil.kt\norg/jetbrains/letsPlot/core/plot/builder/layout/LegendBoxesLayoutUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,143:1\n1#2:144\n*E\n"})
public final class LegendBoxesLayoutUtil {
    @NotNull
    public static final LegendBoxesLayoutUtil INSTANCE = new LegendBoxesLayoutUtil();

    private LegendBoxesLayoutUtil() {
    }

    @NotNull
    public final LegendsBlockInfo arrangeLegendBoxes(@NotNull List<? extends LegendBoxInfo> infos, @NotNull LegendTheme theme) {
        List<LegendBoxesLayout.BoxWithLocation> list2;
        Intrinsics.checkNotNullParameter(infos, (String)"infos");
        Intrinsics.checkNotNullParameter((Object)theme, (String)"theme");
        LegendArrangement legendArrangement = theme.boxArrangement();
        LegendBoxJustification legendBoxJustification = this.legendBoxJustification(theme.boxJustification(), legendArrangement);
        switch (WhenMappings.$EnumSwitchMapping$0[legendArrangement.ordinal()]) {
            case 1: {
                list2 = this.verticalStack(infos, theme.spacing().getY(), legendBoxJustification);
                break;
            }
            case 2: {
                list2 = this.horizontalStack(infos, theme.spacing().getX(), legendBoxJustification);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        List<LegendBoxesLayout.BoxWithLocation> boxWithLocationList = list2;
        return new LegendsBlockInfo(boxWithLocationList);
    }

    private final LegendBoxJustification legendBoxJustification(LegendBoxJustification legendBoxJustification, LegendArrangement legendArrangement) {
        LegendBoxJustification legendBoxJustification2;
        block5: {
            block4: {
                if (legendBoxJustification != LegendBoxJustification.AUTO) break block4;
                switch (WhenMappings.$EnumSwitchMapping$0[legendArrangement.ordinal()]) {
                    case 1: {
                        legendBoxJustification2 = LegendBoxJustification.LEFT;
                        break block5;
                    }
                    case 2: {
                        legendBoxJustification2 = LegendBoxJustification.TOP;
                        break block5;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            legendBoxJustification2 = legendBoxJustification;
        }
        return legendBoxJustification2;
    }

    private final List<LegendBoxesLayout.BoxWithLocation> verticalStack(List<? extends LegendBoxInfo> boxInfos, double spacing, LegendBoxJustification boxJustification) {
        Double d;
        ArrayList<LegendBoxesLayout.BoxWithLocation> result2 = new ArrayList<LegendBoxesLayout.BoxWithLocation>();
        double y2 = 0.0;
        Iterator iterator2 = ((Iterable)boxInfos).iterator();
        if (!iterator2.hasNext()) {
            d = null;
        } else {
            LegendBoxInfo it = (LegendBoxInfo)iterator2.next();
            boolean bl = false;
            double d2 = it.getSize$plot_builder().getX();
            while (iterator2.hasNext()) {
                LegendBoxInfo it2 = (LegendBoxInfo)iterator2.next();
                boolean bl2 = false;
                double d3 = it2.getSize$plot_builder().getX();
                d2 = Math.max(d2, d3);
            }
            d = d2;
        }
        double boxWidth = d != null ? d : 0.0;
        for (LegendBoxInfo legendBoxInfo : boxInfos) {
            double d2;
            switch (WhenMappings.$EnumSwitchMapping$1[boxJustification.ordinal()]) {
                case 1: {
                    d2 = 0.0;
                    break;
                }
                case 2: {
                    d2 = boxWidth - legendBoxInfo.getSize$plot_builder().getX();
                    break;
                }
                default: {
                    d2 = (boxWidth - legendBoxInfo.getSize$plot_builder().getX()) / (double)2;
                }
            }
            double x2 = d2;
            result2.add(new LegendBoxesLayout.BoxWithLocation(legendBoxInfo, new DoubleVector(x2, y2)));
            y2 += legendBoxInfo.getSize$plot_builder().getY() + spacing;
        }
        return result2;
    }

    private final List<LegendBoxesLayout.BoxWithLocation> horizontalStack(List<? extends LegendBoxInfo> boxInfos, double spacing, LegendBoxJustification boxJustification) {
        Double d;
        ArrayList<LegendBoxesLayout.BoxWithLocation> result2 = new ArrayList<LegendBoxesLayout.BoxWithLocation>();
        double x2 = 0.0;
        Iterator iterator2 = ((Iterable)boxInfos).iterator();
        if (!iterator2.hasNext()) {
            d = null;
        } else {
            LegendBoxInfo it = (LegendBoxInfo)iterator2.next();
            boolean bl = false;
            double d2 = it.getSize$plot_builder().getY();
            while (iterator2.hasNext()) {
                LegendBoxInfo it2 = (LegendBoxInfo)iterator2.next();
                boolean bl2 = false;
                double d3 = it2.getSize$plot_builder().getY();
                d2 = Math.max(d2, d3);
            }
            d = d2;
        }
        double boxHeight = d != null ? d : 0.0;
        for (LegendBoxInfo legendBoxInfo : boxInfos) {
            double d2;
            switch (WhenMappings.$EnumSwitchMapping$1[boxJustification.ordinal()]) {
                case 3: {
                    d2 = 0.0;
                    break;
                }
                case 4: {
                    d2 = boxHeight - legendBoxInfo.getSize$plot_builder().getY();
                    break;
                }
                default: {
                    d2 = (boxHeight - legendBoxInfo.getSize$plot_builder().getY()) / (double)2;
                }
            }
            double y2 = d2;
            result2.add(new LegendBoxesLayout.BoxWithLocation(legendBoxInfo, new DoubleVector(x2, y2)));
            x2 += legendBoxInfo.getSize$plot_builder().getX() + spacing;
        }
        return result2;
    }

    @NotNull
    public final DoubleVector overlayLegendOriginInsidePlot(@NotNull DoubleRectangle plotBounds, @NotNull DoubleVector legendSize, @NotNull LegendPosition legendPosition, @NotNull LegendJustification legendJustification) {
        Intrinsics.checkNotNullParameter((Object)plotBounds, (String)"plotBounds");
        Intrinsics.checkNotNullParameter((Object)legendSize, (String)"legendSize");
        Intrinsics.checkNotNullParameter((Object)legendPosition, (String)"legendPosition");
        Intrinsics.checkNotNullParameter((Object)legendJustification, (String)"legendJustification");
        DoubleVector plotSize2 = plotBounds.getDimension();
        DoubleVector absolutePosition = new DoubleVector(plotBounds.getLeft() + plotSize2.getX() * legendPosition.getX(), plotBounds.getBottom() - plotSize2.getY() * legendPosition.getY());
        DoubleVector originOffset = new DoubleVector(-legendSize.getX() * legendJustification.getX(), legendSize.getY() * legendJustification.getY() - legendSize.getY());
        return absolutePosition.add(originOffset);
    }

    @NotNull
    public final DoubleVector overlayLegendOriginOutsidePlot(@NotNull DoubleRectangle innerBounds, @NotNull DoubleRectangle outerBounds, @NotNull DoubleVector legendSize, @NotNull LegendPosition legendPosition, @NotNull LegendJustification legendJustification) {
        DoubleVector doubleVector;
        Intrinsics.checkNotNullParameter((Object)innerBounds, (String)"innerBounds");
        Intrinsics.checkNotNullParameter((Object)outerBounds, (String)"outerBounds");
        Intrinsics.checkNotNullParameter((Object)legendSize, (String)"legendSize");
        Intrinsics.checkNotNullParameter((Object)legendPosition, (String)"legendPosition");
        Intrinsics.checkNotNullParameter((Object)legendJustification, (String)"legendJustification");
        LegendPosition legendPosition2 = legendPosition;
        if (Intrinsics.areEqual((Object)legendPosition2, (Object)LegendPosition.Companion.getLEFT()) ? true : Intrinsics.areEqual((Object)legendPosition2, (Object)LegendPosition.Companion.getRIGHT())) {
            double y2 = innerBounds.getTop() + (innerBounds.getHeight() - legendSize.getY()) * (1.0 - legendJustification.getY());
            double x2 = Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getLEFT()) ? outerBounds.getLeft() : outerBounds.getRight() - legendSize.getX();
            doubleVector = new DoubleVector(x2, y2);
        } else if (Intrinsics.areEqual((Object)legendPosition2, (Object)LegendPosition.Companion.getTOP()) ? true : Intrinsics.areEqual((Object)legendPosition2, (Object)LegendPosition.Companion.getBOTTOM())) {
            double x3 = innerBounds.getLeft() + (innerBounds.getWidth() - legendSize.getX()) * legendJustification.getX();
            double y3 = Intrinsics.areEqual((Object)legendPosition, (Object)LegendPosition.Companion.getTOP()) ? outerBounds.getTop() : outerBounds.getBottom() - legendSize.getY();
            doubleVector = new DoubleVector(x3, y3);
        } else {
            throw new IllegalArgumentException("Expect fixed legend position, but was inside via numeric vector: " + legendPosition.getX() + ", " + legendPosition.getY());
        }
        return doubleVector;
    }

    @Metadata(mv={1, 9, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LegendArrangement.values().length];
            try {
                nArray[LegendArrangement.VERTICAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegendArrangement.HORIZONTAL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[LegendBoxJustification.values().length];
            try {
                nArray[LegendBoxJustification.LEFT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegendBoxJustification.RIGHT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegendBoxJustification.TOP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LegendBoxJustification.BOTTOM.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

