/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.relocated.apache.batik.svggen.font.table;

import java.io.IOException;
import java.io.RandomAccessFile;
import org.jetbrains.relocated.apache.batik.svggen.font.table.LookupSubtable;
import org.jetbrains.relocated.apache.batik.svggen.font.table.LookupSubtableFactory;

public class Lookup {
    public static final int IGNORE_BASE_GLYPHS = 2;
    public static final int IGNORE_BASE_LIGATURES = 4;
    public static final int IGNORE_BASE_MARKS = 8;
    public static final int MARK_ATTACHMENT_TYPE = 65280;
    private int type;
    private int flag;
    private int subTableCount;
    private int[] subTableOffsets;
    private LookupSubtable[] subTables;

    public Lookup(LookupSubtableFactory factory2, RandomAccessFile raf, int offset2) throws IOException {
        int i;
        raf.seek(offset2);
        this.type = raf.readUnsignedShort();
        this.flag = raf.readUnsignedShort();
        this.subTableCount = raf.readUnsignedShort();
        this.subTableOffsets = new int[this.subTableCount];
        this.subTables = new LookupSubtable[this.subTableCount];
        for (i = 0; i < this.subTableCount; ++i) {
            this.subTableOffsets[i] = raf.readUnsignedShort();
        }
        for (i = 0; i < this.subTableCount; ++i) {
            this.subTables[i] = factory2.read(this.type, raf, offset2 + this.subTableOffsets[i]);
        }
    }

    public int getType() {
        return this.type;
    }

    public int getSubtableCount() {
        return this.subTableCount;
    }

    public LookupSubtable getSubtable(int i) {
        return this.subTables[i];
    }
}

