/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.nodejs.boilerplate.npmInit;

import com.intellij.execution.filters.Filter;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterField;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.javascript.nodejs.library.core.NodeCoreLibraryConfigurator;
import com.intellij.javascript.nodejs.npm.NpmManager;
import com.intellij.javascript.nodejs.npm.NpmNodePackage;
import com.intellij.javascript.nodejs.npm.NpmUtil;
import com.intellij.javascript.nodejs.packages.NodePackageUtil;
import com.intellij.javascript.nodejs.util.NodePackage;
import com.intellij.javascript.nodejs.util.NodePackageField;
import com.intellij.javascript.nodejs.util.NodePackageRef;
import com.intellij.lang.javascript.boilerplate.NpmPackageProjectGenerator;
import com.intellij.lang.javascript.buildTools.npm.PackageJsonUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.platform.ProjectGeneratorPeer;
import com.intellij.pom.Navigatable;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.PathUtil;
import com.jetbrains.nodejs.NodeJSBundle;
import icons.JavaScriptLanguageIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public final class NpmInitProjectGenerator
extends NpmPackageProjectGenerator {
    public void generateProject(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull NpmPackageProjectGenerator.Settings settings, @NotNull Module module) {
        if (project == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(0);
        }
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(1);
        }
        if (settings == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(2);
        }
        if (module == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(3);
        }
        super.generateProject(project, baseDir, settings, module);
        NpmManager.getInstance((Project)project).setPackageRef(settings.myPackageRef);
    }

    protected void configureProject(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(4);
        }
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(5);
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            NodeJsInterpreter interpreter;
            Navigatable navigatable;
            VirtualFile packageJsonFile = PackageJsonUtil.findChildPackageJsonFile((VirtualFile)baseDir);
            if (packageJsonFile != null && (navigatable = PsiNavigationSupport.getInstance().createNavigatable(project, packageJsonFile, -1)).canNavigate()) {
                navigatable.navigate(true);
            }
            if ((interpreter = NodeJsInterpreterManager.getInstance((Project)project).getInterpreter()) != null) {
                interpreter.provideCachedVersionOrFetch(version -> {
                    if (version != null) {
                        ApplicationManager.getApplication().invokeLater(() -> NodeCoreLibraryConfigurator.getInstance((Project)project).configureAndAssociateWithProject(interpreter, version, null), project.getDisposed());
                    }
                });
            }
        }, project.getDisposed());
    }

    public String getId() {
        return "NodeJS";
    }

    @Nls
    @NotNull
    public String getName() {
        String string = NodeJSBundle.message("npm.init.generator.name", new Object[0]);
        if (string == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(6);
        }
        return string;
    }

    public String getDescription() {
        return NodeJSBundle.message("npm.init.generator.description", new Object[0]);
    }

    protected Filter @NotNull [] filters(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(7);
        }
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(8);
        }
        if (Filter.EMPTY_ARRAY == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(9);
        }
        return Filter.EMPTY_ARRAY;
    }

    @NotNull
    protected String executable(@NotNull NodePackage pkg) {
        if (pkg == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(10);
        }
        if (pkg instanceof NpmNodePackage) {
            throw new IllegalStateException("Executable of NpmNodePackage is inferred automatically, passed " + String.valueOf(pkg) + " of " + String.valueOf(pkg.getClass()));
        }
        throw new IllegalStateException("Expected NpmNodePackage instance, got " + String.valueOf(pkg) + " of " + String.valueOf(pkg.getClass()));
    }

    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir) {
        if (project == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(11);
        }
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(12);
        }
        if (ArrayUtilRt.EMPTY_STRING_ARRAY == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(13);
        }
        return ArrayUtilRt.EMPTY_STRING_ARRAY;
    }

    protected void customizeModule(@NotNull VirtualFile baseDir, ContentEntry entry) {
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(14);
        }
    }

    protected String @NotNull [] generatorArgs(@NotNull Project project, @NotNull VirtualFile baseDir, @NotNull NpmPackageProjectGenerator.Settings settings) {
        if (project == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(15);
        }
        if (baseDir == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(16);
        }
        if (settings == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(17);
        }
        if (NpmUtil.isPnpmPackage((NodePackage)settings.myPackage)) {
            String[] stringArray = new String[]{"init"};
            if (stringArray == null) {
                NpmInitProjectGenerator.$$$reportNull$$$0(18);
            }
            return stringArray;
        }
        String[] stringArray = new String[]{"init", "-y"};
        if (stringArray == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(19);
        }
        return stringArray;
    }

    protected String validateProjectPath(@NotNull String path) {
        String error;
        if (path == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(20);
        }
        if ((error = NodePackageUtil.validateNpmPackageName((String)PathUtil.getFileName((String)path))) != null) {
            return error;
        }
        return super.validateProjectPath(path);
    }

    @NotNull
    protected String packageName() {
        return "npm";
    }

    @NotNull
    protected String presentablePackageName() {
        String string = NpmUtil.getPackageManagerPackageFieldLabelText();
        if (string == null) {
            NpmInitProjectGenerator.$$$reportNull$$$0(21);
        }
        return string;
    }

    public Icon getIcon() {
        return JavaScriptLanguageIcons.Nodejs.Nodejs;
    }

    @NotNull
    public ProjectGeneratorPeer<NpmPackageProjectGenerator.Settings> createPeer() {
        return new NpmPackageProjectGenerator.NpmPackageGeneratorPeer(){

            @NotNull
            protected NodePackageField createAndInitPackageField(@NotNull NodeJsInterpreterField interpreterField) {
                if (interpreterField == null) {
                    1.$$$reportNull$$$0(0);
                }
                NodePackageField field = NpmUtil.createPackageManagerPackageField((NodeJsInterpreterField)interpreterField, (boolean)true);
                field.setSelectedRef(NodePackageRef.create((String)"npm"));
                NodePackageField nodePackageField = field;
                if (nodePackageField == null) {
                    1.$$$reportNull$$$0(1);
                }
                return nodePackageField;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "interpreterField";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/jetbrains/nodejs/boilerplate/npmInit/NpmInitProjectGenerator$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/jetbrains/nodejs/boilerplate/npmInit/NpmInitProjectGenerator$1";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "createAndInitPackageField";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "createAndInitPackageField";
                        break;
                    }
                    case 1: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1 -> new IllegalStateException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 6, 9, 13, 18, 19, 21 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 5: 
            case 8: 
            case 12: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 2: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/nodejs/boilerplate/npmInit/NpmInitProjectGenerator";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pkg";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/nodejs/boilerplate/npmInit/NpmInitProjectGenerator";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "filters";
                break;
            }
            case 13: 
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "generatorArgs";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "presentablePackageName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "generateProject";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "configureProject";
                break;
            }
            case 6: 
            case 9: 
            case 13: 
            case 18: 
            case 19: 
            case 21: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "filters";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "executable";
                break;
            }
            case 11: 
            case 12: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "generatorArgs";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "customizeModule";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "validateProjectPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 6, 9, 13, 18, 19, 21 -> new IllegalStateException(string);
        };
    }
}

