/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ktor;

import com.intellij.java.library.JavaLibraryModificationTracker;
import com.intellij.ktor.KtorRoutingVisitor;
import com.intellij.ktor.KtorUastSearchUtilsKt;
import com.intellij.ktor.KtorUrlMapping;
import com.intellij.ktor.KtorUrlTargetInfo;
import com.intellij.ktor.KtorUtilsKt;
import com.intellij.ktor.oas.KtorOasArgumentVisitorsKt;
import com.intellij.ktor.url.UrlUtilsKt;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.uast.UastModificationTracker;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00060\u0001H\u0002\u001a\u0016\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0002\u001a\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000bH\u0000\u00a8\u0006\f"}, d2={"getUrlTargetInfoForModule", "", "Lcom/intellij/ktor/KtorUrlTargetInfo;", "module", "Lcom/intellij/openapi/module/Module;", "ktorUrlMappings", "Lcom/intellij/ktor/KtorUrlMapping;", "getAllUrlMappings", "getSupportedContentTypes", "", "", "Lorg/jetbrains/uast/UCallExpression;", "intellij.ktor"})
@SourceDebugExtension(value={"SMAP\nKtorUrlResolver.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KtorUrlResolver.kt\ncom/intellij/ktor/KtorUrlResolverKt\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,311:1\n1563#2:312\n1634#2,3:313\n*S KotlinDebug\n*F\n+ 1 KtorUrlResolver.kt\ncom/intellij/ktor/KtorUrlResolverKt\n*L\n70#1:312\n70#1:313,3\n*E\n"})
public final class KtorUrlResolverKt {
    /*
     * WARNING - void declaration
     */
    private static final List<KtorUrlTargetInfo> getUrlTargetInfoForModule(Module module, List<KtorUrlMapping> ktorUrlMappings) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = ktorUrlMappings;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            KtorUrlMapping ktorUrlMapping = (KtorUrlMapping)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new KtorUrlTargetInfo((KtorUrlMapping)it, UrlUtilsKt.getAuthoritiesByModule(module)));
        }
        return (List)destination$iv$iv;
    }

    private static final List<KtorUrlMapping> getAllUrlMappings(Module module) {
        Object object = CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> KtorUrlResolverKt.getAllUrlMappings$lambda$1(module));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getCachedValue(...)");
        return (List)object;
    }

    @NotNull
    public static final Set<String> getSupportedContentTypes(@NotNull UCallExpression $this$getSupportedContentTypes) {
        Intrinsics.checkNotNullParameter((Object)$this$getSupportedContentTypes, (String)"<this>");
        UExpression uExpression = KtorUastSearchUtilsKt.getPluginConfigBodyOrNull($this$getSupportedContentTypes, "io.ktor.serialization.Configuration");
        if (uExpression == null) {
            return SetsKt.emptySet();
        }
        UExpression body = uExpression;
        var visitor2 = new AbstractUastVisitor(){
            private final Set<String> contentTypes;
            {
                this.contentTypes = new LinkedHashSet<E>();
            }

            public final Set<String> getContentTypes() {
                return this.contentTypes;
            }

            public boolean visitCallExpression(UCallExpression node) {
                List<String> list;
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                boolean isContentNegotiation = KtorUastSearchUtilsKt.inheritsFqName$default(node.getReceiverType(), "io.ktor.serialization.Configuration", 0, 2, null);
                if (!isContentNegotiation) {
                    return true;
                }
                PsiMethod psiMethod = node.resolve();
                if (psiMethod == null || (psiMethod = JavaPsiUtils.getKotlinFqName((PsiElement)((PsiElement)psiMethod))) == null) {
                    return true;
                }
                PsiMethod fqMethodName = psiMethod;
                PsiMethod psiMethod2 = fqMethodName;
                if (Intrinsics.areEqual((Object)psiMethod2, (Object)KtorUtilsKt.getKTOR_XML_METHOD())) {
                    list = CollectionsKt.listOf((Object)"application/xml");
                } else if (Intrinsics.areEqual((Object)psiMethod2, (Object)KtorUtilsKt.getKTOR_GSON_METHOD()) || Intrinsics.areEqual((Object)psiMethod2, (Object)KtorUtilsKt.getKTOR_JSON_METHOD()) || Intrinsics.areEqual((Object)psiMethod2, (Object)KtorUtilsKt.getKTOR_JACKSON_METHOD())) {
                    list = CollectionsKt.listOf((Object)"application/json");
                } else if (Intrinsics.areEqual((Object)psiMethod2, (Object)KtorUtilsKt.getKTOR_REGISTER_METHOD())) {
                    list = KtorOasArgumentVisitorsKt.getContentTypeCallParameter(node, "*/*");
                } else {
                    return true;
                }
                List<String> contentType = list;
                this.contentTypes.addAll((Collection<String>)contentType);
                return true;
            }
        };
        body.accept((UastVisitor)visitor2);
        return visitor2.getContentTypes();
    }

    private static final CachedValueProvider.Result getAllUrlMappings$lambda$1(Module $module) {
        KtorRoutingVisitor visitor2 = new KtorRoutingVisitor(false, 1, null);
        for (UCallExpression routing : KtorUastSearchUtilsKt.searchRoutingCalls($module)) {
            routing.accept((UastVisitor)visitor2);
        }
        for (UMethod extension : KtorUastSearchUtilsKt.searchRouteExtensions($module)) {
            extension.accept((UastVisitor)visitor2);
        }
        List<KtorUrlMapping> list = visitor2.getSortedMappings();
        Object[] objectArray = new Object[2];
        Project project = $module.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        objectArray[0] = UastModificationTracker.Companion.getInstance(project);
        objectArray[1] = JavaLibraryModificationTracker.getInstance((Project)$module.getProject());
        return CachedValueProvider.Result.create(list, (Object[])objectArray);
    }

    public static final /* synthetic */ List access$getAllUrlMappings(Module module) {
        return KtorUrlResolverKt.getAllUrlMappings(module);
    }

    public static final /* synthetic */ List access$getUrlTargetInfoForModule(Module module, List ktorUrlMappings) {
        return KtorUrlResolverKt.getUrlTargetInfoForModule(module, ktorUrlMappings);
    }
}

