/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.boot.initializr;

import com.fasterxml.jackson.databind.JsonNode;
import com.intellij.ide.starters.shared.CustomizedMessages;
import com.intellij.ide.starters.shared.DependencyAvailable;
import com.intellij.ide.starters.shared.DependencyState;
import com.intellij.ide.starters.shared.DependencyUnavailable;
import com.intellij.ide.starters.shared.LibraryLink;
import com.intellij.ide.starters.shared.LibraryLinkType;
import com.intellij.ide.starters.shared.StarterAppPackaging;
import com.intellij.ide.starters.shared.StarterLanguage;
import com.intellij.ide.starters.shared.StarterLanguageLevel;
import com.intellij.ide.starters.shared.StarterProjectType;
import com.intellij.microservices.jvm.dependencies.Version;
import com.intellij.microservices.jvm.dependencies.VersionRange;
import com.intellij.microservices.jvm.starters.WebStarterContext;
import com.intellij.microservices.jvm.starters.WebStarterDependency;
import com.intellij.microservices.jvm.starters.WebStarterDependencyCategory;
import com.intellij.microservices.jvm.starters.WebStarterFrameworkVersion;
import com.intellij.microservices.jvm.starters.WebStarterModuleBuilder;
import com.intellij.microservices.jvm.starters.WebStarterServerOptions;
import com.intellij.microservices.jvm.starters.WebStarterSettings;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.spring.boot.initializr.SpringBootDependency;
import com.intellij.spring.boot.initializr.SpringBootInitializrBundle;
import com.intellij.spring.boot.initializr.SpringBootInitializrIcons;
import com.intellij.spring.boot.initializr.SpringBootInitializrSettings;
import com.intellij.ultimate.PluginVerifier;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.io.ZipUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0017\u0018\u00002\u00020\u0001:\u0001DB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J\b\u0010\b\u001a\u00020\tH\u0016J\b\u0010\n\u001a\u00020\u0005H\u0016J\b\u0010\u000b\u001a\u00020\u0005H\u0016J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0014J\b\u0010\u000f\u001a\u00020\u0010H\u0014J\u000e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u0016H\u0014J\b\u0010\u0018\u001a\u00020\u0017H\u0014J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u000e\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0016H\u0014J\u000e\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020\u001f0\u0016H\u0014J\u000e\u0010 \u001a\b\u0012\u0004\u0012\u00020!0\u0016H\u0014J\b\u0010\"\u001a\u00020#H\u0014J\u000e\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00050\u0016H\u0014J\u0010\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u0005H\u0015J\u0010\u0010(\u001a\u00020&2\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020!0\u00162\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001f0\u00162\u0006\u0010)\u001a\u00020*H\u0002J\u0010\u0010-\u001a\u00020\u00052\u0006\u0010.\u001a\u00020\u0005H\u0002J\u0016\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00162\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u00100\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u0002020\u00162\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u0002040\u00162\u0006\u0010)\u001a\u00020*H\u0002J\u0016\u00105\u001a\u0004\u0018\u00010\u0005*\u00020*2\u0006\u00106\u001a\u00020\u0005H\u0002J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u0002022\u0006\u0010:\u001a\u00020;H\u0014J\u0018\u0010<\u001a\u00020=2\u0006\u0010'\u001a\u00020\u00052\u0006\u0010>\u001a\u00020\u0012H\u0014J\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020BH\u0015R\u0014\u0010\u0011\u001a\u00020\u00128@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006E"}, d2={"Lcom/intellij/spring/boot/initializr/SpringInitializrModuleBuilder;", "Lcom/intellij/microservices/jvm/starters/WebStarterModuleBuilder;", "<init>", "()V", "getDefaultServerUrl", "", "getDescription", "getBuilderId", "getNodeIcon", "Ljavax/swing/Icon;", "getPresentableName", "getHelpId", "getWeight", "", "getDefaultVersion", "isPackageNameEditable", "", "internalContext", "Lcom/intellij/microservices/jvm/starters/WebStarterContext;", "getInternalContext$intellij_spring_boot_initializr", "()Lcom/intellij/microservices/jvm/starters/WebStarterContext;", "getLanguageLevels", "", "Lcom/intellij/ide/starters/shared/StarterLanguageLevel;", "getDefaultLanguageLevel", "isReformatAfterCreation", "project", "Lcom/intellij/openapi/project/Project;", "getProjectTypes", "Lcom/intellij/ide/starters/shared/StarterProjectType;", "getLanguages", "Lcom/intellij/ide/starters/shared/StarterLanguage;", "getPackagingTypes", "Lcom/intellij/ide/starters/shared/StarterAppPackaging;", "getCustomizedMessages", "Lcom/intellij/ide/starters/shared/CustomizedMessages;", "getFilePathsToOpen", "loadServerOptions", "Lcom/intellij/microservices/jvm/starters/WebStarterServerOptions;", "serverUrl", "parseOptionsJson", "json", "Lcom/fasterxml/jackson/databind/JsonNode;", "parsePackagingTypes", "parseLanguages", "getOptionTitle", "option", "parseProjectTypes", "parseLanguageLevels", "parseFrameworkVersions", "Lcom/intellij/microservices/jvm/starters/WebStarterFrameworkVersion;", "parseDependencies", "Lcom/intellij/microservices/jvm/starters/WebStarterDependencyCategory;", "getDefaultPropertyValue", "propertyName", "getDependencyState", "Lcom/intellij/ide/starters/shared/DependencyState;", "frameworkVersion", "dependency", "Lcom/intellij/microservices/jvm/starters/WebStarterDependency;", "composeGeneratorUrl", "Lcom/intellij/util/Url;", "starterContext", "extractGeneratorResult", "", "tempZipFile", "Ljava/io/File;", "contentEntryDir", "SpringBootVersion", "intellij.spring.boot.initializr"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nSpringInitializrModuleBuilder.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpringInitializrModuleBuilder.kt\ncom/intellij/spring/boot/initializr/SpringInitializrModuleBuilder\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,308:1\n1#2:309\n1563#3:310\n1634#3,3:311\n1563#3:314\n1634#3,3:315\n1563#3:318\n1634#3,3:319\n774#3:322\n865#3,2:323\n1563#3:325\n1634#3,3:326\n1563#3:329\n1634#3,3:330\n1563#3:333\n1634#3,2:334\n1563#3:336\n1634#3,3:337\n1636#3:340\n*S KotlinDebug\n*F\n+ 1 SpringInitializrModuleBuilder.kt\ncom/intellij/spring/boot/initializr/SpringInitializrModuleBuilder\n*L\n121#1:310\n121#1:311,3\n133#1:314\n133#1:315,3\n151#1:318\n151#1:319,3\n158#1:322\n158#1:323,2\n168#1:325\n168#1:326,3\n180#1:329\n180#1:330,3\n191#1:333\n191#1:334,2\n195#1:336\n195#1:337,3\n191#1:340\n*E\n"})
public class SpringInitializrModuleBuilder
extends WebStarterModuleBuilder {
    public SpringInitializrModuleBuilder() {
        PluginVerifier.verifyUltimatePlugin();
    }

    @NotNull
    public String getDefaultServerUrl() {
        return "https://start.spring.io";
    }

    @NotNull
    public String getDescription() {
        String string = SpringBootInitializrBundle.message("description.for.spring.initializr.project.starter", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getBuilderId() {
        return "SpringInitializr";
    }

    @NotNull
    public Icon getNodeIcon() {
        Icon icon = SpringBootInitializrIcons.SpringInitializr;
        Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"SpringInitializr");
        return icon;
    }

    @NotNull
    public String getPresentableName() {
        String string = SpringBootInitializrBundle.message("spring.initializr.project.starter.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    @NotNull
    public String getHelpId() {
        return "reference.spring.boot";
    }

    public int getWeight() {
        return super.getWeight() + 2;
    }

    @NotNull
    protected String getDefaultVersion() {
        return "0.0.1-SNAPSHOT";
    }

    protected boolean isPackageNameEditable() {
        return true;
    }

    @NotNull
    public final WebStarterContext getInternalContext$intellij_spring_boot_initializr() {
        return this.getStarterContext();
    }

    @NotNull
    protected List<StarterLanguageLevel> getLanguageLevels() {
        Object[] objectArray = new StarterLanguageLevel[]{new StarterLanguageLevel("17", "17", "17"), new StarterLanguageLevel("11", "11", "11"), new StarterLanguageLevel("1.8", "8", "1.8")};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected StarterLanguageLevel getDefaultLanguageLevel() {
        return new StarterLanguageLevel("17", "17", "17");
    }

    protected boolean isReformatAfterCreation(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return SpringBootInitializrSettings.getInstance(project).isReformatAfterCreation();
    }

    @NotNull
    protected List<StarterProjectType> getProjectTypes() {
        Object[] objectArray = new StarterProjectType[]{new StarterProjectType("gradle-project", "Gradle - Groovy", null, 4, null), new StarterProjectType("gradle-project-kotlin", "Gradle - Kotlin", null, 4, null), new StarterProjectType("maven-project", "Maven", null, 4, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<StarterLanguage> getLanguages() {
        Object[] objectArray = new StarterLanguage[]{new StarterLanguage("java", "Java", "JAVA", false, null, 24, null), new StarterLanguage("kotlin", "Kotlin", "kotlin", false, null, 24, null), new StarterLanguage("groovy", "Groovy", "Groovy", false, null, 24, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected List<StarterAppPackaging> getPackagingTypes() {
        Object[] objectArray = new StarterAppPackaging[]{new StarterAppPackaging("jar", "Jar", null, 4, null), new StarterAppPackaging("war", "War", null, 4, null)};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @NotNull
    protected CustomizedMessages getCustomizedMessages() {
        CustomizedMessages customizedMessages;
        CustomizedMessages $this$getCustomizedMessages_u24lambda_u240 = customizedMessages = new CustomizedMessages();
        boolean bl = false;
        $this$getCustomizedMessages_u24lambda_u240.setFrameworkVersionLabel(SpringBootInitializrBundle.message("label.spring.boot.version", new Object[0]));
        $this$getCustomizedMessages_u24lambda_u240.setServerUrlDialogTitle(SpringBootInitializrBundle.message("label.spring.initializr.url", new Object[0]));
        return customizedMessages;
    }

    @NotNull
    protected List<String> getFilePathsToOpen() {
        return CollectionsKt.listOf((Object)"HELP.md");
    }

    @RequiresBackgroundThread
    @NotNull
    protected WebStarterServerOptions loadServerOptions(@NotNull String serverUrl) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        String mimeType = "application/vnd.initializr.v2.2+json,application/vnd.initializr.v2.1+json;q=0.9";
        JsonNode json = this.loadJsonData(serverUrl, mimeType);
        return this.parseOptionsJson(json);
    }

    /*
     * WARNING - void declaration
     */
    private final WebStarterServerOptions parseOptionsJson(JsonNode json) {
        StarterLanguageLevel starterLanguageLevel;
        List<WebStarterDependencyCategory> dependencies = this.parseDependencies(json);
        List<WebStarterFrameworkVersion> frameworkVersions = this.parseFrameworkVersions(json);
        WebStarterServerOptions options = new WebStarterServerOptions(frameworkVersions, dependencies);
        options.putUserData(WebStarterSettings.getSERVER_PROJECT_TYPES(), this.parseProjectTypes(json));
        options.putUserData(WebStarterSettings.getSERVER_LANGUAGES(), this.parseLanguages(json));
        options.putUserData(WebStarterSettings.getSERVER_PACKAGING_TYPES(), this.parsePackagingTypes(json));
        options.putUserData(WebStarterSettings.getSERVER_NAME_KEY(), (Object)this.getDefaultPropertyValue(json, "name"));
        options.putUserData(WebStarterSettings.getSERVER_GROUP_KEY(), (Object)this.getDefaultPropertyValue(json, "groupId"));
        options.putUserData(WebStarterSettings.getSERVER_ARTIFACT_KEY(), (Object)this.getDefaultPropertyValue(json, "artifactId"));
        options.putUserData(WebStarterSettings.getSERVER_VERSION_KEY(), (Object)this.getDefaultPropertyValue(json, "version"));
        options.putUserData(WebStarterSettings.getSERVER_PACKAGE_NAME_KEY(), (Object)this.getDefaultPropertyValue(json, "packageName"));
        options.putUserData(WebStarterSettings.getSERVER_LANGUAGE_LEVELS_KEY(), this.parseLanguageLevels(json));
        WebStarterServerOptions webStarterServerOptions = options;
        Key key = WebStarterSettings.getSERVER_LANGUAGE_LEVEL_KEY();
        String string = this.getDefaultPropertyValue(json, "javaVersion");
        if (string != null) {
            void it;
            String string2 = string;
            Key key2 = key;
            WebStarterServerOptions webStarterServerOptions2 = webStarterServerOptions;
            boolean bl = false;
            StarterLanguageLevel starterLanguageLevel2 = new StarterLanguageLevel((String)it, (String)it, (String)it);
            webStarterServerOptions = webStarterServerOptions2;
            key = key2;
            starterLanguageLevel = starterLanguageLevel2;
        } else {
            starterLanguageLevel = null;
        }
        webStarterServerOptions.putUserData(key, starterLanguageLevel);
        return options;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StarterAppPackaging> parsePackagingTypes(JsonNode json) {
        void $this$mapTo$iv$iv;
        JsonNode jsonNode = json.get("packaging");
        if (jsonNode == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode packagingNode = jsonNode;
        JsonNode jsonNode2 = packagingNode.get("values");
        if (jsonNode2 == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode values = jsonNode2;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object object;
            void valueNode;
            JsonNode jsonNode3 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String packagingId = valueNode.get("id").asText();
            Object object2 = valueNode.get("name");
            if (object2 == null || (object2 = object2.asText()) == null) {
                object2 = packagingId;
            }
            Object packagingName = object2;
            Intrinsics.checkNotNull((Object)packagingName);
            String optionTitle = this.getOptionTitle((String)packagingName);
            Intrinsics.checkNotNull((Object)packagingId);
            Object object3 = object = packagingName;
            String string = optionTitle;
            String string2 = packagingId;
            boolean bl2 = false;
            boolean bl3 = !Intrinsics.areEqual((Object)it, (Object)optionTitle);
            Object object4 = bl3 ? object : null;
            String string3 = string;
            String string4 = string2;
            collection.add(new StarterAppPackaging(string4, string3, (String)object4));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StarterLanguage> parseLanguages(JsonNode json) {
        void $this$mapTo$iv$iv;
        JsonNode jsonNode = json.get("language");
        if (jsonNode == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode packagingNode = jsonNode;
        JsonNode jsonNode2 = packagingNode.get("values");
        if (jsonNode2 == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode values = jsonNode2;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Object object;
            void valueNode;
            JsonNode jsonNode3 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String languageId = valueNode.get("id").asText();
            Object object2 = valueNode.get("name");
            if (object2 == null || (object2 = object2.asText()) == null) {
                object2 = languageId;
            }
            Object languageName = object2;
            Intrinsics.checkNotNull((Object)languageName);
            String optionTitle = this.getOptionTitle((String)languageName);
            Intrinsics.checkNotNull((Object)languageId);
            Object object3 = object = languageName;
            boolean bl2 = false;
            String string = languageId;
            String string2 = optionTitle;
            String string3 = languageId;
            boolean bl3 = false;
            boolean bl4 = !Intrinsics.areEqual((Object)it, (Object)optionTitle);
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 8;
            Object object4 = bl4 ? object : null;
            boolean bl5 = bl2;
            String string4 = string;
            String string5 = string2;
            String string6 = string3;
            collection.add(new StarterLanguage(string6, string5, string4, bl5, (String)object4, n, defaultConstructorMarker));
        }
        return (List)destination$iv$iv;
    }

    private final String getOptionTitle(String option) {
        return ((Object)StringsKt.trim((CharSequence)StringsKt.substringBefore$default((String)option, (String)"(", null, (int)2, null))).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final List<StarterProjectType> parseProjectTypes(JsonNode json) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        void $this$mapTo$iv$iv;
        JsonNode jsonNode = json.get("type");
        if (jsonNode == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode javaVersionNode = jsonNode;
        JsonNode jsonNode2 = javaVersionNode.get("values");
        if (jsonNode2 == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode values = jsonNode2;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void versionItem;
            JsonNode jsonNode3 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String typeId = versionItem.get("id").asText();
            Object object = versionItem.get("name");
            if (object == null || (object = object.asText()) == null) {
                object = typeId;
            }
            Object typeName = object;
            Intrinsics.checkNotNull((Object)typeName);
            String optionTitle = this.getOptionTitle(StringsKt.removeSuffix((String)typeName, (CharSequence)" Project"));
            Object object2 = versionItem.get("description");
            if (object2 == null || (object2 = object2.asText()) == null) {
                Object object3;
                Object it = object3 = typeName;
                boolean bl2 = false;
                object2 = !Intrinsics.areEqual((Object)it, (Object)optionTitle) ? object3 : null;
            }
            Object description = object2;
            Intrinsics.checkNotNull((Object)typeId);
            collection.add(new StarterProjectType(typeId, optionTitle, (String)description));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            StarterProjectType it = (StarterProjectType)element$iv$iv;
            boolean bl = false;
            if (!(!Intrinsics.areEqual((Object)it.getId(), (Object)"maven-build") && !Intrinsics.areEqual((Object)it.getId(), (Object)"gradle-build"))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<StarterLanguageLevel> parseLanguageLevels(JsonNode json) {
        void $this$mapTo$iv$iv;
        JsonNode jsonNode = json.get("javaVersion");
        if (jsonNode == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode javaVersionNode = jsonNode;
        JsonNode jsonNode2 = javaVersionNode.get("values");
        if (jsonNode2 == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode values = jsonNode2;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void versionItem;
            JsonNode jsonNode3 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String versionId = versionItem.get("id").asText();
            Object object = versionItem.get("name");
            if (object == null || (object = object.asText()) == null) {
                object = versionId;
            }
            Object versionName = object;
            Intrinsics.checkNotNull((Object)versionId);
            Intrinsics.checkNotNull((Object)versionName);
            collection.add(new StarterLanguageLevel(versionId, (String)versionName, versionId));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WebStarterFrameworkVersion> parseFrameworkVersions(JsonNode json) {
        void $this$mapTo$iv$iv;
        JsonNode jsonNode = json.get("bootVersion");
        if (jsonNode == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode bootVersionNode = jsonNode;
        JsonNode jsonNode2 = bootVersionNode.get("values");
        if (jsonNode2 == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode values = jsonNode2;
        JsonNode jsonNode3 = this.getNullable(bootVersionNode, "default");
        String defaultVersion = jsonNode3 != null ? jsonNode3.asText() : null;
        Iterable $this$map$iv = (Iterable)values;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void versionItem;
            JsonNode jsonNode4 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String versionText = versionItem.get("id").asText();
            Object object = versionItem.get("name");
            if (object == null || (object = object.asText()) == null) {
                object = versionText;
            }
            Object versionName = object;
            Version version = Version.parse((String)versionText);
            Intrinsics.checkNotNull((Object)versionText);
            Intrinsics.checkNotNull((Object)versionName);
            Intrinsics.checkNotNull((Object)version);
            collection.add(new SpringBootVersion(versionText, (String)versionName, version, Intrinsics.areEqual((Object)defaultVersion, (Object)versionText)));
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<WebStarterDependencyCategory> parseDependencies(JsonNode json) {
        void $this$mapTo$iv$iv;
        JsonNode jsonNode = this.getNullable(json, "dependencies");
        if (jsonNode == null || (jsonNode = this.getNullable(jsonNode, "values")) == null) {
            return CollectionsKt.emptyList();
        }
        JsonNode dependencyGroupItems = jsonNode;
        Iterable $this$map$iv = (Iterable)dependencyGroupItems;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            List list;
            JsonNode dependencyItems;
            void groupItem;
            JsonNode jsonNode2 = (JsonNode)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)groupItem);
            Object object = this.getNullable((JsonNode)groupItem, "name");
            if (object == null || (object = object.asText()) == null) {
                object = "";
            }
            Object groupName = object;
            JsonNode jsonNode3 = dependencyItems = this.getNullable((JsonNode)groupItem, "values");
            if (jsonNode3 != null) {
                void $this$mapTo$iv$iv2;
                Iterable $this$map$iv2 = (Iterable)jsonNode3;
                boolean $i$f$map2 = false;
                Iterable iterable2 = $this$map$iv2;
                Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                boolean $i$f$mapTo2 = false;
                for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                    VersionRange versionRange;
                    String versionRangeValue;
                    Object object2;
                    Object id;
                    void item;
                    JsonNode jsonNode4 = (JsonNode)item$iv$iv2;
                    Collection collection2 = destination$iv$iv2;
                    boolean bl2 = false;
                    Object object3 = item.get("id");
                    if (object3 == null || (object3 = object3.asText()) == null) {
                        object3 = id = "";
                    }
                    if ((object2 = item.get("name")) == null || (object2 = object2.asText()) == null) {
                        object2 = "";
                    }
                    Object name = object2;
                    Intrinsics.checkNotNull((Object)item);
                    JsonNode jsonNode5 = this.getNullable((JsonNode)item, "description");
                    String description = jsonNode5 != null ? jsonNode5.asText() : null;
                    List links = new ArrayList();
                    JsonNode linksNode = this.getNullable((JsonNode)item, "_links");
                    if (linksNode != null) {
                        Iterator iterator;
                        Intrinsics.checkNotNullExpressionValue((Object)linksNode.fields(), (String)"fields(...)");
                        while (iterator.hasNext()) {
                            Iterator iterator2;
                            LibraryLinkType linkType;
                            Map.Entry linkEntry = (Map.Entry)iterator.next();
                            String string = (String)linkEntry.getKey();
                            LibraryLinkType libraryLinkType = Intrinsics.areEqual((Object)string, (Object)"reference") ? LibraryLinkType.REFERENCE : (linkType = Intrinsics.areEqual((Object)string, (Object)"guide") ? LibraryLinkType.GUIDE : LibraryLinkType.WEBSITE);
                            if (((JsonNode)linkEntry.getValue()).isObject()) {
                                Object v = linkEntry.getValue();
                                Intrinsics.checkNotNullExpressionValue(v, (String)"<get-value>(...)");
                                Object object4 = this.getNullable((JsonNode)v, "href");
                                if (object4 == null || (object4 = object4.asText()) == null) {
                                    object4 = "";
                                }
                                Object url = object4;
                                links.add(new LibraryLink(linkType, (String)url, null, 4, null));
                                continue;
                            }
                            if (!((JsonNode)linkEntry.getValue()).isArray()) continue;
                            JsonNode linksArray = (JsonNode)linkEntry.getValue();
                            Intrinsics.checkNotNullExpressionValue((Object)linksArray.iterator(), (String)"iterator(...)");
                            while (iterator2.hasNext()) {
                                JsonNode linkObject = (JsonNode)iterator2.next();
                                Intrinsics.checkNotNull((Object)linkObject);
                                JsonNode jsonNode6 = this.getNullable(linkObject, "title");
                                String title = jsonNode6 != null ? jsonNode6.asText() : null;
                                Object object5 = this.getNullable(linkObject, "href");
                                if (object5 == null || (object5 = object5.asText()) == null) {
                                    object5 = "";
                                }
                                Object url = object5;
                                links.add(new LibraryLink(linkType, (String)url, title));
                            }
                        }
                    }
                    JsonNode jsonNode7 = item.get("versionRange");
                    String string = versionRangeValue = jsonNode7 != null ? jsonNode7.asText() : null;
                    if (versionRangeValue != null) {
                        String it;
                        boolean bl3 = false;
                        versionRange = VersionRange.parse((String)it);
                    } else {
                        versionRange = null;
                    }
                    VersionRange versionRange2 = versionRange;
                    collection2.add(new SpringBootDependency((String)id, (String)name, description, links, false, versionRange2, null, 64, null));
                }
                list = (List)destination$iv$iv2;
            } else {
                list = CollectionsKt.emptyList();
            }
            List dependencies = list;
            collection.add(new WebStarterDependencyCategory((String)groupName, dependencies));
        }
        return (List)destination$iv$iv;
    }

    private final String getDefaultPropertyValue(JsonNode $this$getDefaultPropertyValue, String propertyName) {
        JsonNode defaultProperty;
        JsonNode jsonNode = $this$getDefaultPropertyValue.get(propertyName);
        if (jsonNode == null) {
            return null;
        }
        JsonNode property = jsonNode;
        JsonNode jsonNode2 = defaultProperty = this.getNullable(property, "default");
        return jsonNode2 != null ? jsonNode2.asText() : null;
    }

    @NotNull
    protected DependencyState getDependencyState(@NotNull WebStarterFrameworkVersion frameworkVersion, @NotNull WebStarterDependency dependency) {
        Intrinsics.checkNotNullParameter((Object)frameworkVersion, (String)"frameworkVersion");
        Intrinsics.checkNotNullParameter((Object)dependency, (String)"dependency");
        SpringBootDependency springDependency = (SpringBootDependency)dependency;
        VersionRange versionRange = springDependency.getVersionRange();
        if (versionRange == null) {
            return (DependencyState)DependencyAvailable.INSTANCE;
        }
        SpringBootVersion springBootVersion = (SpringBootVersion)frameworkVersion;
        if (!versionRange.match(springBootVersion.getVersion())) {
            Object[] objectArray = new Object[]{versionRange.displayText()};
            return (DependencyState)new DependencyUnavailable(SpringBootInitializrBundle.message("message.requires.specific.spring.boot.version", objectArray), versionRange.displayText());
        }
        return (DependencyState)DependencyAvailable.INSTANCE;
    }

    @NotNull
    protected Url composeGeneratorUrl(@NotNull String serverUrl, @NotNull WebStarterContext starterContext) {
        Intrinsics.checkNotNullParameter((Object)serverUrl, (String)"serverUrl");
        Intrinsics.checkNotNullParameter((Object)starterContext, (String)"starterContext");
        Pair[] pairArray = new Pair[11];
        StarterProjectType starterProjectType = starterContext.getProjectType();
        Intrinsics.checkNotNull((Object)starterProjectType);
        pairArray[0] = TuplesKt.to((Object)"type", (Object)starterProjectType.getId());
        WebStarterFrameworkVersion webStarterFrameworkVersion = starterContext.getFrameworkVersion();
        Intrinsics.checkNotNull((Object)webStarterFrameworkVersion);
        pairArray[1] = TuplesKt.to((Object)"bootVersion", (Object)webStarterFrameworkVersion.getId());
        pairArray[2] = TuplesKt.to((Object)"groupId", (Object)starterContext.getGroup());
        pairArray[3] = TuplesKt.to((Object)"artifactId", (Object)starterContext.getArtifact());
        pairArray[4] = TuplesKt.to((Object)"name", (Object)starterContext.getName());
        pairArray[5] = TuplesKt.to((Object)"version", (Object)starterContext.getVersion());
        pairArray[6] = TuplesKt.to((Object)"language", (Object)starterContext.getLanguage().getId());
        pairArray[7] = TuplesKt.to((Object)"packageName", (Object)starterContext.getPackageName());
        StarterLanguageLevel starterLanguageLevel = starterContext.getLanguageLevel();
        Intrinsics.checkNotNull((Object)starterLanguageLevel);
        pairArray[8] = TuplesKt.to((Object)"javaVersion", (Object)starterLanguageLevel.getId());
        StarterAppPackaging starterAppPackaging = starterContext.getPackaging();
        Intrinsics.checkNotNull((Object)starterAppPackaging);
        pairArray[9] = TuplesKt.to((Object)"packaging", (Object)starterAppPackaging.getId());
        pairArray[10] = TuplesKt.to((Object)"description", (Object)starterContext.getName());
        Map parameters = MapsKt.mapOf((Pair[])pairArray);
        Url url = Urls.newFromEncoded((String)(StringsKt.removeSuffix((String)serverUrl, (CharSequence)"/") + "/starter.zip")).addParameters(parameters);
        Intrinsics.checkNotNullExpressionValue((Object)url, (String)"addParameters(...)");
        Url url2 = url;
        for (WebStarterDependency dependency : starterContext.getDependencies()) {
            Intrinsics.checkNotNullExpressionValue((Object)url2.addParameters(MapsKt.mapOf((Pair)TuplesKt.to((Object)"dependencies", (Object)dependency.getId()))), (String)"addParameters(...)");
        }
        return url2;
    }

    @RequiresBackgroundThread
    protected void extractGeneratorResult(@NotNull File tempZipFile, @NotNull File contentEntryDir) {
        Intrinsics.checkNotNullParameter((Object)tempZipFile, (String)"tempZipFile");
        Intrinsics.checkNotNullParameter((Object)contentEntryDir, (String)"contentEntryDir");
        ZipUtil.extract((File)tempZipFile, (File)contentEntryDir, null);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/boot/initializr/SpringInitializrModuleBuilder$SpringBootVersion;", "Lcom/intellij/microservices/jvm/starters/WebStarterFrameworkVersion;", "id", "", "title", "version", "Lcom/intellij/microservices/jvm/dependencies/Version;", "isDefault", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/microservices/jvm/dependencies/Version;Z)V", "getVersion", "()Lcom/intellij/microservices/jvm/dependencies/Version;", "intellij.spring.boot.initializr"})
    public static final class SpringBootVersion
    extends WebStarterFrameworkVersion {
        @NotNull
        private final Version version;

        public SpringBootVersion(@NotNull String id, @NotNull String title, @NotNull Version version, boolean isDefault) {
            Intrinsics.checkNotNullParameter((Object)id, (String)"id");
            Intrinsics.checkNotNullParameter((Object)title, (String)"title");
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            super(id, title, isDefault);
            this.version = version;
        }

        @NotNull
        public final Version getVersion() {
            return this.version;
        }
    }
}

