/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.rest.model.jam;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.MetaAnnotationUtil;
import com.intellij.jam.JamElement;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.jam.reflect.JamMethodMeta;
import com.intellij.javaee.utils.JavaeeClass;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PsiJavaPatterns;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementRef;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.semantic.SemContributor;
import com.intellij.semantic.SemKey;
import com.intellij.semantic.SemRegistrar;
import com.intellij.semantic.SemService;
import com.intellij.ws.rest.constants.RSAnnotations;
import com.intellij.ws.rest.model.jam.RSAnnotationHttpMethod;
import com.intellij.ws.rest.model.jam.RSApplicationPath;
import com.intellij.ws.rest.model.jam.RSHttpMethod;
import com.intellij.ws.rest.model.jam.RSJamPsiClassPath;
import com.intellij.ws.rest.model.jam.RSJamPsiMethodPath;
import com.intellij.ws.rest.model.jam.httpMethods.RSCustomHttpMethod;
import com.intellij.ws.rest.model.jam.httpMethods.RSDefaultMethod;
import com.intellij.ws.rest.model.jam.microprofile.MicroprofileRegisterRestClient;
import com.intellij.ws.rest.utils.RSUtils;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

final class RSSemContributor
extends SemContributor {
    private final Map<JavaeeClass, JamMethodMeta<RSDefaultMethod>> defaultHttpMethodMetas = Map.of(RSAnnotations.DELETE, RSSemContributor.buildMeta("DELETE"), RSAnnotations.GET, RSSemContributor.buildMeta("GET"), RSAnnotations.HEAD, RSSemContributor.buildMeta("HEAD"), RSAnnotations.OPTIONS, RSSemContributor.buildMeta("OPTIONS"), RSAnnotations.POST, RSSemContributor.buildMeta("POST"), RSAnnotations.PUT, RSSemContributor.buildMeta("PUT"), RSAnnotations.PATCH, RSSemContributor.buildMeta("PATCH"));

    RSSemContributor() {
    }

    private static JamMethodMeta<RSDefaultMethod> buildMeta(@NotNull String shortName) {
        if (shortName == null) {
            RSSemContributor.$$$reportNull$$$0(0);
        }
        return new JamMethodMeta(null, ref -> new RSDefaultMethod((PsiElementRef<?>)ref, shortName), RSHttpMethod.RS_HTTP_METHOD_JAM_KEY.subKey("JAX-RS_" + shortName, new SemKey[0]));
    }

    protected boolean isAvailable(@NotNull Project project) {
        if (project == null) {
            RSSemContributor.$$$reportNull$$$0(1);
        }
        return RSUtils.hasRestLibrary(project);
    }

    public void registerSemProviders(@NotNull SemRegistrar registrar, @NotNull Project project) {
        if (registrar == null) {
            RSSemContributor.$$$reportNull$$$0(2);
        }
        if (project == null) {
            RSSemContributor.$$$reportNull$$$0(3);
        }
        RSJamPsiClassPath.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotations(RSAnnotations.PATH.all()));
        RSJamPsiMethodPath.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotations(RSAnnotations.PATH.all()));
        RSApplicationPath.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().withAnnotations(RSAnnotations.APPLICATION_PATH.all()));
        for (Map.Entry<JavaeeClass, JamMethodMeta<RSDefaultMethod>> entry : this.defaultHttpMethodMetas.entrySet()) {
            entry.getValue().register(registrar, (ElementPattern)PsiJavaPatterns.psiMethod().withAnnotations(entry.getKey().all()));
        }
        RSAnnotationHttpMethod.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().isAnnotationType().withAnnotations(RSAnnotations.HTTP_METHOD.all()));
        RSSemContributor.registerMetaComponents(SemService.getSemService((Project)project), registrar, PsiJavaPatterns.psiMethod(), RSHttpMethod.META_KEY, RSHttpMethod.RS_HTTP_METHOD_JAM_KEY, RSSemContributor.createFunction(RSHttpMethod.RS_HTTP_METHOD_JAM_KEY, (anno, psi) -> new RSCustomHttpMethod(RSSemContributor.findHttpMethod(anno, (PsiMember)psi), (PsiElement)psi)));
        MicroprofileRegisterRestClient.META.register(registrar, (ElementPattern)PsiJavaPatterns.psiClass().isInterface().withAnnotation("org.eclipse.microprofile.rest.client.inject.RegisterRestClient"));
    }

    @NotNull
    private static String findHttpMethod(String annotationName, PsiMember psiMember) {
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)psiMember, (String[])new String[]{annotationName});
        if (annotation == null) {
            return "";
        }
        PsiClass psiAnnotationClass = annotation.resolveAnnotationType();
        if (psiAnnotationClass == null) {
            return "";
        }
        RSAnnotationHttpMethod httpMethodOnAnnotation = (RSAnnotationHttpMethod)RSAnnotationHttpMethod.META.getJamElement((PsiModifierListOwner)psiAnnotationClass);
        if (httpMethodOnAnnotation == null) {
            return "";
        }
        String string = StringUtil.defaultIfEmpty((String)httpMethodOnAnnotation.getMetaHttpMethodName(), (String)"");
        if (string == null) {
            RSSemContributor.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static <T extends JamElement, Psi extends PsiMember> void registerMetaComponents(@NotNull SemService semService, @NotNull SemRegistrar registrar, @NotNull ElementPattern<? extends Psi> place, @NotNull SemKey<JamMemberMeta<Psi, T>> metaKey, @NotNull SemKey<T> semKey, @NotNull Function<? super Psi, ? extends JamMemberMeta<Psi, T>> metaFunction) {
        if (semService == null) {
            RSSemContributor.$$$reportNull$$$0(5);
        }
        if (registrar == null) {
            RSSemContributor.$$$reportNull$$$0(6);
        }
        if (place == null) {
            RSSemContributor.$$$reportNull$$$0(7);
        }
        if (metaKey == null) {
            RSSemContributor.$$$reportNull$$$0(8);
        }
        if (semKey == null) {
            RSSemContributor.$$$reportNull$$$0(9);
        }
        if (metaFunction == null) {
            RSSemContributor.$$$reportNull$$$0(10);
        }
        registrar.registerSemElementProvider(metaKey, place, metaFunction);
        registrar.registerSemElementProvider(semKey, place, member -> {
            JamMemberMeta memberMeta = (JamMemberMeta)semService.getSemElement(metaKey, (PsiElement)member);
            return memberMeta != null ? memberMeta.createJamElement(PsiElementRef.real((PsiElement)member)) : null;
        });
    }

    private static <T extends JamElement, Psi extends PsiMember> Function<Psi, JamMemberMeta<Psi, T>> createFunction(@NotNull SemKey<T> semKey, @NotNull BiFunction<String, ? super Psi, ? extends T> producer) {
        if (semKey == null) {
            RSSemContributor.$$$reportNull$$$0(11);
        }
        if (producer == null) {
            RSSemContributor.$$$reportNull$$$0(12);
        }
        return psiMember -> {
            String qualifiedName;
            if (DumbService.isDumb((Project)psiMember.getProject())) {
                return null;
            }
            if (psiMember instanceof PsiClass && ((PsiClass)psiMember).isAnnotationType()) {
                return null;
            }
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiMember);
            PsiClass annotated = MetaAnnotationUtil.findAnnotationsByMeta((PsiModifierListOwner)psiMember, RSCustomHttpMethod.getMetaAnnotations(module)).findFirst().orElse(null);
            if (annotated != null && (qualifiedName = annotated.getQualifiedName()) != null && !RSCustomHttpMethod.isKnownAnnotation(qualifiedName)) {
                return new JamMemberMeta(null, semKey, ref -> (JamElement)producer.apply(qualifiedName, (Object)ref.getPsiElement()));
            }
            return null;
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "shortName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "registrar";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ws/rest/model/jam/RSSemContributor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semService";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaKey";
                break;
            }
            case 9: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "semKey";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "metaFunction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "producer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ws/rest/model/jam/RSSemContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "findHttpMethod";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildMeta";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "registerSemProviders";
                break;
            }
            case 4: {
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "registerMetaComponents";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "createFunction";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

