/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.config;

import com.intellij.javaee.oss.jboss.config.JBossConfigProcessor;
import com.intellij.javaee.oss.jboss.server.JBossLocalModel;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.server.JavaeeHostConfig;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.CachedConfig;
import com.intellij.openapi.util.Ref;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBoss7HostConfig
extends JavaeeHostConfig {
    private static final Pattern HOST_PATTERN = Pattern.compile(Pattern.quote("${") + "(.+?)(" + Pattern.quote(":") + "((\\d+)(.+?)))?" + Pattern.quote("}"));
    private static final String DEFAULT_ADDRESS = "127.0.0.1";
    private static final JBossHostFactoryBase STANDALONE_MANAGEMENT_BIND_ADDRESS = new JBossHostFactoryBase("Management"){

        @Override
        protected String getXPath() {
            return new String("ns:server/ns:interfaces/ns:interface[@name='management']/ns:inet-address/@value");
        }

        @Override
        protected File getConfigFile(JBossLocalModel data) {
            return JBossVersion7Handler.getConfigFile(data);
        }
    };
    private static final JBossHostFactoryBase DOMAIN_MANAGEMENT_BIND_ADDRESS = new JBossHostFactoryBase("Management"){

        @Override
        protected String getXPath() {
            return new String("ns:host/ns:interfaces/ns:interface[@name='management']/ns:inet-address/@value");
        }

        @Override
        protected File getConfigFile(JBossLocalModel data) {
            return JBossVersion7Handler.getDomainHostFile(data);
        }
    };
    private final JBossHostFactoryBase myFactory;
    private final File myConfigFile;

    public JBoss7HostConfig(JBossHostFactoryBase factory, File configFile) {
        this.myFactory = factory;
        this.myConfigFile = configFile;
    }

    protected long getStamp(JavaeeServerModel data) {
        return JBoss7HostConfig.getStamp((File)this.myConfigFile);
    }

    @Nullable
    protected String getHost(JavaeeServerModel model) {
        String host = (String)new JBossConfigProcessor<String>(this.myFactory.getXPath(), ""){

            @Override
            protected String process(XPath xpath, Document doc) throws JDOMException, IOException {
                Attribute attribute = (Attribute)xpath.selectSingleNode((Object)doc);
                return attribute == null ? null : attribute.getValue();
            }
        }.get(this.myConfigFile);
        return JBoss7HostConfig.parseHost(host, (JBossLocalModel)model, (Ref<String>)new Ref());
    }

    public static String getBindManagementHost(JBossLocalModel model) {
        return JBoss7HostConfig.get((JavaeeHostConfig.Factory)(model.isDomain() ? DOMAIN_MANAGEMENT_BIND_ADDRESS : STANDALONE_MANAGEMENT_BIND_ADDRESS), (JavaeeServerModel)model, (String)DEFAULT_ADDRESS);
    }

    @Contract(value="null, _, _ -> null")
    @Nullable
    public static String parseHost(@Nullable String host, JBossLocalModel model, Ref<String> vmArgName) {
        if (host == null) {
            return null;
        }
        Matcher matcher = HOST_PATTERN.matcher(host);
        if (matcher.matches()) {
            vmArgName.set((Object)matcher.group(1));
            String vmArg = model.getVmArgument((String)vmArgName.get());
            if (vmArg != null) {
                return vmArg;
            }
            host = matcher.group(3);
        }
        return host;
    }

    @ApiStatus.Internal
    public static abstract class JBossHostFactoryBase
    implements JavaeeHostConfig.Factory<JBossLocalModel> {
        private final String myHostKindKey;

        JBossHostFactoryBase(String hostKindKey) {
            this.myHostKindKey = hostKindKey;
        }

        @NotNull
        public CachedConfig.Key createKey(JBossLocalModel data) {
            Object[] keyParts = new String[]{data.getHome(), this.myHostKindKey, "VM:" + data.getVmArguments()};
            return new CachedConfig.Key((String[])(data.isDomain() ? (String[])ArrayUtil.append((Object[])keyParts, (Object)data.getServerGroup()) : keyParts));
        }

        @NotNull
        public JBoss7HostConfig createConfig(JBossLocalModel data) {
            return new JBoss7HostConfig(this, this.getConfigFile(data));
        }

        protected abstract String getXPath();

        protected abstract File getConfigFile(JBossLocalModel var1);
    }
}

