/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesHandlerFactory;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.impl.beanProperties.BeanProperty;
import com.intellij.psi.impl.beanProperties.BeanPropertyFindUsagesHandler;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.highlighting.jam.SpringAutowiredBeanFindUsagesHandler;
import com.intellij.spring.model.highlighting.jam.SpringJavaBeanReferencesFindUsagesHandler;
import com.intellij.spring.model.highlighting.providers.SpringJavaExternalBeanFindUsagesHandler;
import com.intellij.spring.model.properties.SpringPropertiesUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.xml.DomUtil;
import org.jetbrains.annotations.NotNull;

public class SpringFindUsagesHandlerFactory
extends FindUsagesHandlerFactory {
    public boolean canFindUsages(@NotNull PsiElement psiElement) {
        Module module;
        if (psiElement == null) {
            SpringFindUsagesHandlerFactory.$$$reportNull$$$0(0);
        }
        if (!SpringCommonUtils.isSpringConfigured(module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiElement))) {
            return false;
        }
        PsiFile containingFile = psiElement.getContainingFile();
        if (containingFile instanceof XmlFile) {
            return SpringDomUtils.isSpringXml((XmlFile)containingFile);
        }
        return SpringFindUsagesHandlerFactory.isContextBeanCandidate(psiElement) || SpringFindUsagesHandlerFactory.isExternalBean(psiElement);
    }

    private static boolean isExternalBean(PsiElement psiElement) {
        return psiElement instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiElement), (String)"org.springframework.config.java.annotation.ExternalBean", (int)0);
    }

    private static boolean isContextBeanCandidate(PsiElement psiElement) {
        return psiElement instanceof PsiMethod && AnnotationUtil.isAnnotated((PsiModifierListOwner)((PsiModifierListOwner)psiElement), (String)"org.springframework.context.annotation.Bean", (int)0);
    }

    public FindUsagesHandler createFindUsagesHandler(@NotNull PsiElement element, boolean forHighlightUsages) {
        if (element == null) {
            SpringFindUsagesHandlerFactory.$$$reportNull$$$0(1);
        }
        if (SpringFindUsagesHandlerFactory.isContextBeanCandidate(element)) {
            return new SpringAutowiredBeanFindUsagesHandler(element);
        }
        if (SpringFindUsagesHandlerFactory.isExternalBean(element)) {
            return new SpringJavaExternalBeanFindUsagesHandler((PsiMethod)element);
        }
        BeanProperty property = SpringPropertiesUtil.getBeanProperty(element);
        if (property != null) {
            return new BeanPropertyFindUsagesHandler(property);
        }
        CommonSpringBean bean = (CommonSpringBean)DomUtil.findDomElement((PsiElement)element, DomSpringBean.class, (boolean)false);
        if (bean != null) {
            return new SpringJavaBeanReferencesFindUsagesHandler(bean);
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/SpringFindUsagesHandlerFactory";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "canFindUsages";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "createFindUsagesHandler";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

