/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopAdvice;
import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopCommonIcons;
import com.intellij.aop.AopIntroduction;
import com.intellij.aop.jam.AopUastAnnotator;
import com.intellij.aop.jam.utils.AopModelUtils;
import com.intellij.codeInsight.daemon.LineMarkerInfo;
import com.intellij.codeInsight.daemon.LineMarkerProviderDescriptor;
import com.intellij.codeInsight.navigation.NavigationGutterIconBuilder;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.spring.aop.SpringAopBundle;
import com.intellij.spring.aop.model.xml.DeclareParents;
import com.intellij.spring.aop.model.xml.SpringAopAdvice;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.xml.util.XmlTagUtil;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAopAnnotator
extends LineMarkerProviderDescriptor {
    public String getId() {
        return "SpringAopAnnotator";
    }

    @NotNull
    public String getName() {
        String string = SpringAopBundle.message("SpringAopAnnotator.annotator.name", new Object[0]);
        if (string == null) {
            SpringAopAnnotator.$$$reportNull$$$0(0);
        }
        return string;
    }

    @Nullable
    public Icon getIcon() {
        return AopCommonIcons.Abstract_advice;
    }

    public LineMarkerInfo<?> getLineMarkerInfo(@NotNull PsiElement element) {
        if (element == null) {
            SpringAopAnnotator.$$$reportNull$$$0(1);
        }
        return null;
    }

    public void collectSlowLineMarkers(@NotNull List<? extends PsiElement> elements, @NotNull Collection<? super LineMarkerInfo<?>> result2) {
        if (elements == null) {
            SpringAopAnnotator.$$$reportNull$$$0(2);
        }
        if (result2 == null) {
            SpringAopAnnotator.$$$reportNull$$$0(3);
        }
        if (elements.isEmpty()) {
            return;
        }
        PsiFile file = elements.get(0).getContainingFile();
        if (!(file instanceof XmlFile)) {
            return;
        }
        XmlFile xmlFile = (XmlFile)file;
        if (!SpringDomUtils.isSpringXml(xmlFile)) {
            return;
        }
        int size = elements.size();
        for (int i = 0; i < size; ++i) {
            ProgressManager.checkCanceled();
            PsiElement element = elements.get(i);
            SpringAopAnnotator.annotate(element, result2);
        }
    }

    private static void annotate(PsiElement psiElement, Collection<? super LineMarkerInfo<?>> result2) {
        XmlTag tag;
        PsiElement psiElement2;
        if (psiElement instanceof XmlToken && (psiElement2 = psiElement.getParent()) instanceof XmlTag && XmlTagUtil.getStartTagNameElement((XmlTag)(tag = (XmlTag)psiElement2)) == psiElement) {
            PsiClass psiClass;
            DomElement element = DomManager.getDomManager((Project)psiElement.getProject()).getDomElement(tag);
            if (element instanceof SpringAopAdvice) {
                SpringAopAdvice advice = (SpringAopAdvice)element;
                result2.add((LineMarkerInfo<?>)AopUastAnnotator.addNavigationToInterceptedMethods((AopAdvice)advice, (AopAdvisedElementsSearcher)advice.getSearcher()).createLineMarkerInfo(psiElement));
            } else if (element instanceof DeclareParents) {
                NavigationGutterIconBuilder builder = AopUastAnnotator.addNavigationToIntroducedClasses((AopIntroduction)((DeclareParents)element));
                if (builder != null) {
                    result2.add((LineMarkerInfo<?>)builder.createLineMarkerInfo(psiElement));
                }
            } else if (element instanceof DomSpringBean && (psiClass = PsiTypesUtil.getPsiClass((PsiType)((DomSpringBean)element).getBeanType())) != null) {
                List introductions;
                Map advices = AopModelUtils.getBoundAdvices((PsiClass)psiClass);
                if (!advices.isEmpty()) {
                    result2.add((LineMarkerInfo<?>)AopUastAnnotator.addNavigationToBoundAdvices((Map)advices).createLineMarkerInfo(psiElement));
                }
                if (!(introductions = AopModelUtils.getBoundIntroductions((PsiClass)psiClass)).isEmpty()) {
                    result2.add((LineMarkerInfo<?>)AopUastAnnotator.addNavigationToBoundIntroductions((List)introductions).createLineMarkerInfo(psiElement));
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/aop/SpringAopAnnotator";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/aop/SpringAopAnnotator";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getLineMarkerInfo";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "collectSlowLineMarkers";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3 -> new IllegalArgumentException(string);
        };
    }
}

