/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.aop;

import com.intellij.aop.AopAdvice;
import com.intellij.aop.AopAdvisedElementsSearcher;
import com.intellij.aop.AopAspect;
import com.intellij.aop.AopProvider;
import com.intellij.aop.ArgNamesManipulator;
import com.intellij.aop.psi.AllAdvisedElementsSearcher;
import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.SpringManager;
import com.intellij.spring.SpringModelVisitorUtils;
import com.intellij.spring.aop.SpringAdvisedElementsSearcher;
import com.intellij.spring.aop.SpringArgNamesManipulator;
import com.intellij.spring.aop.model.xml.AopConfig;
import com.intellij.spring.aop.model.xml.BasicAdvice;
import com.intellij.spring.aop.model.xml.SpringAopAdvice;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.util.PerformanceAssertions;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringAopProvider
extends AopProvider {
    public boolean isAvailable(@NotNull Module module) {
        if (module == null) {
            SpringAopProvider.$$$reportNull$$$0(0);
        }
        return SpringCommonUtils.isSpringConfigured(module);
    }

    @NotNull
    public Set<? extends AopAspect> getAdditionalAspects(@NotNull Module module) {
        if (module == null) {
            SpringAopProvider.$$$reportNull$$$0(1);
        }
        if (!SpringCommonUtils.isSpringConfigured(module)) {
            Set set = Collections.emptySet();
            if (set == null) {
                SpringAopProvider.$$$reportNull$$$0(2);
            }
            return set;
        }
        if (!SpringAopProvider.hasSpringXmlInModule(module)) {
            Set set = Collections.emptySet();
            if (set == null) {
                SpringAopProvider.$$$reportNull$$$0(3);
            }
            return set;
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            HashSet<AopAspect> set = new HashSet<AopAspect>();
            HashSet<XmlFile> configFiles = new HashSet<XmlFile>();
            Set<SpringModel> models = SpringManager.getInstance(module.getProject()).getAllModelsWithoutDependencies(module);
            for (SpringModel model : models) {
                for (LocalXmlModel localXmlModel : SpringModelVisitorUtils.getLocalXmlModels(model)) {
                    DomFileElement<Beans> element = localXmlModel.getRoot();
                    if (element == null) continue;
                    configFiles.add(element.getFile());
                    if (!SpringDomUtils.hasNamespace(element, "Spring AOP namespace key")) continue;
                    SpringAopProvider.addAopAspects(set, element.getRootElement());
                }
            }
            Object[] dependencies = SpringManager.getInstance(module.getProject()).getModelsDependencies(module, configFiles.toArray());
            return new CachedValueProvider.Result(set, dependencies);
        });
        if (set == null) {
            SpringAopProvider.$$$reportNull$$$0(4);
        }
        return set;
    }

    private static boolean hasSpringXmlInModule(@NotNull Module module) {
        if (module == null) {
            SpringAopProvider.$$$reportNull$$$0(5);
        }
        return (Boolean)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> {
            GlobalSearchScope scope = module.getModuleRuntimeScope(false);
            return CachedValueProvider.Result.create((Object)(!DomService.getInstance().getDomFileCandidates(Beans.class, scope).isEmpty() ? 1 : 0), (Object[])new Object[]{DomManager.getDomManager((Project)module.getProject())});
        });
    }

    protected static Set<AopAspect> addAopAspects(Set<AopAspect> set, DomElement element) {
        for (DomElement child : DomUtil.getDefinedChildren((DomElement)element, (boolean)true, (boolean)false)) {
            if (child instanceof AopAspect) {
                AopAspect aspect = (AopAspect)child;
                set.add(aspect);
                continue;
            }
            if (!(child instanceof AopConfig)) continue;
            AopConfig config = (AopConfig)child;
            set.addAll(config.getAdvisors());
            set.addAll(config.getAspects());
        }
        return set;
    }

    public AopAdvisedElementsSearcher getAdvisedElementsSearcher(@NotNull PsiClass aClass) {
        if (aClass == null) {
            SpringAopProvider.$$$reportNull$$$0(6);
        }
        PerformanceAssertions.assertDoesNotAffectHighlighting();
        PsiFile file = aClass.getContainingFile();
        if (file == null) {
            return null;
        }
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return AopAdvisedElementsSearcher.EMPTY;
        }
        return (AopAdvisedElementsSearcher)CachedValuesManager.getManager((Project)module.getProject()).getCachedValue((UserDataHolder)module, () -> CachedValueProvider.Result.create((Object)SpringAopProvider.getModuleElementsSearcher(module), (Object[])SpringManager.getInstance(module.getProject()).getModelsDependencies(module, PsiModificationTracker.MODIFICATION_COUNT)));
    }

    @NotNull
    private static AopAdvisedElementsSearcher getModuleElementsSearcher(@NotNull Module module) {
        if (module == null) {
            SpringAopProvider.$$$reportNull$$$0(7);
        }
        return SpringAopProvider.hasNoSpringFacetAtAll(module) ? new AllAdvisedElementsSearcher(module) : new SpringAdvisedElementsSearcher(module.getProject(), module, () -> SpringManager.getInstance(module.getProject()).getCombinedModel(module));
    }

    private static boolean hasNoSpringFacetAtAll(Module module) {
        return !SpringCommonUtils.isSpringConfigured(module.getProject()) || ModuleUtilCore.visitMeAndDependentModules((Module)module, checkModule -> !SpringCommonUtils.isSpringConfigured(checkModule));
    }

    @Nullable
    public Pair<? extends ArgNamesManipulator, PsiMethod> getCustomArgNamesManipulator(@NotNull PsiElement element) {
        DomElement domElement;
        XmlTag tag;
        if (element == null) {
            SpringAopProvider.$$$reportNull$$$0(8);
        }
        if (element instanceof XmlAttributeValue && element.getParent() instanceof XmlAttribute && "pointcut-ref".equals(((XmlAttribute)element.getParent()).getLocalName()) && (tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)element, XmlTag.class)) != null && (domElement = DomManager.getDomManager((Project)element.getProject()).getDomElement(tag)) instanceof BasicAdvice) {
            BasicAdvice advice = (BasicAdvice)domElement;
            PsiMethod method = (PsiMethod)advice.getMethod().getValue();
            if (advice.getPointcut().getStringValue() == null && method != null) {
                return Pair.create((Object)((Object)new SpringArgNamesManipulator(tag)), (Object)method);
            }
        }
        return super.getCustomArgNamesManipulator(element);
    }

    public Integer getAdviceOrder(AopAdvice advice) {
        if (advice instanceof SpringAopAdvice) {
            return (Integer)((SpringAopAdvice)advice).getOrder().getValue();
        }
        PsiElement element = advice.getIdentifyingPsiElement();
        if (element instanceof PsiAnnotation) {
            PsiClass aClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)element, PsiClass.class, (boolean)false);
            if (aClass == null) {
                return null;
            }
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)aClass, (boolean)true, (String[])new String[]{"org.springframework.core.annotation.Order"});
            if (annotation != null) {
                Object o;
                PsiAnnotationMemberValue value = annotation.findDeclaredAttributeValue("value");
                if (value instanceof PsiExpression && (o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)((PsiExpression)value), (boolean)false)) instanceof Integer) {
                    return (Integer)o;
                }
                return null;
            }
            PsiClass orderedClass = JavaPsiFacade.getInstance((Project)aClass.getProject()).findClass("org.springframework.core.Ordered", aClass.getResolveScope());
            if (orderedClass != null && aClass.isInheritor(orderedClass, true)) {
                PsiMethod[] methods;
                for (PsiMethod method : methods = aClass.findMethodsByName("getOrder", true)) {
                    PsiExpression value;
                    Object o;
                    PsiStatement first;
                    PsiCodeBlock body = method.getBody();
                    if (method.getParameterList().getParametersCount() != 0 || body == null || body.getStatements().length != 1 || !((first = body.getStatements()[0]) instanceof PsiReturnStatement) || !((o = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)(value = ((PsiReturnStatement)first).getReturnValue()), (boolean)false)) instanceof Integer)) continue;
                    return (Integer)o;
                }
            }
        }
        return super.getAdviceOrder(advice);
    }

    @NotNull
    public static SpringAdvisedElementsSearcher getLocalModelSearcher(@NotNull PsiFile file) {
        if (file == null) {
            SpringAopProvider.$$$reportNull$$$0(9);
        }
        SpringAdvisedElementsSearcher springAdvisedElementsSearcher = (SpringAdvisedElementsSearcher)((Object)CachedValuesManager.getCachedValue((PsiElement)file, () -> {
            SpringAdvisedElementsSearcher searcher = new SpringAdvisedElementsSearcher(file.getProject(), ModuleUtilCore.findModuleForFile((PsiFile)file), () -> file instanceof XmlFile ? SpringModelUtils.getInstance().getSpringModel((PsiElement)file) : SpringModel.UNKNOWN);
            return CachedValueProvider.Result.create((Object)((Object)searcher), (Object[])new Object[]{file});
        }));
        if (springAdvisedElementsSearcher == null) {
            SpringAopProvider.$$$reportNull$$$0(10);
        }
        return springAdvisedElementsSearcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 4, 10 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/aop/SpringAopProvider";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/aop/SpringAopProvider";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalAspects";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getLocalModelSearcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isAvailable";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getAdditionalAspects";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 10: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "hasSpringXmlInModule";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdvisedElementsSearcher";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getModuleElementsSearcher";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCustomArgNamesManipulator";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getLocalModelSearcher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 4, 10 -> new IllegalStateException(string);
        };
    }
}

