/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.chooser;

import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.chooser.SpringContextDescriptor;
import com.intellij.spring.contexts.chooser.SpringMultipleContextsManager;
import com.intellij.spring.editor.SpringEditorNotificationPanel;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.LightColors;
import com.intellij.ui.components.JBList;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class SpringMultipleContextsPanel
extends SpringEditorNotificationPanel {
    private final PsiFile myPsiFile;
    private final List<SpringContextDescriptor> myDescriptors;

    SpringMultipleContextsPanel(@NotNull FileEditor fileEditor, @NotNull PsiFile psiFile, @NotNull List<SpringContextDescriptor> descriptors, @NotNull SpringContextDescriptor currentContext) {
        if (fileEditor == null) {
            SpringMultipleContextsPanel.$$$reportNull$$$0(0);
        }
        if (psiFile == null) {
            SpringMultipleContextsPanel.$$$reportNull$$$0(1);
        }
        if (descriptors == null) {
            SpringMultipleContextsPanel.$$$reportNull$$$0(2);
        }
        if (currentContext == null) {
            SpringMultipleContextsPanel.$$$reportNull$$$0(3);
        }
        super(fileEditor, LightColors.SLIGHTLY_GREEN, EditorNotificationPanel.Status.Info);
        this.myPsiFile = psiFile;
        this.myDescriptors = descriptors;
        Set<Module> modules = SpringMultipleContextsPanel.getModules(descriptors);
        JPanel myDescriptorPanel = new JPanel(new FlowLayout(0, JBUIScale.scale((int)3), JBUIScale.scale((int)5)));
        this.add(myDescriptorPanel, "West");
        myDescriptorPanel.setToolTipText(SpringBundle.message("multiple.context.tooltip.text", new Object[0]));
        myDescriptorPanel.add((Component)this.addChangeContextLabel(currentContext));
        if (!modules.isEmpty()) {
            SpringMultipleContextsPanel.addModuleLabel(myDescriptorPanel, currentContext);
        }
        SpringMultipleContextsPanel.addTotalContextsDescriptionLabel(myDescriptorPanel, descriptors, modules);
        myDescriptorPanel.setBackground(this.getBackground());
        this.installOpenSettingsButton(psiFile.getProject());
    }

    private static void addTotalContextsDescriptionLabel(JPanel descriptorPanel, List<SpringContextDescriptor> descriptors, Set<Module> modules) {
        String message = modules.size() > 1 ? SpringBundle.message("multiple.context.description.in.modules.label.text", descriptors.size(), modules.size()) : SpringBundle.message("multiple.context.description.label.text", descriptors.size());
        SpringMultipleContextsPanel.addLabel(descriptorPanel, message, null);
    }

    private static void addModuleLabel(JPanel descriptorPanel, SpringContextDescriptor currentContext) {
        Module module = currentContext.getModule();
        if (module != null) {
            SpringMultipleContextsPanel.addLabel(descriptorPanel, SpringBundle.message("multiple.context.description.in.module.text", module.getName()), null);
        }
    }

    private static Set<Module> getModules(List<SpringContextDescriptor> descriptors) {
        LinkedHashSet<Module> modules = new LinkedHashSet<Module>();
        for (SpringContextDescriptor descriptor : descriptors) {
            Module module = descriptor.getModule();
            if (module == null) continue;
            modules.add(module);
        }
        return modules;
    }

    private HyperlinkLabel addChangeContextLabel(final SpringContextDescriptor currentContext) {
        final HyperlinkLabel label = new HyperlinkLabel(currentContext.getName(), this.getBackground());
        label.setIcon(SpringApiIcons.FileSet);
        label.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

            public void hyperlinkActivated(@NotNull HyperlinkEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                JBList list = new JBList(SpringMultipleContextsPanel.this.myDescriptors);
                list.installCellRenderer(contextDescriptor -> {
                    JPanel panel = new JPanel(new BorderLayout());
                    Icon icon = contextDescriptor.equals(currentContext) ? AllIcons.Actions.Checked : EmptyIcon.create((Icon)AllIcons.Actions.Checked);
                    @NlsSafe String name1 = contextDescriptor.getName();
                    if (contextDescriptor.isPredefinedContext()) {
                        name1 = String.format("<html><b>%s</b></html>", name1);
                    }
                    JLabel descriptorLabel = new JLabel(name1, icon, 2);
                    descriptorLabel.setBorder((Border)JBUI.Borders.emptyRight((int)10));
                    panel.add((Component)descriptorLabel, "West");
                    Module module = contextDescriptor.getModule();
                    if (module != null) {
                        JPanel modulePanel = new JPanel(new BorderLayout());
                        modulePanel.setOpaque(false);
                        modulePanel.add((Component)new JLabel("    " + module.getName()), "West");
                        JLabel iconLabel = new JLabel("", ModuleType.get((Module)module).getIcon(), 2);
                        iconLabel.setBorder((Border)JBUI.Borders.emptyRight((int)2));
                        modulePanel.add((Component)iconLabel, "East");
                        panel.add((Component)modulePanel, "East");
                    }
                    panel.setBorder(JBUI.Borders.empty((int)1));
                    return panel;
                });
                JBPopup popup = JBPopupFactory.getInstance().createListPopupBuilder((JList)list).setItemChosenCallback(() -> {
                    SpringContextDescriptor value = (SpringContextDescriptor)list.getSelectedValue();
                    if (value != null) {
                        SpringMultipleContextsPanel.this.saveSelectedContext(value);
                        Project project = SpringMultipleContextsPanel.this.myPsiFile.getProject();
                        EditorNotifications.getInstance((Project)project).updateAllNotifications();
                        SpringModificationTrackersManager.getInstance(project).fireMultipleContextsChanged();
                        PsiManager.getInstance((Project)project).dropPsiCaches();
                    }
                }).setFilteringEnabled(o -> {
                    if (!(o instanceof SpringContextDescriptor)) {
                        return null;
                    }
                    SpringContextDescriptor descriptor = (SpringContextDescriptor)o;
                    Module module = descriptor.getModule();
                    return module != null ? descriptor.getName() + " " + module.getName() : descriptor.getName();
                }).createPopup();
                DataContext context = DataManager.getInstance().getDataContext((Component)label);
                popup.showInBestPositionFor(context);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/spring/contexts/chooser/SpringMultipleContextsPanel$1", "hyperlinkActivated"));
            }
        });
        return label;
    }

    private void saveSelectedContext(@NotNull SpringContextDescriptor value) {
        if (value == null) {
            SpringMultipleContextsPanel.$$$reportNull$$$0(4);
        }
        SpringMultipleContextsManager.getInstance().persistDescriptor(this.myPsiFile, value);
    }

    private static void addLabel(@NotNull JPanel panel, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String s, @Nullable Icon icon) {
        if (panel == null) {
            SpringMultipleContextsPanel.$$$reportNull$$$0(5);
        }
        if (s == null) {
            SpringMultipleContextsPanel.$$$reportNull$$$0(6);
        }
        panel.add(new JLabel(s, icon, 2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileEditor";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptors";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "currentContext";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "panel";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/contexts/chooser/SpringMultipleContextsPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "saveSelectedContext";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "addLabel";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

