/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.diagrams.contexts.actions;

import com.intellij.diagram.DiagramProvider;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.diagrams.beans.SpringDiagramProvider;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.uml.core.actions.ShowDiagram;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/spring/diagrams/contexts/actions/ShowBeansDiagramAction;", "Lcom/intellij/uml/core/actions/ShowDiagram;", "<init>", "()V", "getForcedProvider", "Lcom/intellij/diagram/DiagramProvider;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.spring.graph"})
public final class ShowBeansDiagramAction
extends ShowDiagram {
    public ShowBeansDiagramAction() {
        super(false, false, 3, null);
    }

    @NotNull
    public DiagramProvider<?> getForcedProvider(@NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        return new SpringDiagramProvider();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        boolean springConfigured = SpringCommonUtils.isSpringConfigured(project);
        e.getPresentation().setEnabledAndVisible(springConfigured);
        if (springConfigured) {
            super.update(e);
            e.getPresentation().setIcon(SpringApiIcons.SpringDiagrams);
            e.getPresentation().setVisible(true);
        }
    }
}

