/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.diagrams.contexts.extras;

import com.intellij.diagram.AbstractDiagramElementManager;
import com.intellij.diagram.presentation.DiagramState;
import com.intellij.ide.projectView.impl.ProjectRootsUtil;
import com.intellij.jam.model.util.JamCommonUtil;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.SpringApiIcons;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.SpringLocalModelFactory;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.diagrams.contexts.beans.LocalAnnotationModelWrapper;
import com.intellij.spring.diagrams.contexts.beans.LocalModelGraphElementWrapper;
import com.intellij.spring.diagrams.contexts.beans.LocalModelWrapper;
import com.intellij.spring.diagrams.contexts.beans.LocalXmlModelWrapper;
import com.intellij.spring.diagrams.contexts.beans.ModuleLocalModelWrapper;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.ui.SimpleColoredText;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;

public final class SpringLocalModelsDiagramElementManager
extends AbstractDiagramElementManager<LocalModelGraphElementWrapper<?>> {
    @Nullable
    private final SmartPsiElementPointer<PsiElement> myPointer;

    public SpringLocalModelsDiagramElementManager(@Nullable SmartPsiElementPointer<PsiElement> pointer) {
        this.myPointer = pointer;
    }

    @Nullable
    public LocalModelGraphElementWrapper<?> findInDataContext(@NotNull DataContext context) {
        PsiClass[] classes;
        PsiElement element;
        LocalModel<?> model;
        if (context == null) {
            SpringLocalModelsDiagramElementManager.$$$reportNull$$$0(0);
        }
        if ((model = SpringLocalModelsDiagramElementManager.findPsiClass((element = this.myPointer != null ? this.myPointer.getElement() : null) != null ? element : (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(context))) != null) {
            return LocalModelWrapper.create(model);
        }
        PsiFile psiFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(context);
        if (psiFile != null && !SpringLibraryUtil.hasSpringLibrary(psiFile.getProject())) {
            return null;
        }
        if (JamCommonUtil.isPlainXmlFile((PsiElement)psiFile) && SpringDomUtils.isSpringXml((XmlFile)psiFile)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
            if (module == null) {
                return null;
            }
            LocalXmlModel localXmlModel = SpringLocalModelFactory.getInstance().getOrCreateLocalXmlModel((XmlFile)psiFile, module, Collections.emptySet());
            return LocalXmlModelWrapper.create(localXmlModel);
        }
        if (JamCommonUtil.isPlainJavaFile((PsiElement)psiFile) && (classes = ((PsiJavaFile)psiFile).getClasses()).length == 1 && SpringCommonUtils.isConfigurationOrMeta(classes[0])) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiFile);
            if (module == null) {
                return null;
            }
            LocalAnnotationModel localAnnotationModel = SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(classes[0], module, Collections.emptySet());
            return LocalAnnotationModelWrapper.create(localAnnotationModel);
        }
        Module module = (Module)LangDataKeys.MODULE_CONTEXT.getData(context);
        if (SpringCommonUtils.isSpringConfigured(module)) {
            Project project = module.getProject();
            VirtualFile moduleFolder = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(context);
            if (moduleFolder != null && ProjectRootsUtil.isModuleContentRoot((VirtualFile)moduleFolder, (Project)project)) {
                return ModuleLocalModelWrapper.create(module);
            }
        }
        return null;
    }

    @Nullable
    private static LocalModel<?> findPsiClass(@Nullable PsiElement element) {
        if (element != null && !SpringLibraryUtil.hasSpringLibrary(element.getProject())) {
            return null;
        }
        UElement uElement = UastContextKt.toUElement((PsiElement)element);
        if (uElement == null) {
            return null;
        }
        PsiClass psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)UastUtils.getParentOfType((UElement)uElement, UClass.class, (boolean)false), PsiClass.class);
        if (psiClass != null && SpringCommonUtils.isConfigurationOrMeta(psiClass)) {
            Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            if (module == null) {
                return null;
            }
            return SpringLocalModelFactory.getInstance().getOrCreateLocalAnnotationModel(psiClass, module, Collections.emptySet());
        }
        return null;
    }

    public boolean isAcceptableAsNode(@Nullable Object element) {
        return element instanceof LocalModelGraphElementWrapper;
    }

    public String getElementTitle(LocalModelGraphElementWrapper model) {
        return SpringLocalModelsDiagramElementManager.getLocalModelConfigFileName(model);
    }

    @NlsSafe
    private static String getLocalModelConfigFileName(LocalModelGraphElementWrapper<?> model) {
        return model.getTitle();
    }

    @Nullable
    public SimpleColoredText getItemName(@Nullable Object obj, @NotNull DiagramState presentation) {
        if (presentation == null) {
            SpringLocalModelsDiagramElementManager.$$$reportNull$$$0(1);
        }
        if (obj instanceof LocalModelGraphElementWrapper) {
            return new SimpleColoredText(SpringLocalModelsDiagramElementManager.getLocalModelConfigFileName((LocalModelGraphElementWrapper)obj), DEFAULT_TEXT_ATTR);
        }
        return null;
    }

    @Nullable
    @Nls
    public String getNodeTooltip(LocalModelGraphElementWrapper element) {
        return element.getToolTip();
    }

    @Nullable
    public Icon getItemIcon(@Nullable Object model, @NotNull DiagramState presentation) {
        if (presentation == null) {
            SpringLocalModelsDiagramElementManager.$$$reportNull$$$0(2);
        }
        if (model instanceof LocalAnnotationModel) {
            return ((LocalAnnotationModel)model).getConfig().getIcon(0);
        }
        if (model instanceof LocalXmlModel) {
            return ((XmlFile)((LocalXmlModel)model).getConfig()).getIcon(0);
        }
        return SpringApiIcons.Spring;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentation";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/diagrams/contexts/extras/SpringLocalModelsDiagramElementManager";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "findInDataContext";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getItemIcon";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

