/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.facet;

import com.intellij.facet.ui.FacetEditorContext;
import com.intellij.facet.ui.FacetEditorTab;
import com.intellij.facet.ui.FacetEditorValidator;
import com.intellij.facet.ui.FacetValidatorsManager;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.ActionUpdateThreadAware;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.AnActionWrapper;
import com.intellij.openapi.actionSystem.CheckedActionGroup;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.PlatformEditorBundle;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringConfigurationTabSettings;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetEditorCustomization;
import com.intellij.spring.facet.SpringFileSetImpl;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.facet.editor.FileSetEditor;
import com.intellij.spring.facet.nodes.ConfigFileNode;
import com.intellij.spring.facet.nodes.DependencyNode;
import com.intellij.spring.facet.nodes.FileSetNode;
import com.intellij.spring.facet.nodes.FilesetGroupNode;
import com.intellij.spring.facet.searchers.CodeConfigSearcher;
import com.intellij.spring.facet.searchers.XmlConfigSearcher;
import com.intellij.spring.facet.validation.FileSetDependenciesValidator;
import com.intellij.spring.facet.validation.FilesetContainsConfigFilesInTestsSourceValidator;
import com.intellij.spring.facet.validation.UnmappedConfigurationFilesValidator;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.AutoExpandSimpleNodeListener;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.NonUrgentExecutor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SpringConfigurationTab
extends FacetEditorTab
implements Disposable {
    private final JPanel myMainPanel;
    private final SimpleTree myTree;
    private final SpringConfigurationTabSettings myConfigurationTabSettings;
    private final SpringFacet myFacet;
    private final FacetEditorContext myContext;
    private final FacetValidatorsManager myValidatorsManager;
    private final List<SpringFileSet> myBuffer = new CopyOnWriteArrayList<SpringFileSet>();
    private final StructureTreeModel<SimpleTreeStructure> myTreeModel;
    private boolean myModified;
    private final SimpleNode myRoot = new SimpleNode(){

        public SimpleNode @NotNull [] getChildren() {
            ArrayList<FileSetNode> nodes = new ArrayList<FileSetNode>(SpringConfigurationTab.this.myBuffer.size());
            for (SpringFileSet springFileSet : SpringConfigurationTab.this.myBuffer) {
                if (springFileSet.isRemoved()) continue;
                FileSetNode fileSetNode = new FileSetNode(springFileSet, SpringConfigurationTab.this.myConfigurationTabSettings, this);
                nodes.add(fileSetNode);
            }
            SimpleNode[] simpleNodeArray = nodes.toArray(new SimpleNode[0]);
            if (simpleNodeArray == null) {
                1.$$$reportNull$$$0(0);
            }
            return simpleNodeArray;
        }

        public boolean isAutoExpandNode() {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringConfigurationTab$1", "getChildren"));
        }
    };

    SpringConfigurationTab(FacetEditorContext context, FacetValidatorsManager validatorsManager) {
        this.myFacet = (SpringFacet)context.getFacet();
        this.myConfigurationTabSettings = SpringConfigurationTabSettings.getInstance(context.getProject());
        this.myContext = context;
        this.myValidatorsManager = validatorsManager;
        SimpleTreeStructure structure = new SimpleTreeStructure(){

            @NotNull
            public Object getRootElement() {
                SimpleNode simpleNode = SpringConfigurationTab.this.myRoot;
                if (simpleNode == null) {
                    2.$$$reportNull$$$0(0);
                }
                return simpleNode;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/facet/SpringConfigurationTab$2", "getRootElement"));
            }
        };
        this.myTreeModel = new StructureTreeModel((AbstractTreeStructure)structure, (Disposable)this);
        this.myTree = new SimpleTree();
        this.myTree.setRootVisible(false);
        this.myTree.getEmptyText().setText(SpringBundle.message("config.no.contexts.defined", new Object[0]));
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel(this.myTreeModel, (Disposable)this);
        asyncTreeModel.addTreeModelListener((TreeModelListener)new AutoExpandSimpleNodeListener((JTree)this.myTree));
        this.myTree.setModel((TreeModel)asyncTreeModel);
        this.myMainPanel = new JPanel(new BorderLayout());
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this);
        loadingPanel.setLoadingText(SpringBundle.message("config.detecting.contexts", new Object[0]));
        loadingPanel.startLoading();
        this.myMainPanel.add((Component)loadingPanel, "Center");
        ReadAction.nonBlocking(() -> SpringFileSetService.getInstance().getAllSets(this.myFacet)).finishOnUiThread(ModalityState.any(), allFileSets -> {
            ToolbarDecorator decorator = ToolbarDecorator.createDecorator((JTree)this.myTree).setAddAction((AnActionButtonRunnable)new CreateApplicationContextAction()).setRemoveAction((AnActionButtonRunnable)new RemoveSelectedNodesAction()).setRemoveActionUpdater(e -> this.getCurrentFileSet() != null).setEditAction((AnActionButtonRunnable)new EditApplicationContextAction(this.myFacet)).setEditActionUpdater(e -> {
                SpringFileSet fileSet = this.getCurrentFileSet();
                return fileSet != null && !fileSet.isAutodetected();
            }).disableUpDownActions();
            ActionGroup additionalSettingsActionGroup = this.getAdditionalSettingsActionGroup((Set<SpringFileSet>)allFileSets);
            if (additionalSettingsActionGroup != null) {
                decorator.addExtraAction((AnAction)additionalSettingsActionGroup);
            }
            for (final SpringFileSetEditorCustomization customization : (SpringFileSetEditorCustomization[])SpringFileSetEditorCustomization.EP_NAME.getExtensions()) {
                if (!ContainerUtil.exists((Iterable)allFileSets, customization::isApplicable)) continue;
                for (AnAction extraAction : customization.getExtraActions()) {
                    AnActionWrapper extraActionWrapper = new AnActionWrapper(extraAction){

                        public void actionPerformed(@NotNull AnActionEvent e) {
                            if (e == null) {
                                3.$$$reportNull$$$0(0);
                            }
                            SpringFileSet set = SpringConfigurationTab.this.getCurrentFileSet();
                            assert (set != null);
                            assert (set.isAutodetected());
                            DataManager.getInstance().saveInDataContext(e.getDataContext(), SpringFileSetEditorCustomization.EXTRA_ACTION_FILESET, (Object)set);
                            super.actionPerformed(e);
                            int idx = SpringConfigurationTab.this.myBuffer.indexOf(set);
                            SpringConfigurationTab.this.myBuffer.remove(set);
                            ((SpringFacetConfiguration)SpringConfigurationTab.this.myFacet.getConfiguration()).setModified();
                            for (SpringFileSet fileSet : SpringFileSetService.getInstance().getModelProviderSets(SpringConfigurationTab.this.myFacet)) {
                                if (!fileSet.getId().equals(set.getId())) continue;
                                SpringConfigurationTab.this.addToBuffer(idx, fileSet);
                                SpringConfigurationTab.this.myModified = true;
                                SpringConfigurationTab.this.myTreeModel.invalidateAsync().thenRun(() -> SpringConfigurationTab.this.selectFileSet(fileSet));
                                break;
                            }
                            SpringConfigurationTab.this.validateFileSetConfiguration();
                        }

                        @NotNull
                        public ActionUpdateThread getActionUpdateThread() {
                            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                            if (actionUpdateThread == null) {
                                3.$$$reportNull$$$0(1);
                            }
                            return actionUpdateThread;
                        }

                        public void update(@NotNull AnActionEvent e) {
                            if (e == null) {
                                3.$$$reportNull$$$0(2);
                            }
                            SpringFileSet currentFileSet = SpringConfigurationTab.this.getCurrentFileSet();
                            e.getPresentation().setEnabled(currentFileSet != null && currentFileSet.isAutodetected() && customization.isApplicable(currentFileSet));
                        }

                        private static /* synthetic */ void $$$reportNull$$$0(int n) {
                            Object[] objectArray;
                            Object[] objectArray2;
                            Object[] objectArray3 = new Object[switch (n) {
                                default -> 3;
                                case 1 -> 2;
                            }];
                            switch (n) {
                                default: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "e";
                                    break;
                                }
                                case 1: {
                                    objectArray2 = objectArray3;
                                    objectArray3[0] = "com/intellij/spring/facet/SpringConfigurationTab$3";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "com/intellij/spring/facet/SpringConfigurationTab$3";
                                    break;
                                }
                                case 1: {
                                    objectArray = objectArray2;
                                    objectArray2[1] = "getActionUpdateThread";
                                    break;
                                }
                            }
                            switch (n) {
                                default: {
                                    objectArray = objectArray;
                                    objectArray[2] = "actionPerformed";
                                    break;
                                }
                                case 1: {
                                    break;
                                }
                                case 2: {
                                    objectArray = objectArray;
                                    objectArray[2] = "update";
                                    break;
                                }
                            }
                            String string = String.format(v0, objectArray);
                            throw switch (n) {
                                default -> new IllegalArgumentException(string);
                                case 1 -> new IllegalStateException(string);
                            };
                        }
                    };
                    decorator.addExtraAction((AnAction)extraActionWrapper);
                }
            }
            JPanel decoratorPanel = decorator.createPanel();
            ActionToolbar displaySettingsToolbar = ActionManager.getInstance().createActionToolbar("SpringFacetDisplaySettingsToolbar", this.getDisplaySettingsActionGroup(), false);
            displaySettingsToolbar.setTargetComponent((JComponent)decoratorPanel);
            decoratorPanel.add((Component)displaySettingsToolbar.getComponent(), "East");
            loadingPanel.stopLoading();
            this.myMainPanel.remove((Component)loadingPanel);
            this.myMainPanel.add((Component)decoratorPanel, "Center");
        }).submit((Executor)NonUrgentExecutor.getInstance());
        List<SpringFileSet> validatorBuffer = Collections.unmodifiableList(this.myBuffer);
        FileSetDependenciesValidator dependenciesValidator = new FileSetDependenciesValidator(validatorBuffer);
        this.myValidatorsManager.registerValidator((FacetEditorValidator)dependenciesValidator, new JComponent[0]);
        UnmappedConfigurationFilesValidator unmappedConfigurationFilesValidator = new UnmappedConfigurationFilesValidator(validatorBuffer, this.myContext.getModule());
        this.myValidatorsManager.registerValidator((FacetEditorValidator)unmappedConfigurationFilesValidator, new JComponent[0]);
        FilesetContainsConfigFilesInTestsSourceValidator containsTestConfigsValidator = new FilesetContainsConfigFilesInTestsSourceValidator(this.myContext.getModule(), validatorBuffer);
        this.myValidatorsManager.registerValidator((FacetEditorValidator)containsTestConfigsValidator, new JComponent[0]);
    }

    @NotNull
    private Set<CustomSetting> getCustomSettings() {
        Set<CustomSetting> set = ((SpringFacetConfiguration)this.myFacet.getConfiguration()).getCustomSettings();
        if (set == null) {
            SpringConfigurationTab.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Nullable
    private ActionGroup getAdditionalSettingsActionGroup(Set<SpringFileSet> allFileSets) {
        LinkedHashSet<CustomSetting> allCustomSettings = new LinkedHashSet<CustomSetting>(this.getCustomSettings());
        block0: for (SpringFileSetEditorCustomization customization : (SpringFileSetEditorCustomization[])SpringFileSetEditorCustomization.EP_NAME.getExtensions()) {
            List<CustomSetting> customSettings = customization.getCustomSettings();
            customSettings.forEach(allCustomSettings::remove);
            for (SpringFileSet set : allFileSets) {
                if (!customization.isApplicable(set)) continue;
                allCustomSettings.addAll(customSettings);
                continue block0;
            }
        }
        MyCheckedActionGroup actionGroup = new MyCheckedActionGroup(new CheckAction[0]);
        for (CustomSetting setting : allCustomSettings) {
            if (!(setting instanceof CustomSetting.BOOLEAN)) continue;
            actionGroup.add((AnAction)new CheckAction((CustomSetting.BOOLEAN)setting));
        }
        if (actionGroup.getChildrenCount() == 0) {
            return null;
        }
        actionGroup.getTemplatePresentation().setText(SpringBundle.messagePointer("configuration.tab.additional.settings", new Object[0]));
        actionGroup.getTemplatePresentation().setIcon(AllIcons.General.Settings);
        return actionGroup;
    }

    private ActionGroup getDisplaySettingsActionGroup() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add((AnAction)new AlphabeticallyToggleAction());
        group.addSeparator();
        CommonActionsManager actionManager = CommonActionsManager.getInstance();
        DefaultTreeExpander treeExpander = new DefaultTreeExpander((JTree)this.myTree);
        group.add(actionManager.createExpandAllAction((TreeExpander)treeExpander, (JComponent)this.myTree));
        group.add(actionManager.createCollapseAllAction((TreeExpander)treeExpander, (JComponent)this.myTree));
        return group;
    }

    private void addToBuffer(SpringFileSet fileSet) {
        if (!this.myBuffer.contains(fileSet)) {
            this.myBuffer.add(fileSet);
        }
    }

    private void addToBuffer(int index, SpringFileSet fileSet) {
        if (!this.myBuffer.contains(fileSet)) {
            this.myBuffer.add(index, fileSet);
        }
    }

    private void remove() {
        List nodes = TreeUtil.collectSelectedObjects((JTree)this.myTree, path -> (SimpleNode)TreeUtil.getLastUserObject(SimpleNode.class, (TreePath)path));
        for (SimpleNode node : nodes) {
            SpringFileSet fileSet;
            if (node instanceof DependencyNode) {
                fileSet = SpringConfigurationTab.getFileSetForNode(node);
                fileSet.removeDependency(((DependencyNode)node).getFileSet());
                continue;
            }
            if (node instanceof FileSetNode) {
                fileSet = ((FileSetNode)node).getFileSet();
                int result2 = Messages.showYesNoDialog((Component)this.myMainPanel, (String)SpringBundle.message("facet.context.remove.message", fileSet.getName()), (String)SpringBundle.message("facet.context.remove.title", new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result2 != 0) continue;
                if (fileSet.isAutodetected()) {
                    fileSet.setRemoved(true);
                    this.addToBuffer(fileSet);
                } else {
                    this.myBuffer.remove(fileSet);
                }
                for (SpringFileSet set : this.myBuffer) {
                    set.removeDependency(fileSet);
                }
                continue;
            }
            if (node instanceof FilesetGroupNode) {
                fileSet = SpringConfigurationTab.getFileSetForNode(node);
                if (fileSet.isAutodetected()) continue;
                Set<VirtualFilePointer> filePointers = ((FilesetGroupNode)node).getFilePointers();
                for (VirtualFilePointer filePointer : filePointers) {
                    fileSet.removeFile(filePointer);
                }
                continue;
            }
            if (!(node instanceof ConfigFileNode) || (fileSet = SpringConfigurationTab.getFileSetForNode(node)).isAutodetected()) continue;
            VirtualFilePointer filePointer = ((ConfigFileNode)node).getFilePointer();
            fileSet.removeFile(filePointer);
        }
        this.myModified = true;
        this.myTreeModel.invalidateAsync().thenRun(() -> IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus((Component)this.myTree, true)));
    }

    @NotNull
    private static SpringFileSet getFileSetForNode(SimpleNode node) {
        FileSetNode fileSetNode = SpringConfigurationTab.getFileSetNodeFor(node);
        assert (fileSetNode != null);
        SpringFileSet springFileSet = fileSetNode.getFileSet();
        if (springFileSet == null) {
            SpringConfigurationTab.$$$reportNull$$$0(1);
        }
        return springFileSet;
    }

    @Nullable
    private SpringFileSet getCurrentFileSet() {
        SimpleNode node = this.myTree.getSelectedNode();
        FileSetNode currentFileSetNode = SpringConfigurationTab.getFileSetNodeFor(node);
        return currentFileSetNode == null ? null : currentFileSetNode.getFileSet();
    }

    @Nullable
    private static FileSetNode getFileSetNodeFor(@Nullable SimpleNode node) {
        while (node != null) {
            if (node instanceof FileSetNode) {
                return (FileSetNode)node;
            }
            node = node.getParent();
        }
        return null;
    }

    public String getHelpTopic() {
        return "reference.settings.project.modules.spring.facet";
    }

    @Nls
    public String getDisplayName() {
        return SpringBundle.message("config.display.name", new Object[0]);
    }

    @NotNull
    public JComponent createComponent() {
        JComponent jComponent = DumbService.getInstance((Project)this.myContext.getProject()).wrapGently((JComponent)this.myMainPanel, (Disposable)this);
        if (jComponent == null) {
            SpringConfigurationTab.$$$reportNull$$$0(2);
        }
        return jComponent;
    }

    public boolean isModified() {
        for (CustomSetting setting : this.getCustomSettings()) {
            if (!setting.isModified()) continue;
            return true;
        }
        return this.myModified;
    }

    public void apply() {
        if (this.myFacet.isDisposed()) {
            return;
        }
        this.myFacet.removeFileSets();
        for (SpringFileSet fileSet : this.myBuffer) {
            if (fileSet.isAutodetected() && (!fileSet.isAutodetected() || !fileSet.isRemoved())) continue;
            this.myFacet.addFileSet(fileSet);
        }
        ((SpringFacetConfiguration)this.myFacet.getConfiguration()).setModified();
        for (CustomSetting setting : this.getCustomSettings()) {
            setting.apply();
        }
        this.myModified = false;
        this.validateFileSetConfiguration();
    }

    public void reset() {
        this.myBuffer.clear();
        this.myTree.setPaintBusy(true);
        ReadAction.nonBlocking(() -> SpringFileSetService.getInstance().getAllSets(this.myFacet)).finishOnUiThread(ModalityState.any(), fileSets -> {
            for (SpringFileSet fileSet : fileSets) {
                this.addToBuffer(new SpringFileSetImpl(fileSet));
            }
            this.myTreeModel.invalidateAsync();
            this.myTree.setPaintBusy(false);
            this.myTree.setSelectionRow(0);
            this.validateFileSetConfiguration();
        }).submit((Executor)NonUrgentExecutor.getInstance());
        for (CustomSetting setting : this.getCustomSettings()) {
            setting.reset();
        }
        this.myModified = false;
    }

    public void disposeUIResources() {
        Disposer.dispose((Disposable)this);
    }

    private void selectFileSet(SpringFileSet fileSet) {
        TreeUtil.promiseSelect((JTree)this.myTree, path -> {
            Object object = TreeUtil.getLastUserObject((TreePath)path);
            if (this.myRoot.equals(object)) {
                return TreeVisitor.Action.CONTINUE;
            }
            FileSetNode node = (FileSetNode)((Object)((Object)ObjectUtils.tryCast((Object)object, FileSetNode.class)));
            return node != null && node.getFileSet().getId().equals(fileSet.getId()) ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.SKIP_CHILDREN;
        });
    }

    public void dispose() {
    }

    private void validateFileSetConfiguration() {
        this.myValidatorsManager.validate();
    }

    @NotNull
    private FileSetEditor createFileSetEditor(@NotNull SpringFileSet fileSet) {
        if (fileSet == null) {
            SpringConfigurationTab.$$$reportNull$$$0(3);
        }
        return new FileSetEditor(this.myMainPanel, this.myContext.getModule(), fileSet, this.myBuffer, new XmlConfigSearcher(this.myContext.getModule()), new CodeConfigSearcher(this.myContext.getModule()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 3 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/facet/SpringConfigurationTab";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCustomSettings";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFileSetForNode";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/facet/SpringConfigurationTab";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFileSetEditor";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 3 -> new IllegalArgumentException(string);
        };
    }

    private static class MyCheckedActionGroup
    extends DefaultActionGroup
    implements CheckedActionGroup {
        MyCheckedActionGroup(CheckAction ... actions) {
            super((AnAction[])actions);
            this.setPopup(true);
        }
    }

    private static final class CheckAction
    extends ToggleAction
    implements ActionUpdateThreadAware {
        private final CustomSetting.BOOLEAN myBean;

        private CheckAction(CustomSetting.BOOLEAN bean) {
            super(bean.getDescription());
            this.myBean = bean;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            Boolean value;
            if (e == null) {
                CheckAction.$$$reportNull$$$0(0);
            }
            return (value = this.myBean.getValue()) == null ? this.myBean.getDefaultValue() : value.booleanValue();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                CheckAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                CheckAction.$$$reportNull$$$0(2);
            }
            this.myBean.setBooleanValue(state);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/facet/SpringConfigurationTab$CheckAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/facet/SpringConfigurationTab$CheckAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class AlphabeticallyToggleAction
    extends ToggleAction
    implements ActionUpdateThreadAware {
        AlphabeticallyToggleAction() {
            super(PlatformEditorBundle.message((String)"action.sort.alphabetically", (Object[])new Object[0]), PlatformEditorBundle.message((String)"action.sort.alphabetically.description", (Object[])new Object[0]), AllIcons.ObjectBrowser.Sorted);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                AlphabeticallyToggleAction.$$$reportNull$$$0(0);
            }
            return SpringConfigurationTab.this.myConfigurationTabSettings.isSortAlpha();
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                AlphabeticallyToggleAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                AlphabeticallyToggleAction.$$$reportNull$$$0(2);
            }
            SpringConfigurationTab.this.myConfigurationTabSettings.setSortAlpha(state);
            SpringConfigurationTab.this.myTreeModel.invalidateAsync();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/spring/facet/SpringConfigurationTab$AlphabeticallyToggleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/spring/facet/SpringConfigurationTab$AlphabeticallyToggleAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    private class CreateApplicationContextAction
    implements AnActionButtonRunnable {
        private CreateApplicationContextAction() {
        }

        public void run(AnActionButton button) {
            SpringFileSetService fileSetService = SpringFileSetService.getInstance();
            String uniqueId = fileSetService.getUniqueId(SpringConfigurationTab.this.myBuffer);
            String uniqueName = fileSetService.getUniqueName(SpringBundle.message("facet.context.default.name", new Object[0]), SpringConfigurationTab.this.myBuffer);
            SpringFileSetImpl fileSet = new SpringFileSetImpl(uniqueId, uniqueName, SpringConfigurationTab.this.myFacet){

                @Override
                public boolean isNew() {
                    return true;
                }
            };
            FileSetEditor editor = SpringConfigurationTab.this.createFileSetEditor(fileSet);
            editor.show();
            if (editor.getExitCode() == 0) {
                SpringFileSet editedFileSet = editor.getEditedFileSet();
                Disposer.register((Disposable)SpringConfigurationTab.this.myFacet, (Disposable)editedFileSet);
                SpringConfigurationTab.this.addToBuffer(editedFileSet);
                SpringConfigurationTab.this.myModified = true;
                SpringConfigurationTab.this.myTreeModel.invalidateAsync().thenRun(() -> SpringConfigurationTab.this.selectFileSet(fileSet));
                SpringConfigurationTab.this.validateFileSetConfiguration();
            }
        }
    }

    private class RemoveSelectedNodesAction
    implements AnActionButtonRunnable {
        private RemoveSelectedNodesAction() {
        }

        public void run(AnActionButton button) {
            SpringConfigurationTab.this.remove();
            SpringConfigurationTab.this.validateFileSetConfiguration();
        }
    }

    private final class EditApplicationContextAction
    implements AnActionButtonRunnable {
        private final SpringFacet mySpringFacet;

        private EditApplicationContextAction(SpringFacet springFacet) {
            this.mySpringFacet = springFacet;
        }

        public void run(AnActionButton button) {
            SpringFileSet fileSet = SpringConfigurationTab.this.getCurrentFileSet();
            if (fileSet != null) {
                FileSetEditor editor = SpringConfigurationTab.this.createFileSetEditor(fileSet);
                editor.show();
                if (editor.getExitCode() == 0) {
                    SpringConfigurationTab.this.myModified = true;
                    int idx = SpringConfigurationTab.this.myBuffer.indexOf(fileSet);
                    SpringConfigurationTab.this.myBuffer.remove(fileSet);
                    SpringFileSet edited = editor.getEditedFileSet();
                    Disposer.register((Disposable)this.mySpringFacet, (Disposable)edited);
                    SpringConfigurationTab.this.addToBuffer(idx, edited);
                    edited.setAutodetected(false);
                    SpringConfigurationTab.this.myTreeModel.invalidateAsync().thenRun(() -> SpringConfigurationTab.this.selectFileSet(edited));
                    SpringConfigurationTab.this.validateFileSetConfiguration();
                }
            }
        }
    }
}

